/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.mapping;

import org.apache.hop.core.Const;
import org.apache.hop.core.xml.XmlHandler;
import org.w3c.dom.Node;

public class MappingParameters
implements Cloneable {
    public static final String XML_TAG = "parameters";
    private static final String XML_VARIABLES_TAG = "variablemapping";
    private String[] variable;
    private String[] input;
    private boolean inheritingAllVariables;

    public MappingParameters() {
        this.variable = new String[0];
        this.input = new String[0];
        this.inheritingAllVariables = true;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public MappingParameters(Node paramNode) {
        int nrVariables = XmlHandler.countNodes((Node)paramNode, (String)XML_VARIABLES_TAG);
        this.variable = new String[nrVariables];
        this.input = new String[nrVariables];
        for (int i = 0; i < this.variable.length; ++i) {
            Node variableMappingNode = XmlHandler.getSubNodeByNr((Node)paramNode, (String)XML_VARIABLES_TAG, (int)i);
            this.variable[i] = XmlHandler.getTagValue((Node)variableMappingNode, (String)"variable");
            this.input[i] = XmlHandler.getTagValue((Node)variableMappingNode, (String)"input");
        }
        this.inheritingAllVariables = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)paramNode, (String)"inherit_all_vars"));
    }

    public String getXml() {
        StringBuilder xml = new StringBuilder(200);
        xml.append("    ").append(XmlHandler.openTag((String)XML_TAG));
        for (int i = 0; i < this.variable.length; ++i) {
            xml.append("       ").append(XmlHandler.openTag((String)XML_VARIABLES_TAG));
            xml.append(XmlHandler.addTagValue((String)"variable", (String)this.variable[i], (boolean)false, (String[])new String[0]));
            xml.append(XmlHandler.addTagValue((String)"input", (String)this.input[i], (boolean)false, (String[])new String[0]));
            xml.append(XmlHandler.closeTag((String)XML_VARIABLES_TAG)).append(Const.CR);
        }
        xml.append("    ").append(XmlHandler.addTagValue((String)"inherit_all_vars", (boolean)this.inheritingAllVariables));
        xml.append("    ").append(XmlHandler.closeTag((String)XML_TAG));
        return xml.toString();
    }

    public String[] getInputField() {
        return this.input;
    }

    public void setInputField(String[] inputField) {
        this.input = inputField;
    }

    public String[] getVariable() {
        return this.variable;
    }

    public void setVariable(String[] variable) {
        this.variable = variable;
    }

    public boolean isInheritingAllVariables() {
        return this.inheritingAllVariables;
    }

    public void setInheritingAllVariables(boolean inheritingAllVariables) {
        this.inheritingAllVariables = inheritingAllVariables;
    }
}

