/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.excelinput;

import java.util.List;
import java.util.Map;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.fileinput.FileInputList;
import org.apache.hop.core.injection.AfterInjection;
import org.apache.hop.core.injection.Injection;
import org.apache.hop.core.injection.InjectionDeep;
import org.apache.hop.core.injection.InjectionSupported;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaBoolean;
import org.apache.hop.core.row.value.ValueMetaDate;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.row.value.ValueMetaNone;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.excelinput.ExcelInput;
import org.apache.hop.pipeline.transforms.excelinput.ExcelInputData;
import org.apache.hop.pipeline.transforms.excelinput.ExcelInputField;
import org.apache.hop.pipeline.transforms.excelinput.SpreadSheetType;
import org.apache.hop.resource.IResourceNaming;
import org.apache.hop.resource.ResourceDefinition;
import org.w3c.dom.Node;

@Transform(id="ExcelInput", image="excelinput.svg", name="i18n::ExcelInput.Name", description="i18n::ExcelInput.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Input", keywords={"i18n::ExcelInputMeta.keyword"}, documentationUrl="/pipeline/transforms/excelinput.html")
@InjectionSupported(localizationPrefix="ExcelInput.Injection.", groups={"FIELDS", "SHEETS", "FILENAME_LINES"})
public class ExcelInputMeta
extends BaseTransformMeta<ExcelInput, ExcelInputData> {
    private static final Class<?> PKG = ExcelInputMeta.class;
    public static final String[] RequiredFilesDesc = new String[]{BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0])};
    public static final String[] RequiredFilesCode = new String[]{"N", "Y"};
    private static final String YES = "Y";
    public static final int TYPE_TRIM_NONE = 0;
    public static final int TYPE_TRIM_LEFT = 1;
    public static final int TYPE_TRIM_RIGHT = 2;
    public static final int TYPE_TRIM_BOTH = 3;
    public static final String[] type_trimCode = new String[]{"none", "left", "right", "both"};
    public static final String[] type_trimDesc = new String[]{BaseMessages.getString(PKG, (String)"ExcelInputMeta.TrimType.None", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelInputMeta.TrimType.Left", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelInputMeta.TrimType.Right", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelInputMeta.TrimType.Both", (String[])new String[0])};
    public static final String STRING_SEPARATOR = " \t --> ";
    @Injection(name="FILENAME", group="FILENAME_LINES")
    private String[] fileName;
    @Injection(name="FILEMASK", group="FILENAME_LINES")
    private String[] fileMask;
    @Injection(name="EXCLUDE_FILEMASK", group="FILENAME_LINES")
    private String[] excludeFileMask;
    @Injection(name="FILE_REQUIRED", group="FILENAME_LINES")
    private String[] fileRequired;
    private String fileField;
    @Injection(name="SHEET_NAME", group="SHEETS")
    private String[] sheetName;
    @Injection(name="SHEET_START_ROW", group="SHEETS")
    private int[] startRow;
    @Injection(name="SHEET_START_COL", group="SHEETS")
    private int[] startColumn;
    private String sheetField;
    private boolean startsWithHeader;
    private boolean stopOnEmpty;
    private boolean ignoreEmptyRows;
    private String rowNumberField;
    private String sheetRowNumberField;
    private long rowLimit;
    @InjectionDeep
    private ExcelInputField[] field;
    private boolean strictTypes;
    private boolean errorIgnored;
    private boolean errorLineSkipped;
    private String warningFilesDestinationDirectory;
    private String warningFilesExtension;
    private String errorFilesDestinationDirectory;
    private String errorFilesExtension;
    private String lineNumberFilesDestinationDirectory;
    private String lineNumberFilesExtension;
    private boolean acceptingFilenames;
    private String acceptingField;
    private String acceptingTransformName;
    @Injection(name="INCLUDE_SUBFOLDERS", group="FILENAME_LINES")
    private String[] includeSubFolders;
    private TransformMeta acceptingTransform;
    private String encoding;
    private boolean isaddresult;
    private String shortFileFieldName;
    private String pathFieldName;
    private String hiddenFieldName;
    private String lastModificationTimeFieldName;
    private String uriNameFieldName;
    private String rootUriNameFieldName;
    private String extensionFieldName;
    private String sizeFieldName;
    @Injection(name="SPREADSHEET_TYPE")
    private SpreadSheetType spreadSheetType;

    public String getShortFileNameField() {
        return this.shortFileFieldName;
    }

    public void setShortFileNameField(String field) {
        this.shortFileFieldName = field;
    }

    public String getPathField() {
        return this.pathFieldName;
    }

    public void setPathField(String field) {
        this.pathFieldName = field;
    }

    public String isHiddenField() {
        return this.hiddenFieldName;
    }

    public void setIsHiddenField(String field) {
        this.hiddenFieldName = field;
    }

    public String getLastModificationDateField() {
        return this.lastModificationTimeFieldName;
    }

    public void setLastModificationDateField(String field) {
        this.lastModificationTimeFieldName = field;
    }

    public String getUriField() {
        return this.uriNameFieldName;
    }

    public void setUriField(String field) {
        this.uriNameFieldName = field;
    }

    public String getRootUriField() {
        return this.rootUriNameFieldName;
    }

    public void setRootUriField(String field) {
        this.rootUriNameFieldName = field;
    }

    public String getExtensionField() {
        return this.extensionFieldName;
    }

    public void setExtensionField(String field) {
        this.extensionFieldName = field;
    }

    public String getSizeField() {
        return this.sizeFieldName;
    }

    public void setSizeField(String field) {
        this.sizeFieldName = field;
    }

    public ExcelInputField[] getField() {
        return this.field;
    }

    public void setField(ExcelInputField[] fields) {
        this.field = fields;
    }

    public String getFileField() {
        return this.fileField;
    }

    public void setFileField(String fileField) {
        this.fileField = fileField;
    }

    public String[] getFileMask() {
        return this.fileMask;
    }

    public void setFileMask(String[] fileMask) {
        this.fileMask = fileMask;
    }

    public String[] getExcludeFileMask() {
        return this.excludeFileMask;
    }

    public void setExcludeFileMask(String[] excludeFileMask) {
        this.excludeFileMask = excludeFileMask;
    }

    public String[] getIncludeSubFolders() {
        return this.includeSubFolders;
    }

    public void setIncludeSubFolders(String[] includeSubFoldersin) {
        if (includeSubFoldersin != null) {
            this.includeSubFolders = new String[includeSubFoldersin.length];
            for (int i = 0; i < includeSubFoldersin.length && i < this.includeSubFolders.length; ++i) {
                this.includeSubFolders[i] = this.getRequiredFilesCode(includeSubFoldersin[i]);
            }
        } else {
            this.includeSubFolders = new String[0];
        }
    }

    public String getRequiredFilesCode(String tt) {
        if (tt == null) {
            return RequiredFilesCode[0];
        }
        if (tt.equals(RequiredFilesDesc[1])) {
            return RequiredFilesCode[1];
        }
        return RequiredFilesCode[0];
    }

    public String getRequiredFilesDesc(String tt) {
        if (tt == null) {
            return RequiredFilesDesc[0];
        }
        if (tt.equals(RequiredFilesCode[1])) {
            return RequiredFilesDesc[1];
        }
        return RequiredFilesDesc[0];
    }

    public String[] getFileName() {
        return this.fileName;
    }

    public void setFileName(String[] fileName) {
        this.fileName = fileName;
    }

    public boolean ignoreEmptyRows() {
        return this.ignoreEmptyRows;
    }

    public void setIgnoreEmptyRows(boolean ignoreEmptyRows) {
        this.ignoreEmptyRows = ignoreEmptyRows;
    }

    public long getRowLimit() {
        return this.rowLimit;
    }

    public void setRowLimit(long rowLimit) {
        this.rowLimit = rowLimit;
    }

    public String getRowNumberField() {
        return this.rowNumberField;
    }

    public void setRowNumberField(String rowNumberField) {
        this.rowNumberField = rowNumberField;
    }

    public String getSheetRowNumberField() {
        return this.sheetRowNumberField;
    }

    public void setSheetRowNumberField(String rowNumberField) {
        this.sheetRowNumberField = rowNumberField;
    }

    public String getSheetField() {
        return this.sheetField;
    }

    public void setSheetField(String sheetField) {
        this.sheetField = sheetField;
    }

    public String[] getSheetName() {
        return this.sheetName;
    }

    public void setSheetName(String[] sheetName) {
        this.sheetName = sheetName;
    }

    public int[] getStartColumn() {
        return this.startColumn;
    }

    public void setStartColumn(int[] startColumn) {
        this.startColumn = startColumn;
    }

    public int[] getStartRow() {
        return this.startRow;
    }

    public void setStartRow(int[] startRow) {
        this.startRow = startRow;
    }

    public boolean startsWithHeader() {
        return this.startsWithHeader;
    }

    public void setStartsWithHeader(boolean startsWithHeader) {
        this.startsWithHeader = startsWithHeader;
    }

    public boolean stopOnEmpty() {
        return this.stopOnEmpty;
    }

    public void setStopOnEmpty(boolean stopOnEmpty) {
        this.stopOnEmpty = stopOnEmpty;
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.readData(transformNode);
    }

    public Object clone() {
        ExcelInputMeta retval = (ExcelInputMeta)((Object)super.clone());
        this.normilizeAllocation();
        int nrfiles = this.fileName.length;
        int nrsheets = this.sheetName.length;
        int nrFields = this.field.length;
        retval.allocate(nrfiles, nrsheets, nrFields);
        for (int i = 0; i < nrFields; ++i) {
            retval.field[i] = (ExcelInputField)this.field[i].clone();
        }
        System.arraycopy(this.fileName, 0, retval.fileName, 0, nrfiles);
        System.arraycopy(this.fileMask, 0, retval.fileMask, 0, nrfiles);
        System.arraycopy(this.excludeFileMask, 0, retval.excludeFileMask, 0, nrfiles);
        System.arraycopy(this.fileRequired, 0, retval.fileRequired, 0, nrfiles);
        System.arraycopy(this.includeSubFolders, 0, retval.includeSubFolders, 0, nrfiles);
        System.arraycopy(this.sheetName, 0, retval.sheetName, 0, nrsheets);
        System.arraycopy(this.startColumn, 0, retval.startColumn, 0, nrsheets);
        System.arraycopy(this.startRow, 0, retval.startRow, 0, nrsheets);
        return retval;
    }

    private void readData(Node transformNode) throws HopXmlException {
        try {
            int i;
            this.startsWithHeader = YES.equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"header"));
            String nempty = XmlHandler.getTagValue((Node)transformNode, (String)"noempty");
            this.ignoreEmptyRows = YES.equalsIgnoreCase(nempty) || nempty == null;
            String soempty = XmlHandler.getTagValue((Node)transformNode, (String)"stoponempty");
            this.stopOnEmpty = YES.equalsIgnoreCase(soempty) || nempty == null;
            this.sheetRowNumberField = XmlHandler.getTagValue((Node)transformNode, (String)"sheetrownumfield");
            this.rowNumberField = XmlHandler.getTagValue((Node)transformNode, (String)"rownum_field");
            this.rowNumberField = XmlHandler.getTagValue((Node)transformNode, (String)"rownumfield");
            this.rowLimit = Const.toLong((String)XmlHandler.getTagValue((Node)transformNode, (String)"limit"), (long)0L);
            this.encoding = XmlHandler.getTagValue((Node)transformNode, (String)"encoding");
            String addToResult = XmlHandler.getTagValue((Node)transformNode, (String)"add_to_result_filenames");
            this.isaddresult = Utils.isEmpty((CharSequence)addToResult) ? true : YES.equalsIgnoreCase(addToResult);
            this.sheetField = XmlHandler.getTagValue((Node)transformNode, (String)"sheetfield");
            this.fileField = XmlHandler.getTagValue((Node)transformNode, (String)"filefield");
            this.acceptingFilenames = YES.equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"accept_filenames"));
            this.acceptingField = XmlHandler.getTagValue((Node)transformNode, (String)"accept_field");
            this.acceptingTransformName = XmlHandler.getTagValue((Node)transformNode, (String)"accept_transform_name");
            Node filenode = XmlHandler.getSubNode((Node)transformNode, (String)"file");
            Node sheetsnode = XmlHandler.getSubNode((Node)transformNode, (String)"sheets");
            Node fields = XmlHandler.getSubNode((Node)transformNode, (String)"fields");
            int nrfiles = XmlHandler.countNodes((Node)filenode, (String)"name");
            int nrsheets = XmlHandler.countNodes((Node)sheetsnode, (String)"sheet");
            int nrFields = XmlHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrfiles, nrsheets, nrFields);
            for (i = 0; i < nrfiles; ++i) {
                Node filenamenode = XmlHandler.getSubNodeByNr((Node)filenode, (String)"name", (int)i);
                Node filemasknode = XmlHandler.getSubNodeByNr((Node)filenode, (String)"filemask", (int)i);
                Node excludefilemasknode = XmlHandler.getSubNodeByNr((Node)filenode, (String)"exclude_filemask", (int)i);
                Node fileRequirednode = XmlHandler.getSubNodeByNr((Node)filenode, (String)"file_required", (int)i);
                Node includeSubFoldersnode = XmlHandler.getSubNodeByNr((Node)filenode, (String)"include_subfolders", (int)i);
                this.fileName[i] = XmlHandler.getNodeValue((Node)filenamenode);
                this.fileMask[i] = XmlHandler.getNodeValue((Node)filemasknode);
                this.excludeFileMask[i] = XmlHandler.getNodeValue((Node)excludefilemasknode);
                this.fileRequired[i] = XmlHandler.getNodeValue((Node)fileRequirednode);
                this.includeSubFolders[i] = XmlHandler.getNodeValue((Node)includeSubFoldersnode);
            }
            for (i = 0; i < nrFields; ++i) {
                Node fnode = XmlHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.field[i] = new ExcelInputField();
                this.field[i].setName(XmlHandler.getTagValue((Node)fnode, (String)"name"));
                this.field[i].setType(ValueMetaFactory.getIdForValueMeta((String)XmlHandler.getTagValue((Node)fnode, (String)"type")));
                this.field[i].setLength(Const.toInt((String)XmlHandler.getTagValue((Node)fnode, (String)"length"), (int)-1));
                this.field[i].setPrecision(Const.toInt((String)XmlHandler.getTagValue((Node)fnode, (String)"precision"), (int)-1));
                String srepeat = XmlHandler.getTagValue((Node)fnode, (String)"repeat");
                this.field[i].setTrimType(ExcelInputMeta.getTrimTypeByCode(XmlHandler.getTagValue((Node)fnode, (String)"trim_type")));
                if (srepeat != null) {
                    this.field[i].setRepeated(YES.equalsIgnoreCase(srepeat));
                } else {
                    this.field[i].setRepeated(false);
                }
                this.field[i].setFormat(XmlHandler.getTagValue((Node)fnode, (String)"format"));
                this.field[i].setCurrencySymbol(XmlHandler.getTagValue((Node)fnode, (String)"currency"));
                this.field[i].setDecimalSymbol(XmlHandler.getTagValue((Node)fnode, (String)"decimal"));
                this.field[i].setGroupSymbol(XmlHandler.getTagValue((Node)fnode, (String)"group"));
            }
            for (i = 0; i < nrsheets; ++i) {
                Node snode = XmlHandler.getSubNodeByNr((Node)sheetsnode, (String)"sheet", (int)i);
                this.sheetName[i] = XmlHandler.getTagValue((Node)snode, (String)"name");
                this.startRow[i] = Const.toInt((String)XmlHandler.getTagValue((Node)snode, (String)"startrow"), (int)0);
                this.startColumn[i] = Const.toInt((String)XmlHandler.getTagValue((Node)snode, (String)"startcol"), (int)0);
            }
            this.strictTypes = YES.equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"strict_types"));
            this.errorIgnored = YES.equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"error_ignored"));
            this.errorLineSkipped = YES.equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"error_line_skipped"));
            this.warningFilesDestinationDirectory = XmlHandler.getTagValue((Node)transformNode, (String)"bad_line_files_destination_directory");
            this.warningFilesExtension = XmlHandler.getTagValue((Node)transformNode, (String)"bad_line_files_extension");
            this.errorFilesDestinationDirectory = XmlHandler.getTagValue((Node)transformNode, (String)"error_line_files_destination_directory");
            this.errorFilesExtension = XmlHandler.getTagValue((Node)transformNode, (String)"error_line_files_extension");
            this.lineNumberFilesDestinationDirectory = XmlHandler.getTagValue((Node)transformNode, (String)"line_number_files_destination_directory");
            this.lineNumberFilesExtension = XmlHandler.getTagValue((Node)transformNode, (String)"line_number_files_extension");
            this.shortFileFieldName = XmlHandler.getTagValue((Node)transformNode, (String)"shortFileFieldName");
            this.pathFieldName = XmlHandler.getTagValue((Node)transformNode, (String)"pathFieldName");
            this.hiddenFieldName = XmlHandler.getTagValue((Node)transformNode, (String)"hiddenFieldName");
            this.lastModificationTimeFieldName = XmlHandler.getTagValue((Node)transformNode, (String)"lastModificationTimeFieldName");
            this.uriNameFieldName = XmlHandler.getTagValue((Node)transformNode, (String)"uriNameFieldName");
            this.rootUriNameFieldName = XmlHandler.getTagValue((Node)transformNode, (String)"rootUriNameFieldName");
            this.extensionFieldName = XmlHandler.getTagValue((Node)transformNode, (String)"extensionFieldName");
            this.sizeFieldName = XmlHandler.getTagValue((Node)transformNode, (String)"sizeFieldName");
            try {
                this.spreadSheetType = SpreadSheetType.valueOf(XmlHandler.getTagValue((Node)transformNode, (String)"spreadsheet_type"));
            }
            catch (Exception e) {
                this.spreadSheetType = SpreadSheetType.POI;
            }
        }
        catch (Exception e) {
            throw new HopXmlException("Unable to read transform information from XML", (Throwable)e);
        }
    }

    public String[] normilizeArray(String[] array, int length) {
        String[] newArray = new String[length];
        if (array != null) {
            if (array.length <= length) {
                System.arraycopy(array, 0, newArray, 0, array.length);
            } else {
                System.arraycopy(array, 0, newArray, 0, length);
            }
        }
        return newArray;
    }

    public int[] normilizeArray(int[] array, int length) {
        int[] newArray = new int[length];
        if (array != null) {
            if (array.length <= length) {
                System.arraycopy(array, 0, newArray, 0, array.length);
            } else {
                System.arraycopy(array, 0, newArray, 0, length);
            }
        }
        return newArray;
    }

    public void normilizeAllocation() {
        int nrfiles = 0;
        int nrsheets = 0;
        if (this.fileName != null) {
            nrfiles = this.fileName.length;
        } else {
            this.fileName = new String[0];
        }
        if (this.sheetName != null) {
            nrsheets = this.sheetName.length;
        } else {
            this.sheetName = new String[0];
        }
        if (this.field == null) {
            this.field = new ExcelInputField[0];
        }
        this.fileMask = this.normilizeArray(this.fileMask, nrfiles);
        this.excludeFileMask = this.normilizeArray(this.excludeFileMask, nrfiles);
        this.fileRequired = this.normilizeArray(this.fileRequired, nrfiles);
        this.includeSubFolders = this.normilizeArray(this.includeSubFolders, nrfiles);
        this.startRow = this.normilizeArray(this.startRow, nrsheets);
        this.startColumn = this.normilizeArray(this.startColumn, nrsheets);
    }

    public void allocate(int nrfiles, int nrsheets, int nrFields) {
        this.allocateFiles(nrfiles);
        this.sheetName = new String[nrsheets];
        this.startRow = new int[nrsheets];
        this.startColumn = new int[nrsheets];
        this.field = new ExcelInputField[nrFields];
    }

    public void allocateFiles(int nrfiles) {
        this.fileName = new String[nrfiles];
        this.fileMask = new String[nrfiles];
        this.excludeFileMask = new String[nrfiles];
        this.fileRequired = new String[nrfiles];
        this.includeSubFolders = new String[nrfiles];
    }

    public void setDefault() {
        this.startsWithHeader = true;
        this.ignoreEmptyRows = true;
        this.rowNumberField = "";
        this.sheetRowNumberField = "";
        this.isaddresult = true;
        int nrfiles = 0;
        int nrFields = 0;
        int nrsheets = 0;
        this.allocate(nrfiles, nrsheets, nrFields);
        this.rowLimit = 0L;
        this.strictTypes = false;
        this.errorIgnored = false;
        this.errorLineSkipped = false;
        this.warningFilesDestinationDirectory = null;
        this.warningFilesExtension = "warning";
        this.errorFilesDestinationDirectory = null;
        this.errorFilesExtension = "error";
        this.lineNumberFilesDestinationDirectory = null;
        this.lineNumberFilesExtension = "line";
        this.spreadSheetType = SpreadSheetType.SAX_POI;
    }

    public void getFields(IRowMeta row, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        for (int i = 0; i < this.field.length; ++i) {
            int type = this.field[i].getType();
            if (type == 0) {
                type = 2;
            }
            try {
                IValueMeta v = ValueMetaFactory.createValueMeta((String)this.field[i].getName(), (int)type);
                v.setLength(this.field[i].getLength());
                v.setPrecision(this.field[i].getPrecision());
                v.setOrigin(name);
                v.setConversionMask(this.field[i].getFormat());
                v.setDecimalSymbol(this.field[i].getDecimalSymbol());
                v.setGroupingSymbol(this.field[i].getGroupSymbol());
                v.setCurrencySymbol(this.field[i].getCurrencySymbol());
                row.addValueMeta(v);
                continue;
            }
            catch (Exception e) {
                throw new HopTransformException((Throwable)e);
            }
        }
        if (this.fileField != null && this.fileField.length() > 0) {
            ValueMetaString v = new ValueMetaString(this.fileField);
            v.setLength(250);
            v.setPrecision(-1);
            v.setOrigin(name);
            row.addValueMeta((IValueMeta)v);
        }
        if (this.sheetField != null && this.sheetField.length() > 0) {
            ValueMetaString v = new ValueMetaString(this.sheetField);
            v.setLength(250);
            v.setPrecision(-1);
            v.setOrigin(name);
            row.addValueMeta((IValueMeta)v);
        }
        if (this.sheetRowNumberField != null && this.sheetRowNumberField.length() > 0) {
            ValueMetaInteger v = new ValueMetaInteger(this.sheetRowNumberField);
            v.setLength(10, 0);
            v.setOrigin(name);
            row.addValueMeta((IValueMeta)v);
        }
        if (this.rowNumberField != null && this.rowNumberField.length() > 0) {
            ValueMetaInteger v = new ValueMetaInteger(this.rowNumberField);
            v.setLength(10, 0);
            v.setOrigin(name);
            row.addValueMeta((IValueMeta)v);
        }
        if (this.getShortFileNameField() != null && this.getShortFileNameField().length() > 0) {
            ValueMetaString v = new ValueMetaString(variables.resolve(this.getShortFileNameField()));
            v.setLength(100, -1);
            v.setOrigin(name);
            row.addValueMeta((IValueMeta)v);
        }
        if (this.getExtensionField() != null && this.getExtensionField().length() > 0) {
            ValueMetaString v = new ValueMetaString(variables.resolve(this.getExtensionField()));
            v.setLength(100, -1);
            v.setOrigin(name);
            row.addValueMeta((IValueMeta)v);
        }
        if (this.getPathField() != null && this.getPathField().length() > 0) {
            ValueMetaString v = new ValueMetaString(variables.resolve(this.getPathField()));
            v.setLength(100, -1);
            v.setOrigin(name);
            row.addValueMeta((IValueMeta)v);
        }
        if (this.getSizeField() != null && this.getSizeField().length() > 0) {
            ValueMetaInteger v = new ValueMetaInteger(variables.resolve(this.getSizeField()));
            v.setOrigin(name);
            v.setLength(9);
            row.addValueMeta((IValueMeta)v);
        }
        if (this.isHiddenField() != null && this.isHiddenField().length() > 0) {
            ValueMetaBoolean v = new ValueMetaBoolean(variables.resolve(this.isHiddenField()));
            v.setOrigin(name);
            row.addValueMeta((IValueMeta)v);
        }
        if (this.getLastModificationDateField() != null && this.getLastModificationDateField().length() > 0) {
            ValueMetaDate v = new ValueMetaDate(variables.resolve(this.getLastModificationDateField()));
            v.setOrigin(name);
            row.addValueMeta((IValueMeta)v);
        }
        if (this.getUriField() != null && this.getUriField().length() > 0) {
            ValueMetaString v = new ValueMetaString(variables.resolve(this.getUriField()));
            v.setLength(100, -1);
            v.setOrigin(name);
            row.addValueMeta((IValueMeta)v);
        }
        if (this.getRootUriField() != null && this.getRootUriField().length() > 0) {
            ValueMetaString v = new ValueMetaString(variables.resolve(this.getRootUriField()));
            v.setLength(100, -1);
            v.setOrigin(name);
            row.addValueMeta((IValueMeta)v);
        }
    }

    public String getXml() {
        int i;
        StringBuilder retval = new StringBuilder(1024);
        this.normilizeAllocation();
        retval.append("    ").append(XmlHandler.addTagValue((String)"header", (boolean)this.startsWithHeader));
        retval.append("    ").append(XmlHandler.addTagValue((String)"noempty", (boolean)this.ignoreEmptyRows));
        retval.append("    ").append(XmlHandler.addTagValue((String)"stoponempty", (boolean)this.stopOnEmpty));
        retval.append("    ").append(XmlHandler.addTagValue((String)"filefield", (String)this.fileField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"sheetfield", (String)this.sheetField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"sheetrownumfield", (String)this.sheetRowNumberField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"rownumfield", (String)this.rowNumberField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"sheetfield", (String)this.sheetField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"filefield", (String)this.fileField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"limit", (long)this.rowLimit));
        retval.append("    ").append(XmlHandler.addTagValue((String)"encoding", (String)this.encoding));
        retval.append("    " + XmlHandler.addTagValue((String)"add_to_result_filenames", (boolean)this.isaddresult));
        retval.append("    ").append(XmlHandler.addTagValue((String)"accept_filenames", (boolean)this.acceptingFilenames));
        retval.append("    ").append(XmlHandler.addTagValue((String)"accept_field", (String)this.acceptingField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"accept_transform_name", (String)(this.acceptingTransform != null ? this.acceptingTransform.getName() : "")));
        retval.append("    <file>").append(Const.CR);
        for (i = 0; i < this.fileName.length; ++i) {
            retval.append("      ").append(XmlHandler.addTagValue((String)"name", (String)this.fileName[i]));
            retval.append("      ").append(XmlHandler.addTagValue((String)"filemask", (String)this.fileMask[i]));
            retval.append("      ").append(XmlHandler.addTagValue((String)"exclude_filemask", (String)this.excludeFileMask[i]));
            retval.append("      ").append(XmlHandler.addTagValue((String)"file_required", (String)this.fileRequired[i]));
            retval.append("      ").append(XmlHandler.addTagValue((String)"include_subfolders", (String)this.includeSubFolders[i]));
        }
        retval.append("    </file>").append(Const.CR);
        retval.append("    <fields>").append(Const.CR);
        for (i = 0; i < this.field.length; ++i) {
            retval.append("      <field>").append(Const.CR);
            retval.append("        ").append(XmlHandler.addTagValue((String)"name", (String)this.field[i].getName()));
            retval.append("        ").append(XmlHandler.addTagValue((String)"type", (String)this.field[i].getTypeDesc()));
            retval.append("        ").append(XmlHandler.addTagValue((String)"length", (int)this.field[i].getLength()));
            retval.append("        ").append(XmlHandler.addTagValue((String)"precision", (int)this.field[i].getPrecision()));
            retval.append("        ").append(XmlHandler.addTagValue((String)"trim_type", (String)this.field[i].getTrimTypeCode()));
            retval.append("        ").append(XmlHandler.addTagValue((String)"repeat", (boolean)this.field[i].isRepeated()));
            retval.append("        ").append(XmlHandler.addTagValue((String)"format", (String)this.field[i].getFormat()));
            retval.append("        ").append(XmlHandler.addTagValue((String)"currency", (String)this.field[i].getCurrencySymbol()));
            retval.append("        ").append(XmlHandler.addTagValue((String)"decimal", (String)this.field[i].getDecimalSymbol()));
            retval.append("        ").append(XmlHandler.addTagValue((String)"group", (String)this.field[i].getGroupSymbol()));
            retval.append("      </field>").append(Const.CR);
        }
        retval.append("    </fields>").append(Const.CR);
        retval.append("    <sheets>").append(Const.CR);
        for (i = 0; i < this.sheetName.length; ++i) {
            retval.append("      <sheet>").append(Const.CR);
            retval.append("        ").append(XmlHandler.addTagValue((String)"name", (String)this.sheetName[i]));
            retval.append("        ").append(XmlHandler.addTagValue((String)"startrow", (int)this.startRow[i]));
            retval.append("        ").append(XmlHandler.addTagValue((String)"startcol", (int)this.startColumn[i]));
            retval.append("        </sheet>").append(Const.CR);
        }
        retval.append("    </sheets>").append(Const.CR);
        retval.append("    ").append(XmlHandler.addTagValue((String)"strict_types", (boolean)this.strictTypes));
        retval.append("    ").append(XmlHandler.addTagValue((String)"error_ignored", (boolean)this.errorIgnored));
        retval.append("    ").append(XmlHandler.addTagValue((String)"error_line_skipped", (boolean)this.errorLineSkipped));
        retval.append("    ").append(XmlHandler.addTagValue((String)"bad_line_files_destination_directory", (String)this.warningFilesDestinationDirectory));
        retval.append("    ").append(XmlHandler.addTagValue((String)"bad_line_files_extension", (String)this.warningFilesExtension));
        retval.append("    ").append(XmlHandler.addTagValue((String)"error_line_files_destination_directory", (String)this.errorFilesDestinationDirectory));
        retval.append("    ").append(XmlHandler.addTagValue((String)"error_line_files_extension", (String)this.errorFilesExtension));
        retval.append("    ").append(XmlHandler.addTagValue((String)"line_number_files_destination_directory", (String)this.lineNumberFilesDestinationDirectory));
        retval.append("    ").append(XmlHandler.addTagValue((String)"line_number_files_extension", (String)this.lineNumberFilesExtension));
        retval.append("    ").append(XmlHandler.addTagValue((String)"shortFileFieldName", (String)this.shortFileFieldName));
        retval.append("    ").append(XmlHandler.addTagValue((String)"pathFieldName", (String)this.pathFieldName));
        retval.append("    ").append(XmlHandler.addTagValue((String)"hiddenFieldName", (String)this.hiddenFieldName));
        retval.append("    ").append(XmlHandler.addTagValue((String)"lastModificationTimeFieldName", (String)this.lastModificationTimeFieldName));
        retval.append("    ").append(XmlHandler.addTagValue((String)"uriNameFieldName", (String)this.uriNameFieldName));
        retval.append("    ").append(XmlHandler.addTagValue((String)"rootUriNameFieldName", (String)this.rootUriNameFieldName));
        retval.append("    ").append(XmlHandler.addTagValue((String)"extensionFieldName", (String)this.extensionFieldName));
        retval.append("    ").append(XmlHandler.addTagValue((String)"sizeFieldName", (String)this.sizeFieldName));
        retval.append("    ").append(XmlHandler.addTagValue((String)"spreadsheet_type", (String)(this.spreadSheetType != null ? this.spreadSheetType.toString() : "")));
        return retval.toString();
    }

    private String getValueOrEmptyIfNull(String str) {
        return str == null ? "" : str;
    }

    public static final int getTrimTypeByCode(String tt) {
        if (tt != null) {
            for (int i = 0; i < type_trimCode.length; ++i) {
                if (!type_trimCode[i].equalsIgnoreCase(tt)) continue;
                return i;
            }
        }
        return 0;
    }

    public static final int getTrimTypeByDesc(String tt) {
        if (tt != null) {
            for (int i = 0; i < type_trimDesc.length; ++i) {
                if (!type_trimDesc[i].equalsIgnoreCase(tt)) continue;
                return i;
            }
        }
        return 0;
    }

    public static final String getTrimTypeCode(int i) {
        if (i < 0 || i >= type_trimCode.length) {
            return type_trimCode[0];
        }
        return type_trimCode[i];
    }

    public static final String getTrimTypeDesc(int i) {
        if (i < 0 || i >= type_trimDesc.length) {
            return type_trimDesc[0];
        }
        return type_trimDesc[i];
    }

    public String[] getFilePaths(IVariables variables) {
        this.normilizeAllocation();
        return FileInputList.createFilePathList((IVariables)variables, (String[])this.fileName, (String[])this.fileMask, (String[])this.excludeFileMask, (String[])this.fileRequired, (boolean[])this.includeSubFolderBoolean());
    }

    public FileInputList getFileList(IVariables variables) {
        this.normilizeAllocation();
        return FileInputList.createFileList((IVariables)variables, (String[])this.fileName, (String[])this.fileMask, (String[])this.excludeFileMask, (String[])this.fileRequired, (boolean[])this.includeSubFolderBoolean());
    }

    private boolean[] includeSubFolderBoolean() {
        this.normilizeAllocation();
        int len = this.fileName.length;
        boolean[] includeSubFolderBoolean = new boolean[len];
        for (int i = 0; i < len; ++i) {
            includeSubFolderBoolean[i] = YES.equalsIgnoreCase(this.includeSubFolders[i]);
        }
        return includeSubFolderBoolean;
    }

    public String getLookupTransformName() {
        if (this.acceptingFilenames && this.acceptingTransform != null && !Utils.isEmpty((CharSequence)this.acceptingTransform.getName())) {
            return this.acceptingTransform.getName();
        }
        return null;
    }

    public void searchInfoAndTargetTransforms(List<TransformMeta> transforms) {
        this.acceptingTransform = TransformMeta.findTransform(transforms, (String)this.acceptingTransformName);
    }

    public String[] getInfoTransforms() {
        return null;
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (input.length > 0) {
            if (!this.isAcceptingFilenames()) {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"ExcelInputMeta.CheckResult.NoInputError", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"ExcelInputMeta.CheckResult.AcceptFilenamesOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"ExcelInputMeta.CheckResult.NoInputOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        FileInputList fileList = this.getFileList(variables);
        if (fileList.nrOfFiles() == 0) {
            if (!this.isAcceptingFilenames()) {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"ExcelInputMeta.CheckResult.ExpectedFilesError", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"ExcelInputMeta.CheckResult.ExpectedFilesOk", (String[])new String[]{"" + fileList.nrOfFiles()}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public IRowMeta getEmptyFields() {
        RowMeta row = new RowMeta();
        if (this.field != null) {
            for (int i = 0; i < this.field.length; ++i) {
                ValueMetaNone v;
                try {
                    v = ValueMetaFactory.createValueMeta((String)this.field[i].getName(), (int)this.field[i].getType());
                }
                catch (HopPluginException e) {
                    v = new ValueMetaNone(this.field[i].getName());
                }
                row.addValueMeta((IValueMeta)v);
            }
        }
        return row;
    }

    public String getWarningFilesDestinationDirectory() {
        return this.warningFilesDestinationDirectory;
    }

    public void setWarningFilesDestinationDirectory(String badLineFilesDestinationDirectory) {
        this.warningFilesDestinationDirectory = badLineFilesDestinationDirectory;
    }

    public String getBadLineFilesExtension() {
        return this.warningFilesExtension;
    }

    public void setBadLineFilesExtension(String badLineFilesExtension) {
        this.warningFilesExtension = badLineFilesExtension;
    }

    public boolean isErrorIgnored() {
        return this.errorIgnored;
    }

    public void setErrorIgnored(boolean errorIgnored) {
        this.errorIgnored = errorIgnored;
    }

    public String getErrorFilesDestinationDirectory() {
        return this.errorFilesDestinationDirectory;
    }

    public void setErrorFilesDestinationDirectory(String errorLineFilesDestinationDirectory) {
        this.errorFilesDestinationDirectory = errorLineFilesDestinationDirectory;
    }

    public String getErrorFilesExtension() {
        return this.errorFilesExtension;
    }

    public void setErrorFilesExtension(String errorLineFilesExtension) {
        this.errorFilesExtension = errorLineFilesExtension;
    }

    public String getLineNumberFilesDestinationDirectory() {
        return this.lineNumberFilesDestinationDirectory;
    }

    public void setLineNumberFilesDestinationDirectory(String lineNumberFilesDestinationDirectory) {
        this.lineNumberFilesDestinationDirectory = lineNumberFilesDestinationDirectory;
    }

    public String getLineNumberFilesExtension() {
        return this.lineNumberFilesExtension;
    }

    public void setLineNumberFilesExtension(String lineNumberFilesExtension) {
        this.lineNumberFilesExtension = lineNumberFilesExtension;
    }

    public boolean isErrorLineSkipped() {
        return this.errorLineSkipped;
    }

    public void setErrorLineSkipped(boolean errorLineSkipped) {
        this.errorLineSkipped = errorLineSkipped;
    }

    public boolean isStrictTypes() {
        return this.strictTypes;
    }

    public void setStrictTypes(boolean strictTypes) {
        this.strictTypes = strictTypes;
    }

    public String[] getFileRequired() {
        return this.fileRequired;
    }

    public void setFileRequired(String[] fileRequiredin) {
        this.fileRequired = new String[fileRequiredin.length];
        for (int i = 0; i < fileRequiredin.length && i < this.fileRequired.length; ++i) {
            this.fileRequired[i] = this.getRequiredFilesCode(fileRequiredin[i]);
        }
    }

    public String getAcceptingField() {
        return this.acceptingField;
    }

    public void setAcceptingField(String acceptingField) {
        this.acceptingField = acceptingField;
    }

    public boolean isAcceptingFilenames() {
        return this.acceptingFilenames;
    }

    public void setAcceptingFilenames(boolean acceptingFilenames) {
        this.acceptingFilenames = acceptingFilenames;
    }

    public TransformMeta getAcceptingTransform() {
        return this.acceptingTransform;
    }

    public void setAcceptingTransform(TransformMeta acceptingTransform) {
        this.acceptingTransform = acceptingTransform;
    }

    public String getAcceptingTransformName() {
        return this.acceptingTransformName;
    }

    public void setAcceptingTransformName(String acceptingTransformName) {
        this.acceptingTransformName = acceptingTransformName;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setAddResultFile(boolean isaddresult) {
        this.isaddresult = isaddresult;
    }

    public boolean isAddResultFile() {
        return this.isaddresult;
    }

    public boolean readAllSheets() {
        return Utils.isEmpty((CharSequence[])this.sheetName) || this.sheetName.length == 1 && Utils.isEmpty((CharSequence)this.sheetName[0]);
    }

    public String exportResources(IVariables variables, Map<String, ResourceDefinition> definitions, IResourceNaming iResourceNaming, IHopMetadataProvider metadataProvider) throws HopException {
        try {
            this.normilizeAllocation();
            if (!this.acceptingFilenames) {
                for (int i = 0; i < this.fileName.length; ++i) {
                    FileObject fileObject = HopVfs.getFileObject((String)variables.resolve(this.fileName[i]));
                    this.fileName[i] = iResourceNaming.nameResource(fileObject, variables, Utils.isEmpty((CharSequence)this.fileMask[i]));
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new HopException((Throwable)e);
        }
    }

    public SpreadSheetType getSpreadSheetType() {
        return this.spreadSheetType;
    }

    public void setSpreadSheetType(SpreadSheetType spreadSheetType) {
        this.spreadSheetType = spreadSheetType;
    }

    @AfterInjection
    public void afterInjectionSynchronization() {
        this.normilizeAllocation();
    }
}

