/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.checksum;

import java.io.ByteArrayOutputStream;
import java.security.MessageDigest;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import org.apache.commons.codec.binary.Hex;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.checksum.CheckSumData;
import org.apache.hop.pipeline.transforms.checksum.CheckSumMeta;
import org.apache.hop.pipeline.transforms.checksum.Field;

public class CheckSum
extends BaseTransform<CheckSumMeta, CheckSumData> {
    private static final Class<?> PKG = CheckSumMeta.class;

    public CheckSum(TransformMeta transformMeta, CheckSumMeta meta, CheckSumData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        block19: {
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                int i;
                this.first = false;
                ((CheckSumData)this.data).outputRowMeta = this.getInputRowMeta().clone();
                ((CheckSumData)this.data).nrInfields = ((CheckSumData)this.data).outputRowMeta.size();
                ((CheckSumMeta)this.meta).getFields(((CheckSumData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
                if (((CheckSumMeta)this.meta).getFields().isEmpty()) {
                    ((CheckSumData)this.data).fieldnrs = new int[r.length];
                    for (i = 0; i < r.length; ++i) {
                        ((CheckSumData)this.data).fieldnrs[i] = i;
                    }
                } else {
                    ((CheckSumData)this.data).fieldnrs = new int[((CheckSumMeta)this.meta).getFields().size()];
                    for (i = 0; i < ((CheckSumMeta)this.meta).getFields().size(); ++i) {
                        Field field = ((CheckSumMeta)this.meta).getFields().get(i);
                        ((CheckSumData)this.data).fieldnrs[i] = this.getInputRowMeta().indexOfValue(field.getName());
                        if (((CheckSumData)this.data).fieldnrs[i] >= 0) continue;
                        this.logError(BaseMessages.getString(PKG, (String)"CheckSum.Log.CanNotFindField", (String[])new String[]{field.getName()}));
                        throw new HopException(BaseMessages.getString(PKG, (String)"CheckSum.Log.CanNotFindField", (String[])new String[]{field.getName()}));
                    }
                }
                ((CheckSumData)this.data).fieldnr = ((CheckSumData)this.data).fieldnrs.length;
                try {
                    if (((CheckSumMeta)this.meta).getCheckSumType() == CheckSumMeta.CheckSumType.MD5 || ((CheckSumMeta)this.meta).getCheckSumType() == CheckSumMeta.CheckSumType.SHA1 || ((CheckSumMeta)this.meta).getCheckSumType() == CheckSumMeta.CheckSumType.SHA256 || ((CheckSumMeta)this.meta).getCheckSumType() == CheckSumMeta.CheckSumType.SHA384 || ((CheckSumMeta)this.meta).getCheckSumType() == CheckSumMeta.CheckSumType.SHA512) {
                        ((CheckSumData)this.data).digest = MessageDigest.getInstance(((CheckSumMeta)this.meta).getCheckSumType().getCode());
                    }
                }
                catch (Exception e) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"CheckSum.Error.Digest", (String[])new String[0]), (Throwable)e);
                }
            }
            Object[] outputRowData = null;
            try {
                if (((CheckSumMeta)this.meta).getCheckSumType() == CheckSumMeta.CheckSumType.ADLER32 || ((CheckSumMeta)this.meta).getCheckSumType() == CheckSumMeta.CheckSumType.CRC32) {
                    Long checksum = this.calculCheckSum(r);
                    outputRowData = RowDataUtil.addValueData((Object[])r, (int)((CheckSumData)this.data).nrInfields, (Object)checksum);
                } else {
                    byte[] o = this.createCheckSum(r);
                    switch (((CheckSumMeta)this.meta).getResultType()) {
                        case BINARY: {
                            outputRowData = RowDataUtil.addValueData((Object[])r, (int)((CheckSumData)this.data).nrInfields, (Object)o);
                            break;
                        }
                        case HEXADECIMAL: {
                            String hex = new String(Hex.encodeHex((byte[])o));
                            outputRowData = RowDataUtil.addValueData((Object[])r, (int)((CheckSumData)this.data).nrInfields, (Object)hex);
                            break;
                        }
                        default: {
                            outputRowData = RowDataUtil.addValueData((Object[])r, (int)((CheckSumData)this.data).nrInfields, (Object)CheckSum.getStringFromBytes(o));
                        }
                    }
                }
                if (this.checkFeedback(this.getLinesRead()) && this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"CheckSum.Log.LineNumber", (String[])new String[]{Long.toString(this.getLinesRead())}));
                }
                this.putRow(((CheckSumData)this.data).outputRowMeta, outputRowData);
            }
            catch (Exception e) {
                boolean sendToErrorRow = false;
                String errorMessage = null;
                if (!this.getTransformMeta().isDoingErrorHandling()) {
                    this.logError(BaseMessages.getString(PKG, (String)"CheckSum.ErrorInTransformRunning", (String[])new String[0]) + e.getMessage());
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block19;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, ((CheckSumMeta)this.meta).getResultFieldName(), "CheckSum001");
            }
        }
        return true;
    }

    private byte[] createCheckSum(Object[] r) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (int i = 0; i < ((CheckSumData)this.data).fieldnr; ++i) {
            if (this.getInputRowMeta().getValueMeta(((CheckSumData)this.data).fieldnrs[i]).isBinary()) {
                baos.write(this.getInputRowMeta().getBinary(r, ((CheckSumData)this.data).fieldnrs[i]));
                continue;
            }
            baos.write(this.getInputRowMeta().getValueMeta(((CheckSumData)this.data).fieldnrs[i]).getNativeDataType(r[((CheckSumData)this.data).fieldnrs[i]]).toString().getBytes());
        }
        ((CheckSumData)this.data).digest.update(baos.toByteArray());
        byte[] hash = ((CheckSumData)this.data).digest.digest();
        return hash;
    }

    private static String getStringFromBytes(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            sb.append(0xFF & b);
            if (i + 1 >= bytes.length) continue;
            sb.append("-");
        }
        return sb.toString();
    }

    private Long calculCheckSum(Object[] r) throws Exception {
        Long retval;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (int i = 0; i < ((CheckSumData)this.data).fieldnr; ++i) {
            if (this.getInputRowMeta().getValueMeta(((CheckSumData)this.data).fieldnrs[i]).isBinary()) {
                baos.write(this.getInputRowMeta().getBinary(r, ((CheckSumData)this.data).fieldnrs[i]));
                continue;
            }
            baos.write(this.getInputRowMeta().getValueMeta(((CheckSumData)this.data).fieldnrs[i]).getNativeDataType(r[((CheckSumData)this.data).fieldnrs[i]]).toString().getBytes());
        }
        byte[] byteArray = baos.toByteArray();
        if (((CheckSumMeta)this.meta).getCheckSumType() == CheckSumMeta.CheckSumType.CRC32) {
            CRC32 crc32 = new CRC32();
            crc32.update(byteArray);
            retval = crc32.getValue();
        } else {
            Adler32 adler32 = new Adler32();
            adler32.update(byteArray);
            retval = adler32.getValue();
        }
        return retval;
    }

    public boolean init() {
        if (super.init()) {
            if (Utils.isEmpty((CharSequence)((CheckSumMeta)this.meta).getResultFieldName())) {
                this.logError(BaseMessages.getString(PKG, (String)"CheckSum.Error.ResultFieldMissing", (String[])new String[0]));
                return false;
            }
            return true;
        }
        return false;
    }
}

