/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.i18n.editor;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.function.Supplier;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.Const;
import org.apache.hop.core.HopClientEnvironment;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterStringDialog;
import org.apache.hop.ui.core.dialog.EnterTextDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.HopNamespace;
import org.apache.hop.ui.core.gui.WindowProperty;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.i18n.BundleFile;
import org.apache.hop.ui.i18n.BundlesStore;
import org.apache.hop.ui.i18n.KeyOccurrence;
import org.apache.hop.ui.i18n.MessagesSourceCrawler;
import org.apache.hop.ui.i18n.TranslationsStore;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class Translator {
    private static final Class<?> PKG = Translator.class;
    private static final String TRANSLATOR_NAMESPACE = "hop-translator";
    public static final String APP_NAME = BaseMessages.getString(PKG, (String)"i18nDialog.ApplicationName", (String[])new String[0]);
    private Display display;
    private Shell shell;
    private ILogChannel log;
    private PropsUi props;
    private MessagesSourceCrawler crawler;
    private TranslationsStore store;
    private SashForm sashform;
    private org.eclipse.swt.widgets.List wLocale;
    private TableView wPackages;
    private org.eclipse.swt.widgets.List wTodo;
    private String selectedLocale;
    private String selectedMessagesPackage;
    private String selectedSourceFile;
    private Text wReferenceLocale;
    private Text wSelectedSourceFolder;
    private Text wSelectedPackage;
    private Text wKey;
    private Text wMain;
    private Text wValue;
    private Text wSourceFile;
    private Text wBundleFile;
    private Text wSource;
    private Button wReload;
    private Button wClose;
    private Button wApply;
    private Button wRevert;
    private Button wZip;
    private Button wAll;
    private String referenceLocale;
    private String rootFolder;
    private List<String> sourceDirectories;
    private List<String> localeList;
    protected String lastValue;
    protected boolean lastValueChanged;
    protected String selectedKey;
    protected String searchString;
    protected String lastFoundKey;
    private String singleMessagesFile;
    private String selectedSourceFolder;
    private List<String> filesToAvoid;

    public Translator(Display display) {
        this.display = display;
        this.log = new LogChannel((Object)APP_NAME);
        this.props = PropsUi.getInstance();
        this.filesToAvoid = new ArrayList<String>();
    }

    public boolean showKey(String key, String messagesPackage) {
        return !key.startsWith("System.") || messagesPackage.equals(BaseMessages.class.getPackage().getName());
    }

    public void readFiles() throws HopFileException {
        this.log.logBasic(BaseMessages.getString(PKG, (String)"i18n.Log.ScanningSourceDirectories", (String[])new String[0]));
        HopFileException collisionException = null;
        try {
            BundlesStore bundlesStore = new BundlesStore(this.rootFolder);
            try {
                bundlesStore.findAllMessagesBundles();
            }
            catch (HopFileException e) {
                collisionException = e;
            }
            this.crawler = new MessagesSourceCrawler(this.log, this.rootFolder, bundlesStore);
            this.crawler.setFilesToAvoid(this.filesToAvoid);
            this.crawler.crawl();
            this.store = new TranslationsStore(this.log, this.localeList, this.referenceLocale, this.crawler.getSourcePackageOccurrences(), bundlesStore);
            HashMap<String, int[]> folderKeyCounts = new HashMap<String, int[]>();
            HashMap<String, Integer> nrKeysPerFolder = new HashMap<String, Integer>();
            for (String sourceFolder : this.sourceDirectories) {
                folderKeyCounts.put(sourceFolder, new int[this.localeList.size()]);
            }
            for (String sourceFolder : this.sourceDirectories) {
                int[] keyCounts = (int[])folderKeyCounts.get(sourceFolder);
                int nrKeys = 0;
                for (int i = 0; i < this.localeList.size(); ++i) {
                    String locale = this.localeList.get(i);
                    for (KeyOccurrence keyOccurrence : this.crawler.getKeyOccurrences(sourceFolder)) {
                        if (!this.showKey(keyOccurrence.getKey(), keyOccurrence.getMessagesPackage())) continue;
                        String value = this.store.lookupKeyValue(locale, keyOccurrence.getMessagesPackage(), keyOccurrence.getKey());
                        if (!Utils.isEmpty((CharSequence)value)) {
                            int n = i;
                            keyCounts[n] = keyCounts[n] + 1;
                        }
                        if (!locale.equals(this.referenceLocale)) continue;
                        ++nrKeys;
                    }
                }
                nrKeysPerFolder.put(sourceFolder, nrKeys);
            }
            DecimalFormat pctFormat = new DecimalFormat("#00.00");
            DecimalFormat nrFormat = new DecimalFormat("00");
            for (String sourceFolder : this.sourceDirectories) {
                int i;
                System.out.println("-------------------------------------");
                System.out.println("Folder: " + sourceFolder);
                System.out.println("-------------------------------------");
                int nrKeys = (Integer)nrKeysPerFolder.get(sourceFolder);
                System.out.println(BaseMessages.getString(PKG, (String)"i18n.Log.NumberOfKeysFound", (String[])new String[]{"" + nrKeys}));
                int[] keyCounts = (int[])folderKeyCounts.get(sourceFolder);
                String[] locales = this.localeList.toArray(new String[this.localeList.size()]);
                for (i = 0; i < locales.length; ++i) {
                    for (int j = 0; j < locales.length - 1; ++j) {
                        if (keyCounts[j] >= keyCounts[j + 1]) continue;
                        int c = keyCounts[j];
                        keyCounts[j] = keyCounts[j + 1];
                        keyCounts[j + 1] = c;
                        String l = locales[j];
                        locales[j] = locales[j + 1];
                        locales[j + 1] = l;
                    }
                }
                for (i = 0; i < locales.length; ++i) {
                    double donePct = 100.0 * (double)keyCounts[i] / (double)nrKeys;
                    int missingKeys = nrKeys - keyCounts[i];
                    String statusKeys = "# " + nrFormat.format(i + 1) + " : " + locales[i] + " : " + pctFormat.format(donePct) + "% " + BaseMessages.getString(PKG, (String)"i18n.Log.CompleteKeys", (Object[])new Object[]{keyCounts[i]}) + (missingKeys != 0 ? BaseMessages.getString(PKG, (String)"i18n.Log.MissingKeys", (Object[])new Object[]{missingKeys}) : "");
                    System.out.println(statusKeys);
                }
            }
        }
        catch (Exception e) {
            throw new HopFileException(BaseMessages.getString(PKG, (String)"i18n.Log.UnableToGetFiles", (String[])new String[]{this.sourceDirectories.toString()}), (Throwable)e);
        }
        if (collisionException != null) {
            throw collisionException;
        }
    }

    public void loadConfiguration(String configFile, String sourceFolder) throws Exception {
        this.rootFolder = sourceFolder;
        this.localeList = new ArrayList<String>();
        this.sourceDirectories = new ArrayList<String>();
        FileObject file = HopVfs.getFileObject((String)configFile);
        if (file.exists()) {
            try {
                Document doc = XmlHandler.loadXmlFile((FileObject)file);
                Node configNode = XmlHandler.getSubNode((Node)doc, (String)"translator-config");
                this.referenceLocale = XmlHandler.getTagValue((Node)configNode, (String)"reference-locale");
                this.singleMessagesFile = XmlHandler.getTagValue((Node)configNode, (String)"single-messages-file");
                Node localeListNode = XmlHandler.getSubNode((Node)configNode, (String)"locale-list");
                int nrLocale = XmlHandler.countNodes((Node)localeListNode, (String)"locale");
                if (nrLocale > 0) {
                    this.localeList.clear();
                }
                for (int i = 0; i < nrLocale; ++i) {
                    Node localeNode = XmlHandler.getSubNodeByNr((Node)localeListNode, (String)"locale", (int)i);
                    String locale = XmlHandler.getNodeValue((Node)localeNode);
                    this.localeList.add(locale);
                }
                Node filesToAvoidNode = XmlHandler.getSubNode((Node)configNode, (String)"files-to-avoid");
                List filesNodes = XmlHandler.getNodes((Node)filesToAvoidNode, (String)"filename");
                this.filesToAvoid = new ArrayList<String>();
                for (Node fileNode : filesNodes) {
                    this.filesToAvoid.add(XmlHandler.getNodeValue((Node)fileNode));
                }
            }
            catch (Exception e) {
                this.log.logError("Translator", new Object[]{"Error reading translator.xml", e});
            }
        }
    }

    public void open() {
        this.shell = new Shell(this.display);
        this.shell.setLayout((Layout)new FillLayout());
        this.shell.setText(APP_NAME);
        this.shell.setImage(GuiResource.getInstance().getImageHopUiTaskbar());
        try {
            this.readFiles();
        }
        catch (Exception e) {
            this.shell.getDisplay().asyncExec(() -> new ErrorDialog(this.shell, "Error reading translations", "There was an unexpected error reading the translations", e));
        }
        this.sashform = new SashForm((Composite)this.shell, 256);
        this.sashform.setLayout((Layout)new FormLayout());
        this.addLists();
        this.addGrid();
        this.addListeners();
        this.sashform.setWeights(new int[]{50, 50});
        this.sashform.setVisible(true);
        this.shell.pack();
        this.refresh();
        this.wPackages.optWidth(true);
        BaseTransformDialog.setSize(this.shell);
        this.shell.open();
    }

    private void addListeners() {
        Runtime.getRuntime().addShutdownHook(new TranslateShutdownHook(this.shell, () -> !this.store.getChangedBundleFiles().isEmpty(), () -> this.saveFiles(true)));
        this.display.addListener(21, event -> {
            event.doit = this.quitFile();
        });
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                e.doit = Translator.this.quitFile();
            }
        });
        this.wReload.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                int[] idx = Translator.this.wPackages.table.getSelectionIndices();
                Translator.this.reload();
                Translator.this.wPackages.table.setSelection(idx);
            }
        });
        this.wZip.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                Translator.this.saveFilesToZip();
            }
        });
        this.wClose.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                Translator.this.quitFile();
            }
        });
    }

    public void reload() {
        try {
            this.shell.setCursor(this.display.getSystemCursor(1));
            this.readFiles();
            this.shell.setCursor(null);
            this.refresh();
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, "Error loading data", "There was an unexpected error re-loading the data", e);
        }
    }

    public boolean quitFile() {
        List<BundleFile> changedBundleFiles = this.store.getChangedBundleFiles();
        if (changedBundleFiles.size() > 0) {
            MessageBox mb = new MessageBox(this.shell, 200);
            mb.setMessage(BaseMessages.getString(PKG, (String)"i18nDialog.ChangedFilesWhenExit", (String[])new String[]{"" + changedBundleFiles.size()}));
            mb.setText(BaseMessages.getString(PKG, (String)"i18nDialog.Warning", (String[])new String[0]));
            int answer = mb.open();
            if (answer == 128) {
                return false;
            }
        }
        WindowProperty winprop = new WindowProperty(this.shell);
        this.props.setScreen(winprop);
        this.shell.dispose();
        this.display.dispose();
        return true;
    }

    private void addLists() {
        Composite composite = new Composite((Composite)this.sashform, 0);
        this.props.setLook((Control)composite);
        FormLayout formLayout = new FormLayout();
        formLayout.marginHeight = 5;
        formLayout.marginWidth = 5;
        composite.setLayout((Layout)formLayout);
        this.wLocale = new org.eclipse.swt.widgets.List(composite, 2820);
        FormData fdLocale = new FormData();
        fdLocale.left = new FormAttachment(0, 0);
        fdLocale.right = new FormAttachment(100, 0);
        fdLocale.top = new FormAttachment(0, 0);
        fdLocale.bottom = new FormAttachment(10, 0);
        this.wLocale.setLayoutData((Object)fdLocale);
        ColumnInfo[] colinfo = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"i18nDialog.SourceFolder", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"i18nDialog.Packagename", (String[])new String[0]), 1, false, true)};
        this.wPackages = new TableView((IVariables)new Variables(), composite, 67588, colinfo, 1, true, null, this.props);
        FormData fdPackages = new FormData();
        fdPackages.left = new FormAttachment(0, 0);
        fdPackages.right = new FormAttachment(100, 0);
        fdPackages.top = new FormAttachment((Control)this.wLocale, this.props.getMargin());
        fdPackages.bottom = new FormAttachment(100, 0);
        this.wPackages.setLayoutData(fdPackages);
        this.wPackages.setSortable(true);
        FormData fdComposite = new FormData();
        fdComposite.left = new FormAttachment(0, 0);
        fdComposite.right = new FormAttachment(100, 0);
        fdComposite.top = new FormAttachment(0, 0);
        fdComposite.bottom = new FormAttachment(100, 0);
        composite.setLayoutData((Object)fdComposite);
        this.wLocale.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Translator.this.refreshGrid();
            }
        });
        this.wPackages.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Translator.this.refreshGrid();
            }
        });
        composite.layout();
    }

    private void addGrid() {
        Composite composite = new Composite((Composite)this.sashform, 0);
        this.props.setLook((Control)composite);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        composite.setLayout((Layout)formLayout);
        this.wReload = new Button(composite, 0);
        this.wReload.setText(BaseMessages.getString(PKG, (String)"i18nDialog.Reload", (String[])new String[0]));
        Button wSave = new Button(composite, 0);
        wSave.setText(BaseMessages.getString(PKG, (String)"i18nDialog.Save", (String[])new String[0]));
        this.wZip = new Button(composite, 0);
        this.wZip.setText(BaseMessages.getString(PKG, (String)"i18nDialog.Zip", (String[])new String[0]));
        this.wZip.setToolTipText(BaseMessages.getString(PKG, (String)"i18nDialog.Zip.Tip", (String[])new String[0]));
        this.wClose = new Button(composite, 0);
        this.wClose.setText(BaseMessages.getString(PKG, (String)"i18nDialog.Close", (String[])new String[0]));
        BaseTransformDialog.positionBottomButtons(composite, new Button[]{this.wReload, wSave, this.wZip, this.wClose}, this.props.getMargin() * 3, null);
        int left = 30;
        int middle = 45;
        this.wAll = new Button(composite, 32);
        this.wAll.setText(BaseMessages.getString(PKG, (String)"i18nDialog.ShowAllkeys", (String[])new String[0]));
        this.props.setLook((Control)this.wAll);
        FormData fdAll = new FormData();
        fdAll.left = new FormAttachment(0, 0);
        fdAll.right = new FormAttachment(left, 0);
        fdAll.bottom = new FormAttachment((Control)this.wClose, -this.props.getMargin());
        this.wAll.setLayoutData((Object)fdAll);
        Label wlTodo = new Label(composite, 16384);
        this.props.setLook((Control)wlTodo);
        wlTodo.setText(BaseMessages.getString(PKG, (String)"i18nDialog.ToDoList", (String[])new String[0]));
        FormData fdlTodo = new FormData();
        fdlTodo.left = new FormAttachment(0, 0);
        fdlTodo.right = new FormAttachment(left, 0);
        fdlTodo.top = new FormAttachment(0, 0);
        wlTodo.setLayoutData((Object)fdlTodo);
        this.wTodo = new org.eclipse.swt.widgets.List(composite, 2820);
        FormData fdTodo = new FormData();
        fdTodo.left = new FormAttachment(0, 0);
        fdTodo.right = new FormAttachment(left, 0);
        fdTodo.top = new FormAttachment((Control)wlTodo, this.props.getMargin());
        fdTodo.bottom = new FormAttachment((Control)this.wAll, -this.props.getMargin());
        this.wTodo.setLayoutData((Object)fdTodo);
        Label lastControl = wlTodo;
        Label wlReferenceLocale = new Label(composite, 131072);
        wlReferenceLocale.setText(BaseMessages.getString(PKG, (String)"i18nDialog.TranslationReferenceLocale", (String[])new String[0]));
        this.props.setLook((Control)wlReferenceLocale);
        FormData fdlReferenceLocale = new FormData();
        fdlReferenceLocale.left = new FormAttachment(left, this.props.getMargin());
        fdlReferenceLocale.right = new FormAttachment(middle, 0);
        fdlReferenceLocale.top = new FormAttachment((Control)lastControl, this.props.getMargin());
        wlReferenceLocale.setLayoutData((Object)fdlReferenceLocale);
        this.wReferenceLocale = new Text(composite, 2820);
        this.props.setLook((Control)this.wReferenceLocale);
        FormData fdReferenceLocale = new FormData();
        fdReferenceLocale.left = new FormAttachment(middle, this.props.getMargin());
        fdReferenceLocale.right = new FormAttachment(100, 0);
        fdReferenceLocale.top = new FormAttachment((Control)wlReferenceLocale, 0, 0x1000000);
        this.wReferenceLocale.setLayoutData((Object)fdReferenceLocale);
        this.wReferenceLocale.setEditable(false);
        this.wReferenceLocale.setText(Const.NVL((String)this.referenceLocale, (String)""));
        lastControl = this.wReferenceLocale;
        Label wlSelectedSourceFolder = new Label(composite, 131072);
        wlSelectedSourceFolder.setText(BaseMessages.getString(PKG, (String)"i18nDialog.TranslationSelectedSourceFolder", (String[])new String[0]));
        this.props.setLook((Control)wlSelectedSourceFolder);
        FormData fdlSelectedSourceFolder = new FormData();
        fdlSelectedSourceFolder.left = new FormAttachment(left, this.props.getMargin());
        fdlSelectedSourceFolder.right = new FormAttachment(middle, 0);
        fdlSelectedSourceFolder.top = new FormAttachment((Control)lastControl, this.props.getMargin());
        wlSelectedSourceFolder.setLayoutData((Object)fdlSelectedSourceFolder);
        this.wSelectedSourceFolder = new Text(composite, 16388);
        this.props.setLook((Control)this.wSelectedSourceFolder);
        FormData fdSelectedSourceFolder = new FormData();
        fdSelectedSourceFolder.left = new FormAttachment(middle, this.props.getMargin());
        fdSelectedSourceFolder.right = new FormAttachment(100, 0);
        fdSelectedSourceFolder.top = new FormAttachment((Control)wlSelectedSourceFolder, 0, 0x1000000);
        this.wSelectedSourceFolder.setLayoutData((Object)fdSelectedSourceFolder);
        this.wSelectedSourceFolder.setEditable(false);
        lastControl = this.wSelectedSourceFolder;
        Label wlSelectedPackage = new Label(composite, 131072);
        wlSelectedPackage.setText(BaseMessages.getString(PKG, (String)"i18nDialog.TranslationSelectedPackage", (String[])new String[0]));
        this.props.setLook((Control)wlSelectedPackage);
        FormData fdlSelectedPackage = new FormData();
        fdlSelectedPackage.left = new FormAttachment(left, this.props.getMargin());
        fdlSelectedPackage.right = new FormAttachment(middle, 0);
        fdlSelectedPackage.top = new FormAttachment((Control)lastControl, this.props.getMargin());
        wlSelectedPackage.setLayoutData((Object)fdlSelectedPackage);
        this.wSelectedPackage = new Text(composite, 2820);
        this.props.setLook((Control)this.wSelectedPackage);
        FormData fdSelectedPackage = new FormData();
        fdSelectedPackage.left = new FormAttachment(middle, this.props.getMargin());
        fdSelectedPackage.right = new FormAttachment(100, 0);
        fdSelectedPackage.top = new FormAttachment((Control)wlSelectedPackage, 0, 0x1000000);
        this.wSelectedPackage.setLayoutData((Object)fdSelectedPackage);
        this.wSelectedPackage.setEditable(false);
        lastControl = this.wSelectedPackage;
        Label wlKey = new Label(composite, 131072);
        wlKey.setText(BaseMessages.getString(PKG, (String)"i18nDialog.TranslationKey", (String[])new String[0]));
        this.props.setLook((Control)wlKey);
        FormData fdlKey = new FormData();
        fdlKey.left = new FormAttachment(left, this.props.getMargin());
        fdlKey.right = new FormAttachment(middle, 0);
        fdlKey.top = new FormAttachment((Control)lastControl, this.props.getMargin());
        wlKey.setLayoutData((Object)fdlKey);
        this.wKey = new Text(composite, 2820);
        this.props.setLook((Control)this.wKey);
        FormData fdKey = new FormData();
        fdKey.left = new FormAttachment(middle, this.props.getMargin());
        fdKey.right = new FormAttachment(100, 0);
        fdKey.top = new FormAttachment((Control)wlKey, 0, 0x1000000);
        this.wKey.setLayoutData((Object)fdKey);
        this.wKey.setEditable(false);
        lastControl = this.wKey;
        Label wlMain = new Label(composite, 131072);
        wlMain.setText(BaseMessages.getString(PKG, (String)"i18nDialog.MainTranslation", (String[])new String[0]));
        this.props.setLook((Control)wlMain);
        FormData fdlMain = new FormData();
        fdlMain.left = new FormAttachment(left, this.props.getMargin());
        fdlMain.right = new FormAttachment(middle, 0);
        fdlMain.top = new FormAttachment((Control)this.wKey, this.props.getMargin());
        wlMain.setLayoutData((Object)fdlMain);
        this.wMain = new Text(composite, 2818);
        this.props.setLook((Control)this.wMain);
        FormData fdMain = new FormData();
        fdMain.left = new FormAttachment(middle, this.props.getMargin());
        fdMain.right = new FormAttachment(100, 0);
        fdMain.top = new FormAttachment((Control)this.wKey, this.props.getMargin());
        fdMain.bottom = new FormAttachment((Control)this.wKey, 250 + this.props.getMargin());
        this.wMain.setLayoutData((Object)fdMain);
        this.wMain.setEditable(false);
        Button wSearch = new Button(composite, 8);
        wSearch.setText(BaseMessages.getString(PKG, (String)"i18nDialog.Search", (String[])new String[0]));
        FormData fdSearch = new FormData();
        fdSearch.left = new FormAttachment(left, 3 * this.props.getMargin());
        fdSearch.right = new FormAttachment(middle, -this.props.getMargin() * 2);
        fdSearch.top = new FormAttachment((Control)this.wMain, 0, 0x1000000);
        wSearch.setLayoutData((Object)fdSearch);
        Button wNext = new Button(composite, 8);
        wNext.setText(BaseMessages.getString(PKG, (String)"i18nDialog.Next", (String[])new String[0]));
        FormData fdNext = new FormData();
        fdNext.left = new FormAttachment(left, 3 * this.props.getMargin());
        fdNext.right = new FormAttachment(middle, -this.props.getMargin() * 2);
        fdNext.top = new FormAttachment((Control)wSearch, this.props.getMargin() * 2);
        wNext.setLayoutData((Object)fdNext);
        Label wlSource = new Label(composite, 131072);
        wlSource.setText(BaseMessages.getString(PKG, (String)"i18nDialog.LineOfSourceCode", (String[])new String[0]));
        this.props.setLook((Control)wlSource);
        FormData fdlSource = new FormData();
        fdlSource.left = new FormAttachment(left, this.props.getMargin());
        fdlSource.right = new FormAttachment(middle, 0);
        fdlSource.top = new FormAttachment((Control)this.wClose, -300 - this.props.getMargin());
        wlSource.setLayoutData((Object)fdlSource);
        this.wSource = new Text(composite, 2626);
        this.props.setLook((Control)this.wSource);
        FormData fdSource = new FormData();
        fdSource.left = new FormAttachment(middle, this.props.getMargin());
        fdSource.right = new FormAttachment(100, 0);
        fdSource.top = new FormAttachment((Control)this.wClose, -300 - this.props.getMargin());
        fdSource.bottom = new FormAttachment((Control)this.wClose, -this.props.getMargin());
        this.wSource.setLayoutData((Object)fdSource);
        this.wSource.setEditable(false);
        Label wlSourceFile = new Label(composite, 131072);
        wlSourceFile.setText(BaseMessages.getString(PKG, (String)"i18nDialog.SourceFile", (String[])new String[0]));
        this.props.setLook((Control)wlSourceFile);
        FormData fdlSourceFile = new FormData();
        fdlSourceFile.left = new FormAttachment(left, this.props.getMargin());
        fdlSourceFile.right = new FormAttachment(middle, 0);
        fdlSourceFile.bottom = new FormAttachment((Control)this.wSource, -2 * this.props.getMargin(), 128);
        wlSourceFile.setLayoutData((Object)fdlSourceFile);
        this.wSourceFile = new Text(composite, 2052);
        this.props.setLook((Control)this.wSourceFile);
        FormData fdSourceFile = new FormData();
        fdSourceFile.left = new FormAttachment(middle, this.props.getMargin());
        fdSourceFile.right = new FormAttachment(100, 0);
        fdSourceFile.top = new FormAttachment((Control)wlSourceFile, 0, 0x1000000);
        this.wSourceFile.setLayoutData((Object)fdSourceFile);
        this.wSourceFile.setEditable(false);
        Label wlBundleFile = new Label(composite, 131072);
        wlBundleFile.setText(BaseMessages.getString(PKG, (String)"i18nDialog.BundleFile", (String[])new String[0]));
        this.props.setLook((Control)wlBundleFile);
        FormData fdlBundleFile = new FormData();
        fdlBundleFile.left = new FormAttachment(left, this.props.getMargin());
        fdlBundleFile.right = new FormAttachment(middle, 0);
        fdlBundleFile.bottom = new FormAttachment((Control)this.wSourceFile, -this.props.getMargin());
        wlBundleFile.setLayoutData((Object)fdlBundleFile);
        this.wBundleFile = new Text(composite, 2052);
        this.props.setLook((Control)this.wBundleFile);
        FormData fdBundleFile = new FormData();
        fdBundleFile.left = new FormAttachment(middle, this.props.getMargin());
        fdBundleFile.right = new FormAttachment(100, 0);
        fdBundleFile.top = new FormAttachment((Control)wlBundleFile, 0, 0x1000000);
        this.wBundleFile.setLayoutData((Object)fdBundleFile);
        this.wBundleFile.setEditable(false);
        Label wlValue = new Label(composite, 131072);
        wlValue.setText(BaseMessages.getString(PKG, (String)"i18nDialog.Translation", (String[])new String[0]));
        wlValue.setFont(GuiResource.getInstance().getFontBold());
        this.props.setLook((Control)wlValue);
        FormData fdlValue = new FormData();
        fdlValue.left = new FormAttachment(left, this.props.getMargin());
        fdlValue.right = new FormAttachment(middle, 0);
        fdlValue.top = new FormAttachment((Control)this.wMain, this.props.getMargin());
        wlValue.setLayoutData((Object)fdlValue);
        this.wValue = new Text(composite, 2818);
        this.props.setLook((Control)this.wValue);
        this.wValue.setFont(GuiResource.getInstance().getFontBold());
        FormData fdValue = new FormData();
        fdValue.left = new FormAttachment(middle, this.props.getMargin());
        fdValue.right = new FormAttachment(100, 0);
        fdValue.top = new FormAttachment((Control)this.wMain, this.props.getMargin());
        fdValue.bottom = new FormAttachment((Control)this.wBundleFile, -this.props.getMargin());
        this.wValue.setLayoutData((Object)fdValue);
        this.wValue.setEditable(true);
        this.wApply = new Button(composite, 8);
        this.wApply.setText(BaseMessages.getString(PKG, (String)"i18nDialog.Apply", (String[])new String[0]));
        FormData fdApply = new FormData();
        fdApply.left = new FormAttachment(left, 3 * this.props.getMargin());
        fdApply.right = new FormAttachment(middle, -this.props.getMargin() * 2);
        fdApply.top = new FormAttachment((Control)this.wValue, 0, 0x1000000);
        this.wApply.setLayoutData((Object)fdApply);
        this.wApply.setEnabled(false);
        this.wRevert = new Button(composite, 8);
        this.wRevert.setText(BaseMessages.getString(PKG, (String)"i18nDialog.Revert", (String[])new String[0]));
        FormData fdRevert = new FormData();
        fdRevert.left = new FormAttachment(left, 3 * this.props.getMargin());
        fdRevert.right = new FormAttachment(middle, -this.props.getMargin() * 2);
        fdRevert.top = new FormAttachment((Control)this.wApply, this.props.getMargin() * 2);
        this.wRevert.setLayoutData((Object)fdRevert);
        this.wRevert.setEnabled(false);
        Button wSearchV = new Button(composite, 8);
        wSearchV.setText(BaseMessages.getString(PKG, (String)"i18nDialog.Search", (String[])new String[0]));
        FormData fdSearchV = new FormData();
        fdSearchV.left = new FormAttachment(left, 3 * this.props.getMargin());
        fdSearchV.right = new FormAttachment(middle, -this.props.getMargin() * 2);
        fdSearchV.top = new FormAttachment((Control)this.wRevert, this.props.getMargin() * 4);
        wSearchV.setLayoutData((Object)fdSearchV);
        Button wNextV = new Button(composite, 8);
        wNextV.setText(BaseMessages.getString(PKG, (String)"i18nDialog.Next", (String[])new String[0]));
        FormData fdNextV = new FormData();
        fdNextV.left = new FormAttachment(left, 3 * this.props.getMargin());
        fdNextV.right = new FormAttachment(middle, -this.props.getMargin() * 2);
        fdNextV.top = new FormAttachment((Control)wSearchV, this.props.getMargin() * 2);
        wNextV.setLayoutData((Object)fdNextV);
        this.wAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Translator.this.refreshGrid();
            }
        });
        this.wTodo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (Translator.this.wTodo.getSelectionCount() == 1) {
                    String key = Translator.this.wTodo.getSelection()[0];
                    Translator.this.showKeySelection(key);
                }
            }
        });
        this.wValue.addModifyListener(e -> {
            this.lastValueChanged = true;
            this.lastValue = this.wValue.getText();
            this.wApply.setEnabled(true);
            this.wRevert.setEnabled(true);
        });
        this.wApply.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Translator.this.applyChangedValue();
            }
        });
        this.wRevert.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Translator.this.revertChangedValue();
            }
        });
        wSave.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Translator.this.saveFiles();
            }
        });
        wSearch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Translator.this.search(Translator.this.referenceLocale);
            }
        });
        wNext.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Translator.this.searchAgain(Translator.this.referenceLocale);
            }
        });
        wSearchV.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Translator.this.search(Translator.this.selectedLocale);
            }
        });
        wNextV.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Translator.this.searchAgain(Translator.this.selectedLocale);
            }
        });
    }

    protected boolean saveFiles() {
        return this.saveFiles(false);
    }

    private boolean saveFiles(boolean force) {
        if (!Utils.isEmpty((CharSequence)this.lastValue)) {
            this.store.storeValue(this.selectedLocale, this.selectedSourceFile, this.selectedMessagesPackage, this.selectedKey, this.lastValue);
            this.lastValueChanged = false;
            this.updateToDoList(this.wTodo.getSelectionIndex());
        }
        this.lastValue = null;
        List<BundleFile> changedBundleFiles = this.store.getChangedBundleFiles();
        if (changedBundleFiles.size() > 0) {
            StringBuilder msg = new StringBuilder();
            for (BundleFile bundleFile : changedBundleFiles) {
                String filename = bundleFile.getFilename();
                msg.append(bundleFile.getFilename());
                if (!new File(filename).exists()) {
                    msg.append(" (NEW!)");
                }
                msg.append(Const.CR);
            }
            EnterTextDialog dialog = new EnterTextDialog(this.shell, BaseMessages.getString(PKG, (String)"i18nDialog.ChangedFiles", (String[])new String[0]), BaseMessages.getString(PKG, (String)"i18nDialog.ChangedMessagesFiles", (String[])new String[0]), msg.toString());
            if (dialog.open() != null || force) {
                try {
                    for (BundleFile bundleFile : changedBundleFiles) {
                        bundleFile.write();
                        this.log.logBasic(BaseMessages.getString(PKG, (String)"i18n.Log.SavedMessagesFile", (String[])new String[]{bundleFile.getFilename()}));
                    }
                }
                catch (HopException hopException) {
                    new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"i18n.UnexpectedError", (String[])new String[0]), "There was an error saving the changed messages files:", (Exception)((Object)hopException));
                    return false;
                }
                return true;
            }
            return false;
        }
        return true;
    }

    protected void saveFilesToZip() {
        List<BundleFile> bundleFiles;
        if (this.saveFiles() && (bundleFiles = this.store.findBundleFiles(this.selectedLocale, null)).size() > 0) {
            StringBuilder msg = new StringBuilder();
            for (BundleFile bundleFile : bundleFiles) {
                BundleFile mainLocaleMessagesStore = this.store.findMainBundleFile(bundleFile.getPackageName());
                String filename = bundleFile.getFilename();
                msg.append(filename).append(Const.CR);
            }
            String zipFilename = BaseDialog.presentFileDialog(this.shell, new String[]{"*.zip", "*"}, new String[]{BaseMessages.getString(PKG, (String)"System.FileType.ZIPFiles", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.FileType.AllFiles", (String[])new String[0])}, true);
            if (zipFilename != null) {
                try {
                    ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipFilename));
                    byte[] buf = new byte[1024];
                    for (BundleFile bundleFile : bundleFiles) {
                        int len;
                        FileInputStream in = new FileInputStream(bundleFile.getFilename());
                        out.putNextEntry(new ZipEntry(bundleFile.getFilename()));
                        while ((len = in.read(buf)) > 0) {
                            out.write(buf, 0, len);
                        }
                        out.closeEntry();
                        in.close();
                    }
                    out.close();
                }
                catch (Exception e) {
                    new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"i18n.UnexpectedError", (String[])new String[0]), "There was an error saving the changed messages files:", e);
                }
            }
        }
    }

    protected void search(String searchLocale) {
        EnterStringDialog dialog = new EnterStringDialog(this.shell, Const.NVL((String)this.searchString, (String)""), BaseMessages.getString(PKG, (String)"i18nDialog.SearchKey", (String[])new String[0]), BaseMessages.getString(PKG, (String)"i18nDialog.SearchLocale1", (String[])new String[0]) + " '" + Const.NVL((String)searchLocale, (String)"") + "' " + BaseMessages.getString(PKG, (String)"i18nDialog.SearchLocale2", (String[])new String[0]));
        this.searchString = dialog.open();
        this.lastFoundKey = null;
        this.searchAgain(searchLocale);
    }

    protected void searchAgain(String searchLocale) {
        if (this.searchString != null) {
            String upperSearchString = this.searchString.toUpperCase();
            boolean lastKeyFound = this.lastFoundKey == null;
            List<BundleFile> mainLocaleBundleFiles = this.store.findBundleFiles(searchLocale, this.selectedMessagesPackage);
            for (BundleFile bundleFile : mainLocaleBundleFiles) {
                for (String key : bundleFile.getContents().keySet()) {
                    int index;
                    String value = bundleFile.getContents().get(key);
                    String upperValue = value.toUpperCase();
                    if (upperValue.indexOf(upperSearchString) < 0) continue;
                    if (lastKeyFound && (index = this.wTodo.indexOf(key)) >= 0) {
                        this.lastFoundKey = key;
                        this.wTodo.setSelection(index);
                        this.showKeySelection(this.wTodo.getSelection()[0]);
                        return;
                    }
                    if (!key.equals(this.lastFoundKey)) continue;
                    lastKeyFound = true;
                }
            }
        }
    }

    protected void showKeySelection(String key) {
        this.wSelectedSourceFolder.setText(Const.NVL((String)this.selectedSourceFolder, (String)""));
        this.wSelectedPackage.setText(Const.NVL((String)this.selectedMessagesPackage, (String)""));
        this.wReferenceLocale.setText(Const.NVL((String)this.referenceLocale, (String)""));
        if (!key.equals(this.selectedKey) && this.lastValueChanged) {
            this.applyChangedValue();
        }
        if (this.selectedLocale != null && key != null && this.selectedMessagesPackage != null) {
            String mainValue = this.store.lookupKeyValue(this.referenceLocale, this.selectedMessagesPackage, key);
            String value = this.store.lookupKeyValue(this.selectedLocale, this.selectedMessagesPackage, key);
            KeyOccurrence keyOccurrence = this.crawler.getKeyOccurrence(key, this.selectedMessagesPackage);
            this.wKey.setText(key);
            this.wMain.setText(Const.NVL((String)mainValue, (String)""));
            this.wValue.setText(Const.NVL((String)value, (String)""));
            this.wSource.setText(Const.NVL((String)keyOccurrence.getSourceLine(), (String)""));
            String javaFilename = this.stripRootFolder(HopVfs.getFilename((FileObject)keyOccurrence.getFileObject()));
            this.wSourceFile.setText(Const.NVL((String)javaFilename, (String)""));
            if (Const.NVL((String)javaFilename, (String)"") != null) {
                this.selectedSourceFile = Const.NVL((String)javaFilename, (String)"");
                String lookupStr = File.separator + "src" + File.separator + "main" + File.separator + "java";
                this.selectedSourceFile = this.rootFolder + this.selectedSourceFile.substring(0, this.selectedSourceFile.indexOf(lookupStr) + lookupStr.length());
            } else {
                this.selectedSourceFile = "";
            }
            String bundleFilename = "";
            BundleFile file = this.store.getBundleStore().findBundleFile(this.selectedMessagesPackage, this.selectedLocale);
            if (file != null) {
                bundleFilename = this.stripRootFolder(file.getFilename());
            }
            this.wBundleFile.setText(Const.NVL((String)bundleFilename, (String)""));
            this.wValue.setFocus();
            this.wValue.setSelection(this.wValue.getText().length());
            this.wValue.showSelection();
            this.wValue.clearSelection();
            this.selectedKey = key;
            this.lastValueChanged = false;
            this.wApply.setEnabled(false);
            this.wRevert.setEnabled(false);
        }
    }

    private String stripRootFolder(String filename) {
        if (filename != null && filename.startsWith(this.rootFolder)) {
            return filename.substring(this.rootFolder.length());
        }
        return filename;
    }

    public void refreshGrid() {
        this.applyChangedValue();
        this.wTodo.setRedraw(false);
        this.wTodo.removeAll();
        this.wKey.setText("");
        this.wMain.setText("");
        this.wValue.setText("");
        this.wSource.setText("");
        this.selectedLocale = this.wLocale.getSelectionCount() == 0 ? null : this.wLocale.getSelection()[0];
        this.selectedSourceFolder = this.wPackages.table.getSelectionCount() == 0 ? null : this.wPackages.table.getSelection()[0].getText(1);
        this.selectedSourceFolder = this.getLongSourceFolder(this.rootFolder, this.selectedSourceFolder);
        this.selectedMessagesPackage = this.wPackages.table.getSelectionCount() == 0 ? null : this.wPackages.table.getSelection()[0].getText(2);
        this.refreshPackages();
        if (this.selectedLocale != null && this.selectedSourceFolder != null && this.selectedMessagesPackage != null) {
            List<KeyOccurrence> todo = this.getTodoList(this.selectedLocale, this.selectedMessagesPackage, this.selectedSourceFolder, false);
            String[] todoItems = new String[todo.size()];
            for (int i = 0; i < todoItems.length; ++i) {
                todoItems[i] = todo.get(i).getKey();
            }
            this.wTodo.setItems(todoItems);
        }
        if (this.wTodo.getSelectionCount() == 0 && this.wTodo.getItemCount() > 0) {
            this.wTodo.setSelection(0);
            this.wTodo.notifyListeners(13, new Event());
        }
        this.wTodo.setRedraw(true);
    }

    private List<KeyOccurrence> getTodoList(String locale, String messagesPackage, String sourceFolder, boolean strict) {
        List<KeyOccurrence> keys = this.crawler.getOccurrencesForPackage(messagesPackage);
        ArrayList<KeyOccurrence> todo = new ArrayList<KeyOccurrence>();
        for (KeyOccurrence keyOccurrence : keys) {
            String value;
            if (!this.showKey(keyOccurrence.getKey(), keyOccurrence.getMessagesPackage()) || !Utils.isEmpty((CharSequence)(value = this.store.lookupKeyValue(locale, messagesPackage, keyOccurrence.getKey()))) && (!this.wAll.getSelection() || strict) || !keyOccurrence.getSourceFolder().equals(sourceFolder)) continue;
            todo.add(keyOccurrence);
        }
        return todo;
    }

    private void applyChangedValue() {
        if (this.selectedKey != null && this.selectedLocale != null && this.selectedMessagesPackage != null && this.lastValueChanged && this.selectedSourceFile != null) {
            if (!Utils.isEmpty((CharSequence)this.lastValue)) {
                this.store.storeValue(this.selectedLocale, this.selectedSourceFile, this.selectedMessagesPackage, this.selectedKey, this.lastValue);
                this.lastValueChanged = false;
                this.updateToDoList(this.wTodo.getSelectionIndex());
            }
            this.lastValue = null;
            this.wApply.setEnabled(false);
            this.wRevert.setEnabled(false);
        }
    }

    private void updateToDoList(int todoIndex) {
        if (!this.wAll.getSelection()) {
            this.wTodo.remove(this.selectedKey);
            if (this.wTodo.getSelectionIndex() < 0) {
                if (todoIndex > this.wTodo.getItemCount()) {
                    todoIndex = this.wTodo.getItemCount() - 1;
                }
                if (todoIndex >= 0 && todoIndex < this.wTodo.getItemCount()) {
                    this.wTodo.setSelection(todoIndex);
                    this.showKeySelection(this.wTodo.getSelection()[0]);
                } else {
                    this.refreshGrid();
                }
            } else {
                this.showKeySelection(this.wTodo.getSelection()[0]);
            }
        }
    }

    private void revertChangedValue() {
        this.lastValueChanged = false;
        this.refreshGrid();
    }

    public void refresh() {
        this.refreshLocale();
        this.refreshPackages();
        this.refreshGrid();
    }

    public void refreshPackages() {
        int index = this.wPackages.getSelectionIndex();
        int topIndex = this.wPackages.table.getTopIndex();
        this.wPackages.table.setRedraw(false);
        this.wPackages.table.removeAll();
        Map<String, Map<String, List<KeyOccurrence>>> sourceMessagesPackages = this.crawler.getSourcePackageOccurrences();
        ArrayList<String> sourceFolders = new ArrayList<String>(sourceMessagesPackages.keySet());
        sourceFolders.sort(this::pathDepthFirstComparator);
        for (String sourceFolder : sourceFolders) {
            Map<String, List<KeyOccurrence>> messagesPackages = sourceMessagesPackages.get(sourceFolder);
            ArrayList<String> packageNames = new ArrayList<String>(messagesPackages.keySet());
            Collections.sort(packageNames);
            for (String packageName : packageNames) {
                String shortSourceFolder = this.getShortSourceFolder(this.rootFolder, sourceFolder);
                TableItem item = new TableItem(this.wPackages.table, 0);
                item.setText(1, shortSourceFolder);
                item.setText(2, packageName);
                if (this.selectedLocale == null) continue;
                BundleFile bundleFile = this.store.getBundleStore().findBundleFile(packageName, this.selectedLocale);
                if (bundleFile == null) {
                    item.setBackground(new Color((Device)this.shell.getDisplay(), 230, 150, 150));
                    continue;
                }
                List<KeyOccurrence> todo = this.getTodoList(this.selectedLocale, packageName, sourceFolder, true);
                if (todo.size() > 50) {
                    item.setBackground(new Color((Device)this.shell.getDisplay(), this.props.contrastColor(150, 150, 150)));
                    continue;
                }
                if (todo.size() > 25) {
                    item.setBackground(new Color((Device)this.shell.getDisplay(), this.props.contrastColor(170, 170, 170)));
                    continue;
                }
                if (todo.size() > 10) {
                    item.setBackground(new Color((Device)this.shell.getDisplay(), this.props.contrastColor(190, 190, 190)));
                    continue;
                }
                if (todo.size() > 5) {
                    item.setBackground(new Color((Device)this.shell.getDisplay(), this.props.contrastColor(210, 210, 210)));
                    continue;
                }
                if (todo.size() <= 0) continue;
                item.setBackground(new Color((Device)this.shell.getDisplay(), this.props.contrastColor(230, 230, 230)));
            }
            if (messagesPackages.size() == 0) {
                new TableItem(this.wPackages.table, 0);
                continue;
            }
            this.wPackages.setRowNums();
        }
        if (topIndex > 0) {
            this.wPackages.table.setTopIndex(topIndex);
        }
        if (index >= 0) {
            this.wPackages.table.setSelection(index);
        }
        this.wPackages.table.setRedraw(true);
    }

    private String getShortSourceFolder(String rootFolder, String sourceFolder) {
        if (sourceFolder == null) {
            return null;
        }
        try {
            FileObject root = HopVfs.getFileObject((String)rootFolder);
            FileObject source = HopVfs.getFileObject((String)sourceFolder);
            return root.getName().getRelativeName(source.getName());
        }
        catch (Exception e) {
            LogChannel.UI.logError("Error calculating relative source path against '" + rootFolder + "' for source folder: " + sourceFolder, (Throwable)e);
            return sourceFolder;
        }
    }

    private String getLongSourceFolder(String rootFolder, String shortSourceFolder) {
        if (shortSourceFolder == null) {
            return null;
        }
        if (rootFolder.endsWith(File.separator)) {
            return rootFolder + shortSourceFolder;
        }
        return rootFolder + File.separatorChar + shortSourceFolder.replace("/", String.valueOf(File.separatorChar));
    }

    public void refreshLocale() {
        this.wLocale.removeAll();
        this.wLocale.setItems(this.localeList.toArray(new String[this.localeList.size()]));
    }

    public String toString() {
        return APP_NAME;
    }

    private int pathDepthFirstComparator(String path1, String path2) {
        int rs = Integer.compare(path1.split("/").length, path2.split("/").length);
        if (rs == 0) {
            return path1.compareTo(path2);
        }
        return rs;
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.err.println("Usage: Translator <translator.xml> <path-to-source>");
            System.err.println("Example:");
            System.err.println("sh hop-translator.sh translator.xml /home/john/git/hop/");
            System.exit(1);
        }
        HopClientEnvironment.init();
        String configFile = args[0];
        String sourceFolder = args[1];
        Display display = new Display();
        LogChannel log = new LogChannel((Object)APP_NAME);
        HopNamespace.setNamespace(TRANSLATOR_NAMESPACE);
        Translator translator = new Translator(display);
        translator.loadConfiguration(configFile, sourceFolder);
        translator.open();
        try {
            while (!display.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        catch (Throwable e) {
            log.logError(BaseMessages.getString(PKG, (String)"i18n.UnexpectedError", (String[])new String[]{e.getMessage()}));
            log.logError(Const.getStackTracker((Throwable)e));
        }
    }

    private static class TranslateShutdownHook
    extends Thread {
        final Shell shell;
        final Supplier<Boolean> ifNeedSupplier;
        final Runnable doSaveRunnable;
        CountDownLatch exitLatch;

        public TranslateShutdownHook(Shell shell, Supplier<Boolean> ifNeedSupplier, Runnable doSaveRunnable) {
            this.shell = shell;
            this.ifNeedSupplier = ifNeedSupplier;
            this.doSaveRunnable = doSaveRunnable;
        }

        @Override
        public void run() {
            if (!this.ifNeedSupplier.get().booleanValue()) {
                return;
            }
            this.exitLatch = new CountDownLatch(1);
            this.shell.getDisplay().asyncExec(this::asyncSaveFile);
            try {
                this.exitLatch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        private void asyncSaveFile() {
            MessageBox mb = new MessageBox(this.shell, 34);
            mb.setText(BaseMessages.getString((String)"i18nDialog.Information.Title"));
            mb.setMessage(BaseMessages.getString((String)"i18nDialog.ForceSaveChanges.Message"));
            mb.open();
            this.doSaveRunnable.run();
            this.exitLatch.countDown();
        }
    }
}

