/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.widget;

import java.util.ArrayList;
import org.apache.hop.core.Condition;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.ValueMetaAndData;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.dialog.EnterSelectionDialog;
import org.apache.hop.ui.core.dialog.EnterValueDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.util.EnvironmentUtils;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ConditionEditor
extends Canvas
implements MouseMoveListener {
    private static final Class<?> PKG = ConditionEditor.class;
    private static final int X_PADDING = 18;
    private static final String STRING_NOT = BaseMessages.getString(PKG, (String)"ConditionEditor.StringNot", (String[])new String[0]);
    private static final String STRING_UP = BaseMessages.getString(PKG, (String)"ConditionEditor.StringUp", (String[])new String[0]);
    private static final int AREA_NONE = 0;
    private static final int AREA_BACKGROUND = 1;
    private static final int AREA_NOT = 2;
    private static final int AREA_CONDITION = 3;
    private static final int AREA_SUBCONDITION = 4;
    private static final int AREA_OPERATOR = 5;
    private static final int AREA_UP = 6;
    private static final int AREA_LEFT = 7;
    private static final int AREA_FUNCTION = 8;
    private static final int AREA_RIGHT_VALUE = 9;
    private static final int AREA_RIGHT_EXACT = 10;
    private static final int AREA_ICON_ADD = 11;
    protected Canvas widget = this;
    private Shell shell;
    private Display display;
    private Condition activeCondition;
    private Color bg;
    private Color white;
    private Color black;
    private Color red;
    private Color green;
    private Color blue;
    private Color gray;
    private Font fixed;
    private Image imageAdd;
    private Rectangle sizeNot;
    private Rectangle sizeWidget;
    private Rectangle sizeAndNot;
    private Rectangle sizeUp;
    private Rectangle sizeLeft;
    private Rectangle sizeFn;
    private Rectangle sizeRightval;
    private Rectangle sizeRightex;
    private Rectangle[] sizeCond;
    private Rectangle[] sizeOper;
    private Rectangle sizeAdd;
    private Rectangle maxdrawn;
    private int hoverCondition;
    private int hoverOperator;
    private boolean hoverNot;
    private boolean hoverUp;
    private boolean hoverLeft;
    private boolean hoverFn;
    private boolean hoverRightval;
    private boolean hoverRightex;
    private int previousArea;
    private int previousAreaNr;
    private ArrayList<Condition> parents;
    private IRowMeta fields;
    private int maxFieldLength;
    private ScrollBar sbVertical;
    private ScrollBar sbHorizontal;
    private int offsetx;
    private int offsety;
    private ArrayList<ModifyListener> modListeners;
    private String messageString;
    private Menu mPop;

    public ConditionEditor(Composite composite, int arg1, Condition co, IRowMeta inputFields) {
        super(composite, arg1 | 0x40000 | 0x200 | 0x100);
        this.activeCondition = co;
        this.fields = inputFields;
        this.imageAdd = GuiResource.getInstance().getImage("ui/images/add.svg");
        this.modListeners = new ArrayList();
        this.sbVertical = this.getVerticalBar();
        this.sbHorizontal = this.getHorizontalBar();
        this.offsetx = 0;
        this.offsety = 0;
        this.maxdrawn = null;
        this.sizeNot = null;
        this.sizeWidget = null;
        this.sizeCond = null;
        this.previousArea = -1;
        this.previousAreaNr = -1;
        this.parents = new ArrayList();
        this.hoverCondition = -1;
        this.hoverOperator = -1;
        this.hoverNot = false;
        this.hoverUp = false;
        this.hoverLeft = false;
        this.hoverFn = false;
        this.hoverRightval = false;
        this.hoverRightex = false;
        this.getMaxFieldLength();
        this.shell = composite.getShell();
        this.display = this.shell.getDisplay();
        this.bg = GuiResource.getInstance().getColorBackground();
        this.fixed = GuiResource.getInstance().getFontFixed();
        this.white = GuiResource.getInstance().getColorWhite();
        this.black = GuiResource.getInstance().getColorBlack();
        this.red = GuiResource.getInstance().getColorRed();
        this.green = GuiResource.getInstance().getColorGreen();
        this.blue = GuiResource.getInstance().getColorBlue();
        this.gray = GuiResource.getInstance().getColorDarkGray();
        this.widget.addPaintListener(pe -> {
            Rectangle r = this.widget.getBounds();
            if (r.width > 0 && r.height > 0) {
                this.repaint(pe.gc, r.width, r.height);
            }
        });
        if (!EnvironmentUtils.getInstance().isWeb()) {
            this.widget.addMouseMoveListener((MouseMoveListener)this);
        }
        this.widget.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                Point screen = new Point(e.x, e.y);
                int area = ConditionEditor.this.getAreaCode(screen);
                if (e.button == 1) {
                    switch (area) {
                        case 2: {
                            ConditionEditor.this.activeCondition.negate();
                            ConditionEditor.this.setModified();
                            ConditionEditor.this.widget.redraw();
                            break;
                        }
                        case 5: {
                            int operator = ConditionEditor.this.getNrOperator(screen);
                            EnterSelectionDialog esd = new EnterSelectionDialog(ConditionEditor.this.shell, Condition.getRealOperators(), BaseMessages.getString(PKG, (String)"ConditionEditor.Operator.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ConditionEditor.SelectOperator.Label", (String[])new String[0]));
                            esd.setAvoidQuickSearch();
                            Condition selcond = ConditionEditor.this.activeCondition.getCondition(operator);
                            String def = selcond.getOperatorDesc();
                            int defnr = esd.getSelectionNr(Const.trim((String)def));
                            String selection = esd.open(defnr);
                            if (selection != null) {
                                int opnr = Condition.getOperator((String)selection);
                                ConditionEditor.this.activeCondition.getCondition(operator).setOperator(opnr);
                                ConditionEditor.this.setModified();
                            }
                            ConditionEditor.this.widget.redraw();
                            break;
                        }
                        case 4: {
                            int nr = ConditionEditor.this.getNrSubcondition(screen);
                            ConditionEditor.this.editCondition(nr);
                            ConditionEditor.this.setMessageString(BaseMessages.getString(PKG, (String)"ConditionEditor.GoUpOneLevel.Label", (String[])new String[]{"" + ConditionEditor.this.getLevel()}));
                            ConditionEditor.this.redraw();
                            break;
                        }
                        case 6: {
                            ConditionEditor.this.goUp();
                            break;
                        }
                        case 8: {
                            if (!ConditionEditor.this.activeCondition.isAtomic()) break;
                            EnterSelectionDialog esd = new EnterSelectionDialog(ConditionEditor.this.shell, Condition.functions, BaseMessages.getString(PKG, (String)"ConditionEditor.Functions.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ConditionEditor.SelectFunction.Label", (String[])new String[0]));
                            esd.setAvoidQuickSearch();
                            String def = ConditionEditor.this.activeCondition.getFunctionDesc();
                            int defnr = esd.getSelectionNr(def);
                            String selection = esd.open(defnr);
                            if (selection != null) {
                                int fnnr = Condition.getFunction((String)selection);
                                ConditionEditor.this.activeCondition.setFunction(fnnr);
                                if (ConditionEditor.this.activeCondition.getFunction() == 8 || ConditionEditor.this.activeCondition.getFunction() == 7) {
                                    ConditionEditor.this.activeCondition.setRightValuename(null);
                                    ConditionEditor.this.activeCondition.setRightExact(null);
                                }
                                ConditionEditor.this.setModified();
                            }
                            ConditionEditor.this.widget.redraw();
                            break;
                        }
                        case 7: {
                            if (!ConditionEditor.this.activeCondition.isAtomic() || ConditionEditor.this.fields == null) break;
                            EnterSelectionDialog esd = new EnterSelectionDialog(ConditionEditor.this.shell, ConditionEditor.this.fields.getFieldNamesAndTypes(ConditionEditor.this.maxFieldLength), BaseMessages.getString(PKG, (String)"ConditionEditor.Fields", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ConditionEditor.SelectAField", (String[])new String[0]));
                            esd.setAvoidQuickSearch();
                            String def = ConditionEditor.this.activeCondition.getLeftValuename();
                            int defnr = esd.getSelectionNr(def);
                            String selection = esd.open(defnr);
                            if (selection != null) {
                                IValueMeta v = ConditionEditor.this.fields.getValueMeta(esd.getSelectionNr());
                                ConditionEditor.this.activeCondition.setLeftValuename(v.getName());
                                ConditionEditor.this.setModified();
                            }
                            ConditionEditor.this.widget.redraw();
                            break;
                        }
                        case 9: {
                            if (!ConditionEditor.this.activeCondition.isAtomic() || ConditionEditor.this.fields == null) break;
                            EnterSelectionDialog esd = new EnterSelectionDialog(ConditionEditor.this.shell, ConditionEditor.this.fields.getFieldNamesAndTypes(ConditionEditor.this.maxFieldLength), BaseMessages.getString(PKG, (String)"ConditionEditor.Fields", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ConditionEditor.SelectAField", (String[])new String[0]));
                            esd.setAvoidQuickSearch();
                            String def = ConditionEditor.this.activeCondition.getLeftValuename();
                            int defnr = esd.getSelectionNr(def);
                            String selection = esd.open(defnr);
                            if (selection != null) {
                                IValueMeta v = ConditionEditor.this.fields.getValueMeta(esd.getSelectionNr());
                                ConditionEditor.this.activeCondition.setRightValuename(v.getName());
                                ConditionEditor.this.activeCondition.setRightExact(null);
                                ConditionEditor.this.setModified();
                            }
                            ConditionEditor.this.widget.redraw();
                            break;
                        }
                        case 10: {
                            if (!ConditionEditor.this.activeCondition.isAtomic()) break;
                            ValueMetaAndData v = ConditionEditor.this.activeCondition.getRightExact();
                            if (v == null) {
                                IValueMeta leftval;
                                IValueMeta iValueMeta = leftval = ConditionEditor.this.fields != null ? ConditionEditor.this.fields.searchValueMeta(ConditionEditor.this.activeCondition.getLeftValuename()) : null;
                                if (leftval != null) {
                                    try {
                                        v = new ValueMetaAndData(ValueMetaFactory.createValueMeta((String)"constant", (int)leftval.getType()), null);
                                    }
                                    catch (Exception exception) {
                                        new ErrorDialog(ConditionEditor.this.shell, "Error", "Error creating value meta object", exception);
                                    }
                                } else {
                                    v = new ValueMetaAndData((IValueMeta)new ValueMetaString("constant"), null);
                                }
                            }
                            EnterValueDialog evd = new EnterValueDialog(ConditionEditor.this.shell, 0, v.getValueMeta(), v.getValueData());
                            evd.setModalDialog(true);
                            ValueMetaAndData newval = evd.open();
                            if (newval != null) {
                                ConditionEditor.this.activeCondition.setRightValuename(null);
                                ConditionEditor.this.activeCondition.setRightExact(newval);
                                ConditionEditor.this.setModified();
                            }
                            ConditionEditor.this.widget.redraw();
                            break;
                        }
                        case 11: {
                            ConditionEditor.this.addCondition();
                            break;
                        }
                    }
                }
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this.widget.addMenuDetectListener(e -> {
            Point screen = new Point(e.x, e.y);
            Point widgetScreen = this.widget.toDisplay(1, 1);
            Point wRel = new Point(screen.x - widgetScreen.x, screen.y - widgetScreen.y);
            int area = this.getAreaCode(wRel);
            this.setMenu(area, wRel);
        });
        this.sbVertical.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConditionEditor.this.offsety = -ConditionEditor.this.sbVertical.getSelection();
                ConditionEditor.this.widget.redraw();
            }
        });
        this.sbHorizontal.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConditionEditor.this.offsetx = -ConditionEditor.this.sbHorizontal.getSelection();
                ConditionEditor.this.widget.redraw();
            }
        });
        this.widget.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent arg0) {
                ConditionEditor.this.sizeWidget = ConditionEditor.this.widget.getBounds();
                ConditionEditor.this.setBars();
            }
        });
    }

    private void getMaxFieldLength() {
        this.maxFieldLength = 5;
        if (this.fields != null) {
            for (int i = 0; i < this.fields.size(); ++i) {
                int len;
                IValueMeta value = this.fields.getValueMeta(i);
                if (value == null || value.getName() == null || (len = this.fields.getValueMeta(i).getName().length()) <= this.maxFieldLength) continue;
                this.maxFieldLength = len;
            }
        }
    }

    public int getLevel() {
        return this.parents.size();
    }

    public void goUp() {
        if (this.parents.size() > 0) {
            int last = this.parents.size() - 1;
            this.activeCondition = this.parents.get(last);
            this.parents.remove(last);
            this.redraw();
        }
        if (this.getLevel() > 0) {
            this.setMessageString(BaseMessages.getString(PKG, (String)"ConditionEditor.GoUpOneLevel.Label", (String[])new String[]{"" + this.getLevel()}));
        } else {
            this.setMessageString(BaseMessages.getString(PKG, (String)"ConditionEditor.EditSubCondition", (String[])new String[0]));
        }
    }

    private void setMenu(int area, Point screen) {
        final int cond_nr = this.getNrSubcondition(screen);
        if (this.mPop != null && !this.mPop.isDisposed()) {
            this.mPop.dispose();
        }
        switch (area) {
            case 2: {
                this.mPop = new Menu((Control)this.widget);
                MenuItem miNegate = new MenuItem(this.mPop, 8);
                miNegate.setText(BaseMessages.getString(PKG, (String)"ConditionEditor.NegateCondition", (String[])new String[0]));
                miNegate.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ConditionEditor.this.activeCondition.negate();
                        ConditionEditor.this.widget.redraw();
                        ConditionEditor.this.setModified();
                    }
                });
                this.setMenu(this.mPop);
                break;
            }
            case 1: 
            case 11: {
                this.mPop = new Menu((Control)this.widget);
                MenuItem miAdd = new MenuItem(this.mPop, 8);
                miAdd.setText(BaseMessages.getString(PKG, (String)"ConditionEditor.AddCondition.Label", (String[])new String[0]));
                miAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ConditionEditor.this.addCondition();
                    }
                });
                this.setMenu(this.mPop);
                break;
            }
            case 4: {
                this.mPop = new Menu((Control)this.widget);
                MenuItem miEdit = new MenuItem(this.mPop, 8);
                miEdit.setText(BaseMessages.getString(PKG, (String)"ConditionEditor.EditCondition.Label", (String[])new String[0]));
                miEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ConditionEditor.this.editCondition(cond_nr);
                        ConditionEditor.this.setModified();
                        ConditionEditor.this.widget.redraw();
                    }
                });
                MenuItem miDel = new MenuItem(this.mPop, 8);
                miDel.setText(BaseMessages.getString(PKG, (String)"ConditionEditor.DeleteCondition.Label", (String[])new String[0]));
                miDel.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ConditionEditor.this.removeCondition(cond_nr);
                        ConditionEditor.this.setModified();
                        ConditionEditor.this.widget.redraw();
                    }
                });
                final Condition sub = this.activeCondition.getCondition(cond_nr);
                if (sub.getLeftValuename() != null) {
                    MenuItem miAdd = new MenuItem(this.mPop, 8);
                    miAdd.setText(BaseMessages.getString(PKG, (String)"ConditionEditor.AddSubCondition.Label", (String[])new String[0]));
                    miAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            Condition c = new Condition();
                            c.setOperator(2);
                            sub.addCondition(c);
                            ConditionEditor.this.setModified();
                            ConditionEditor.this.widget.redraw();
                        }
                    });
                }
                new MenuItem(this.mPop, 2);
                MenuItem miCopy = new MenuItem(this.mPop, 8);
                miCopy.setText(BaseMessages.getString(PKG, (String)"ConditionEditor.CopyToClipboard", (String[])new String[0]));
                miCopy.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Condition c = ConditionEditor.this.activeCondition.getCondition(cond_nr);
                        try {
                            String xml = c.getXml();
                            GuiResource.getInstance().toClipboard(xml);
                            ConditionEditor.this.widget.redraw();
                        }
                        catch (Exception ex) {
                            new ErrorDialog(ConditionEditor.this.shell, "Error", "Error encoding to XML", ex);
                        }
                    }
                });
                MenuItem miPasteBef = new MenuItem(this.mPop, 8);
                miPasteBef.setText(BaseMessages.getString(PKG, (String)"ConditionEditor.PasteFromClipboardBeforeCondition", (String[])new String[0]));
                miPasteBef.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        String xml = GuiResource.getInstance().fromClipboard();
                        try {
                            Document d = XmlHandler.loadXmlString((String)xml);
                            Node condNode = XmlHandler.getSubNode((Node)d, (String)"condition");
                            if (condNode != null) {
                                Condition c = new Condition(condNode);
                                ConditionEditor.this.activeCondition.addCondition(cond_nr, c);
                                ConditionEditor.this.widget.redraw();
                            } else {
                                new ErrorDialog(ConditionEditor.this.shell, BaseMessages.getString(PKG, (String)"ConditionEditor.Error", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ConditionEditor.NoConditionFoundXML", (String[])new String[0]), (Exception)((Object)new HopXmlException(BaseMessages.getString(PKG, (String)"ConditionEditor.NoConditionFoundXML.Exception", (String[])new String[]{Const.CR + Const.CR + xml}))));
                            }
                        }
                        catch (HopXmlException ex) {
                            new ErrorDialog(ConditionEditor.this.shell, BaseMessages.getString(PKG, (String)"ConditionEditor.Error", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ConditionEditor.ErrorParsingCondition", (String[])new String[0]), (Exception)((Object)ex));
                        }
                    }
                });
                new MenuItem(this.mPop, 2);
                MenuItem miPasteAft = new MenuItem(this.mPop, 8);
                miPasteAft.setText(BaseMessages.getString(PKG, (String)"ConditionEditor.PasteFromClipboardAfterCondition", (String[])new String[0]));
                miPasteAft.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        String xml = GuiResource.getInstance().fromClipboard();
                        try {
                            Document d = XmlHandler.loadXmlString((String)xml);
                            Node condNode = XmlHandler.getSubNode((Node)d, (String)"condition");
                            if (condNode != null) {
                                Condition c = new Condition(condNode);
                                ConditionEditor.this.activeCondition.addCondition(cond_nr + 1, c);
                                ConditionEditor.this.widget.redraw();
                            } else {
                                new ErrorDialog(ConditionEditor.this.shell, BaseMessages.getString(PKG, (String)"ConditionEditor.Error", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ConditionEditor.NoConditionFoundXML", (String[])new String[0]), (Exception)((Object)new HopXmlException(BaseMessages.getString(PKG, (String)"ConditionEditor.NoConditionFoundXML.Exception", (String[])new String[]{Const.CR + Const.CR + xml}))));
                            }
                        }
                        catch (HopXmlException ex) {
                            new ErrorDialog(ConditionEditor.this.shell, BaseMessages.getString(PKG, (String)"ConditionEditor.Error", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ConditionEditor.ErrorParsingCondition", (String[])new String[0]), (Exception)((Object)ex));
                        }
                    }
                });
                new MenuItem(this.mPop, 2);
                MenuItem miMoveSub = new MenuItem(this.mPop, 8);
                miMoveSub.setText(BaseMessages.getString(PKG, (String)"ConditionEditor.MoveConditionToSubCondition", (String[])new String[0]));
                miMoveSub.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Condition down = ConditionEditor.this.activeCondition.getCondition(cond_nr);
                        Condition c = new Condition();
                        c.setOperator(down.getOperator());
                        down.setOperator(0);
                        ConditionEditor.this.activeCondition.setCondition(cond_nr, c);
                        c.addCondition(down);
                        ConditionEditor.this.widget.redraw();
                    }
                });
                MenuItem miMoveParent = new MenuItem(this.mPop, 8);
                miMoveParent.setText(BaseMessages.getString(PKG, (String)"ConditionEditor.MoveConditionToParentCondition", (String[])new String[0]));
                if (this.getLevel() == 0) {
                    miMoveParent.setEnabled(false);
                }
                miMoveParent.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Condition up = ConditionEditor.this.activeCondition.getCondition(cond_nr);
                        ConditionEditor.this.activeCondition.removeCondition(cond_nr);
                        Condition parent = ConditionEditor.this.parents.get(ConditionEditor.this.getLevel() - 1);
                        parent.addCondition(up);
                        ConditionEditor.this.goUp();
                        ConditionEditor.this.widget.redraw();
                    }
                });
                new MenuItem(this.mPop, 2);
                MenuItem miMoveDown = new MenuItem(this.mPop, 8);
                miMoveDown.setText(BaseMessages.getString(PKG, (String)"ConditionEditor.MoveConditionDown", (String[])new String[0]));
                if (cond_nr >= this.activeCondition.nrConditions() - 1) {
                    miMoveDown.setEnabled(false);
                }
                miMoveDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Condition down = ConditionEditor.this.activeCondition.getCondition(cond_nr);
                        ConditionEditor.this.activeCondition.removeCondition(cond_nr);
                        ConditionEditor.this.activeCondition.addCondition(cond_nr + 1, down);
                        ConditionEditor.this.widget.redraw();
                    }
                });
                MenuItem miMoveUp = new MenuItem(this.mPop, 8);
                miMoveUp.setText(BaseMessages.getString(PKG, (String)"ConditionEditor.MoveConditionUp", (String[])new String[0]));
                if (cond_nr == 0) {
                    miMoveUp.setEnabled(false);
                }
                miMoveUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Condition up = ConditionEditor.this.activeCondition.getCondition(cond_nr);
                        ConditionEditor.this.activeCondition.removeCondition(cond_nr);
                        ConditionEditor.this.activeCondition.addCondition(cond_nr - 1, up);
                        ConditionEditor.this.widget.redraw();
                    }
                });
                this.setMenu(this.mPop);
                break;
            }
            case 5: {
                Menu mPop = new Menu((Control)this.widget);
                MenuItem miDown = new MenuItem(mPop, 8);
                miDown.setText(BaseMessages.getString(PKG, (String)"ConditionEditor.MoveDown", (String[])new String[0]));
                miDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ConditionEditor.this.setModified();
                        ConditionEditor.this.widget.redraw();
                    }
                });
                this.setMenu(mPop);
                break;
            }
            default: {
                this.setMenu(null);
            }
        }
    }

    public void repaint(GC gc, int width, int height) {
        this.sizeNot = this.getNotSize(gc);
        this.sizeWidget = this.getWidgetSize(gc);
        this.sizeAndNot = this.getAndNotSize(gc);
        this.sizeUp = this.getUpSize(gc);
        this.sizeAdd = this.getAddSize(gc);
        this.sizeLeft = null;
        this.sizeFn = null;
        this.sizeRightval = null;
        this.sizeRightex = null;
        gc.setBackground(this.white);
        gc.setForeground(this.black);
        gc.fillRectangle(0, 0, width, height);
        gc.setFont(this.fixed);
        if (this.activeCondition.isAtomic()) {
            this.sizeCond = null;
            this.drawNegated(gc, 0, 0, this.activeCondition);
            this.drawAtomic(gc, 0, 0, this.activeCondition);
        } else {
            this.drawNegated(gc, 0, 0, this.activeCondition);
            this.sizeCond = new Rectangle[this.activeCondition.nrConditions()];
            this.sizeOper = new Rectangle[this.activeCondition.nrConditions()];
            int basex = 10;
            int basey = this.sizeNot.y + 5;
            for (int i = 0; i < this.activeCondition.nrConditions(); ++i) {
                Point to = this.drawCondition(gc, basex, basey, i, this.activeCondition.getCondition(i));
                basey += this.sizeAndNot.height + to.y + 15;
            }
        }
        gc.drawImage(this.imageAdd, this.sizeAdd.x, this.sizeAdd.y);
        if (this.parents.size() > 0) {
            this.drawUp(gc);
        }
        if (this.messageString != null) {
            this.drawMessage(gc);
        }
        this.getMaxSize();
        this.setBars();
    }

    private Rectangle getNotSize(GC gc) {
        Point p = gc.textExtent(STRING_NOT);
        return new Rectangle(0, 0, p.x + 10, p.y + 4);
    }

    private Rectangle getWidgetSize(GC gc) {
        return this.widget.getBounds();
    }

    private Rectangle getAndNotSize(GC gc) {
        Point p = gc.textExtent(Condition.operators[5]);
        return new Rectangle(0, 0, p.x, p.y);
    }

    private Rectangle getUpSize(GC gc) {
        Point p = gc.textExtent(STRING_UP);
        return new Rectangle(this.sizeNot.x + this.sizeNot.width + 40, this.sizeNot.y, p.x + 20, this.sizeNot.height);
    }

    private Rectangle getAddSize(GC gc) {
        Rectangle is = this.imageAdd.getBounds();
        Rectangle cs = this.getBounds();
        return new Rectangle(cs.width - is.width - 5 - 18, 5, is.width, is.height);
    }

    private void drawNegated(GC gc, int x, int y, Condition condition) {
        Color color = gc.getForeground();
        if (this.hoverNot) {
            gc.setBackground(this.gray);
        }
        gc.fillRectangle(this.real2Screen(this.sizeNot));
        gc.drawRectangle(this.real2Screen(this.sizeNot));
        if (condition.isNegated()) {
            if (this.hoverNot) {
                gc.setForeground(this.green);
            }
            gc.drawText(STRING_NOT, this.sizeNot.x + 5 + this.offsetx, this.sizeNot.y + 2 + this.offsety, 1);
            gc.drawText(STRING_NOT, this.sizeNot.x + 6 + this.offsetx, this.sizeNot.y + 2 + this.offsety, 1);
            if (this.hoverNot) {
                gc.setForeground(color);
            }
        } else if (this.hoverNot) {
            gc.setForeground(this.red);
            gc.drawText(STRING_NOT, this.sizeNot.x + 5 + this.offsetx, this.sizeNot.y + 2 + this.offsety, 1);
            gc.drawText(STRING_NOT, this.sizeNot.x + 6 + this.offsetx, this.sizeNot.y + 2 + this.offsety, 1);
            gc.setForeground(color);
        }
        if (this.hoverNot) {
            gc.setBackground(this.bg);
        }
    }

    private void drawAtomic(GC gc, int x, int y, Condition condition) {
        String rightex;
        String left = Const.rightPad((String)condition.getLeftValuename(), (int)this.maxFieldLength);
        Point extLeft = gc.textExtent(left);
        if (condition.getLeftValuename() == null) {
            extLeft = gc.textExtent("<field>");
        }
        String fnMax = Condition.functions[8];
        String fn = condition.getFunctionDesc();
        Point extFn = gc.textExtent(fnMax);
        String rightval = Const.rightPad((String)condition.getRightValuename(), (int)this.maxFieldLength);
        Point extRval = gc.textExtent(rightval);
        if (condition.getLeftValuename() == null) {
            extRval = gc.textExtent("<field>");
        }
        String rightexMax = rightex = condition.getRightExactString();
        if (rightex == null) {
            rightexMax = Const.rightPad((String)" ", (int)10);
        } else if (rightex.length() < 10) {
            rightexMax = Const.rightPad((String)rightex, (int)10);
        }
        Point extRex = gc.textExtent(rightexMax);
        this.sizeLeft = new Rectangle(x + 5, y + this.sizeNot.height + 5, extLeft.x + 5, extLeft.y + 5);
        this.sizeFn = new Rectangle(this.sizeLeft.x + this.sizeLeft.width + 15, y + this.sizeNot.height + 5, extFn.x + 5, extFn.y + 5);
        this.sizeRightval = new Rectangle(this.sizeFn.x + this.sizeFn.width + 15, y + this.sizeNot.height + 5, extRval.x + 5, extRval.y + 5);
        this.sizeRightex = new Rectangle(this.sizeFn.x + this.sizeFn.width + 15, y + this.sizeNot.height + 5 + this.sizeRightval.height + 5, extRex.x + 5, extRex.y + 5);
        if (this.hoverLeft) {
            gc.setBackground(this.gray);
        }
        gc.fillRectangle(this.real2Screen(this.sizeLeft));
        gc.drawRectangle(this.real2Screen(this.sizeLeft));
        gc.setBackground(this.bg);
        if (this.hoverFn) {
            gc.setBackground(this.gray);
        }
        gc.fillRectangle(this.real2Screen(this.sizeFn));
        gc.drawRectangle(this.real2Screen(this.sizeFn));
        gc.setBackground(this.bg);
        if (this.hoverRightval) {
            gc.setBackground(this.gray);
        }
        gc.fillRectangle(this.real2Screen(this.sizeRightval));
        gc.drawRectangle(this.real2Screen(this.sizeRightval));
        gc.setBackground(this.bg);
        if (this.hoverRightex) {
            gc.setBackground(this.gray);
        }
        gc.fillRectangle(this.real2Screen(this.sizeRightex));
        gc.drawRectangle(this.real2Screen(this.sizeRightex));
        gc.setBackground(this.bg);
        if (condition.getLeftValuename() != null) {
            gc.drawText(left, this.sizeLeft.x + 1 + this.offsetx, this.sizeLeft.y + 1 + this.offsety, 1);
        } else {
            gc.setForeground(this.gray);
            gc.drawText("<field>", this.sizeLeft.x + 1 + this.offsetx, this.sizeLeft.y + 1 + this.offsety, 1);
            gc.setForeground(this.black);
        }
        gc.drawText(fn, this.sizeFn.x + 1 + this.offsetx, this.sizeFn.y + 1 + this.offsety, 1);
        if (condition.getFunction() != 8 && condition.getFunction() != 7) {
            String nothing;
            String re = rightex == null ? "" : rightex;
            Object stype = "";
            ValueMetaAndData v = condition.getRightExact();
            if (v != null) {
                stype = " (" + v.getValueMeta().getTypeDesc() + ")";
            }
            if (condition.getRightValuename() != null) {
                gc.drawText(rightval, this.sizeRightval.x + 1 + this.offsetx, this.sizeRightval.y + 1 + this.offsety, 1);
            } else {
                nothing = rightex == null ? "<field>" : "";
                gc.setForeground(this.gray);
                gc.drawText(nothing, this.sizeRightval.x + 1 + this.offsetx, this.sizeRightval.y + 1 + this.offsety, 1);
                if (condition.getRightValuename() == null) {
                    gc.setForeground(this.black);
                }
            }
            if (rightex != null) {
                gc.drawText(re, this.sizeRightex.x + 1 + this.offsetx, this.sizeRightex.y + 1 + this.offsety, 1);
            } else {
                nothing = condition.getRightValuename() == null ? "<value>" : "";
                gc.setForeground(this.gray);
                gc.drawText(nothing, this.sizeRightex.x + 1 + this.offsetx, this.sizeRightex.y + 1 + this.offsety, 1);
                gc.setForeground(this.black);
            }
            gc.drawText((String)stype, this.sizeRightex.x + 1 + this.sizeRightex.width + 10 + this.offsetx, this.sizeRightex.y + 1 + this.offsety, 1);
        } else {
            gc.drawText("-", this.sizeRightval.x + 1 + this.offsetx, this.sizeRightval.y + 1 + this.offsety, 1);
            gc.drawText("-", this.sizeRightex.x + 1 + this.offsetx, this.sizeRightex.y + 1 + this.offsety, 1);
        }
    }

    private Point drawCondition(GC gc, int x, int y, int nr, Condition condition) {
        int opx = x;
        int opy = y;
        int opw = this.sizeAndNot.width + 6;
        int oph = this.sizeAndNot.height + 2;
        if (nr > 0) {
            String operator = condition.getOperatorDesc();
            this.sizeOper[nr] = new Rectangle(opx, opy, opw, oph);
            if (nr == this.hoverOperator) {
                gc.setBackground(this.gray);
                gc.fillRectangle(this.real2Screen(this.sizeOper[nr]));
                gc.drawRectangle(this.real2Screen(this.sizeOper[nr]));
                gc.setBackground(this.bg);
            }
            gc.drawText(operator, this.sizeOper[nr].x + 2 + this.offsetx, this.sizeOper[nr].y + 2 + this.offsety, 1);
        }
        String str = condition.toString(0, true, false);
        Point p = gc.textExtent(str);
        int cx = opx + 23;
        int cy = opy + oph + 10;
        int cw = p.x + 5;
        int ch = p.y + 5;
        this.sizeCond[nr] = new Rectangle(cx, cy, cw, ch);
        if (nr == this.hoverCondition) {
            gc.setBackground(this.gray);
            gc.fillRectangle(this.real2Screen(this.sizeCond[nr]));
            gc.drawRectangle(this.real2Screen(this.sizeCond[nr]));
            gc.setBackground(this.bg);
        }
        gc.drawText(str, this.sizeCond[nr].x + 2 + this.offsetx, this.sizeCond[nr].y + 5 + this.offsety, 15);
        p.x += 0;
        p.y += 5;
        return p;
    }

    public void drawUp(GC gc) {
        if (this.hoverUp) {
            gc.setBackground(this.gray);
            gc.fillRectangle(this.sizeUp);
        }
        gc.drawRectangle(this.sizeUp);
        gc.drawText(STRING_UP, this.sizeUp.x + 1 + this.offsetx, this.sizeUp.y + 1 + this.offsety, 1);
    }

    public void drawMessage(GC gc) {
        gc.setForeground(this.blue);
        gc.drawText(this.getMessageString(), this.sizeUp.x + this.sizeUp.width + this.offsetx + 40, this.sizeUp.y + 1 + this.offsety, 1);
    }

    private boolean isInNot(Point screen) {
        if (this.sizeNot == null) {
            return false;
        }
        return this.real2Screen(this.sizeNot).contains(screen);
    }

    private boolean isInUp(Point screen) {
        if (this.sizeUp == null || this.parents.isEmpty()) {
            return false;
        }
        return this.real2Screen(this.sizeUp).contains(screen);
    }

    private boolean isInAdd(Point screen) {
        if (this.sizeAdd == null || screen == null) {
            return false;
        }
        return this.sizeAdd.contains(screen);
    }

    private boolean isInWidget(Point screen) {
        if (this.sizeWidget == null) {
            return false;
        }
        return this.real2Screen(this.sizeWidget).contains(screen);
    }

    private int getNrSubcondition(Point screen) {
        if (this.sizeCond == null) {
            return -1;
        }
        for (int i = 0; i < this.sizeCond.length; ++i) {
            if (this.sizeCond[i] == null || !this.screen2Real(this.sizeCond[i]).contains(screen)) continue;
            return i;
        }
        return -1;
    }

    private boolean isInSubcondition(Point screen) {
        return this.getNrSubcondition(screen) >= 0;
    }

    private int getNrOperator(Point screen) {
        if (this.sizeOper == null) {
            return -1;
        }
        for (int i = 0; i < this.sizeOper.length; ++i) {
            if (this.sizeOper[i] == null || !this.screen2Real(this.sizeOper[i]).contains(screen)) continue;
            return i;
        }
        return -1;
    }

    private boolean isInOperator(Point screen) {
        return this.getNrOperator(screen) >= 0;
    }

    private boolean isInLeft(Point screen) {
        if (this.sizeLeft == null) {
            return false;
        }
        return this.real2Screen(this.sizeLeft).contains(screen);
    }

    private boolean isInFunction(Point screen) {
        if (this.sizeFn == null) {
            return false;
        }
        return this.real2Screen(this.sizeFn).contains(screen);
    }

    private boolean isInRightValue(Point screen) {
        if (this.sizeRightval == null) {
            return false;
        }
        return this.real2Screen(this.sizeRightval).contains(screen);
    }

    private boolean isInRightExact(Point screen) {
        if (this.sizeRightex == null) {
            return false;
        }
        return this.real2Screen(this.sizeRightex).contains(screen);
    }

    private int getAreaCode(Point screen) {
        if (this.isInNot(screen)) {
            return 2;
        }
        if (this.isInUp(screen)) {
            return 6;
        }
        if (this.isInAdd(screen)) {
            return 11;
        }
        if (this.activeCondition.isAtomic()) {
            if (this.isInLeft(screen)) {
                return 7;
            }
            if (this.isInFunction(screen)) {
                return 8;
            }
            if (this.isInRightExact(screen)) {
                return 10;
            }
            if (this.isInRightValue(screen)) {
                return 9;
            }
        } else {
            if (this.isInSubcondition(screen)) {
                return 4;
            }
            if (this.isInOperator(screen)) {
                return 5;
            }
        }
        if (this.isInWidget(screen)) {
            return 1;
        }
        return 0;
    }

    private void editCondition(int nr) {
        if (this.activeCondition.isComposite()) {
            this.parents.add(this.activeCondition);
            this.activeCondition = this.activeCondition.getCondition(nr);
        }
    }

    private void addCondition() {
        Condition c = new Condition();
        c.setOperator(2);
        this.addCondition(c);
        this.setModified();
        this.widget.redraw();
    }

    private void addCondition(Condition condition) {
        this.activeCondition.addCondition(condition);
    }

    private void removeCondition(int nr) {
        this.activeCondition.removeCondition(nr);
    }

    public void setMessageString(String messageString) {
        this.messageString = messageString;
    }

    public String getMessageString() {
        return this.messageString;
    }

    private Rectangle real2Screen(Rectangle r) {
        return new Rectangle(r.x + this.offsetx, r.y + this.offsety, r.width, r.height);
    }

    private Rectangle screen2Real(Rectangle r) {
        return new Rectangle(r.x - this.offsetx, r.y - this.offsety, r.width, r.height);
    }

    private void getMaxSize() {
        this.maxdrawn = this.sizeNot.union(this.sizeUp);
        if (this.activeCondition.isAtomic()) {
            this.maxdrawn = this.maxdrawn.union(this.sizeLeft);
            this.maxdrawn = this.maxdrawn.union(this.sizeFn);
            this.maxdrawn = this.maxdrawn.union(this.sizeRightval);
            this.maxdrawn = this.maxdrawn.union(this.sizeRightex);
            this.maxdrawn.width += 100;
        } else {
            int i;
            if (this.sizeCond != null) {
                for (i = 0; i < this.sizeCond.length; ++i) {
                    if (this.sizeCond[i] == null) continue;
                    this.maxdrawn = this.maxdrawn.union(this.sizeCond[i]);
                }
            }
            if (this.sizeOper != null) {
                for (i = 0; i < this.sizeOper.length; ++i) {
                    if (this.sizeOper[i] == null) continue;
                    this.maxdrawn = this.maxdrawn.union(this.sizeOper[i]);
                }
            }
        }
        this.maxdrawn.width += 10;
        this.maxdrawn.height += 10;
    }

    private void setBars() {
        if (this.sizeWidget == null || this.maxdrawn == null) {
            return;
        }
        if (this.sizeWidget.width > this.maxdrawn.width) {
            this.offsetx = 0;
            this.sbHorizontal.setSelection(0);
            this.sbHorizontal.setVisible(false);
        } else {
            this.offsetx = -this.sbHorizontal.getSelection();
            this.sbHorizontal.setVisible(true);
            this.sbHorizontal.setMaximum(this.maxdrawn.width);
            this.sbHorizontal.setMinimum(0);
            if (!EnvironmentUtils.getInstance().isWeb()) {
                this.sbHorizontal.setPageIncrement(this.sizeWidget.width);
                this.sbHorizontal.setIncrement(10);
            }
        }
        if (this.sizeWidget.height > this.maxdrawn.height) {
            this.offsety = 0;
            this.sbVertical.setSelection(0);
            this.sbVertical.setVisible(false);
        } else {
            this.offsety = this.sbVertical.getSelection();
            this.sbVertical.setVisible(true);
            this.sbVertical.setMaximum(this.maxdrawn.height);
            this.sbVertical.setMinimum(0);
            if (!EnvironmentUtils.getInstance().isWeb()) {
                this.sbVertical.setPageIncrement(this.sizeWidget.height);
                this.sbVertical.setIncrement(10);
            }
        }
    }

    public void addModifyListener(ModifyListener lsMod) {
        this.modListeners.add(lsMod);
    }

    public void setModified() {
        for (int i = 0; i < this.modListeners.size(); ++i) {
            ModifyListener lsMod = this.modListeners.get(i);
            if (lsMod == null) continue;
            Event e = new Event();
            e.widget = this;
            lsMod.modifyText(new ModifyEvent(e));
        }
    }

    public void mouseMove(MouseEvent e) {
        Point screen = new Point(e.x, e.y);
        int area = this.getAreaCode(screen);
        int nr = 0;
        boolean needRedraw = false;
        this.hoverCondition = -1;
        this.hoverOperator = -1;
        this.hoverNot = false;
        this.hoverUp = false;
        this.hoverLeft = false;
        this.hoverFn = false;
        this.hoverRightval = false;
        this.hoverRightex = false;
        if (area != 11) {
            this.setToolTipText(null);
        } else {
            this.setToolTipText(BaseMessages.getString(PKG, (String)"ConditionEditor.AddCondition.Label", (String[])new String[0]));
        }
        switch (area) {
            case 2: {
                this.hoverNot = true;
                nr = 1;
                break;
            }
            case 6: {
                this.hoverUp = this.getLevel() > 0;
                nr = 1;
                break;
            }
            case 1: {
                break;
            }
            case 4: {
                nr = this.hoverCondition = this.getNrSubcondition(screen);
                break;
            }
            case 5: {
                nr = this.hoverOperator = this.getNrOperator(screen);
                break;
            }
            case 7: {
                this.hoverLeft = true;
                nr = 1;
                break;
            }
            case 8: {
                this.hoverFn = true;
                nr = 1;
                break;
            }
            case 9: {
                this.hoverRightval = true;
                nr = 1;
                break;
            }
            case 10: {
                this.hoverRightex = true;
                nr = 1;
                break;
            }
            case 3: {
                break;
            }
            case 0: {
                break;
            }
        }
        if (area != this.previousArea || nr != this.previousAreaNr) {
            needRedraw = true;
        }
        if (needRedraw) {
            this.offsetx = -this.sbHorizontal.getSelection();
            this.offsety = -this.sbVertical.getSelection();
            this.widget.redraw();
        }
        this.previousArea = area;
        this.previousAreaNr = nr;
    }
}

