/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.vendor.grpc.v1p43p2.io.opencensus.trace;

import javax.annotation.concurrent.Immutable;
import org.apache.beam.vendor.grpc.v1p43p2.io.opencensus.common.Function;
import org.apache.beam.vendor.grpc.v1p43p2.io.opencensus.internal.Utils;
import org.apache.beam.vendor.grpc.v1p43p2.io.opencensus.trace.AutoValue_AttributeValue_AttributeValueBoolean;
import org.apache.beam.vendor.grpc.v1p43p2.io.opencensus.trace.AutoValue_AttributeValue_AttributeValueDouble;
import org.apache.beam.vendor.grpc.v1p43p2.io.opencensus.trace.AutoValue_AttributeValue_AttributeValueLong;
import org.apache.beam.vendor.grpc.v1p43p2.io.opencensus.trace.AutoValue_AttributeValue_AttributeValueString;

@Immutable
public abstract class AttributeValue {
    public static AttributeValue stringAttributeValue(String stringValue) {
        return AttributeValueString.create(stringValue);
    }

    public static AttributeValue booleanAttributeValue(boolean booleanValue) {
        return AttributeValueBoolean.create(booleanValue);
    }

    public static AttributeValue longAttributeValue(long longValue) {
        return AttributeValueLong.create(longValue);
    }

    public static AttributeValue doubleAttributeValue(double doubleValue) {
        return AttributeValueDouble.create(doubleValue);
    }

    AttributeValue() {
    }

    @Deprecated
    public abstract <T> T match(Function<? super String, T> var1, Function<? super Boolean, T> var2, Function<? super Long, T> var3, Function<Object, T> var4);

    public abstract <T> T match(Function<? super String, T> var1, Function<? super Boolean, T> var2, Function<? super Long, T> var3, Function<? super Double, T> var4, Function<Object, T> var5);

    @Immutable
    static abstract class AttributeValueDouble
    extends AttributeValue {
        AttributeValueDouble() {
        }

        static AttributeValue create(Double doubleValue) {
            return new AutoValue_AttributeValue_AttributeValueDouble(Utils.checkNotNull(doubleValue, "doubleValue"));
        }

        @Override
        public final <T> T match(Function<? super String, T> stringFunction, Function<? super Boolean, T> booleanFunction, Function<? super Long, T> longFunction, Function<Object, T> defaultFunction) {
            return defaultFunction.apply(this.getDoubleValue());
        }

        @Override
        public final <T> T match(Function<? super String, T> stringFunction, Function<? super Boolean, T> booleanFunction, Function<? super Long, T> longFunction, Function<? super Double, T> doubleFunction, Function<Object, T> defaultFunction) {
            return doubleFunction.apply(this.getDoubleValue());
        }

        abstract Double getDoubleValue();
    }

    @Immutable
    static abstract class AttributeValueLong
    extends AttributeValue {
        AttributeValueLong() {
        }

        static AttributeValue create(Long longValue) {
            return new AutoValue_AttributeValue_AttributeValueLong(Utils.checkNotNull(longValue, "longValue"));
        }

        @Override
        public final <T> T match(Function<? super String, T> stringFunction, Function<? super Boolean, T> booleanFunction, Function<? super Long, T> longFunction, Function<Object, T> defaultFunction) {
            return longFunction.apply(this.getLongValue());
        }

        @Override
        public final <T> T match(Function<? super String, T> stringFunction, Function<? super Boolean, T> booleanFunction, Function<? super Long, T> longFunction, Function<? super Double, T> doubleFunction, Function<Object, T> defaultFunction) {
            return longFunction.apply(this.getLongValue());
        }

        abstract Long getLongValue();
    }

    @Immutable
    static abstract class AttributeValueBoolean
    extends AttributeValue {
        AttributeValueBoolean() {
        }

        static AttributeValue create(Boolean booleanValue) {
            return new AutoValue_AttributeValue_AttributeValueBoolean(Utils.checkNotNull(booleanValue, "booleanValue"));
        }

        @Override
        public final <T> T match(Function<? super String, T> stringFunction, Function<? super Boolean, T> booleanFunction, Function<? super Long, T> longFunction, Function<Object, T> defaultFunction) {
            return booleanFunction.apply(this.getBooleanValue());
        }

        @Override
        public final <T> T match(Function<? super String, T> stringFunction, Function<? super Boolean, T> booleanFunction, Function<? super Long, T> longFunction, Function<? super Double, T> doubleFunction, Function<Object, T> defaultFunction) {
            return booleanFunction.apply(this.getBooleanValue());
        }

        abstract Boolean getBooleanValue();
    }

    @Immutable
    static abstract class AttributeValueString
    extends AttributeValue {
        AttributeValueString() {
        }

        static AttributeValue create(String stringValue) {
            return new AutoValue_AttributeValue_AttributeValueString(Utils.checkNotNull(stringValue, "stringValue"));
        }

        @Override
        public final <T> T match(Function<? super String, T> stringFunction, Function<? super Boolean, T> booleanFunction, Function<? super Long, T> longFunction, Function<Object, T> defaultFunction) {
            return stringFunction.apply(this.getStringValue());
        }

        @Override
        public final <T> T match(Function<? super String, T> stringFunction, Function<? super Boolean, T> booleanFunction, Function<? super Long, T> longFunction, Function<? super Double, T> doubleFunction, Function<Object, T> defaultFunction) {
            return stringFunction.apply(this.getStringValue());
        }

        abstract String getStringValue();
    }
}

