/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.rest.directory;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Produces;
import org.apache.guacamole.GuacamoleClientException;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.net.auth.Directory;
import org.apache.guacamole.net.auth.Identifiable;
import org.apache.guacamole.net.auth.UserContext;
import org.apache.guacamole.rest.directory.DirectoryObjectTranslator;

@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public abstract class DirectoryObjectResource<InternalType extends Identifiable, ExternalType> {
    private final UserContext userContext;
    private final Directory<InternalType> directory;
    private final InternalType object;
    private final DirectoryObjectTranslator<InternalType, ExternalType> translator;

    public DirectoryObjectResource(UserContext userContext, Directory<InternalType> directory, InternalType object, DirectoryObjectTranslator<InternalType, ExternalType> translator) {
        this.userContext = userContext;
        this.directory = directory;
        this.object = object;
        this.translator = translator;
    }

    @GET
    public ExternalType getObject() throws GuacamoleException {
        return (ExternalType)this.translator.toExternalObject(this.object);
    }

    @PUT
    public void updateObject(ExternalType modifiedObject) throws GuacamoleException {
        if (modifiedObject == null) {
            throw new GuacamoleClientException("Data must be submitted when updating objects.");
        }
        this.translator.filterExternalObject(this.userContext, modifiedObject);
        this.translator.applyExternalChanges(this.object, modifiedObject);
        this.directory.update(this.object);
    }

    @DELETE
    public void deleteObject() throws GuacamoleException {
        this.directory.remove(this.object.getIdentifier());
    }
}

