/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.configuration.converters;

import org.apache.commons.lang3.StringUtils;
import org.apache.geode.cache.configuration.DeclarableType;
import org.apache.geode.cache.configuration.PdxType;
import org.apache.geode.management.configuration.AutoSerializer;
import org.apache.geode.management.configuration.ClassName;
import org.apache.geode.management.configuration.Pdx;
import org.apache.geode.management.internal.configuration.converters.AutoSerializerConverter;
import org.apache.geode.management.internal.configuration.converters.ClassNameConverter;
import org.apache.geode.management.internal.configuration.converters.ConfigurationConverter;

public class PdxConverter
extends ConfigurationConverter<Pdx, PdxType> {
    private final ClassNameConverter converter = new ClassNameConverter();
    private final AutoSerializerConverter autoSerializerConverter = new AutoSerializerConverter();

    @Override
    protected Pdx fromNonNullXmlObject(PdxType xmlObject) {
        Pdx pdx = new Pdx();
        pdx.setReadSerialized(xmlObject.isReadSerialized());
        if (xmlObject.isPersistent().booleanValue()) {
            String diskStoreName = xmlObject.getDiskStoreName();
            if (StringUtils.isBlank((CharSequence)diskStoreName)) {
                diskStoreName = "DEFAULT";
            }
            pdx.setDiskStoreName(diskStoreName);
        }
        pdx.setIgnoreUnreadFields(xmlObject.isIgnoreUnreadFields());
        AutoSerializer autoSerializer = (AutoSerializer)this.autoSerializerConverter.fromXmlObject(xmlObject.getPdxSerializer());
        if (autoSerializer == null) {
            ClassName className = (ClassName)this.converter.fromXmlObject(xmlObject.getPdxSerializer());
            pdx.setPdxSerializer(className);
        } else {
            pdx.setAutoSerializer(autoSerializer);
        }
        return pdx;
    }

    @Override
    protected PdxType fromNonNullConfigObject(Pdx configObject) {
        PdxType xmlType = new PdxType();
        xmlType.setReadSerialized(configObject.isReadSerialized());
        xmlType.setDiskStoreName(configObject.getDiskStoreName());
        xmlType.setIgnoreUnreadFields(configObject.isIgnoreUnreadFields());
        xmlType.setPersistent(configObject.getDiskStoreName() != null);
        DeclarableType pdxSerializer = (DeclarableType)this.autoSerializerConverter.fromConfigObject(configObject.getAutoSerializer());
        if (pdxSerializer == null) {
            pdxSerializer = (DeclarableType)this.converter.fromConfigObject(configObject.getPdxSerializer());
        }
        xmlType.setPdxSerializer(pdxSerializer);
        return xmlType;
    }
}

