/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.persistence;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.InetAddress;
import org.apache.geode.DataSerializable;
import org.apache.geode.DataSerializer;
import org.apache.geode.internal.cache.persistence.DiskStoreID;
import org.apache.geode.internal.cache.versions.VersionSource;

public class PersistentMemberID
implements DataSerializable {
    private static final long serialVersionUID = 7037022320499508045L;
    private InetAddress host;
    private String directory;
    private long timeStamp;
    private short version;
    private DiskStoreID diskStoreId;
    private String name;

    public PersistentMemberID() {
    }

    public PersistentMemberID(DiskStoreID diskStoreId, InetAddress host, String directory, String name, long timeStamp, short version) {
        this.diskStoreId = diskStoreId;
        this.host = host;
        this.directory = directory;
        this.name = name;
        this.timeStamp = timeStamp;
        this.version = version;
    }

    public PersistentMemberID(DiskStoreID diskStoreId, InetAddress host, String directory, long timeStamp, short version) {
        this.diskStoreId = diskStoreId;
        this.host = host;
        this.directory = directory;
        this.timeStamp = timeStamp;
        this.version = version;
    }

    public boolean isOlderOrEqualVersionOf(PersistentMemberID id) {
        return id != null && this.diskStoreId.equals(id.diskStoreId) && this.timeStamp <= id.timeStamp && (this.timeStamp < id.timeStamp || this.version <= id.version);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        long diskStoreIdHigh = in.readLong();
        long diskStoreIdLow = in.readLong();
        this.diskStoreId = new DiskStoreID(diskStoreIdHigh, diskStoreIdLow);
        this.host = DataSerializer.readInetAddress(in);
        this.directory = DataSerializer.readString(in);
        this.timeStamp = in.readLong();
        this.version = in.readShort();
        this.name = DataSerializer.readString(in);
    }

    public void _fromData662(DataInput in) throws IOException, ClassNotFoundException {
        long diskStoreIdHigh = in.readLong();
        long diskStoreIdLow = in.readLong();
        this.diskStoreId = new DiskStoreID(diskStoreIdHigh, diskStoreIdLow);
        this.host = DataSerializer.readInetAddress(in);
        this.directory = DataSerializer.readString(in);
        this.timeStamp = in.readLong();
        this.version = in.readShort();
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        out.writeLong(this.diskStoreId.getMostSignificantBits());
        out.writeLong(this.diskStoreId.getLeastSignificantBits());
        DataSerializer.writeInetAddress(this.host, out);
        DataSerializer.writeString(this.directory, out);
        out.writeLong(this.timeStamp);
        out.writeShort(this.version);
        DataSerializer.writeString(this.name, out);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.diskStoreId == null ? 0 : this.diskStoreId.hashCode());
        result = 31 * result + (this.directory == null ? 0 : this.directory.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        result = 31 * result + (int)(this.timeStamp ^ this.timeStamp >>> 32);
        result = 31 * result + this.version;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PersistentMemberID other = (PersistentMemberID)obj;
        if (this.directory == null ? other.directory != null : !this.directory.equals(other.directory)) {
            return false;
        }
        if (this.diskStoreId == null ? other.diskStoreId != null : !this.diskStoreId.equals(other.diskStoreId)) {
            return false;
        }
        if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
            return false;
        }
        if (this.timeStamp != other.timeStamp) {
            return false;
        }
        if (this.version != other.version) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        return this.host + ":" + this.directory + " created at timestamp " + this.timeStamp + " version " + this.version + " diskStoreId " + this.diskStoreId + " name " + this.name;
    }

    public String abbrev() {
        return this.diskStoreId.abbrev();
    }

    public VersionSource getVersionMember() {
        return this.diskStoreId;
    }

    public InetAddress getHost() {
        return this.host;
    }

    public String getDirectory() {
        return this.directory;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public short getVersion() {
        return this.version;
    }

    public DiskStoreID getDiskStoreId() {
        return this.diskStoreId;
    }

    public String getName() {
        return this.name;
    }
}

