/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.runtime.event.TaskEvent;
import org.apache.flink.runtime.io.network.TaskEventPublisher;
import org.apache.flink.runtime.io.network.api.TaskEventHandler;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.util.event.EventListener;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskEventDispatcher
implements TaskEventPublisher {
    private static final Logger LOG = LoggerFactory.getLogger(TaskEventDispatcher.class);
    private final Map<ResultPartitionID, TaskEventHandler> registeredHandlers = new HashMap<ResultPartitionID, TaskEventHandler>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerPartition(ResultPartitionID partitionId) {
        Preconditions.checkNotNull(partitionId);
        Map<ResultPartitionID, TaskEventHandler> map = this.registeredHandlers;
        synchronized (map) {
            LOG.debug("registering {}", (Object)partitionId);
            if (this.registeredHandlers.put(partitionId, new TaskEventHandler()) != null) {
                throw new IllegalStateException("Partition " + partitionId + " already registered at task event dispatcher.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterPartition(ResultPartitionID partitionId) {
        Preconditions.checkNotNull(partitionId);
        Map<ResultPartitionID, TaskEventHandler> map = this.registeredHandlers;
        synchronized (map) {
            LOG.debug("unregistering {}", (Object)partitionId);
            this.registeredHandlers.remove(partitionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribeToEvent(ResultPartitionID partitionId, EventListener<TaskEvent> eventListener, Class<? extends TaskEvent> eventType) {
        TaskEventHandler taskEventHandler;
        Preconditions.checkNotNull(partitionId);
        Preconditions.checkNotNull(eventListener);
        Preconditions.checkNotNull(eventType);
        Map<ResultPartitionID, TaskEventHandler> map = this.registeredHandlers;
        synchronized (map) {
            taskEventHandler = this.registeredHandlers.get(partitionId);
        }
        if (taskEventHandler == null) {
            throw new IllegalStateException("Partition " + partitionId + " not registered at task event dispatcher.");
        }
        taskEventHandler.subscribe(eventListener, eventType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean publish(ResultPartitionID partitionId, TaskEvent event) {
        TaskEventHandler taskEventHandler;
        Preconditions.checkNotNull(partitionId);
        Preconditions.checkNotNull(event);
        Map<ResultPartitionID, TaskEventHandler> map = this.registeredHandlers;
        synchronized (map) {
            taskEventHandler = this.registeredHandlers.get(partitionId);
        }
        if (taskEventHandler != null) {
            taskEventHandler.publish(event);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAll() {
        Map<ResultPartitionID, TaskEventHandler> map = this.registeredHandlers;
        synchronized (map) {
            this.registeredHandlers.clear();
        }
    }
}

