/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.util.NoSuchElementException;
import org.apache.flink.annotation.Public;
import org.apache.flink.util.SplittableIterator;

@Public
public class NumberSequenceIterator
extends SplittableIterator<Long> {
    private static final long serialVersionUID = 1L;
    private final long to;
    private long current;

    public NumberSequenceIterator(long from, long to) {
        if (from > to) {
            throw new IllegalArgumentException("The 'to' value must not be smaller than the 'from' value.");
        }
        this.current = from;
        this.to = to;
    }

    private NumberSequenceIterator(long from, long to, boolean unused) {
        this.current = from;
        this.to = to;
    }

    public long getCurrent() {
        return this.current;
    }

    public long getTo() {
        return this.to;
    }

    @Override
    public boolean hasNext() {
        return this.current <= this.to;
    }

    @Override
    public Long next() {
        if (this.current <= this.to) {
            return this.current++;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public NumberSequenceIterator[] split(int numPartitions) {
        long elementsPerSplit;
        if (numPartitions < 1) {
            throw new IllegalArgumentException("The number of partitions must be at least 1.");
        }
        if (numPartitions == 1) {
            return new NumberSequenceIterator[]{new NumberSequenceIterator(this.current, this.to)};
        }
        if (this.to - this.current + 1L >= 0L) {
            elementsPerSplit = (this.to - this.current + 1L) / (long)numPartitions;
        } else {
            long posFrom;
            long halfDiff = this.current == Long.MIN_VALUE ? 0x4000000000000000L + this.to / 2L : ((posFrom = -this.current) > this.to ? this.to + (posFrom - this.to) / 2L : posFrom + (this.to - posFrom) / 2L);
            elementsPerSplit = halfDiff / (long)numPartitions * 2L;
        }
        if (elementsPerSplit < Long.MAX_VALUE) {
            long next;
            long numWithExtra = -(elementsPerSplit * (long)numPartitions) + this.to - this.current + 1L;
            if (numWithExtra > (long)numPartitions) {
                ++elementsPerSplit;
                if ((numWithExtra -= (long)numPartitions) > (long)numPartitions) {
                    throw new RuntimeException("Bug in splitting logic. To much rounding loss.");
                }
            }
            NumberSequenceIterator[] iters = new NumberSequenceIterator[numPartitions];
            long curr = this.current;
            int i = 0;
            while ((long)i < numWithExtra) {
                next = curr + elementsPerSplit + 1L;
                iters[i] = new NumberSequenceIterator(curr, next - 1L);
                curr = next;
                ++i;
            }
            while (i < numPartitions) {
                next = curr + elementsPerSplit;
                iters[i] = new NumberSequenceIterator(curr, next - 1L, true);
                curr = next;
                ++i;
            }
            return iters;
        }
        if (numPartitions != 2) {
            throw new RuntimeException("Bug in splitting logic.");
        }
        return new NumberSequenceIterator[]{new NumberSequenceIterator(this.current, this.current + elementsPerSplit), new NumberSequenceIterator(this.current + elementsPerSplit, this.to)};
    }

    @Override
    public int getMaximumNumberOfSplits() {
        if (this.to >= Integer.MAX_VALUE || this.current <= Integer.MIN_VALUE || this.to - this.current + 1L >= Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)(this.to - this.current + 1L);
    }
}

