/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.source;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.streaming.api.functions.source.ContinuousFileReaderOperator;
import org.apache.flink.streaming.api.functions.source.TimestampedInputSplit;
import org.apache.flink.streaming.api.operators.AbstractStreamOperatorFactory;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.OneInputStreamOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperatorParameters;
import org.apache.flink.streaming.api.operators.YieldingOperatorFactory;

public class ContinuousFileReaderOperatorFactory<OUT, T extends TimestampedInputSplit>
extends AbstractStreamOperatorFactory<OUT>
implements YieldingOperatorFactory<OUT>,
OneInputStreamOperatorFactory<T, OUT> {
    private final InputFormat<OUT, ? super T> inputFormat;
    private TypeInformation<OUT> type;
    private ExecutionConfig executionConfig;

    public ContinuousFileReaderOperatorFactory(InputFormat<OUT, ? super T> inputFormat) {
        this(inputFormat, null, null);
    }

    public ContinuousFileReaderOperatorFactory(InputFormat<OUT, ? super T> inputFormat, TypeInformation<OUT> type, ExecutionConfig executionConfig) {
        this.inputFormat = inputFormat;
        this.type = type;
        this.executionConfig = executionConfig;
        this.chainingStrategy = ChainingStrategy.HEAD;
    }

    @Override
    public <O extends StreamOperator<OUT>> O createStreamOperator(StreamOperatorParameters<OUT> parameters) {
        ContinuousFileReaderOperator<OUT, T> operator = new ContinuousFileReaderOperator<OUT, T>(this.inputFormat, this.processingTimeService, this.getMailboxExecutor());
        operator.setup(parameters.getContainingTask(), parameters.getStreamConfig(), parameters.getOutput());
        operator.setOutputType(this.type, this.executionConfig);
        return (O)operator;
    }

    @Override
    public void setOutputType(TypeInformation<OUT> type, ExecutionConfig executionConfig) {
        this.type = type;
        this.executionConfig = executionConfig;
    }

    @Override
    public Class<? extends StreamOperator> getStreamOperatorClass(ClassLoader classLoader) {
        return ContinuousFileReaderOperator.class;
    }

    @Override
    public boolean isOutputTypeConfigurable() {
        return true;
    }
}

