/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.graph;

import java.io.Serializable;
import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.streaming.runtime.partitioner.StreamPartitioner;
import org.apache.flink.util.OutputTag;

@Internal
public class NonChainedOutput
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final boolean supportsUnalignedCheckpoints;
    private final int sourceNodeId;
    private final int consumerParallelism;
    private final int consumerMaxParallelism;
    private final long bufferTimeout;
    private final IntermediateDataSetID dataSetId;
    private final boolean isPersistentDataSet;
    private final OutputTag<?> outputTag;
    private final StreamPartitioner<?> partitioner;
    private final ResultPartitionType partitionType;

    public NonChainedOutput(boolean supportsUnalignedCheckpoints, int sourceNodeId, int consumerParallelism, int consumerMaxParallelism, long bufferTimeout, boolean isPersistentDataSet, IntermediateDataSetID dataSetId, OutputTag<?> outputTag, StreamPartitioner<?> partitioner, ResultPartitionType partitionType) {
        this.supportsUnalignedCheckpoints = supportsUnalignedCheckpoints;
        this.sourceNodeId = sourceNodeId;
        this.consumerParallelism = consumerParallelism;
        this.consumerMaxParallelism = consumerMaxParallelism;
        this.bufferTimeout = bufferTimeout;
        this.isPersistentDataSet = isPersistentDataSet;
        this.dataSetId = dataSetId;
        this.outputTag = outputTag;
        this.partitioner = partitioner;
        this.partitionType = partitionType;
    }

    public boolean supportsUnalignedCheckpoints() {
        return this.supportsUnalignedCheckpoints;
    }

    public int getSourceNodeId() {
        return this.sourceNodeId;
    }

    public int getConsumerParallelism() {
        return this.consumerParallelism;
    }

    public int getConsumerMaxParallelism() {
        return this.consumerMaxParallelism;
    }

    public long getBufferTimeout() {
        return this.bufferTimeout;
    }

    public IntermediateDataSetID getDataSetId() {
        return this.dataSetId;
    }

    public IntermediateDataSetID getPersistentDataSetId() {
        return this.isPersistentDataSet ? this.dataSetId : null;
    }

    public OutputTag<?> getOutputTag() {
        return this.outputTag;
    }

    public StreamPartitioner<?> getPartitioner() {
        return this.partitioner;
    }

    public ResultPartitionType getPartitionType() {
        return this.partitionType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NonChainedOutput output = (NonChainedOutput)o;
        return Objects.equals(this.dataSetId, output.dataSetId);
    }

    public int hashCode() {
        return Objects.hash(this.dataSetId);
    }
}

