/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base.array;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.base.CharComparator;
import org.apache.flink.api.common.typeutils.base.array.PrimitiveArrayComparator;

@Internal
public class CharPrimitiveArrayComparator
extends PrimitiveArrayComparator<char[], CharComparator> {
    public CharPrimitiveArrayComparator(boolean ascending) {
        super(ascending, new CharComparator(ascending));
    }

    @Override
    public int hash(char[] record) {
        int result = 0;
        for (char field : record) {
            result += field;
        }
        return result;
    }

    @Override
    public int compare(char[] first, char[] second) {
        for (int x = 0; x < Math.min(first.length, second.length); ++x) {
            int cmp = first[x] - second[x];
            if (cmp == 0) continue;
            return this.ascending ? cmp : -cmp;
        }
        int cmp = first.length - second.length;
        return this.ascending ? cmp : -cmp;
    }

    @Override
    public TypeComparator<char[]> duplicate() {
        CharPrimitiveArrayComparator dupe = new CharPrimitiveArrayComparator(this.ascending);
        dupe.setReference(this.reference);
        return dupe;
    }
}

