/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.format.orc;

import java.io.Serializable;
import java.sql.Date;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.store.file.predicate.FieldRef;
import org.apache.flink.table.store.file.predicate.FunctionVisitor;
import org.apache.flink.table.store.shaded.org.apache.flink.orc.OrcFilters;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.ql.io.sarg.PredicateLeaf;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.function.TriFunction;

public class OrcPredicateFunctionVisitor
implements FunctionVisitor<Optional<OrcFilters.Predicate>> {
    public static final OrcPredicateFunctionVisitor VISITOR = new OrcPredicateFunctionVisitor();

    private OrcPredicateFunctionVisitor() {
    }

    @Override
    public Optional<OrcFilters.Predicate> visitIsNull(FieldRef fieldRef) {
        PredicateLeaf.Type colType = OrcPredicateFunctionVisitor.toOrcType(fieldRef.type());
        if (colType == null) {
            return Optional.empty();
        }
        return Optional.of(new OrcFilters.IsNull(fieldRef.name(), colType));
    }

    @Override
    public Optional<OrcFilters.Predicate> visitIsNotNull(FieldRef fieldRef) {
        Object isNull = this.visitIsNull(fieldRef);
        return ((Optional)isNull).map(OrcFilters.Not::new);
    }

    @Override
    public Optional<OrcFilters.Predicate> visitStartsWith(FieldRef fieldRef, Object literal) {
        return Optional.empty();
    }

    @Override
    public Optional<OrcFilters.Predicate> visitLessThan(FieldRef fieldRef, Object literal) {
        return this.convertBinary(fieldRef, literal, (TriFunction<String, PredicateLeaf.Type, Serializable, OrcFilters.Predicate>)((TriFunction)OrcFilters.LessThan::new));
    }

    @Override
    public Optional<OrcFilters.Predicate> visitGreaterOrEqual(FieldRef fieldRef, Object literal) {
        return this.convertBinary(fieldRef, literal, (TriFunction<String, PredicateLeaf.Type, Serializable, OrcFilters.Predicate>)((TriFunction)(colName, litType, serializableLiteral) -> new OrcFilters.Not(new OrcFilters.LessThan((String)colName, (PredicateLeaf.Type)((Object)litType), (Serializable)serializableLiteral))));
    }

    @Override
    public Optional<OrcFilters.Predicate> visitNotEqual(FieldRef fieldRef, Object literal) {
        return this.convertBinary(fieldRef, literal, (TriFunction<String, PredicateLeaf.Type, Serializable, OrcFilters.Predicate>)((TriFunction)(colName, litType, serializableLiteral) -> new OrcFilters.Not(new OrcFilters.Equals((String)colName, (PredicateLeaf.Type)((Object)litType), (Serializable)serializableLiteral))));
    }

    @Override
    public Optional<OrcFilters.Predicate> visitLessOrEqual(FieldRef fieldRef, Object literal) {
        return this.convertBinary(fieldRef, literal, (TriFunction<String, PredicateLeaf.Type, Serializable, OrcFilters.Predicate>)((TriFunction)OrcFilters.LessThanEquals::new));
    }

    @Override
    public Optional<OrcFilters.Predicate> visitEqual(FieldRef fieldRef, Object literal) {
        return this.convertBinary(fieldRef, literal, (TriFunction<String, PredicateLeaf.Type, Serializable, OrcFilters.Predicate>)((TriFunction)OrcFilters.Equals::new));
    }

    @Override
    public Optional<OrcFilters.Predicate> visitGreaterThan(FieldRef fieldRef, Object literal) {
        return this.convertBinary(fieldRef, literal, (TriFunction<String, PredicateLeaf.Type, Serializable, OrcFilters.Predicate>)((TriFunction)(colName, litType, serializableLiteral) -> new OrcFilters.Not(new OrcFilters.LessThanEquals((String)colName, (PredicateLeaf.Type)((Object)litType), (Serializable)serializableLiteral))));
    }

    @Override
    public Optional<OrcFilters.Predicate> visitIn(FieldRef fieldRef, List<Object> literals) {
        return Optional.empty();
    }

    @Override
    public Optional<OrcFilters.Predicate> visitNotIn(FieldRef fieldRef, List<Object> literals) {
        return Optional.empty();
    }

    @Override
    public Optional<OrcFilters.Predicate> visitAnd(List<Optional<OrcFilters.Predicate>> children) {
        return Optional.empty();
    }

    @Override
    public Optional<OrcFilters.Predicate> visitOr(List<Optional<OrcFilters.Predicate>> children) {
        if (children.size() != 2) {
            throw new RuntimeException("Illegal or children: " + children.size());
        }
        Optional<OrcFilters.Predicate> c1 = children.get(0);
        if (!c1.isPresent()) {
            return Optional.empty();
        }
        Optional<OrcFilters.Predicate> c2 = children.get(1);
        return c2.map(value -> new OrcFilters.Or((OrcFilters.Predicate)c1.get(), (OrcFilters.Predicate)value));
    }

    private Optional<OrcFilters.Predicate> convertBinary(FieldRef fieldRef, Object literal, TriFunction<String, PredicateLeaf.Type, Serializable, OrcFilters.Predicate> func) {
        PredicateLeaf.Type litType = OrcPredicateFunctionVisitor.toOrcType(fieldRef.type());
        if (litType == null) {
            return Optional.empty();
        }
        String colName = fieldRef.name();
        Object orcObj = OrcPredicateFunctionVisitor.toOrcObject(litType, literal);
        if (!(orcObj instanceof Serializable)) {
            return Optional.empty();
        }
        Serializable serializableLiteral = (Serializable)orcObj;
        return Optional.of(func.apply((Object)colName, (Object)litType, (Object)serializableLiteral));
    }

    @Nullable
    private static Object toOrcObject(PredicateLeaf.Type litType, Object literalObj) {
        if (literalObj == null) {
            return null;
        }
        switch (litType) {
            case STRING: {
                return literalObj.toString();
            }
            case DECIMAL: {
                return ((DecimalData)literalObj).toBigDecimal();
            }
            case DATE: {
                return Date.valueOf(LocalDate.ofEpochDay(((Number)literalObj).longValue()));
            }
            case TIMESTAMP: {
                return ((TimestampData)literalObj).toTimestamp();
            }
        }
        return literalObj;
    }

    @Nullable
    private static PredicateLeaf.Type toOrcType(LogicalType type) {
        switch (type.getTypeRoot()) {
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: {
                return PredicateLeaf.Type.LONG;
            }
            case FLOAT: 
            case DOUBLE: {
                return PredicateLeaf.Type.FLOAT;
            }
            case BOOLEAN: {
                return PredicateLeaf.Type.BOOLEAN;
            }
            case CHAR: 
            case VARCHAR: {
                return PredicateLeaf.Type.STRING;
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                return PredicateLeaf.Type.TIMESTAMP;
            }
            case DATE: {
                return PredicateLeaf.Type.DATE;
            }
            case DECIMAL: {
                return PredicateLeaf.Type.DECIMAL;
            }
        }
        return null;
    }
}

