/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.junit4osgi.command;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import junit.framework.TestCase;
import junit.framework.TestFailure;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.junit4osgi.OSGiJunitRunner;
import org.apache.felix.shell.Command;

public class JunitCommand
implements Command,
Pojo {
    private InstanceManager __IM;
    private boolean __Fm_runner;
    private OSGiJunitRunner m_runner;
    private boolean __MgetNamesFromTests$java_util_List;
    private boolean __Mexecute$java_lang_String$java_io_PrintStream$java_io_PrintStream;
    private boolean __MgetName;
    private boolean __MgetShortDescription;
    private boolean __MgetUsage;

    OSGiJunitRunner __getm_runner() {
        if (!this.__Fm_runner) {
            return this.m_runner;
        }
        return (OSGiJunitRunner)this.__IM.onGet((Object)this, "m_runner");
    }

    void __setm_runner(OSGiJunitRunner oSGiJunitRunner) {
        if (!this.__Fm_runner) {
            this.m_runner = oSGiJunitRunner;
            return;
        }
        this.__IM.onSet((Object)this, "m_runner", (Object)oSGiJunitRunner);
    }

    public JunitCommand() {
        this(null);
    }

    private JunitCommand(InstanceManager _manager) {
        this._setInstanceManager(_manager);
    }

    private List getNamesFromTests(List list) {
        List list2;
        if (!this.__MgetNamesFromTests$java_util_List) {
            return this.__getNamesFromTests(list);
        }
        try {
            this.__IM.onEntry((Object)this, "getNamesFromTests$java_util_List", new Object[]{list});
            list2 = this.__getNamesFromTests(list);
            this.__IM.onExit((Object)this, "getNamesFromTests$java_util_List", (Object)list2);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getNamesFromTests$java_util_List", throwable);
            throw throwable;
        }
        return list2;
    }

    private List __getNamesFromTests(List list) {
        ArrayList<String> names = new ArrayList<String>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) instanceof TestCase) {
                names.add(((TestCase)list.get(i)).getName());
            }
            if (!(list.get(i) instanceof TestSuite)) continue;
            String name = ((TestSuite)list.get(i)).getName();
            if (name == null) {
                name = ((TestSuite)list.get(i)).toString();
            }
            names.add(name);
        }
        return names;
    }

    public void execute(String string, PrintStream printStream, PrintStream printStream2) {
        if (!this.__Mexecute$java_lang_String$java_io_PrintStream$java_io_PrintStream) {
            this.__execute(string, printStream, printStream2);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "execute$java_lang_String$java_io_PrintStream$java_io_PrintStream", new Object[]{string, printStream, printStream2});
            this.__execute(string, printStream, printStream2);
            this.__IM.onExit((Object)this, "execute$java_lang_String$java_io_PrintStream$java_io_PrintStream", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "execute$java_lang_String$java_io_PrintStream$java_io_PrintStream", throwable);
            throw throwable;
        }
    }

    private void __execute(String line, PrintStream out, PrintStream err) {
        line = line.substring(this.getName().length()).trim();
        List tr = null;
        if (line.equals("all")) {
            if (this.__getm_runner().getTests() == null) {
                err.println("No tests to execute");
                return;
            }
            out.println("Executing " + this.getNamesFromTests(this.__getm_runner().getTests()));
            tr = this.__getm_runner().run();
        } else {
            try {
                Long bundleId = new Long(line);
                if (this.__getm_runner().getTests(bundleId.longValue()) == null) {
                    err.println("No tests to execute");
                    return;
                }
                out.println("Executing " + this.getNamesFromTests(this.__getm_runner().getTests(bundleId.longValue())));
                tr = this.__getm_runner().run(bundleId.longValue());
            }
            catch (NumberFormatException e) {
                err.println("Unable to parse id " + line);
                return;
            }
        }
        ListIterator it = tr.listIterator();
        while (it.hasNext()) {
            TestResult result = (TestResult)it.next();
            if (result.failureCount() == 0) continue;
            TestFailure fail = (TestFailure)result.failures().nextElement();
            out.println(fail.trace());
            return;
        }
    }

    public String getName() {
        String string;
        if (!this.__MgetName) {
            return this.__getName();
        }
        try {
            this.__IM.onEntry((Object)this, "getName", new Object[0]);
            string = this.__getName();
            this.__IM.onExit((Object)this, "getName", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getName", throwable);
            throw throwable;
        }
        return string;
    }

    private String __getName() {
        return "junit";
    }

    public String getShortDescription() {
        String string;
        if (!this.__MgetShortDescription) {
            return this.__getShortDescription();
        }
        try {
            this.__IM.onEntry((Object)this, "getShortDescription", new Object[0]);
            string = this.__getShortDescription();
            this.__IM.onExit((Object)this, "getShortDescription", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getShortDescription", throwable);
            throw throwable;
        }
        return string;
    }

    private String __getShortDescription() {
        return "launch junit tests";
    }

    public String getUsage() {
        String string;
        if (!this.__MgetUsage) {
            return this.__getUsage();
        }
        try {
            this.__IM.onEntry((Object)this, "getUsage", new Object[0]);
            string = this.__getUsage();
            this.__IM.onExit((Object)this, "getUsage", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getUsage", throwable);
            throw throwable;
        }
        return string;
    }

    private String __getUsage() {
        return "junit <bundleid> | junit all";
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null && set.contains("m_runner")) {
            this.__Fm_runner = true;
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("getNamesFromTests$java_util_List")) {
                this.__MgetNamesFromTests$java_util_List = true;
            }
            if (set.contains("execute$java_lang_String$java_io_PrintStream$java_io_PrintStream")) {
                this.__Mexecute$java_lang_String$java_io_PrintStream$java_io_PrintStream = true;
            }
            if (set.contains("getName")) {
                this.__MgetName = true;
            }
            if (set.contains("getShortDescription")) {
                this.__MgetShortDescription = true;
            }
            if (set.contains("getUsage")) {
                this.__MgetUsage = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

