/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.util;

import java.util.StringTokenizer;

public abstract class PatternUtil {
    public static boolean isValidPattern(String pattern) {
        if (pattern == null) {
            return false;
        }
        if (pattern.indexOf("?") != -1) {
            return false;
        }
        if (pattern.length() == 0 || pattern.equals("/")) {
            return true;
        }
        if (pattern.startsWith("*.")) {
            return pattern.indexOf("/") == -1;
        }
        if (!pattern.startsWith("/")) {
            return false;
        }
        int pos = pattern.indexOf(42);
        if (pos != -1 && pos < pattern.length() - 1) {
            return false;
        }
        if (pos != -1 && pattern.charAt(pos - 1) != '/') {
            return false;
        }
        return pattern.charAt(pattern.length() - 1) != '/';
    }

    public static boolean isValidSymbolicName(String name) {
        if (name == null || name.isEmpty()) {
            return false;
        }
        boolean valid = true;
        boolean expectToken = false;
        boolean done = false;
        StringTokenizer st = new StringTokenizer(name, ".", true);
        while (!done && st.hasMoreTokens()) {
            String token = st.nextToken();
            if (expectToken) {
                if (!".".equals(token)) {
                    valid = false;
                    done = true;
                    continue;
                }
                expectToken = false;
                continue;
            }
            if (".".equals(token)) {
                valid = false;
                done = true;
            } else {
                for (int i = 0; i < token.length() && valid; ++i) {
                    char c = token.charAt(i);
                    if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '_') continue;
                    valid = false;
                    done = true;
                }
            }
            expectToken = true;
        }
        if (!expectToken) {
            valid = false;
        }
        return valid;
    }
}

