/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.atomos.utils.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.felix.atomos.utils.api.Context;
import org.apache.felix.atomos.utils.api.FileType;
import org.apache.felix.atomos.utils.api.Launcher;
import org.apache.felix.atomos.utils.api.RegisterServiceCall;
import org.apache.felix.atomos.utils.api.plugin.BundleActivatorPlugin;
import org.apache.felix.atomos.utils.api.plugin.ClassPlugin;
import org.apache.felix.atomos.utils.api.plugin.ComponentDescription;
import org.apache.felix.atomos.utils.api.plugin.ComponentMetaDataPlugin;
import org.apache.felix.atomos.utils.api.plugin.FileCollectorPlugin;
import org.apache.felix.atomos.utils.api.plugin.FileHandlerPlugin;
import org.apache.felix.atomos.utils.api.plugin.FinalPlugin;
import org.apache.felix.atomos.utils.api.plugin.JarPlugin;
import org.apache.felix.atomos.utils.api.plugin.MethodPlugin;
import org.apache.felix.atomos.utils.api.plugin.RegisterServicepPlugin;
import org.apache.felix.atomos.utils.api.plugin.SubstratePlugin;
import org.apache.felix.atomos.utils.core.ComponentDescriptionImpl;
import org.apache.felix.atomos.utils.core.ContextImpl;
import org.apache.felix.atomos.utils.core.scr.mock.EmptyBundeLogger;
import org.apache.felix.atomos.utils.core.scr.mock.PathBundle;
import org.apache.felix.scr.impl.logger.BundleLogger;
import org.apache.felix.scr.impl.metadata.ComponentMetadata;
import org.apache.felix.scr.impl.parser.KXml2SAXHandler;
import org.apache.felix.scr.impl.parser.KXml2SAXParser;
import org.apache.felix.scr.impl.xml.XmlHandler;
import org.osgi.framework.Bundle;

public class LauncherImpl
implements Launcher {
    private Collection<SubstratePlugin<?>> plugins = null;

    public static List<Class<?>> loadClasses(List<Path> paths, URLClassLoader cl) {
        return paths.stream().map(p -> {
            try {
                return new JarFile(p.toFile());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }).flatMap(j -> j.stream()).filter(e -> !e.isDirectory()).filter(e -> e.getName().endsWith(".class")).filter(e -> !e.getName().endsWith("module-info.class")).map(e -> {
            try {
                String name = e.getName().replace("/", ".").substring(0, e.getName().length() - 6);
                return cl.loadClass(name);
            }
            catch (ClassNotFoundException | NoClassDefFoundError throwable) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static List<ComponentDescription> readComponentDescription(JarFile jar) throws Exception {
        EmptyBundeLogger logger = new EmptyBundeLogger();
        ArrayList list = new ArrayList();
        Attributes attributes = jar.getManifest().getMainAttributes();
        String descriptorLocations = attributes.getValue("Service-Component");
        if (descriptorLocations != null) {
            StringTokenizer st = new StringTokenizer(descriptorLocations, ", ");
            while (st.hasMoreTokens()) {
                String descriptorLocation = st.nextToken();
                try (InputStream stream = jar.getInputStream(jar.getEntry(descriptorLocation));
                     BufferedReader in = new BufferedReader(new InputStreamReader(stream, "UTF-8"));){
                    XmlHandler handler = new XmlHandler((Bundle)new PathBundle(jar), (BundleLogger)logger, true, true);
                    KXml2SAXParser parser = new KXml2SAXParser((Reader)in);
                    parser.parseXML((KXml2SAXHandler)handler);
                    list.addAll(handler.getComponentMetadataList());
                }
            }
        }
        List<ComponentDescription> cds = list.stream().map(cmd -> {
            cmd.validate();
            return new ComponentDescriptionImpl((ComponentMetadata)cmd);
        }).collect(Collectors.toList());
        return cds;
    }

    private LauncherImpl() {
    }

    LauncherImpl(Collection<SubstratePlugin<?>> plugins) {
        this();
        this.plugins = plugins;
    }

    public Context execute() {
        return this.execute(new ContextImpl());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Context execute(Context context) {
        this.orderdPluginsBy(FileCollectorPlugin.class).peek(System.out::println).forEachOrdered(plugin -> plugin.collectFiles(context));
        this.orderdPluginsBy(FileHandlerPlugin.class).peek(System.out::println).forEachOrdered(plugin -> List.of(FileType.values()).forEach(fileType -> context.getFiles(new FileType[]{fileType}).forEach(path -> plugin.handleFile(context, path, fileType))));
        List<Path> artifacts = context.getFiles(new FileType[]{FileType.ARTIFACT}).collect(Collectors.toList());
        URL[] urls = (URL[])artifacts.stream().map(p -> {
            try {
                return p.toUri().toURL();
            }
            catch (MalformedURLException e1) {
                throw new UncheckedIOException(e1);
            }
        }).toArray(URL[]::new);
        ArrayList<JarFile> jarFiles = new ArrayList<JarFile>();
        try (URLClassLoader classLoader = URLClassLoader.newInstance(urls, null);){
            List<Class<?>> classes = LauncherImpl.loadClasses(artifacts, classLoader);
            ArrayList jarPlugins = new ArrayList();
            this.orderdPluginsBy(JarPlugin.class).forEachOrdered(jarPlugins::add);
            jarPlugins.forEach(plugin -> plugin.preJars(context));
            for (Path p2 : artifacts) {
                jarFiles.add(new JarFile(p2.toFile()));
            }
            jarFiles.forEach(j -> jarPlugins.forEach(p -> p.initJar(j, context, classLoader)));
            jarFiles.forEach(j -> {
                jarPlugins.forEach(p -> p.doJar(j, context, classLoader));
                try {
                    this.processJar((JarFile)j, context, classLoader);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            jarPlugins.forEach(plugin -> plugin.postJars(context));
            ArrayList classPlugins = new ArrayList();
            this.orderdPluginsBy(ClassPlugin.class).forEachOrdered(classPlugins::add);
            ArrayList methodPlugins = new ArrayList();
            this.orderdPluginsBy(MethodPlugin.class).forEachOrdered(methodPlugins::add);
            if (!classPlugins.isEmpty() || !methodPlugins.isEmpty()) {
                for (Class<?> c : classes) {
                    classPlugins.forEach(p -> p.doClass(c, context));
                    if (methodPlugins.isEmpty()) continue;
                    try {
                        Method[] methods = c.getDeclaredMethods();
                        if (methods == null) continue;
                        for (Method m : methods) {
                            methodPlugins.forEach(p -> p.doMethod(m, context));
                        }
                    }
                    catch (NoClassDefFoundError e) {
                        System.out.println("incomplete classpath: " + c);
                    }
                }
            }
            this.orderdPluginsBy(FinalPlugin.class).forEachOrdered(p -> p.doFinal(context));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            jarFiles.forEach(f -> {
                try {
                    f.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
        }
        return context;
    }

    private void processJar(JarFile j, Context context, URLClassLoader classLoader) throws IOException {
        Attributes attributes = j.getManifest().getMainAttributes();
        String bundleActivatorClassName = attributes.getValue("Bundle-Activator");
        if (bundleActivatorClassName == null) {
            bundleActivatorClassName = attributes.getValue("ExtensionBundle-Activator");
        }
        if (bundleActivatorClassName != null) {
            try {
                Class<?> bundleActivatorClass = classLoader.loadClass(bundleActivatorClassName.trim());
                this.orderdPluginsBy(BundleActivatorPlugin.class).peek(System.out::println).forEachOrdered(plugin -> plugin.doBundleActivator(bundleActivatorClass, context, (ClassLoader)classLoader));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        try {
            ArrayList cmdP = new ArrayList();
            this.orderdPluginsBy(ComponentMetaDataPlugin.class).forEachOrdered(cmdP::add);
            List<ComponentDescription> cds = LauncherImpl.readComponentDescription(j);
            for (ComponentDescription cd : cds) {
                cmdP.forEach(plugin -> plugin.doComponentMetaData(cd, context, (ClassLoader)classLoader));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList rscP = new ArrayList();
        this.orderdPluginsBy(RegisterServicepPlugin.class).forEachOrdered(rscP::add);
        List rscs = context.getRegisterServiceCalls();
        for (RegisterServiceCall rsc : rscs) {
            rscP.forEach(plugin -> plugin.doRegisterServiceCall(rsc, context, (ClassLoader)classLoader));
        }
    }

    List<SubstratePlugin<?>> getPlugins() {
        return List.copyOf(this.plugins);
    }

    private <T extends SubstratePlugin<?>> Stream<T> orderdPluginsBy(Class<T> clazz) {
        return this.plugins.stream().filter(clazz::isInstance).map(clazz::cast).sorted((p1, p2) -> p1.ranking(clazz) - p2.ranking(clazz));
    }
}

