// This is copied from gRPC's testing Protobuf definitions: https://github.com/grpc/grpc/blob/master/src/proto/grpc/testing/messages.proto

// Copyright 2015-2016 gRPC authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Message definitions to be used by integration test service definitions.

// @generated by protoc-gen-es v1.2.1 with parameter "ts_nocheck=false,target=ts"
// @generated from file grpc/testing/messages.proto (package grpc.testing, syntax proto3)
/* eslint-disable */

import type { BinaryReadOptions, FieldList, JsonReadOptions, JsonValue, PartialMessage, PlainMessage } from "@bufbuild/protobuf";
import { Any, Message, proto3 } from "@bufbuild/protobuf";

/**
 * The type of payload that should be returned.
 *
 * @generated from enum grpc.testing.PayloadType
 */
export enum PayloadType {
  /**
   * Compressable text format.
   *
   * @generated from enum value: COMPRESSABLE = 0;
   */
  COMPRESSABLE = 0,
}
// Retrieve enum metadata with: proto3.getEnumType(PayloadType)
proto3.util.setEnumType(PayloadType, "grpc.testing.PayloadType", [
  { no: 0, name: "COMPRESSABLE" },
]);

/**
 * The type of route that a client took to reach a server w.r.t. gRPCLB.
 * The server must fill in "fallback" if it detects that the RPC reached
 * the server via the "gRPCLB fallback" path, and "backend" if it detects
 * that the RPC reached the server via "gRPCLB backend" path (i.e. if it got
 * the address of this server from the gRPCLB server BalanceLoad RPC). Exactly
 * how this detection is done is context and server dependent.
 *
 * @generated from enum grpc.testing.GrpclbRouteType
 */
export enum GrpclbRouteType {
  /**
   * Server didn't detect the route that a client took to reach it.
   *
   * @generated from enum value: GRPCLB_ROUTE_TYPE_UNKNOWN = 0;
   */
  UNKNOWN = 0,

  /**
   * Indicates that a client reached a server via gRPCLB fallback.
   *
   * @generated from enum value: GRPCLB_ROUTE_TYPE_FALLBACK = 1;
   */
  FALLBACK = 1,

  /**
   * Indicates that a client reached a server as a gRPCLB-given backend.
   *
   * @generated from enum value: GRPCLB_ROUTE_TYPE_BACKEND = 2;
   */
  BACKEND = 2,
}
// Retrieve enum metadata with: proto3.getEnumType(GrpclbRouteType)
proto3.util.setEnumType(GrpclbRouteType, "grpc.testing.GrpclbRouteType", [
  { no: 0, name: "GRPCLB_ROUTE_TYPE_UNKNOWN" },
  { no: 1, name: "GRPCLB_ROUTE_TYPE_FALLBACK" },
  { no: 2, name: "GRPCLB_ROUTE_TYPE_BACKEND" },
]);

/**
 * TODO(dgq): Go back to using well-known types once
 * https://github.com/grpc/grpc/issues/6980 has been fixed.
 * import "google/protobuf/wrappers.proto";
 *
 * @generated from message grpc.testing.BoolValue
 */
export class BoolValue extends Message<BoolValue> {
  /**
   * The bool value.
   *
   * @generated from field: bool value = 1;
   */
  value = false;

  constructor(data?: PartialMessage<BoolValue>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "grpc.testing.BoolValue";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "value", kind: "scalar", T: 8 /* ScalarType.BOOL */ },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): BoolValue {
    return new BoolValue().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): BoolValue {
    return new BoolValue().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): BoolValue {
    return new BoolValue().fromJsonString(jsonString, options);
  }

  static equals(a: BoolValue | PlainMessage<BoolValue> | undefined, b: BoolValue | PlainMessage<BoolValue> | undefined): boolean {
    return proto3.util.equals(BoolValue, a, b);
  }
}

/**
 * A block of data, to simply increase gRPC message size.
 *
 * @generated from message grpc.testing.Payload
 */
export class Payload extends Message<Payload> {
  /**
   * The type of data in body.
   *
   * @generated from field: grpc.testing.PayloadType type = 1;
   */
  type = PayloadType.COMPRESSABLE;

  /**
   * Primary contents of payload.
   *
   * @generated from field: bytes body = 2;
   */
  body = new Uint8Array(0);

  constructor(data?: PartialMessage<Payload>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "grpc.testing.Payload";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "type", kind: "enum", T: proto3.getEnumType(PayloadType) },
    { no: 2, name: "body", kind: "scalar", T: 12 /* ScalarType.BYTES */ },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): Payload {
    return new Payload().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): Payload {
    return new Payload().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): Payload {
    return new Payload().fromJsonString(jsonString, options);
  }

  static equals(a: Payload | PlainMessage<Payload> | undefined, b: Payload | PlainMessage<Payload> | undefined): boolean {
    return proto3.util.equals(Payload, a, b);
  }
}

/**
 * A protobuf representation for grpc status. This is used by test
 * clients to specify a status that the server should attempt to return.
 *
 * @generated from message grpc.testing.EchoStatus
 */
export class EchoStatus extends Message<EchoStatus> {
  /**
   * @generated from field: int32 code = 1;
   */
  code = 0;

  /**
   * @generated from field: string message = 2;
   */
  message = "";

  constructor(data?: PartialMessage<EchoStatus>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "grpc.testing.EchoStatus";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "code", kind: "scalar", T: 5 /* ScalarType.INT32 */ },
    { no: 2, name: "message", kind: "scalar", T: 9 /* ScalarType.STRING */ },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): EchoStatus {
    return new EchoStatus().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): EchoStatus {
    return new EchoStatus().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): EchoStatus {
    return new EchoStatus().fromJsonString(jsonString, options);
  }

  static equals(a: EchoStatus | PlainMessage<EchoStatus> | undefined, b: EchoStatus | PlainMessage<EchoStatus> | undefined): boolean {
    return proto3.util.equals(EchoStatus, a, b);
  }
}

/**
 * Unary request.
 *
 * @generated from message grpc.testing.SimpleRequest
 */
export class SimpleRequest extends Message<SimpleRequest> {
  /**
   * Desired payload type in the response from the server.
   * If response_type is RANDOM, server randomly chooses one from other formats.
   *
   * @generated from field: grpc.testing.PayloadType response_type = 1;
   */
  responseType = PayloadType.COMPRESSABLE;

  /**
   * Desired payload size in the response from the server.
   *
   * @generated from field: int32 response_size = 2;
   */
  responseSize = 0;

  /**
   * Optional input payload sent along with the request.
   *
   * @generated from field: grpc.testing.Payload payload = 3;
   */
  payload?: Payload;

  /**
   * Whether SimpleResponse should include username.
   *
   * @generated from field: bool fill_username = 4;
   */
  fillUsername = false;

  /**
   * Whether SimpleResponse should include OAuth scope.
   *
   * @generated from field: bool fill_oauth_scope = 5;
   */
  fillOauthScope = false;

  /**
   * Whether to request the server to compress the response. This field is
   * "nullable" in order to interoperate seamlessly with clients not able to
   * implement the full compression tests by introspecting the call to verify
   * the response's compression status.
   *
   * @generated from field: grpc.testing.BoolValue response_compressed = 6;
   */
  responseCompressed?: BoolValue;

  /**
   * Whether server should return a given status
   *
   * @generated from field: grpc.testing.EchoStatus response_status = 7;
   */
  responseStatus?: EchoStatus;

  /**
   * Whether the server should expect this request to be compressed.
   *
   * @generated from field: grpc.testing.BoolValue expect_compressed = 8;
   */
  expectCompressed?: BoolValue;

  /**
   * Whether SimpleResponse should include server_id.
   *
   * @generated from field: bool fill_server_id = 9;
   */
  fillServerId = false;

  /**
   * Whether SimpleResponse should include grpclb_route_type.
   *
   * @generated from field: bool fill_grpclb_route_type = 10;
   */
  fillGrpclbRouteType = false;

  constructor(data?: PartialMessage<SimpleRequest>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "grpc.testing.SimpleRequest";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "response_type", kind: "enum", T: proto3.getEnumType(PayloadType) },
    { no: 2, name: "response_size", kind: "scalar", T: 5 /* ScalarType.INT32 */ },
    { no: 3, name: "payload", kind: "message", T: Payload },
    { no: 4, name: "fill_username", kind: "scalar", T: 8 /* ScalarType.BOOL */ },
    { no: 5, name: "fill_oauth_scope", kind: "scalar", T: 8 /* ScalarType.BOOL */ },
    { no: 6, name: "response_compressed", kind: "message", T: BoolValue },
    { no: 7, name: "response_status", kind: "message", T: EchoStatus },
    { no: 8, name: "expect_compressed", kind: "message", T: BoolValue },
    { no: 9, name: "fill_server_id", kind: "scalar", T: 8 /* ScalarType.BOOL */ },
    { no: 10, name: "fill_grpclb_route_type", kind: "scalar", T: 8 /* ScalarType.BOOL */ },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): SimpleRequest {
    return new SimpleRequest().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): SimpleRequest {
    return new SimpleRequest().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): SimpleRequest {
    return new SimpleRequest().fromJsonString(jsonString, options);
  }

  static equals(a: SimpleRequest | PlainMessage<SimpleRequest> | undefined, b: SimpleRequest | PlainMessage<SimpleRequest> | undefined): boolean {
    return proto3.util.equals(SimpleRequest, a, b);
  }
}

/**
 * Unary response, as configured by the request.
 *
 * @generated from message grpc.testing.SimpleResponse
 */
export class SimpleResponse extends Message<SimpleResponse> {
  /**
   * Payload to increase message size.
   *
   * @generated from field: grpc.testing.Payload payload = 1;
   */
  payload?: Payload;

  /**
   * The user the request came from, for verifying authentication was
   * successful when the client expected it.
   *
   * @generated from field: string username = 2;
   */
  username = "";

  /**
   * OAuth scope.
   *
   * @generated from field: string oauth_scope = 3;
   */
  oauthScope = "";

  /**
   * Server ID. This must be unique among different server instances,
   * but the same across all RPC's made to a particular server instance.
   *
   * @generated from field: string server_id = 4;
   */
  serverId = "";

  /**
   * gRPCLB Path.
   *
   * @generated from field: grpc.testing.GrpclbRouteType grpclb_route_type = 5;
   */
  grpclbRouteType = GrpclbRouteType.UNKNOWN;

  /**
   * Server hostname.
   *
   * @generated from field: string hostname = 6;
   */
  hostname = "";

  constructor(data?: PartialMessage<SimpleResponse>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "grpc.testing.SimpleResponse";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "payload", kind: "message", T: Payload },
    { no: 2, name: "username", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 3, name: "oauth_scope", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 4, name: "server_id", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 5, name: "grpclb_route_type", kind: "enum", T: proto3.getEnumType(GrpclbRouteType) },
    { no: 6, name: "hostname", kind: "scalar", T: 9 /* ScalarType.STRING */ },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): SimpleResponse {
    return new SimpleResponse().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): SimpleResponse {
    return new SimpleResponse().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): SimpleResponse {
    return new SimpleResponse().fromJsonString(jsonString, options);
  }

  static equals(a: SimpleResponse | PlainMessage<SimpleResponse> | undefined, b: SimpleResponse | PlainMessage<SimpleResponse> | undefined): boolean {
    return proto3.util.equals(SimpleResponse, a, b);
  }
}

/**
 * Client-streaming request.
 *
 * @generated from message grpc.testing.StreamingInputCallRequest
 */
export class StreamingInputCallRequest extends Message<StreamingInputCallRequest> {
  /**
   * Optional input payload sent along with the request.
   *
   * @generated from field: grpc.testing.Payload payload = 1;
   */
  payload?: Payload;

  /**
   * Whether the server should expect this request to be compressed. This field
   * is "nullable" in order to interoperate seamlessly with servers not able to
   * implement the full compression tests by introspecting the call to verify
   * the request's compression status.
   *
   * @generated from field: grpc.testing.BoolValue expect_compressed = 2;
   */
  expectCompressed?: BoolValue;

  constructor(data?: PartialMessage<StreamingInputCallRequest>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "grpc.testing.StreamingInputCallRequest";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "payload", kind: "message", T: Payload },
    { no: 2, name: "expect_compressed", kind: "message", T: BoolValue },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): StreamingInputCallRequest {
    return new StreamingInputCallRequest().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): StreamingInputCallRequest {
    return new StreamingInputCallRequest().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): StreamingInputCallRequest {
    return new StreamingInputCallRequest().fromJsonString(jsonString, options);
  }

  static equals(a: StreamingInputCallRequest | PlainMessage<StreamingInputCallRequest> | undefined, b: StreamingInputCallRequest | PlainMessage<StreamingInputCallRequest> | undefined): boolean {
    return proto3.util.equals(StreamingInputCallRequest, a, b);
  }
}

/**
 * Client-streaming response.
 *
 * @generated from message grpc.testing.StreamingInputCallResponse
 */
export class StreamingInputCallResponse extends Message<StreamingInputCallResponse> {
  /**
   * Aggregated size of payloads received from the client.
   *
   * @generated from field: int32 aggregated_payload_size = 1;
   */
  aggregatedPayloadSize = 0;

  constructor(data?: PartialMessage<StreamingInputCallResponse>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "grpc.testing.StreamingInputCallResponse";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "aggregated_payload_size", kind: "scalar", T: 5 /* ScalarType.INT32 */ },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): StreamingInputCallResponse {
    return new StreamingInputCallResponse().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): StreamingInputCallResponse {
    return new StreamingInputCallResponse().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): StreamingInputCallResponse {
    return new StreamingInputCallResponse().fromJsonString(jsonString, options);
  }

  static equals(a: StreamingInputCallResponse | PlainMessage<StreamingInputCallResponse> | undefined, b: StreamingInputCallResponse | PlainMessage<StreamingInputCallResponse> | undefined): boolean {
    return proto3.util.equals(StreamingInputCallResponse, a, b);
  }
}

/**
 * Configuration for a particular response.
 *
 * @generated from message grpc.testing.ResponseParameters
 */
export class ResponseParameters extends Message<ResponseParameters> {
  /**
   * Desired payload sizes in responses from the server.
   *
   * @generated from field: int32 size = 1;
   */
  size = 0;

  /**
   * Desired interval between consecutive responses in the response stream in
   * microseconds.
   *
   * @generated from field: int32 interval_us = 2;
   */
  intervalUs = 0;

  /**
   * Whether to request the server to compress the response. This field is
   * "nullable" in order to interoperate seamlessly with clients not able to
   * implement the full compression tests by introspecting the call to verify
   * the response's compression status.
   *
   * @generated from field: grpc.testing.BoolValue compressed = 3;
   */
  compressed?: BoolValue;

  constructor(data?: PartialMessage<ResponseParameters>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "grpc.testing.ResponseParameters";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "size", kind: "scalar", T: 5 /* ScalarType.INT32 */ },
    { no: 2, name: "interval_us", kind: "scalar", T: 5 /* ScalarType.INT32 */ },
    { no: 3, name: "compressed", kind: "message", T: BoolValue },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ResponseParameters {
    return new ResponseParameters().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ResponseParameters {
    return new ResponseParameters().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ResponseParameters {
    return new ResponseParameters().fromJsonString(jsonString, options);
  }

  static equals(a: ResponseParameters | PlainMessage<ResponseParameters> | undefined, b: ResponseParameters | PlainMessage<ResponseParameters> | undefined): boolean {
    return proto3.util.equals(ResponseParameters, a, b);
  }
}

/**
 * Server-streaming request.
 *
 * @generated from message grpc.testing.StreamingOutputCallRequest
 */
export class StreamingOutputCallRequest extends Message<StreamingOutputCallRequest> {
  /**
   * Desired payload type in the response from the server.
   * If response_type is RANDOM, the payload from each response in the stream
   * might be of different types. This is to simulate a mixed type of payload
   * stream.
   *
   * @generated from field: grpc.testing.PayloadType response_type = 1;
   */
  responseType = PayloadType.COMPRESSABLE;

  /**
   * Configuration for each expected response message.
   *
   * @generated from field: repeated grpc.testing.ResponseParameters response_parameters = 2;
   */
  responseParameters: ResponseParameters[] = [];

  /**
   * Optional input payload sent along with the request.
   *
   * @generated from field: grpc.testing.Payload payload = 3;
   */
  payload?: Payload;

  /**
   * Whether server should return a given status
   *
   * @generated from field: grpc.testing.EchoStatus response_status = 7;
   */
  responseStatus?: EchoStatus;

  constructor(data?: PartialMessage<StreamingOutputCallRequest>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "grpc.testing.StreamingOutputCallRequest";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "response_type", kind: "enum", T: proto3.getEnumType(PayloadType) },
    { no: 2, name: "response_parameters", kind: "message", T: ResponseParameters, repeated: true },
    { no: 3, name: "payload", kind: "message", T: Payload },
    { no: 7, name: "response_status", kind: "message", T: EchoStatus },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): StreamingOutputCallRequest {
    return new StreamingOutputCallRequest().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): StreamingOutputCallRequest {
    return new StreamingOutputCallRequest().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): StreamingOutputCallRequest {
    return new StreamingOutputCallRequest().fromJsonString(jsonString, options);
  }

  static equals(a: StreamingOutputCallRequest | PlainMessage<StreamingOutputCallRequest> | undefined, b: StreamingOutputCallRequest | PlainMessage<StreamingOutputCallRequest> | undefined): boolean {
    return proto3.util.equals(StreamingOutputCallRequest, a, b);
  }
}

/**
 * Server-streaming response, as configured by the request and parameters.
 *
 * @generated from message grpc.testing.StreamingOutputCallResponse
 */
export class StreamingOutputCallResponse extends Message<StreamingOutputCallResponse> {
  /**
   * Payload to increase response size.
   *
   * @generated from field: grpc.testing.Payload payload = 1;
   */
  payload?: Payload;

  constructor(data?: PartialMessage<StreamingOutputCallResponse>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "grpc.testing.StreamingOutputCallResponse";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "payload", kind: "message", T: Payload },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): StreamingOutputCallResponse {
    return new StreamingOutputCallResponse().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): StreamingOutputCallResponse {
    return new StreamingOutputCallResponse().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): StreamingOutputCallResponse {
    return new StreamingOutputCallResponse().fromJsonString(jsonString, options);
  }

  static equals(a: StreamingOutputCallResponse | PlainMessage<StreamingOutputCallResponse> | undefined, b: StreamingOutputCallResponse | PlainMessage<StreamingOutputCallResponse> | undefined): boolean {
    return proto3.util.equals(StreamingOutputCallResponse, a, b);
  }
}

/**
 * For reconnect interop test only.
 * Client tells server what reconnection parameters it used.
 *
 * @generated from message grpc.testing.ReconnectParams
 */
export class ReconnectParams extends Message<ReconnectParams> {
  /**
   * @generated from field: int32 max_reconnect_backoff_ms = 1;
   */
  maxReconnectBackoffMs = 0;

  constructor(data?: PartialMessage<ReconnectParams>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "grpc.testing.ReconnectParams";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "max_reconnect_backoff_ms", kind: "scalar", T: 5 /* ScalarType.INT32 */ },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ReconnectParams {
    return new ReconnectParams().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ReconnectParams {
    return new ReconnectParams().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ReconnectParams {
    return new ReconnectParams().fromJsonString(jsonString, options);
  }

  static equals(a: ReconnectParams | PlainMessage<ReconnectParams> | undefined, b: ReconnectParams | PlainMessage<ReconnectParams> | undefined): boolean {
    return proto3.util.equals(ReconnectParams, a, b);
  }
}

/**
 * For reconnect interop test only.
 * Server tells client whether its reconnects are following the spec and the
 * reconnect backoffs it saw.
 *
 * @generated from message grpc.testing.ReconnectInfo
 */
export class ReconnectInfo extends Message<ReconnectInfo> {
  /**
   * @generated from field: bool passed = 1;
   */
  passed = false;

  /**
   * @generated from field: repeated int32 backoff_ms = 2;
   */
  backoffMs: number[] = [];

  constructor(data?: PartialMessage<ReconnectInfo>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "grpc.testing.ReconnectInfo";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "passed", kind: "scalar", T: 8 /* ScalarType.BOOL */ },
    { no: 2, name: "backoff_ms", kind: "scalar", T: 5 /* ScalarType.INT32 */, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ReconnectInfo {
    return new ReconnectInfo().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ReconnectInfo {
    return new ReconnectInfo().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ReconnectInfo {
    return new ReconnectInfo().fromJsonString(jsonString, options);
  }

  static equals(a: ReconnectInfo | PlainMessage<ReconnectInfo> | undefined, b: ReconnectInfo | PlainMessage<ReconnectInfo> | undefined): boolean {
    return proto3.util.equals(ReconnectInfo, a, b);
  }
}

/**
 * @generated from message grpc.testing.LoadBalancerStatsRequest
 */
export class LoadBalancerStatsRequest extends Message<LoadBalancerStatsRequest> {
  /**
   * Request stats for the next num_rpcs sent by client.
   *
   * @generated from field: int32 num_rpcs = 1;
   */
  numRpcs = 0;

  /**
   * If num_rpcs have not completed within timeout_sec, return partial results.
   *
   * @generated from field: int32 timeout_sec = 2;
   */
  timeoutSec = 0;

  constructor(data?: PartialMessage<LoadBalancerStatsRequest>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "grpc.testing.LoadBalancerStatsRequest";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "num_rpcs", kind: "scalar", T: 5 /* ScalarType.INT32 */ },
    { no: 2, name: "timeout_sec", kind: "scalar", T: 5 /* ScalarType.INT32 */ },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): LoadBalancerStatsRequest {
    return new LoadBalancerStatsRequest().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): LoadBalancerStatsRequest {
    return new LoadBalancerStatsRequest().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): LoadBalancerStatsRequest {
    return new LoadBalancerStatsRequest().fromJsonString(jsonString, options);
  }

  static equals(a: LoadBalancerStatsRequest | PlainMessage<LoadBalancerStatsRequest> | undefined, b: LoadBalancerStatsRequest | PlainMessage<LoadBalancerStatsRequest> | undefined): boolean {
    return proto3.util.equals(LoadBalancerStatsRequest, a, b);
  }
}

/**
 * @generated from message grpc.testing.LoadBalancerStatsResponse
 */
export class LoadBalancerStatsResponse extends Message<LoadBalancerStatsResponse> {
  /**
   * The number of completed RPCs for each peer.
   *
   * @generated from field: map<string, int32> rpcs_by_peer = 1;
   */
  rpcsByPeer: { [key: string]: number } = {};

  /**
   * The number of RPCs that failed to record a remote peer.
   *
   * @generated from field: int32 num_failures = 2;
   */
  numFailures = 0;

  /**
   * @generated from field: map<string, grpc.testing.LoadBalancerStatsResponse.RpcsByPeer> rpcs_by_method = 3;
   */
  rpcsByMethod: { [key: string]: LoadBalancerStatsResponse_RpcsByPeer } = {};

  constructor(data?: PartialMessage<LoadBalancerStatsResponse>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "grpc.testing.LoadBalancerStatsResponse";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "rpcs_by_peer", kind: "map", K: 9 /* ScalarType.STRING */, V: {kind: "scalar", T: 5 /* ScalarType.INT32 */} },
    { no: 2, name: "num_failures", kind: "scalar", T: 5 /* ScalarType.INT32 */ },
    { no: 3, name: "rpcs_by_method", kind: "map", K: 9 /* ScalarType.STRING */, V: {kind: "message", T: LoadBalancerStatsResponse_RpcsByPeer} },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): LoadBalancerStatsResponse {
    return new LoadBalancerStatsResponse().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): LoadBalancerStatsResponse {
    return new LoadBalancerStatsResponse().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): LoadBalancerStatsResponse {
    return new LoadBalancerStatsResponse().fromJsonString(jsonString, options);
  }

  static equals(a: LoadBalancerStatsResponse | PlainMessage<LoadBalancerStatsResponse> | undefined, b: LoadBalancerStatsResponse | PlainMessage<LoadBalancerStatsResponse> | undefined): boolean {
    return proto3.util.equals(LoadBalancerStatsResponse, a, b);
  }
}

/**
 * @generated from message grpc.testing.LoadBalancerStatsResponse.RpcsByPeer
 */
export class LoadBalancerStatsResponse_RpcsByPeer extends Message<LoadBalancerStatsResponse_RpcsByPeer> {
  /**
   * The number of completed RPCs for each peer.
   *
   * @generated from field: map<string, int32> rpcs_by_peer = 1;
   */
  rpcsByPeer: { [key: string]: number } = {};

  constructor(data?: PartialMessage<LoadBalancerStatsResponse_RpcsByPeer>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "grpc.testing.LoadBalancerStatsResponse.RpcsByPeer";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "rpcs_by_peer", kind: "map", K: 9 /* ScalarType.STRING */, V: {kind: "scalar", T: 5 /* ScalarType.INT32 */} },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): LoadBalancerStatsResponse_RpcsByPeer {
    return new LoadBalancerStatsResponse_RpcsByPeer().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): LoadBalancerStatsResponse_RpcsByPeer {
    return new LoadBalancerStatsResponse_RpcsByPeer().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): LoadBalancerStatsResponse_RpcsByPeer {
    return new LoadBalancerStatsResponse_RpcsByPeer().fromJsonString(jsonString, options);
  }

  static equals(a: LoadBalancerStatsResponse_RpcsByPeer | PlainMessage<LoadBalancerStatsResponse_RpcsByPeer> | undefined, b: LoadBalancerStatsResponse_RpcsByPeer | PlainMessage<LoadBalancerStatsResponse_RpcsByPeer> | undefined): boolean {
    return proto3.util.equals(LoadBalancerStatsResponse_RpcsByPeer, a, b);
  }
}

/**
 * Request for retrieving a test client's accumulated stats.
 *
 * @generated from message grpc.testing.LoadBalancerAccumulatedStatsRequest
 */
export class LoadBalancerAccumulatedStatsRequest extends Message<LoadBalancerAccumulatedStatsRequest> {
  constructor(data?: PartialMessage<LoadBalancerAccumulatedStatsRequest>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "grpc.testing.LoadBalancerAccumulatedStatsRequest";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): LoadBalancerAccumulatedStatsRequest {
    return new LoadBalancerAccumulatedStatsRequest().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): LoadBalancerAccumulatedStatsRequest {
    return new LoadBalancerAccumulatedStatsRequest().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): LoadBalancerAccumulatedStatsRequest {
    return new LoadBalancerAccumulatedStatsRequest().fromJsonString(jsonString, options);
  }

  static equals(a: LoadBalancerAccumulatedStatsRequest | PlainMessage<LoadBalancerAccumulatedStatsRequest> | undefined, b: LoadBalancerAccumulatedStatsRequest | PlainMessage<LoadBalancerAccumulatedStatsRequest> | undefined): boolean {
    return proto3.util.equals(LoadBalancerAccumulatedStatsRequest, a, b);
  }
}

/**
 * Accumulated stats for RPCs sent by a test client.
 *
 * @generated from message grpc.testing.LoadBalancerAccumulatedStatsResponse
 */
export class LoadBalancerAccumulatedStatsResponse extends Message<LoadBalancerAccumulatedStatsResponse> {
  /**
   * The total number of RPCs have ever issued for each type.
   * Deprecated: use stats_per_method.rpcs_started instead.
   *
   * @generated from field: map<string, int32> num_rpcs_started_by_method = 1 [deprecated = true];
   * @deprecated
   */
  numRpcsStartedByMethod: { [key: string]: number } = {};

  /**
   * The total number of RPCs have ever completed successfully for each type.
   * Deprecated: use stats_per_method.result instead.
   *
   * @generated from field: map<string, int32> num_rpcs_succeeded_by_method = 2 [deprecated = true];
   * @deprecated
   */
  numRpcsSucceededByMethod: { [key: string]: number } = {};

  /**
   * The total number of RPCs have ever failed for each type.
   * Deprecated: use stats_per_method.result instead.
   *
   * @generated from field: map<string, int32> num_rpcs_failed_by_method = 3 [deprecated = true];
   * @deprecated
   */
  numRpcsFailedByMethod: { [key: string]: number } = {};

  /**
   * Per-method RPC statistics.  The key is the RpcType in string form; e.g.
   * 'EMPTY_CALL' or 'UNARY_CALL'
   *
   * @generated from field: map<string, grpc.testing.LoadBalancerAccumulatedStatsResponse.MethodStats> stats_per_method = 4;
   */
  statsPerMethod: { [key: string]: LoadBalancerAccumulatedStatsResponse_MethodStats } = {};

  constructor(data?: PartialMessage<LoadBalancerAccumulatedStatsResponse>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "grpc.testing.LoadBalancerAccumulatedStatsResponse";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "num_rpcs_started_by_method", kind: "map", K: 9 /* ScalarType.STRING */, V: {kind: "scalar", T: 5 /* ScalarType.INT32 */} },
    { no: 2, name: "num_rpcs_succeeded_by_method", kind: "map", K: 9 /* ScalarType.STRING */, V: {kind: "scalar", T: 5 /* ScalarType.INT32 */} },
    { no: 3, name: "num_rpcs_failed_by_method", kind: "map", K: 9 /* ScalarType.STRING */, V: {kind: "scalar", T: 5 /* ScalarType.INT32 */} },
    { no: 4, name: "stats_per_method", kind: "map", K: 9 /* ScalarType.STRING */, V: {kind: "message", T: LoadBalancerAccumulatedStatsResponse_MethodStats} },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): LoadBalancerAccumulatedStatsResponse {
    return new LoadBalancerAccumulatedStatsResponse().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): LoadBalancerAccumulatedStatsResponse {
    return new LoadBalancerAccumulatedStatsResponse().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): LoadBalancerAccumulatedStatsResponse {
    return new LoadBalancerAccumulatedStatsResponse().fromJsonString(jsonString, options);
  }

  static equals(a: LoadBalancerAccumulatedStatsResponse | PlainMessage<LoadBalancerAccumulatedStatsResponse> | undefined, b: LoadBalancerAccumulatedStatsResponse | PlainMessage<LoadBalancerAccumulatedStatsResponse> | undefined): boolean {
    return proto3.util.equals(LoadBalancerAccumulatedStatsResponse, a, b);
  }
}

/**
 * @generated from message grpc.testing.LoadBalancerAccumulatedStatsResponse.MethodStats
 */
export class LoadBalancerAccumulatedStatsResponse_MethodStats extends Message<LoadBalancerAccumulatedStatsResponse_MethodStats> {
  /**
   * The number of RPCs that were started for this method.
   *
   * @generated from field: int32 rpcs_started = 1;
   */
  rpcsStarted = 0;

  /**
   * The number of RPCs that completed with each status for this method.  The
   * key is the integral value of a google.rpc.Code; the value is the count.
   *
   * @generated from field: map<int32, int32> result = 2;
   */
  result: { [key: number]: number } = {};

  constructor(data?: PartialMessage<LoadBalancerAccumulatedStatsResponse_MethodStats>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "grpc.testing.LoadBalancerAccumulatedStatsResponse.MethodStats";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "rpcs_started", kind: "scalar", T: 5 /* ScalarType.INT32 */ },
    { no: 2, name: "result", kind: "map", K: 5 /* ScalarType.INT32 */, V: {kind: "scalar", T: 5 /* ScalarType.INT32 */} },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): LoadBalancerAccumulatedStatsResponse_MethodStats {
    return new LoadBalancerAccumulatedStatsResponse_MethodStats().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): LoadBalancerAccumulatedStatsResponse_MethodStats {
    return new LoadBalancerAccumulatedStatsResponse_MethodStats().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): LoadBalancerAccumulatedStatsResponse_MethodStats {
    return new LoadBalancerAccumulatedStatsResponse_MethodStats().fromJsonString(jsonString, options);
  }

  static equals(a: LoadBalancerAccumulatedStatsResponse_MethodStats | PlainMessage<LoadBalancerAccumulatedStatsResponse_MethodStats> | undefined, b: LoadBalancerAccumulatedStatsResponse_MethodStats | PlainMessage<LoadBalancerAccumulatedStatsResponse_MethodStats> | undefined): boolean {
    return proto3.util.equals(LoadBalancerAccumulatedStatsResponse_MethodStats, a, b);
  }
}

/**
 * Configurations for a test client.
 *
 * @generated from message grpc.testing.ClientConfigureRequest
 */
export class ClientConfigureRequest extends Message<ClientConfigureRequest> {
  /**
   * The types of RPCs the client sends.
   *
   * @generated from field: repeated grpc.testing.ClientConfigureRequest.RpcType types = 1;
   */
  types: ClientConfigureRequest_RpcType[] = [];

  /**
   * The collection of custom metadata to be attached to RPCs sent by the client.
   *
   * @generated from field: repeated grpc.testing.ClientConfigureRequest.Metadata metadata = 2;
   */
  metadata: ClientConfigureRequest_Metadata[] = [];

  /**
   * The deadline to use, in seconds, for all RPCs.  If unset or zero, the
   * client will use the default from the command-line.
   *
   * @generated from field: int32 timeout_sec = 3;
   */
  timeoutSec = 0;

  constructor(data?: PartialMessage<ClientConfigureRequest>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "grpc.testing.ClientConfigureRequest";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "types", kind: "enum", T: proto3.getEnumType(ClientConfigureRequest_RpcType), repeated: true },
    { no: 2, name: "metadata", kind: "message", T: ClientConfigureRequest_Metadata, repeated: true },
    { no: 3, name: "timeout_sec", kind: "scalar", T: 5 /* ScalarType.INT32 */ },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ClientConfigureRequest {
    return new ClientConfigureRequest().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ClientConfigureRequest {
    return new ClientConfigureRequest().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ClientConfigureRequest {
    return new ClientConfigureRequest().fromJsonString(jsonString, options);
  }

  static equals(a: ClientConfigureRequest | PlainMessage<ClientConfigureRequest> | undefined, b: ClientConfigureRequest | PlainMessage<ClientConfigureRequest> | undefined): boolean {
    return proto3.util.equals(ClientConfigureRequest, a, b);
  }
}

/**
 * Type of RPCs to send.
 *
 * @generated from enum grpc.testing.ClientConfigureRequest.RpcType
 */
export enum ClientConfigureRequest_RpcType {
  /**
   * @generated from enum value: EMPTY_CALL = 0;
   */
  EMPTY_CALL = 0,

  /**
   * @generated from enum value: UNARY_CALL = 1;
   */
  UNARY_CALL = 1,
}
// Retrieve enum metadata with: proto3.getEnumType(ClientConfigureRequest_RpcType)
proto3.util.setEnumType(ClientConfigureRequest_RpcType, "grpc.testing.ClientConfigureRequest.RpcType", [
  { no: 0, name: "EMPTY_CALL" },
  { no: 1, name: "UNARY_CALL" },
]);

/**
 * Metadata to be attached for the given type of RPCs.
 *
 * @generated from message grpc.testing.ClientConfigureRequest.Metadata
 */
export class ClientConfigureRequest_Metadata extends Message<ClientConfigureRequest_Metadata> {
  /**
   * @generated from field: grpc.testing.ClientConfigureRequest.RpcType type = 1;
   */
  type = ClientConfigureRequest_RpcType.EMPTY_CALL;

  /**
   * @generated from field: string key = 2;
   */
  key = "";

  /**
   * @generated from field: string value = 3;
   */
  value = "";

  constructor(data?: PartialMessage<ClientConfigureRequest_Metadata>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "grpc.testing.ClientConfigureRequest.Metadata";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "type", kind: "enum", T: proto3.getEnumType(ClientConfigureRequest_RpcType) },
    { no: 2, name: "key", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 3, name: "value", kind: "scalar", T: 9 /* ScalarType.STRING */ },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ClientConfigureRequest_Metadata {
    return new ClientConfigureRequest_Metadata().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ClientConfigureRequest_Metadata {
    return new ClientConfigureRequest_Metadata().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ClientConfigureRequest_Metadata {
    return new ClientConfigureRequest_Metadata().fromJsonString(jsonString, options);
  }

  static equals(a: ClientConfigureRequest_Metadata | PlainMessage<ClientConfigureRequest_Metadata> | undefined, b: ClientConfigureRequest_Metadata | PlainMessage<ClientConfigureRequest_Metadata> | undefined): boolean {
    return proto3.util.equals(ClientConfigureRequest_Metadata, a, b);
  }
}

/**
 * Response for updating a test client's configuration.
 *
 * @generated from message grpc.testing.ClientConfigureResponse
 */
export class ClientConfigureResponse extends Message<ClientConfigureResponse> {
  constructor(data?: PartialMessage<ClientConfigureResponse>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "grpc.testing.ClientConfigureResponse";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ClientConfigureResponse {
    return new ClientConfigureResponse().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ClientConfigureResponse {
    return new ClientConfigureResponse().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ClientConfigureResponse {
    return new ClientConfigureResponse().fromJsonString(jsonString, options);
  }

  static equals(a: ClientConfigureResponse | PlainMessage<ClientConfigureResponse> | undefined, b: ClientConfigureResponse | PlainMessage<ClientConfigureResponse> | undefined): boolean {
    return proto3.util.equals(ClientConfigureResponse, a, b);
  }
}

/**
 * @generated from message grpc.testing.ErrorDetail
 */
export class ErrorDetail extends Message<ErrorDetail> {
  /**
   * @generated from field: string reason = 1;
   */
  reason = "";

  /**
   * @generated from field: string domain = 2;
   */
  domain = "";

  constructor(data?: PartialMessage<ErrorDetail>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "grpc.testing.ErrorDetail";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "reason", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 2, name: "domain", kind: "scalar", T: 9 /* ScalarType.STRING */ },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ErrorDetail {
    return new ErrorDetail().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ErrorDetail {
    return new ErrorDetail().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ErrorDetail {
    return new ErrorDetail().fromJsonString(jsonString, options);
  }

  static equals(a: ErrorDetail | PlainMessage<ErrorDetail> | undefined, b: ErrorDetail | PlainMessage<ErrorDetail> | undefined): boolean {
    return proto3.util.equals(ErrorDetail, a, b);
  }
}

/**
 * @generated from message grpc.testing.ErrorStatus
 */
export class ErrorStatus extends Message<ErrorStatus> {
  /**
   * @generated from field: int32 code = 1;
   */
  code = 0;

  /**
   * @generated from field: string message = 2;
   */
  message = "";

  /**
   * @generated from field: repeated google.protobuf.Any details = 3;
   */
  details: Any[] = [];

  constructor(data?: PartialMessage<ErrorStatus>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "grpc.testing.ErrorStatus";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "code", kind: "scalar", T: 5 /* ScalarType.INT32 */ },
    { no: 2, name: "message", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 3, name: "details", kind: "message", T: Any, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ErrorStatus {
    return new ErrorStatus().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ErrorStatus {
    return new ErrorStatus().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ErrorStatus {
    return new ErrorStatus().fromJsonString(jsonString, options);
  }

  static equals(a: ErrorStatus | PlainMessage<ErrorStatus> | undefined, b: ErrorStatus | PlainMessage<ErrorStatus> | undefined): boolean {
    return proto3.util.equals(ErrorStatus, a, b);
  }
}

