/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.dialogs.preferences;

import org.apache.directory.studio.common.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.connection.core.ConnectionCorePlugin;
import org.apache.directory.studio.ldapbrowser.ui.BrowserUIPlugin;
import org.apache.directory.studio.ldapbrowser.ui.dialogs.preferences.Messages;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class SearchLogsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button enableSearchRequestLogging;
    private Button enableSearchResultEntryLogging;
    private Text logFileCountText;
    private Text logFileSizeText;

    public SearchLogsPreferencePage() {
        super(Messages.getString("SearchLogsPreferencePage.SearchLogs"));
        super.setPreferenceStore(BrowserUIPlugin.getDefault().getPreferenceStore());
        super.setDescription(Messages.getString("SearchLogsPreferencePage.GeneralSettings"));
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite composite = BaseWidgetUtils.createColumnContainer((Composite)parent, (int)1, (int)1);
        BaseWidgetUtils.createSpacer((Composite)composite, (int)1);
        BaseWidgetUtils.createSpacer((Composite)composite, (int)1);
        this.enableSearchRequestLogging = BaseWidgetUtils.createCheckbox((Composite)composite, (String)Messages.getString("SearchLogsPreferencePage.EnableRequestLogs"), (int)1);
        this.enableSearchResultEntryLogging = BaseWidgetUtils.createCheckbox((Composite)composite, (String)Messages.getString("SearchLogsPreferencePage.EnableResultLogs"), (int)1);
        Group rotateGroup = BaseWidgetUtils.createGroup((Composite)BaseWidgetUtils.createColumnContainer((Composite)composite, (int)1, (int)1), (String)Messages.getString("SearchLogsPreferencePage.LogFileRotation"), (int)1);
        Composite rotateComposite = BaseWidgetUtils.createColumnContainer((Composite)rotateGroup, (int)5, (int)1);
        BaseWidgetUtils.createLabel((Composite)rotateComposite, (String)Messages.getString("SearchLogsPreferencePage.Use"), (int)1);
        this.logFileCountText = BaseWidgetUtils.createText((Composite)rotateComposite, (String)"", (int)3, (int)1);
        this.logFileCountText.addVerifyListener(e -> {
            if (!e.text.matches("[0-9]*")) {
                e.doit = false;
            }
            if ("".equals(this.logFileCountText.getText()) && e.text.matches("[0]")) {
                e.doit = false;
            }
        });
        this.logFileCountText.addModifyListener(e -> this.validate());
        BaseWidgetUtils.createLabel((Composite)rotateComposite, (String)Messages.getString("SearchLogsPreferencePage.LogFilesEach"), (int)1);
        this.logFileSizeText = BaseWidgetUtils.createText((Composite)rotateComposite, (String)"", (int)5, (int)1);
        this.logFileSizeText.addVerifyListener(e -> {
            if (!e.text.matches("[0-9]*")) {
                e.doit = false;
            }
            if ("".equals(this.logFileSizeText.getText()) && e.text.matches("[0]")) {
                e.doit = false;
            }
        });
        this.logFileSizeText.addModifyListener(e -> this.validate());
        BaseWidgetUtils.createLabel((Composite)rotateComposite, (String)Messages.getString("SearchLogsPreferencePage.KB"), (int)1);
        this.setValues();
        this.applyDialogFont(composite);
        return composite;
    }

    private void setValues() {
        this.enableSearchRequestLogging.setSelection(ConnectionCorePlugin.getDefault().isSearchRequestLogsEnabled());
        this.enableSearchResultEntryLogging.setSelection(ConnectionCorePlugin.getDefault().isSearchResultEntryLogsEnabled());
        this.logFileCountText.setText("" + ConnectionCorePlugin.getDefault().getSearchLogsFileCount());
        this.logFileSizeText.setText("" + ConnectionCorePlugin.getDefault().getSearchLogsFileSize());
    }

    public void validate() {
        this.setValid(this.logFileCountText.getText().matches("[0-9]+") && this.logFileSizeText.getText().matches("[0-9]+"));
    }

    public boolean performOk() {
        IEclipsePreferences instancePreferences = ConnectionCorePlugin.getDefault().getInstanceScopePreferences();
        instancePreferences.putBoolean("searchRequestLogsEnable", this.enableSearchRequestLogging.getSelection());
        instancePreferences.putBoolean("searchResultEntryLogsEnable", this.enableSearchResultEntryLogging.getSelection());
        instancePreferences.putInt("searchLogsFileCount", Integer.parseInt(this.logFileCountText.getText()));
        instancePreferences.putInt("searchLogsFileSize", Integer.parseInt(this.logFileSizeText.getText()));
        ConnectionCorePlugin.getDefault().flushInstanceScopePreferences();
        return true;
    }

    protected void performDefaults() {
        IEclipsePreferences instancePreferences = ConnectionCorePlugin.getDefault().getInstanceScopePreferences();
        instancePreferences.remove("searchRequestLogsEnable");
        instancePreferences.remove("searchResultEntryLogsEnable");
        instancePreferences.remove("searchLogsFileCount");
        instancePreferences.remove("searchLogsFileSize");
        ConnectionCorePlugin.getDefault().flushInstanceScopePreferences();
        this.setValues();
        super.performDefaults();
    }
}

