/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.web.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.directory.fortress.core.AuditMgr;
import org.apache.directory.fortress.core.ReviewMgr;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.model.AuthZ;
import org.apache.directory.fortress.core.model.Permission;
import org.apache.directory.fortress.core.model.Session;
import org.apache.directory.fortress.core.model.UserAudit;
import org.apache.directory.fortress.core.util.Config;
import org.apache.directory.fortress.web.model.SerializableList;
import org.apache.wicket.injection.Injector;
import org.apache.wicket.model.Model;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditAuthzListModel
extends Model<SerializableList<AuthZ>> {
    private static final long serialVersionUID = 1L;
    @SpringBean
    private AuditMgr auditMgr;
    @SpringBean
    private ReviewMgr reviewMgr;
    private static final Logger LOG = LoggerFactory.getLogger((String)AuditAuthzListModel.class.getName());
    private UserAudit userAudit;
    private SerializableList<AuthZ> authZs = null;

    public AuditAuthzListModel(Session session) {
        Injector.get().inject((Object)this);
        if (Config.getInstance().getBoolean("is.arbac02")) {
            this.auditMgr.setAdmin(session);
        }
    }

    public AuditAuthzListModel(UserAudit userAudit, Session session) {
        Injector.get().inject((Object)this);
        this.userAudit = userAudit;
        if (Config.getInstance().getBoolean("is.arbac02")) {
            this.auditMgr.setAdmin(session);
        }
    }

    public SerializableList<AuthZ> getObject() {
        if (this.authZs != null) {
            LOG.debug(".getObject count: " + this.authZs.size());
            return this.authZs;
        }
        if (this.userAudit == null || !StringUtils.isNotEmpty((String)this.userAudit.getUserId()) && !StringUtils.isNotEmpty((String)this.userAudit.getObjName()) && !StringUtils.isNotEmpty((String)this.userAudit.getOpName()) && this.userAudit.getBeginDate() == null && this.userAudit.getEndDate() == null || !StringUtils.isNotEmpty((String)this.userAudit.getUserId()) && StringUtils.isNotEmpty((String)this.userAudit.getObjName()) && !StringUtils.isNotEmpty((String)this.userAudit.getOpName()) && this.userAudit.getBeginDate() == null && this.userAudit.getEndDate() == null) {
            LOG.debug(".getObject null");
            this.authZs = new SerializableList(new ArrayList());
        } else {
            if (StringUtils.isNotEmpty((String)this.userAudit.getObjName()) && StringUtils.isNotEmpty((String)this.userAudit.getOpName()) && !StringUtils.isNotEmpty((String)this.userAudit.getDn())) {
                Permission permission = this.getPermission(this.userAudit);
                if (permission == null) {
                    String warning = "Matching permission not found for object: " + this.userAudit.getObjName() + " operation: " + this.userAudit.getOpName();
                    LOG.warn(warning);
                    throw new RuntimeException(warning);
                }
                this.userAudit.setDn(permission.getDn());
            }
            this.authZs = new SerializableList(this.getList(this.userAudit));
            this.userAudit.setDn("");
        }
        return this.authZs;
    }

    public void setObject(SerializableList<AuthZ> object) {
        LOG.debug(".setObject count: " + object.size());
        this.authZs = object;
    }

    public void detach() {
        this.authZs = null;
        this.userAudit = null;
    }

    private List<AuthZ> getList(UserAudit userAudit) {
        List authZList = null;
        try {
            authZList = this.auditMgr.getUserAuthZs(userAudit);
        }
        catch (SecurityException se) {
            String error = ".getList caught SecurityException=" + se;
            LOG.warn(error);
        }
        return authZList;
    }

    private Permission getPermission(UserAudit userAudit) {
        Permission permission = null;
        try {
            permission = this.reviewMgr.readPermission(new Permission(userAudit.getObjName(), userAudit.getOpName(), userAudit.isAdmin()));
        }
        catch (SecurityException se) {
            String error = ".getPermission caught SecurityException=" + se;
            throw new RuntimeException(error, se);
        }
        return permission;
    }
}

