/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.rest;

import org.apache.directory.fortress.core.DelAdminMgr;
import org.apache.directory.fortress.core.DelAdminMgrFactory;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.model.AdminRole;
import org.apache.directory.fortress.core.model.AdminRoleRelationship;
import org.apache.directory.fortress.core.model.FortEntity;
import org.apache.directory.fortress.core.model.FortRequest;
import org.apache.directory.fortress.core.model.FortResponse;
import org.apache.directory.fortress.core.model.OrgUnit;
import org.apache.directory.fortress.core.model.OrgUnitRelationship;
import org.apache.directory.fortress.core.model.UserAdminRole;
import org.apache.directory.fortress.rest.AbstractMgrImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DelegatedAdminMgrImpl
extends AbstractMgrImpl {
    private static final Logger LOG = LoggerFactory.getLogger((String)DelegatedAdminMgrImpl.class.getName());

    DelegatedAdminMgrImpl() {
    }

    FortResponse addAdminRole(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            AdminRole inRole = (AdminRole)request.getEntity();
            DelAdminMgr delegatedAdminMgr = DelAdminMgrFactory.createInstance((String)request.getContextId());
            delegatedAdminMgr.setAdmin(request.getSession());
            AdminRole retRole = delegatedAdminMgr.addRole(inRole);
            response.setEntity((FortEntity)retRole);
        }
        catch (SecurityException se) {
            LOG.info("Caught " + se + " warnId=" + se.getErrorId());
            response.setErrorCode(se.getErrorId());
            response.setErrorMessage(se.getMessage());
        }
        return response;
    }

    FortResponse deleteAdminRole(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            AdminRole inRole = (AdminRole)request.getEntity();
            DelAdminMgr delegatedAdminMgr = DelAdminMgrFactory.createInstance((String)request.getContextId());
            delegatedAdminMgr.setAdmin(request.getSession());
            delegatedAdminMgr.deleteRole(inRole);
            response.setEntity((FortEntity)inRole);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse updateAdminRole(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            AdminRole inRole = (AdminRole)request.getEntity();
            DelAdminMgr delegatedAdminMgr = DelAdminMgrFactory.createInstance((String)request.getContextId());
            delegatedAdminMgr.setAdmin(request.getSession());
            AdminRole retRole = delegatedAdminMgr.updateRole(inRole);
            response.setEntity((FortEntity)retRole);
        }
        catch (SecurityException se) {
            LOG.info("Caught " + se + " errorId=" + se.getErrorId());
            response.setErrorCode(se.getErrorId());
            response.setErrorMessage(se.getMessage());
        }
        return response;
    }

    FortResponse assignAdminUser(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            UserAdminRole inRole = (UserAdminRole)request.getEntity();
            DelAdminMgr delegatedAdminMgr = DelAdminMgrFactory.createInstance((String)request.getContextId());
            delegatedAdminMgr.setAdmin(request.getSession());
            delegatedAdminMgr.assignUser(inRole);
            response.setEntity((FortEntity)inRole);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse deassignAdminUser(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            UserAdminRole inRole = (UserAdminRole)request.getEntity();
            DelAdminMgr delegatedAdminMgr = DelAdminMgrFactory.createInstance((String)request.getContextId());
            delegatedAdminMgr.setAdmin(request.getSession());
            delegatedAdminMgr.deassignUser(inRole);
            response.setEntity((FortEntity)inRole);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse addAdminDescendant(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            AdminRoleRelationship relationship = (AdminRoleRelationship)request.getEntity();
            DelAdminMgr delegatedAdminMgr = DelAdminMgrFactory.createInstance((String)request.getContextId());
            delegatedAdminMgr.setAdmin(request.getSession());
            delegatedAdminMgr.addDescendant(relationship.getParent(), relationship.getChild());
            response.setEntity((FortEntity)relationship);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse addAdminAscendant(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            AdminRoleRelationship relationship = (AdminRoleRelationship)request.getEntity();
            DelAdminMgr delegatedAdminMgr = DelAdminMgrFactory.createInstance((String)request.getContextId());
            delegatedAdminMgr.setAdmin(request.getSession());
            delegatedAdminMgr.addAscendant(relationship.getChild(), relationship.getParent());
            response.setEntity((FortEntity)relationship);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse addAdminInheritance(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            AdminRoleRelationship relationship = (AdminRoleRelationship)request.getEntity();
            DelAdminMgr delegatedAdminMgr = DelAdminMgrFactory.createInstance((String)request.getContextId());
            delegatedAdminMgr.setAdmin(request.getSession());
            delegatedAdminMgr.addInheritance(relationship.getParent(), relationship.getChild());
            response.setEntity((FortEntity)relationship);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse deleteAdminInheritance(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            AdminRoleRelationship relationship = (AdminRoleRelationship)request.getEntity();
            DelAdminMgr delegatedAdminMgr = DelAdminMgrFactory.createInstance((String)request.getContextId());
            delegatedAdminMgr.setAdmin(request.getSession());
            delegatedAdminMgr.deleteInheritance(relationship.getParent(), relationship.getChild());
            response.setEntity((FortEntity)relationship);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse addOrg(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            OrgUnit inOrg = (OrgUnit)request.getEntity();
            DelAdminMgr delegatedAdminMgr = DelAdminMgrFactory.createInstance((String)request.getContextId());
            delegatedAdminMgr.setAdmin(request.getSession());
            OrgUnit retOrg = delegatedAdminMgr.add(inOrg);
            response.setEntity((FortEntity)retOrg);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse updateOrg(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            OrgUnit inOrg = (OrgUnit)request.getEntity();
            DelAdminMgr delegatedAdminMgr = DelAdminMgrFactory.createInstance((String)request.getContextId());
            delegatedAdminMgr.setAdmin(request.getSession());
            OrgUnit retOrg = delegatedAdminMgr.update(inOrg);
            response.setEntity((FortEntity)retOrg);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse deleteOrg(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            OrgUnit inOrg = (OrgUnit)request.getEntity();
            DelAdminMgr delegatedAdminMgr = DelAdminMgrFactory.createInstance((String)request.getContextId());
            delegatedAdminMgr.setAdmin(request.getSession());
            OrgUnit retOrg = delegatedAdminMgr.delete(inOrg);
            response.setEntity((FortEntity)retOrg);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse addOrgDescendant(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            OrgUnitRelationship relationship = (OrgUnitRelationship)request.getEntity();
            DelAdminMgr delegatedAdminMgr = DelAdminMgrFactory.createInstance((String)request.getContextId());
            delegatedAdminMgr.setAdmin(request.getSession());
            delegatedAdminMgr.addDescendant(relationship.getParent(), relationship.getChild());
            response.setEntity((FortEntity)relationship);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse addOrgAscendant(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            OrgUnitRelationship relationship = (OrgUnitRelationship)request.getEntity();
            DelAdminMgr delegatedAdminMgr = DelAdminMgrFactory.createInstance((String)request.getContextId());
            delegatedAdminMgr.setAdmin(request.getSession());
            delegatedAdminMgr.addAscendant(relationship.getChild(), relationship.getParent());
            response.setEntity((FortEntity)relationship);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse addOrgInheritance(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            OrgUnitRelationship relationship = (OrgUnitRelationship)request.getEntity();
            DelAdminMgr delegatedAdminMgr = DelAdminMgrFactory.createInstance((String)request.getContextId());
            delegatedAdminMgr.setAdmin(request.getSession());
            delegatedAdminMgr.addInheritance(relationship.getParent(), relationship.getChild());
            response.setEntity((FortEntity)relationship);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse deleteOrgInheritance(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            OrgUnitRelationship relationship = (OrgUnitRelationship)request.getEntity();
            DelAdminMgr delegatedAdminMgr = DelAdminMgrFactory.createInstance((String)request.getContextId());
            delegatedAdminMgr.setAdmin(request.getSession());
            delegatedAdminMgr.deleteInheritance(relationship.getParent(), relationship.getChild());
            response.setEntity((FortEntity)relationship);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }
}

