/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.rest;

import java.util.List;
import java.util.Set;
import org.apache.directory.fortress.core.AccessMgr;
import org.apache.directory.fortress.core.AccessMgrFactory;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.model.FortEntity;
import org.apache.directory.fortress.core.model.FortRequest;
import org.apache.directory.fortress.core.model.FortResponse;
import org.apache.directory.fortress.core.model.Group;
import org.apache.directory.fortress.core.model.Permission;
import org.apache.directory.fortress.core.model.Role;
import org.apache.directory.fortress.core.model.Session;
import org.apache.directory.fortress.core.model.User;
import org.apache.directory.fortress.core.model.UserRole;
import org.apache.directory.fortress.rest.AbstractMgrImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AccessMgrImpl
extends AbstractMgrImpl {
    private static final Logger LOG = LoggerFactory.getLogger((String)AccessMgrImpl.class.getName());
    private static final boolean TRUSTED = true;
    private static final boolean UNTRUSTED = false;

    AccessMgrImpl() {
    }

    FortResponse authenticate(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            AccessMgr accessMgr = AccessMgrFactory.createInstance((String)request.getContextId());
            User inUser = (User)request.getEntity();
            Session outSession = accessMgr.authenticate(inUser.getUserId(), inUser.getPassword());
            response.setSession(outSession);
            response.setErrorCode(0);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse createSession(FortRequest request) {
        return this.createSession(request, false);
    }

    FortResponse createSessionTrusted(FortRequest request) {
        return this.createSession(request, true);
    }

    FortResponse createGroupSession(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            AccessMgr accessMgr = AccessMgrFactory.createInstance((String)request.getContextId());
            Group inGroup = (Group)request.getEntity();
            Session outSession = accessMgr.createSession(inGroup);
            response.setSession(outSession);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    private FortResponse createSession(FortRequest request, boolean trusted) {
        FortResponse response = this.createResponse();
        try {
            AccessMgr accessMgr = AccessMgrFactory.createInstance((String)request.getContextId());
            User inUser = (User)request.getEntity();
            Session outSession = accessMgr.createSession(inUser, trusted);
            response.setSession(outSession);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse checkAccess(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            AccessMgr accessMgr = AccessMgrFactory.createInstance((String)request.getContextId());
            Permission perm = (Permission)request.getEntity();
            perm.setAdmin(false);
            Session session = request.getSession();
            boolean result = accessMgr.checkAccess(session, perm);
            response.setSession(session);
            response.setAuthorized(Boolean.valueOf(result));
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse createSessionCheckAccess(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            AccessMgr accessMgr = AccessMgrFactory.createInstance((String)request.getContextId());
            Permission perm = (Permission)request.getEntity();
            perm.setAdmin(false);
            User user = (User)request.getEntity2();
            boolean isTrusted = request.getIsFlag();
            boolean result = accessMgr.checkAccess(user, perm, isTrusted);
            response.setAuthorized(Boolean.valueOf(result));
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse isUserInRole(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            AccessMgr accessMgr = AccessMgrFactory.createInstance((String)request.getContextId());
            Role role = (Role)request.getEntity();
            User user = (User)request.getEntity2();
            boolean isTrusted = request.getIsFlag();
            boolean result = accessMgr.isUserInRole(user, role, isTrusted);
            response.setAuthorized(Boolean.valueOf(result));
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse sessionPermissions(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            AccessMgr accessMgr = AccessMgrFactory.createInstance((String)request.getContextId());
            Session session = request.getSession();
            List perms = accessMgr.sessionPermissions(session);
            response.setSession(session);
            response.setEntities(perms);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse sessionRoles(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            AccessMgr accessMgr = AccessMgrFactory.createInstance((String)request.getContextId());
            Session session = request.getSession();
            List roles = accessMgr.sessionRoles(session);
            response.setEntities(roles);
            response.setSession(session);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse authorizedSessionRoles(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            AccessMgr accessMgr = AccessMgrFactory.createInstance((String)request.getContextId());
            Session session = request.getSession();
            Set roles = accessMgr.authorizedRoles(session);
            response.setValueSet(roles);
            response.setSession(session);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse addActiveRole(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            AccessMgr accessMgr = AccessMgrFactory.createInstance((String)request.getContextId());
            UserRole uRole = (UserRole)request.getEntity();
            Session session = request.getSession();
            accessMgr.addActiveRole(session, uRole);
            response.setSession(session);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse dropActiveRole(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            AccessMgr accessMgr = AccessMgrFactory.createInstance((String)request.getContextId());
            UserRole uRole = (UserRole)request.getEntity();
            Session session = request.getSession();
            accessMgr.dropActiveRole(session, uRole);
            response.setSession(session);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse getUserId(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            AccessMgr accessMgr = AccessMgrFactory.createInstance((String)request.getContextId());
            Session session = request.getSession();
            String userId = accessMgr.getUserId(session);
            User outUser = new User(userId);
            response.setSession(session);
            response.setEntity((FortEntity)outUser);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse getUser(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            AccessMgr accessMgr = AccessMgrFactory.createInstance((String)request.getContextId());
            Session session = request.getSession();
            User outUser = accessMgr.getUser(session);
            response.setSession(session);
            response.setEntity((FortEntity)outUser);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }
}

