/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.dhcp.io;

import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.directory.server.dhcp.DhcpException;
import org.apache.directory.server.dhcp.messages.DhcpMessage;
import org.apache.directory.server.dhcp.messages.HardwareAddress;
import org.apache.directory.server.dhcp.options.DhcpOption;
import org.apache.directory.server.dhcp.options.OptionsField;
import org.apache.directory.server.dhcp.options.dhcp.DhcpMessageType;
import org.apache.directory.server.dhcp.options.dhcp.UnrecognizedOption;
import org.apache.directory.server.i18n.I18n;

public class DhcpMessageDecoder {
    private static final byte[] VENDOR_MAGIC_COOKIE = new byte[]{99, -126, 83, 99};

    public DhcpMessage decode(ByteBuffer buffer) throws DhcpException {
        byte op = buffer.get();
        short htype = (short)(buffer.get() & 0xFF);
        short hlen = (short)(buffer.get() & 0xFF);
        short hops = (short)(buffer.get() & 0xFF);
        int xid = buffer.getInt();
        int secs = buffer.getShort() & 0xFFFF;
        short flags = buffer.getShort();
        InetAddress ciaddr = DhcpMessageDecoder.decodeAddress(buffer);
        InetAddress yiaddr = DhcpMessageDecoder.decodeAddress(buffer);
        InetAddress siaddr = DhcpMessageDecoder.decodeAddress(buffer);
        InetAddress giaddr = DhcpMessageDecoder.decodeAddress(buffer);
        byte[] chaddr = DhcpMessageDecoder.decodeBytes(buffer, 16);
        String sname = DhcpMessageDecoder.decodeString(buffer, 64);
        String file = DhcpMessageDecoder.decodeString(buffer, 128);
        OptionsField options = this.decodeOptions(buffer);
        DhcpMessageType mto = (DhcpMessageType)options.get(DhcpMessageType.class);
        return new DhcpMessage(null != mto ? mto.getType() : null, op, new HardwareAddress(htype, hlen, chaddr), hops, xid, secs, flags, ciaddr, yiaddr, siaddr, giaddr, sname, file, options);
    }

    private static byte[] decodeBytes(ByteBuffer buffer, int len) {
        byte[] bytes = new byte[len];
        buffer.get(bytes);
        return bytes;
    }

    private static String decodeString(ByteBuffer buffer, int len) {
        byte[] bytes = new byte[len];
        buffer.get(bytes);
        int slen = 0;
        while (bytes[slen] != 0) {
            ++slen;
        }
        try {
            return new String(bytes, 0, slen, "ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(I18n.err(I18n.ERR_635, new Object[0]), e);
        }
    }

    private static InetAddress decodeAddress(ByteBuffer buffer) {
        byte[] addr = new byte[4];
        buffer.get(addr);
        try {
            return InetAddress.getByAddress(addr);
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    public OptionsField decodeOptions(ByteBuffer message) throws DhcpException {
        byte[] magicCookie = new byte[4];
        message.get(magicCookie);
        if (!Arrays.equals(VENDOR_MAGIC_COOKIE, magicCookie)) {
            throw new DhcpException("Parse exception.");
        }
        OptionsField options = new OptionsField();
        while (true) {
            byte code;
            if ((code = message.get()) == 0) {
                continue;
            }
            if (code == -1) break;
            byte length = message.get();
            byte[] value = new byte[length];
            message.get(value);
            options.add(this.getOptionInstance(code, value));
        }
        return options;
    }

    private DhcpOption getOptionInstance(int tag, byte[] value) throws DhcpException {
        try {
            Class<?> c = DhcpOption.getClassByTag(tag);
            DhcpOption o = null != c ? (DhcpOption)c.newInstance() : new UnrecognizedOption((byte)tag);
            o.setData(value);
            return o;
        }
        catch (Exception e) {
            throw new DhcpException(I18n.err(I18n.ERR_636, e.toString()));
        }
    }
}

