/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.data.impl.builder.part;

import java.text.MessageFormat;
import org.apache.deltaspike.data.impl.builder.QueryBuilderContext;
import org.apache.deltaspike.data.impl.builder.QueryOperator;
import org.apache.deltaspike.data.impl.builder.part.BasePropertyQueryPart;
import org.apache.deltaspike.data.impl.builder.part.QueryPart;
import org.apache.deltaspike.data.impl.meta.RepositoryMetadata;
import org.apache.deltaspike.data.impl.param.ToUpperStringParameterUpdate;
import org.apache.deltaspike.data.impl.util.QueryUtils;

class PropertyQueryPart
extends BasePropertyQueryPart {
    private String name;
    private QueryOperator comparator;

    PropertyQueryPart() {
    }

    @Override
    protected QueryPart build(String queryPart, String method, RepositoryMetadata repo) {
        this.comparator = QueryOperator.Equal;
        this.name = QueryUtils.uncapitalize(queryPart);
        for (QueryOperator comp : QueryOperator.values()) {
            if (!queryPart.endsWith(comp.getExpression())) continue;
            this.comparator = comp;
            this.name = QueryUtils.uncapitalize(queryPart.substring(0, queryPart.indexOf(comp.getExpression())));
            break;
        }
        this.validate(this.name, method, repo);
        this.name = this.rewriteSeparator(this.name);
        return this;
    }

    @Override
    protected QueryPart buildQuery(QueryBuilderContext ctx) {
        String[] args = new String[this.comparator.getParamNum() + 1];
        args[0] = "e." + this.name;
        for (int i = 1; i < args.length; ++i) {
            args[i] = "?" + ctx.increment();
        }
        ctx.append(MessageFormat.format(this.comparator.getJpql(), args));
        if (this.comparator.isCaseInsensitive() && args.length >= 1) {
            ctx.addParameterUpdate(new ToUpperStringParameterUpdate(args[1].substring(1)));
        }
        return this;
    }
}

