/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.replicationTests;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.replicationTests.ReplicationRun;
import org.apache.derbyTesting.junit.BaseTestSuite;

public class ReplicationRun_Distributed
extends ReplicationRun {
    public ReplicationRun_Distributed(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("ReplicationRun_Distributed Suite");
        baseTestSuite.addTestSuite(ReplicationRun_Distributed.class);
        return baseTestSuite;
    }

    public void testReplication() throws Exception {
        this.cleanAllTestHosts();
        this.initEnvironment();
        this.initMaster(masterServerHost, replicatedDb);
        this.startServer(masterJvmVersion, derbyMasterVersion, masterServerHost, "0.0.0.0", masterServerPort, masterDbSubPath);
        this.startServer(slaveJvmVersion, derbySlaveVersion, slaveServerHost, "0.0.0.0", slaveServerPort, slaveDbSubPath);
        this.startServerMonitor(slaveServerHost);
        this.bootMasterDatabase(jvmVersion, masterDatabasePath + FS + masterDbSubPath, replicatedDb, masterServerHost, masterServerPort, null);
        this.initSlave(slaveServerHost, jvmVersion, replicatedDb);
        this.startSlave(jvmVersion, replicatedDb, slaveServerHost, slaveServerPort, slaveServerHost, slaveReplPort, testClientHost);
        this.util.sleep(sleepTime, "Before startMaster");
        this.startMaster(jvmVersion, replicatedDb, masterServerHost, masterServerPort, masterServerHost, slaveServerPort, slaveServerHost, slaveReplPort);
        this.runTest(replicationTest, jvmVersion, testClientHost, masterServerHost, masterServerPort, replicatedDb);
        this.failOver(jvmVersion, masterDatabasePath, masterDbSubPath, replicatedDb, masterServerHost, masterServerPort, testClientHost);
        this.connectPing(slaveDatabasePath + FS + slaveDbSubPath + FS + replicatedDb, slaveServerHost, slaveServerPort, testClientHost);
        this.verifySlave();
        this.verifyMaster();
        this.stopServer(jvmVersion, derbyVersion, slaveServerHost, slaveServerPort);
        this.stopServer(jvmVersion, derbyVersion, masterServerHost, masterServerPort);
    }

    @Override
    void initEnvironment() throws IOException {
        this.util.DEBUG("*** Properties -----------------------------------------");
        userDir = System.getProperty("user.dir");
        this.util.DEBUG("user.dir:          " + userDir);
        userHome = System.getProperty("user.home");
        this.util.DEBUG("user.home:          " + userHome);
        this.util.writeToFile("exit;", userHome + FS + "ij_dummy_script.sql");
        this.util.DEBUG("derby.system.home: " + System.getProperty("derby.system.home"));
        String string = "replicationtest.properties";
        this.util.DEBUG("realPropertyFile: " + string);
        FileInputStream fileInputStream = new FileInputStream(userDir + FS + string);
        Properties properties = new Properties();
        properties.load(fileInputStream);
        this.util.printDebug = properties.getProperty("test.printDebug", "false").equalsIgnoreCase("true");
        this.util.DEBUG("printDebug: " + this.util.printDebug);
        showSysinfo = properties.getProperty("test.showSysinfo", "false").equalsIgnoreCase("true");
        this.util.DEBUG("showSysinfo: " + showSysinfo);
        testUser = properties.getProperty("test.testUser", "UNKNOWN");
        this.util.DEBUG("testUser: " + testUser);
        masterServerHost = properties.getProperty("test.masterServerHost", masterServerHost);
        this.util.DEBUG("masterServerHost: " + masterServerHost);
        properties.setProperty("test.serverHost", masterServerHost);
        masterServerPort = Integer.parseInt(properties.getProperty("test.masterServerPort", "" + masterServerPort));
        this.util.DEBUG("masterServerPort: " + masterServerPort);
        properties.setProperty("test.serverPort", "" + masterServerPort);
        slaveServerHost = properties.getProperty("test.slaveServerHost", slaveServerHost);
        this.util.DEBUG("slaveServerHost: " + slaveServerHost);
        slaveServerPort = Integer.parseInt(properties.getProperty("test.slaveServerPort", "" + slaveServerPort));
        this.util.DEBUG("slaveServerPort: " + slaveServerPort);
        slaveReplPort = Integer.parseInt(properties.getProperty("test.slaveReplPort", "" + slaveReplPort));
        this.util.DEBUG("slaveReplPort: " + slaveReplPort);
        testClientHost = properties.getProperty("test.testClientHost", testClientHost);
        this.util.DEBUG("testClientHost: " + testClientHost);
        masterDatabasePath = properties.getProperty("test.master.databasepath");
        this.util.DEBUG("masterDatabasePath: " + masterDatabasePath);
        slaveDatabasePath = properties.getProperty("test.slave.databasepath");
        this.util.DEBUG("slaveDatabasePath: " + slaveDatabasePath);
        replicatedDb = properties.getProperty("test.databaseName", "test");
        this.util.DEBUG("replicatedDb: " + replicatedDb);
        bootLoad = properties.getProperty("test.bootLoad");
        this.util.DEBUG("bootLoad: " + bootLoad);
        freezeDB = properties.getProperty("test.freezeDB");
        this.util.DEBUG("freezeDB: " + freezeDB);
        unFreezeDB = properties.getProperty("test.unFreezeDB");
        this.util.DEBUG("unFreezeDB: " + unFreezeDB);
        simpleLoad = System.getProperty("derby.tests.replSimpleLoad", "true").equalsIgnoreCase("true");
        this.util.DEBUG("simpleLoad: " + simpleLoad);
        simpleLoadTuples = Integer.parseInt(properties.getProperty("test.simpleloadtuples", "10000"));
        this.util.DEBUG("simpleLoadTuples: " + simpleLoadTuples);
        replicationTest = properties.getProperty("test.replicationTest");
        this.util.DEBUG("replicationTest: " + replicationTest);
        replicationVerify = properties.getProperty("test.replicationVerify");
        this.util.DEBUG("replicationVerify: " + replicationVerify);
        junitTest = properties.getProperty("test.junitTest", "true").equalsIgnoreCase("true");
        this.util.DEBUG("junitTest: " + junitTest);
        THREADS = Integer.parseInt(properties.getProperty("test.stressMultiThreads", "0"));
        this.util.DEBUG("THREADS: " + THREADS);
        MINUTES = Integer.parseInt(properties.getProperty("test.stressMultiMinutes", "0"));
        this.util.DEBUG("MINUTES: " + MINUTES);
        sqlLoadInit = properties.getProperty("test.sqlLoadInit");
        this.util.DEBUG("sqlLoadInit: " + sqlLoadInit);
        specialTestingJar = properties.getProperty("test.derbyTestingJar", null);
        this.util.DEBUG("specialTestingJar: " + specialTestingJar);
        jvmVersion = properties.getProperty("jvm.version");
        this.util.DEBUG("jvmVersion: " + jvmVersion);
        masterJvmVersion = properties.getProperty("jvm.masterversion");
        if (masterJvmVersion == null) {
            masterJvmVersion = jvmVersion;
        }
        this.util.DEBUG("masterJvmVersion: " + masterJvmVersion);
        slaveJvmVersion = properties.getProperty("jvm.slaveversion");
        if (slaveJvmVersion == null) {
            slaveJvmVersion = jvmVersion;
        }
        this.util.DEBUG("slaveJvmVersion: " + slaveJvmVersion);
        derbyVersion = properties.getProperty("derby.version");
        this.util.DEBUG("derbyVersion: " + derbyVersion);
        derbyMasterVersion = properties.getProperty("derby.masterversion");
        if (derbyMasterVersion == null) {
            derbyMasterVersion = derbyVersion;
        }
        this.util.DEBUG("derbyMasterVersion: " + derbyMasterVersion);
        derbySlaveVersion = properties.getProperty("derby.slaveversion");
        if (derbySlaveVersion == null) {
            derbySlaveVersion = derbyVersion;
        }
        this.util.DEBUG("derbySlaveVersion: " + derbySlaveVersion);
        Object object = derbyVersion + FS + "derbyTesting.jar";
        if (specialTestingJar != null) {
            object = specialTestingJar;
        }
        this.util.DEBUG("derbyTestingJar: " + (String)object);
        junit_jar = properties.getProperty("junit_jar");
        this.util.DEBUG("junit_jar: " + junit_jar);
        test_jars = (String)object + ":" + junit_jar;
        this.util.DEBUG("test_jars: " + test_jars);
        sleepTime = Integer.parseInt(properties.getProperty("test.sleepTime", "15000"));
        this.util.DEBUG("sleepTime: " + sleepTime);
        runUnReplicated = properties.getProperty("test.runUnReplicated", "false").equalsIgnoreCase("true");
        this.util.DEBUG("runUnReplicated: " + runUnReplicated);
        localEnv = properties.getProperty("test.localEnvironment", "false").equalsIgnoreCase("true");
        this.util.DEBUG("localEnv: " + localEnv);
        derbyProperties = "derby.infolog.append=true" + LF + "derby.drda.logConnections=true" + LF + "derby.drda.traceAll=true" + LF;
        this.util.DEBUG("--------------------------------------------------------");
        masterPreRepl = new ReplicationRun.Load(this, "masterPreRepl", properties);
        masterPostRepl = new ReplicationRun.Load(this, "masterPostRepl", properties);
        slavePreSlave = new ReplicationRun.Load(this, "slavePreSlave", properties);
        masterPostSlave = new ReplicationRun.Load(this, "masterPostSlave", properties);
        slavePostSlave = new ReplicationRun.Load(this, "slavePostSlave", properties);
        this.util.DEBUG("--------------------------------------------------------");
        tuplesToInsertPerf = Integer.parseInt(properties.getProperty("test.inserts", "10000"));
        this.util.DEBUG("tuplesToInsertPerf: " + tuplesToInsertPerf);
        commitFreq = Integer.parseInt(properties.getProperty("test.commitFreq", "0"));
        this.util.DEBUG("commitFreq: " + commitFreq);
        this.util.DEBUG("--------------------------------------------------------");
        this.state.initEnvironment(properties);
        this.util.DEBUG("--------------------------------------------------------");
    }
}

