/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.derbynet;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import junit.framework.Test;
import org.apache.derby.drda.NetworkServerControl;
import org.apache.derbyTesting.functionTests.util.PrivilegedFileOpsForTests;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.Derby;
import org.apache.derbyTesting.junit.LocaleTestSetup;
import org.apache.derbyTesting.junit.NetworkServerTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class DerbyNetAutoStartTest
extends BaseJDBCTestCase {
    private Locale oldLocale = Locale.getDefault();
    private static boolean WITHOUTPORT = false;
    private static boolean WITHPORT = true;

    public DerbyNetAutoStartTest(String name) {
        super(name);
    }

    public void setUp() {
        TestConfiguration.getCurrent().shutdownEngine();
    }

    public void testStartNetworkServerFalse() throws Exception {
        DerbyNetAutoStartTest.setSystemProperty("derby.drda.startNetworkServer", "false");
        this.getConnection();
        NetworkServerControl ns = NetworkServerTestSetup.getNetworkServerControl();
        DerbyNetAutoStartTest.assertFalse((boolean)NetworkServerTestSetup.pingForServerUp(ns, null, false));
    }

    public void ttestStartNetworkServerTrueNoPort() throws Exception {
        this.startNetworkServerTrueHelper(WITHOUTPORT);
    }

    public void testStartNetworkServerTrueWithPort() throws Exception {
        this.startNetworkServerTrueHelper(WITHPORT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStartNetworkServerTrueWithInvalidPort() throws Exception {
        DerbyNetAutoStartTest.setSystemProperty("derby.drda.startNetworkServer", "true");
        DerbyNetAutoStartTest.setSystemProperty("derby.drda.portNumber", "-1");
        PrintStream realSystemOut = System.out;
        PrintStream realSystemErr = System.err;
        ByteArrayOutputStream serverOutputBOS = new ByteArrayOutputStream();
        PrintStream serverOutputOut = new PrintStream(serverOutputBOS);
        DerbyNetAutoStartTest.setSystemOut(new PrintStream(serverOutputOut));
        DerbyNetAutoStartTest.setSystemErr(new PrintStream(serverOutputOut));
        try {
            try {
                DatabaseMetaData dbmd = this.getConnection().getMetaData();
                ResultSet rs = dbmd.getSchemas();
                DerbyNetAutoStartTest.assertNotNull((Object)rs);
                rs.close();
            }
            catch (SQLException e) {
                DerbyNetAutoStartTest.fail();
            }
        }
        finally {
            DerbyNetAutoStartTest.setSystemOut(realSystemOut);
            DerbyNetAutoStartTest.setSystemErr(realSystemErr);
        }
        NetworkServerControl ns = NetworkServerTestSetup.getNetworkServerControl();
        DerbyNetAutoStartTest.assertFalse((boolean)NetworkServerTestSetup.pingForServerUp(ns, null, false));
    }

    private void startNetworkServerTrueHelper(boolean withport) throws Exception {
        int n;
        if (withport) {
            n = TestConfiguration.getCurrent().getNextAvailablePort();
        } else {
            TestConfiguration.getCurrent();
            n = TestConfiguration.getBasePort();
        }
        int theport = n;
        DerbyNetAutoStartTest.setSystemProperty("derby.drda.startNetworkServer", "true");
        if (withport) {
            DerbyNetAutoStartTest.setSystemProperty("derby.drda.portNumber", Integer.toString(theport));
        }
        this.getConnection();
        NetworkServerControl ns = NetworkServerTestSetup.getNetworkServerControl(theport);
        NetworkServerTestSetup.waitForServerStart(ns);
        ns.shutdown();
        DerbyNetAutoStartTest.assertFalse((boolean)NetworkServerTestSetup.pingForServerUp(ns, null, false));
    }

    public void testStartNetworkServerLogMessageOnDualStart() throws Exception {
        LocaleTestSetup.setDefaultLocale(Locale.ENGLISH);
        int doubleport = TestConfiguration.getCurrent().getPort();
        NetworkServerControl ns = NetworkServerTestSetup.getNetworkServerControl(doubleport);
        ns.start(null);
        NetworkServerTestSetup.waitForServerStart(ns);
        TestConfiguration.getCurrent().shutdownEngine();
        DerbyNetAutoStartTest.setSystemProperty("derby.drda.startNetworkServer", "true");
        DerbyNetAutoStartTest.setSystemProperty("derby.drda.portNumber", Integer.toString(doubleport));
        this.getConnection();
        DerbyNetAutoStartTest.assertTrue((boolean)NetworkServerTestSetup.pingForServerUp(ns, null, true));
        String logFileName = DerbyNetAutoStartTest.getSystemProperty("derby.system.home") + File.separator + "derby.log";
        String expectedString = "An exception was thrown during network server startup";
        long startTime = System.currentTimeMillis();
        long waitTime = NetworkServerTestSetup.getWaitTime();
        while (true) {
            Thread.sleep(1000L);
            if (DerbyNetAutoStartTest.checkLog(logFileName, new String[]{expectedString})) break;
            long elapsed = System.currentTimeMillis() - startTime;
            if (elapsed <= waitTime) continue;
            DerbyNetAutoStartTest.fail((String)("did not find the expected string: " + expectedString + " within the maximum wait time " + waitTime));
        }
        DerbyNetAutoStartTest.assertTrue((boolean)DerbyNetAutoStartTest.checkLog(logFileName, new String[]{expectedString}));
        ns.shutdown();
    }

    static boolean checkLog(String logFileName, String[] expected) throws IOException {
        int i;
        String logLine;
        boolean allFound = true;
        boolean[] found = new boolean[expected.length];
        FileInputStream is = PrivilegedFileOpsForTests.getFileInputStream(new File(logFileName));
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        while ((logLine = br.readLine()) != null) {
            for (i = 0; i < expected.length; ++i) {
                if (found[i] || !logLine.contains(expected[i])) continue;
                found[i] = true;
            }
        }
        for (i = 0; i < expected.length; ++i) {
            if (found[i]) continue;
            allFound = false;
        }
        br.close();
        return allFound;
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite("DerbyNetAutoStartTest");
        suite.addTest(DerbyNetAutoStartTest.baseSuite("DerbyNetAutoStartTest:embedded"));
        return suite;
    }

    private static Test baseSuite(String name) {
        BaseTestSuite suite = new BaseTestSuite(name);
        if (!Derby.hasServer()) {
            return suite;
        }
        suite.addTestSuite(DerbyNetAutoStartTest.class);
        if (DerbyNetAutoStartTest.getSystemProperty("derby.tests.basePort") != null) {
            return suite;
        }
        suite.addTest((Test)new DerbyNetAutoStartTest("ttestStartNetworkServerTrueNoPort"));
        return suite;
    }

    @Override
    protected void tearDown() throws Exception {
        DerbyNetAutoStartTest.removeSystemProperty("derby.drda.startNetworkServer");
        DerbyNetAutoStartTest.removeSystemProperty("derby.drda.portNumber");
        LocaleTestSetup.setDefaultLocale(this.oldLocale);
        this.oldLocale = null;
        super.tearDown();
    }
}

