/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.tools;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Locale;
import junit.framework.Test;
import org.apache.derby.shared.common.info.JVMInfo;
import org.apache.derby.tools.sysinfo;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.Derby;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.LocaleTestSetup;

public class SysinfoCPCheckTest
extends BaseJDBCTestCase {
    private static boolean isClient = true;
    private static boolean isServer = true;

    public SysinfoCPCheckTest(String string) {
        super(string);
    }

    public static Test suite() {
        if (!Derby.hasTools()) {
            return new BaseTestSuite("empty: no tools support");
        }
        if (!Derby.hasServer()) {
            isServer = false;
        }
        if (!Derby.hasClient()) {
            isClient = false;
        }
        BaseTestSuite baseTestSuite = new BaseTestSuite(SysinfoCPCheckTest.class, "Sysinfo ClassPath Checker");
        return new LocaleTestSetup((Test)baseTestSuite, Locale.ENGLISH);
    }

    public void testClassPathChecker() throws IOException {
        String string = "Success: All Derby related classes found in class path.";
        String string2 = "org.apache.derbyTesting.functionTests.tests.tools.SysinfoCPCheckTest.class";
        String[][] stringArrayArray = new String[][]{{null, "0", "Testing for presence of all Derby-related libraries; typically, only some are needed.", null}, {"a", "0", "Usage: java org.apache.derby.tools.sysinfo -cp [ [ embedded ][ server ][ client] [ tools ] [ anyClass.class ] ]", null}, {"embedded", "6", string, "derby.jar"}, {"server", "10", string, "derbynet.jar"}, {"tools", "6", string, "derbytools.jar"}, {"client", "6", string, "derbyclient.jar"}, {string2, "6", string, "SysinfoCPCheckTest"}, {"nonexist.class", "6", "    (nonexist not found.)", null}};
        PrintStream printStream = System.out;
        int n = 0;
        for (n = 0; n < stringArrayArray.length; ++n) {
            ByteArrayOutputStream byteArrayOutputStream = this.getOutputStream();
            PrintStream printStream2 = new PrintStream(byteArrayOutputStream, false);
            SysinfoCPCheckTest.setSystemOut(printStream2);
            if (!this.checkClientOrServer(stringArrayArray[n][0])) continue;
            if (stringArrayArray[n][0] == null) {
                sysinfo.main((String[])new String[]{"-cp"});
            } else {
                sysinfo.main((String[])new String[]{"-cp", stringArrayArray[n][0]});
            }
            SysinfoCPCheckTest.setSystemOut(printStream);
            byteArrayOutputStream.flush();
            byteArrayOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            String string3 = null;
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(byArray)));
                if (stringArrayArray[n][0] == null) {
                    string3 = bufferedReader.readLine();
                    SysinfoCPCheckTest.assertEquals((String)stringArrayArray[n][2], (String)string3);
                    while (string3 != null) {
                        string3 = bufferedReader.readLine();
                    }
                    continue;
                }
                if (!this.checkClientOrServer(stringArrayArray[n][0])) continue;
                int n2 = Integer.parseInt(stringArrayArray[n][1]);
                boolean bl = false;
                for (int i = 0; i < n2; ++i) {
                    string3 = bufferedReader.readLine();
                    if (stringArrayArray[n][3] == null || string3.indexOf(stringArrayArray[n][3]) <= 0) continue;
                    bl = true;
                }
                if (stringArrayArray[n][3] != null && !bl) {
                    SysinfoCPCheckTest.fail((String)("did not find the string searched for: " + stringArrayArray[n][3] + " for command -cp: " + stringArrayArray[n][0]));
                }
                if ((string3 = bufferedReader.readLine()) == null) {
                    SysinfoCPCheckTest.fail((String)"encountered unexpected null strings");
                } else {
                    SysinfoCPCheckTest.assertEquals((String)stringArrayArray[n][2], (String)string3);
                }
                string3 = bufferedReader.readLine();
                bufferedReader.close();
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public boolean checkClientOrServer(String string) {
        if (string == null) {
            return true;
        }
        if ((string.equals("server") || string.equals("client")) && JDBC.vmSupportsJSR169()) {
            return false;
        }
        if (string.equals("server")) {
            return isServer;
        }
        if (string.equals("client")) {
            return isClient;
        }
        return true;
    }

    ByteArrayOutputStream getOutputStream() {
        return new ByteArrayOutputStream(20480);
    }

    public void testjavaVersion() {
        SysinfoCPCheckTest.assertEquals((int)9, (int)JVMInfo.JDK_ID);
    }

    public void testderbyVMLevel() {
        switch (JVMInfo.JDK_ID) {
            case 9: {
                SysinfoCPCheckTest.assertEquals((String)"Java SE 8 - JDBC 4.2", (String)JVMInfo.derbyVMLevel());
                break;
            }
            default: {
                SysinfoCPCheckTest.assertEquals((String)"?-?", (String)JVMInfo.derbyVMLevel());
            }
        }
    }

    public void testisSunJVM() {
        if (JVMInfo.isSunJVM()) {
            SysinfoCPCheckTest.assertEquals((boolean)true, (boolean)JVMInfo.isSunJVM());
        } else {
            SysinfoCPCheckTest.assertEquals((boolean)false, (boolean)JVMInfo.isSunJVM());
        }
    }

    public void testisIBMJVM() {
        if (JVMInfo.isIBMJVM()) {
            SysinfoCPCheckTest.assertEquals((boolean)true, (boolean)JVMInfo.isIBMJVM());
        } else {
            SysinfoCPCheckTest.assertEquals((boolean)false, (boolean)JVMInfo.isIBMJVM());
        }
    }

    public void testhasJNDI() {
        if (JVMInfo.hasJNDI()) {
            SysinfoCPCheckTest.assertEquals((boolean)true, (boolean)JVMInfo.hasJNDI());
        } else {
            SysinfoCPCheckTest.assertEquals((boolean)false, (boolean)JVMInfo.hasJNDI());
        }
    }
}

