/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class CoalesceTest
extends BaseJDBCTestCase {
    private static String VALID_DATE_STRING = "'2000-01-01'";
    private static String VALID_TIME_STRING = "'15:30:20'";
    private static String VALID_TIMESTAMP_STRING = "'2000-01-01 15:30:20'";
    private static String NULL_VALUE = "NULL";
    private static String[] SQLTypes = new String[]{"SMALLINT", "INTEGER", "BIGINT", "DECIMAL(10,5)", "REAL", "DOUBLE", "CHAR(60)", "VARCHAR(60)", "LONG VARCHAR", "CHAR(60) FOR BIT DATA", "VARCHAR(60) FOR BIT DATA", "LONG VARCHAR FOR BIT DATA", "CLOB(1k)", "DATE", "TIME", "TIMESTAMP", "BLOB(1k)"};
    private static String[] ColumnNames = new String[]{"SMALLINTCOL", "INTEGERCOL", "BIGINTCOL", "DECIMALCOL", "REALCOL", "DOUBLECOL", "CHARCOL", "VARCHARCOL", "LONGVARCHARCOL", "CHARFORBITCOL", "VARCHARFORBITCOL", "LVARCHARFORBITCOL", "CLOBCOL", "DATECOL", "TIMECOL", "TIMESTAMPCOL", "BLOBCOL"};
    private static String[][] SQLData = new String[][]{{NULL_VALUE, "0", "1", "2"}, {NULL_VALUE, "11", "111", NULL_VALUE}, {NULL_VALUE, "22", "222", "3333"}, {NULL_VALUE, "3.3", "3.33", NULL_VALUE}, {NULL_VALUE, "4.4", "4.44", "4.444"}, {NULL_VALUE, "5.5", "5.55", NULL_VALUE}, {NULL_VALUE, "'1992-01-06'", "'1992-01-16'", NULL_VALUE}, {NULL_VALUE, "'1992-01-07'", "'1992-01-17'", VALID_TIME_STRING}, {NULL_VALUE, "'1992-01-08'", "'1992-01-18'", VALID_TIMESTAMP_STRING}, {NULL_VALUE, "X'10aa'", NULL_VALUE, "X'10aaaa'"}, {NULL_VALUE, "X'10bb'", NULL_VALUE, "X'10bbbb'"}, {NULL_VALUE, "X'10cc'", NULL_VALUE, "X'10cccc'"}, {NULL_VALUE, "'13'", "'14'", NULL_VALUE}, {NULL_VALUE, VALID_DATE_STRING, VALID_DATE_STRING, NULL_VALUE}, {NULL_VALUE, VALID_TIME_STRING, VALID_TIME_STRING, NULL_VALUE}, {NULL_VALUE, VALID_TIMESTAMP_STRING, VALID_TIMESTAMP_STRING, NULL_VALUE}, {NULL_VALUE, NULL_VALUE, NULL_VALUE, NULL_VALUE}};
    public static final String[][] resultDataTypeRulesTable = new String[][]{{"SMALLINT", "INTEGER", "BIGINT", "DECIMAL", "DOUBLE", "DOUBLE", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR"}, {"INTEGER", "INTEGER", "BIGINT", "DECIMAL", "DOUBLE", "DOUBLE", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR"}, {"BIGINT", "BIGINT", "BIGINT", "DECIMAL", "DOUBLE", "DOUBLE", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR"}, {"DECIMAL", "DECIMAL", "DECIMAL", "DECIMAL", "DOUBLE", "DOUBLE", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR"}, {"DOUBLE", "DOUBLE", "DOUBLE", "DOUBLE", "REAL", "DOUBLE", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR"}, {"DOUBLE", "DOUBLE", "DOUBLE", "DOUBLE", "DOUBLE", "DOUBLE", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR"}, {"ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "CHAR", "VARCHAR", "LONG VARCHAR", "ERROR", "ERROR", "ERROR", "CLOB", "DATE", "TIME", "TIMESTAMP", "ERROR"}, {"ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "VARCHAR", "VARCHAR", "LONG VARCHAR", "ERROR", "ERROR", "ERROR", "CLOB", "DATE", "TIME", "TIMESTAMP", "ERROR"}, {"ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "LONG VARCHAR", "LONG VARCHAR", "LONG VARCHAR", "ERROR", "ERROR", "ERROR", "CLOB", "ERROR", "ERROR", "ERROR", "ERROR"}, {"ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "CHAR () FOR BIT DATA", "VARCHAR () FOR BIT DATA", "LONG VARCHAR FOR BIT DATA", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR"}, {"ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "VARCHAR () FOR BIT DATA", "VARCHAR () FOR BIT DATA", "LONG VARCHAR FOR BIT DATA", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR"}, {"ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "LONG VARCHAR FOR BIT DATA", "LONG VARCHAR FOR BIT DATA", "LONG VARCHAR FOR BIT DATA", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR"}, {"ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "CLOB", "CLOB", "CLOB", "ERROR", "ERROR", "ERROR", "CLOB", "ERROR", "ERROR", "ERROR", "ERROR"}, {"ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "DATE", "DATE", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "DATE", "ERROR", "ERROR", "ERROR"}, {"ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "TIME", "TIME", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "TIME", "ERROR", "ERROR"}, {"ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "TIMESTAMP", "TIMESTAMP", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "TIMESTAMP", "ERROR"}, {"ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "ERROR", "BLOB"}};
    private static String[] TABLES = new String[]{"create table tA (c1 int, c2 char(254))", "create table coalesce (coalesce int, c12 int)", "create table value (value int, c12 int)", "create table tF (dateCol date, charCol char(10), varcharCol varchar(50))", "create table tG (timeCol time, charCol char(10), varcharCol varchar(50))", "create table tH (timestampCol timestamp, charCol char(19), varcharCol varchar(50))", "create table tE (smallintCol smallint, intCol integer, bigintCol bigint, decimalCol1 decimal(22,2), decimalCol2 decimal(8,6), decimalCol3 decimal(31,28), realCol real, doubleCol double)", "create table tD (c1 int, c2 char(254))", "create table tB (c1 char(254), c2 char(40), vc1 varchar(253), vc2 varchar(2000), lvc1 long varchar, lvc2 long varchar, clob1 CLOB(200), clob2 CLOB(33K))", "create table tC (cbd1 char(254) for bit data, cbd2 char(40) for bit data, vcbd1 varchar(253) for bit data, vcbd2 varchar(2000) for bit data, lvcbd1 long varchar for bit data, lvcbd2 long varchar for bit data, blob1 BLOB(200), blob2 BLOB(33K))", "create table tAggr (i int)"};

    public CoalesceTest(String string) {
        super(string);
    }

    public static Test suite() {
        Test test = TestConfiguration.embeddedSuite(CoalesceTest.class);
        return new CleanDatabaseTestSetup(test){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                int n;
                for (int i = 0; i < TABLES.length; ++i) {
                    statement.execute(TABLES[i]);
                }
                StringBuffer stringBuffer = new StringBuffer("create table AllDataTypesTable (");
                for (n = 0; n < SQLTypes.length - 1; ++n) {
                    stringBuffer.append(ColumnNames[n] + " " + SQLTypes[n] + ",");
                }
                stringBuffer.append(ColumnNames[SQLTypes.length - 1] + " " + SQLTypes[SQLTypes.length - 1] + ")");
                statement.executeUpdate(stringBuffer.toString());
                for (n = 0; n < SQLData[0].length; ++n) {
                    stringBuffer = new StringBuffer("insert into AllDataTypesTable values(");
                    for (int i = 0; i < SQLTypes.length - 1; ++i) {
                        stringBuffer.append(SQLData[i][n] + ",");
                    }
                    stringBuffer.append(SQLData[SQLTypes.length - 1][n] + ")");
                    statement.executeUpdate(stringBuffer.toString());
                }
            }
        };
    }

    public void testCoalesceSyntax() throws Throwable {
        Statement statement = this.createStatement();
        statement.executeUpdate("insert into tA (c1) values(1)");
        CoalesceTest.assertStatementError("42X04", statement, "select coalesce from tA");
        CoalesceTest.assertStatementError("42X04", statement, "select value from tA");
        CoalesceTest.assertStatementError("42X01", statement, "select coalesce() from tA");
        CoalesceTest.assertStatementError("42X01", statement, "select value() from tA");
        CoalesceTest.assertStatementError("42605", statement, "select coalesce(c1) from tA");
        CoalesceTest.assertStatementError("42605", statement, "select value(c1) from tA");
        CoalesceTest.assertStatementError("42X04", statement, "select coalesce(c111) from tA");
        CoalesceTest.assertStatementError("42X04", statement, "select value(c111) from tA");
        statement.executeUpdate("insert into coalesce(coalesce) values(null)");
        statement.executeUpdate("insert into coalesce values(null,1)");
        this.dumpRS(statement.executeQuery("select coalesce(coalesce,c12) from coalesce"), "COL1(datatype : INTEGER, precision : 10, scale : 0) null 1 ");
        statement.executeUpdate("insert into value(value) values(null)");
        statement.executeUpdate("insert into value values(null,1)");
        this.dumpRS(statement.executeQuery("select coalesce(value,c12) from value"), "COL1(datatype : INTEGER, precision : 10, scale : 0) null 1 ");
        this.assertCompileError("42610", "select coalesce(?,?) from tA");
        this.assertCompileError("42610", "select value(?,?) from tA");
    }

    public void testCompatibleDatatypesCombinations() throws Throwable {
        String[] stringArray = new String[]{"COL1(datatype : SMALLINT, precision : 5, scale : 0) null 0 1 2 ", "COL1(datatype : INTEGER, precision : 10, scale : 0) null 0 1 2 ", "COL1(datatype : BIGINT, precision : 19, scale : 0) null 0 1 2 ", "COL1(datatype : DECIMAL, precision : 24, scale : 5) null 0.00000 1.00000 2.00000 ", "COL1(datatype : DOUBLE, precision : 15, scale : 0) null 0.0 1.0 2.0 ", "COL1(datatype : DOUBLE, precision : 15, scale : 0) null 0.0 1.0 2.0 ", "COL1(datatype : INTEGER, precision : 10, scale : 0) null 11 111 2 ", "COL1(datatype : INTEGER, precision : 10, scale : 0) null 11 111 2 ", "COL1(datatype : BIGINT, precision : 19, scale : 0) null 11 111 2 ", "COL1(datatype : DECIMAL, precision : 24, scale : 5) null 11.00000 111.00000 2.00000 ", "COL1(datatype : DOUBLE, precision : 15, scale : 0) null 11.0 111.0 2.0 ", "COL1(datatype : DOUBLE, precision : 15, scale : 0) null 11.0 111.0 2.0 ", "COL1(datatype : BIGINT, precision : 19, scale : 0) null 22 222 3333 ", "COL1(datatype : BIGINT, precision : 19, scale : 0) null 22 222 3333 ", "COL1(datatype : BIGINT, precision : 19, scale : 0) null 22 222 3333 ", "COL1(datatype : DECIMAL, precision : 24, scale : 5) null 22.00000 222.00000 3333.00000 ", "COL1(datatype : DOUBLE, precision : 15, scale : 0) null 22.0 222.0 3333.0 ", "COL1(datatype : DOUBLE, precision : 15, scale : 0) null 22.0 222.0 3333.0 ", "COL1(datatype : DECIMAL, precision : 10, scale : 5) null 3.30000 3.33000 2.00000 ", "COL1(datatype : DECIMAL, precision : 15, scale : 5) null 3.30000 3.33000 2.00000 ", "COL1(datatype : DECIMAL, precision : 24, scale : 5) null 3.30000 3.33000 2.00000 ", "COL1(datatype : DECIMAL, precision : 24, scale : 5) null 3.30000 3.33000 2.00000 ", "COL1(datatype : DOUBLE, precision : 15, scale : 0) null 3.3 3.33 2.0 ", "COL1(datatype : DOUBLE, precision : 15, scale : 0) null 3.3 3.33 2.0 ", "COL1(datatype : DOUBLE, precision : 15, scale : 0) null 4.400000095367432 4.440000057220459 4.443999767303467 ", "COL1(datatype : DOUBLE, precision : 15, scale : 0) null 4.400000095367432 4.440000057220459 4.443999767303467 ", "COL1(datatype : DOUBLE, precision : 15, scale : 0) null 4.400000095367432 4.440000057220459 4.443999767303467 ", "COL1(datatype : DOUBLE, precision : 15, scale : 0) null 4.400000095367432 4.440000057220459 4.443999767303467 ", "COL1(datatype : DOUBLE, precision : 15, scale : 0) null 4.400000095367432 4.440000057220459 4.443999767303467 ", "COL1(datatype : DOUBLE, precision : 15, scale : 0) null 4.400000095367432 4.440000057220459 4.443999767303467 ", "COL1(datatype : DOUBLE, precision : 15, scale : 0) null 5.5 5.55 2.0 ", "COL1(datatype : DOUBLE, precision : 15, scale : 0) null 5.5 5.55 2.0 ", "COL1(datatype : DOUBLE, precision : 15, scale : 0) null 5.5 5.55 2.0 ", "COL1(datatype : DOUBLE, precision : 15, scale : 0) null 5.5 5.55 2.0 ", "COL1(datatype : DOUBLE, precision : 15, scale : 0) null 5.5 5.55 2.0 ", "COL1(datatype : DOUBLE, precision : 15, scale : 0) null 5.5 5.55 2.0 ", "COL1(datatype : CHAR, precision : 60, scale : 0) null 1992-01-06                                                   1992-01-16                                                   null ", "COL1(datatype : VARCHAR, precision : 60, scale : 0) null 1992-01-06                                                   1992-01-16                                                   15:30:20 ", "COL1(datatype : LONG VARCHAR, precision : 32700, scale : 0) null 1992-01-06                                                   1992-01-16                                                   15:30:20 ", "COL1(datatype : CLOB, precision : 32700, scale : 0) null 1992-01-06                                                   1992-01-16                                                   15:30:20 ", "", "", "", "COL1(datatype : VARCHAR, precision : 60, scale : 0) null 1992-01-07 1992-01-17 15:30:20 ", "COL1(datatype : VARCHAR, precision : 60, scale : 0) null 1992-01-07 1992-01-17 15:30:20 ", "COL1(datatype : LONG VARCHAR, precision : 32700, scale : 0) null 1992-01-07 1992-01-17 15:30:20 ", "COL1(datatype : CLOB, precision : 32700, scale : 0) null 1992-01-07 1992-01-17 15:30:20 ", "", "", "", "COL1(datatype : LONG VARCHAR, precision : 32700, scale : 0) null 1992-01-08 1992-01-18 2000-01-01 15:30:20 ", "COL1(datatype : LONG VARCHAR, precision : 32700, scale : 0) null 1992-01-08 1992-01-18 2000-01-01 15:30:20 ", "COL1(datatype : LONG VARCHAR, precision : 32700, scale : 0) null 1992-01-08 1992-01-18 2000-01-01 15:30:20 ", "COL1(datatype : CLOB, precision : 32700, scale : 0) null 1992-01-08 1992-01-18 2000-01-01 15:30:20 ", "COL1(datatype : CHAR () FOR BIT DATA, precision : 60, scale : 0) null 10aa20202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020 null 10aaaa202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020 ", "COL1(datatype : VARCHAR () FOR BIT DATA, precision : 60, scale : 0) null 10aa20202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020 null 10aaaa202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020 ", "COL1(datatype : LONG VARCHAR FOR BIT DATA, precision : 32700, scale : 0) null 10aa20202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020 null 10aaaa202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020 ", "COL1(datatype : VARCHAR () FOR BIT DATA, precision : 60, scale : 0) null 10bb null 10bbbb ", "COL1(datatype : VARCHAR () FOR BIT DATA, precision : 60, scale : 0) null 10bb null 10bbbb ", "COL1(datatype : LONG VARCHAR FOR BIT DATA, precision : 32700, scale : 0) null 10bb null 10bbbb ", "COL1(datatype : LONG VARCHAR FOR BIT DATA, precision : 32700, scale : 0) null 10cc null 10cccc ", "COL1(datatype : LONG VARCHAR FOR BIT DATA, precision : 32700, scale : 0) null 10cc null 10cccc ", "COL1(datatype : LONG VARCHAR FOR BIT DATA, precision : 32700, scale : 0) null 10cc null 10cccc ", "COL1(datatype : CLOB, precision : 1024, scale : 0) null 13 14 null ", "COL1(datatype : CLOB, precision : 1024, scale : 0) null 13 14 15:30:20 ", "COL1(datatype : CLOB, precision : 32700, scale : 0) null 13 14 15:30:20 ", "COL1(datatype : CLOB, precision : 32700, scale : 0) null 13 14 15:30:20 ", "COL1(datatype : DATE, precision : 10, scale : 0) null 2000-01-01 2000-01-01 null ", "", "", "COL1(datatype : TIME, precision : 8, scale : 0) null 15:30:20 15:30:20 null ", "COL1(datatype : TIME, precision : 8, scale : 0) null 15:30:20 15:30:20 15:30:20 ", "COL1(datatype : TIME, precision : 8, scale : 0) null 15:30:20 15:30:20 15:30:20 ", "COL1(datatype : TIMESTAMP, precision : 29, scale : 9) null 2000-01-01 15:30:20.0 2000-01-01 15:30:20.0 null ", "", "", "COL1(datatype : BLOB, precision : 1024, scale : 0) null null null null "};
        Statement statement = this.createStatement();
        int n = 0;
        for (int i = 0; i < SQLTypes.length; ++i) {
            StringBuffer stringBuffer = new StringBuffer("SELECT COALESCE(" + ColumnNames[i]);
            for (int j = 0; j < SQLTypes.length; ++j) {
                boolean bl = stringArray[n].equals("");
                try {
                    if (resultDataTypeRulesTable[i][j].equals("ERROR")) continue;
                    stringBuffer.append("," + ColumnNames[j]);
                    this.dumpRS(statement.executeQuery(stringBuffer + ") from AllDataTypesTable"), stringArray[n]);
                    CoalesceTest.assertFalse((String)"Statement should have failed", (boolean)bl);
                }
                catch (SQLException sQLException) {
                    if (!bl) {
                        CoalesceTest.fail("Expected to succeed", sQLException);
                    }
                    if (CoalesceTest.isClobWithCharAndDateTypeArguments(stringBuffer.toString()) && sQLException.getSQLState().equals("42815")) {
                        CoalesceTest.assertSQLState("42815", sQLException);
                    }
                    if (!CoalesceTest.isSupportedCoalesce(i, j) && sQLException.getSQLState().equals("42815")) {
                        CoalesceTest.assertSQLState("42815", sQLException);
                    }
                    CoalesceTest.assertSQLState("22007", sQLException);
                }
                ++n;
            }
        }
    }

    public void testAllDatatypesCombinations() throws Throwable {
        String[] stringArray = new String[]{"COL1(datatype : SMALLINT, precision : 5, scale : 0) null 0 1 2 ", "COL1(datatype : SMALLINT, precision : 5, scale : 0) null 0 1 2 ", "COL1(datatype : INTEGER, precision : 10, scale : 0) null 0 1 2 ", "COL1(datatype : INTEGER, precision : 10, scale : 0) null 0 1 2 ", "COL1(datatype : BIGINT, precision : 19, scale : 0) null 0 1 2 ", "COL1(datatype : BIGINT, precision : 19, scale : 0) null 0 1 2 ", "COL1(datatype : DECIMAL, precision : 10, scale : 5) null 0.00000 1.00000 2.00000 ", "COL1(datatype : DECIMAL, precision : 10, scale : 5) null 0.00000 1.00000 2.00000 ", "COL1(datatype : DOUBLE, precision : 15, scale : 0) null 0.0 1.0 2.0 ", "COL1(datatype : DOUBLE, precision : 15, scale : 0) null 0.0 1.0 2.0 ", "COL1(datatype : DOUBLE, precision : 15, scale : 0) null 0.0 1.0 2.0 ", "COL1(datatype : DOUBLE, precision : 15, scale : 0) null 0.0 1.0 2.0 ", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "COL1(datatype : INTEGER, precision : 10, scale : 0) null 11 111 2 ", "COL1(datatype : INTEGER, precision : 10, scale : 0) null 11 111 2 ", "COL1(datatype : INTEGER, precision : 10, scale : 0) null 11 111 null ", "COL1(datatype : INTEGER, precision : 10, scale : 0) null 11 111 null ", "COL1(datatype : BIGINT, precision : 19, scale : 0) null 11 111 3333 ", "COL1(datatype : BIGINT, precision : 19, scale : 0) null 11 111 3333 ", "COL1(datatype : DECIMAL, precision : 15, scale : 5) null 11.00000 111.00000 null ", "COL1(datatype : DECIMAL, precision : 15, scale : 5) null 11.00000 111.00000 null ", "COL1(datatype : DOUBLE, precision : 15, scale : 0) null 11.0 111.0 4.443999767303467 ", "COL1(datatype : DOUBLE, precision : 15, scale : 0) null 11.0 111.0 4.443999767303467 ", "COL1(datatype : DOUBLE, precision : 15, scale : 0) null 11.0 111.0 null ", "COL1(datatype : DOUBLE, precision : 15, scale : 0) null 11.0 111.0 null ", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "COL1(datatype : BIGINT, precision : 19, scale : 0) null 22 222 3333 ", "COL1(datatype : BIGINT, precision : 19, scale : 0) null 22 222 3333 ", "COL1(datatype : BIGINT, precision : 19, scale : 0) null 22 222 3333 ", "COL1(datatype : BIGINT, precision : 19, scale : 0) null 22 222 3333 ", "COL1(datatype : BIGINT, precision : 19, scale : 0) null 22 222 3333 ", "COL1(datatype : BIGINT, precision : 19, scale : 0) null 22 222 3333 ", "COL1(datatype : DECIMAL, precision : 24, scale : 5) null 22.00000 222.00000 3333.00000 ", "COL1(datatype : DECIMAL, precision : 24, scale : 5) null 22.00000 222.00000 3333.00000 ", "COL1(datatype : DOUBLE, precision : 15, scale : 0) null 22.0 222.0 3333.0 ", "COL1(datatype : DOUBLE, precision : 15, scale : 0) null 22.0 222.0 3333.0 ", "COL1(datatype : DOUBLE, precision : 15, scale : 0) null 22.0 222.0 3333.0 ", "COL1(datatype : DOUBLE, precision : 15, scale : 0) null 22.0 222.0 3333.0 ", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "COL1(datatype : DECIMAL, precision : 10, scale : 5) null 3.30000 3.33000 2.00000 ", "COL1(datatype : DECIMAL, precision : 10, scale : 5) null 3.30000 3.33000 2.00000 ", "COL1(datatype : DECIMAL, precision : 15, scale : 5) null 3.30000 3.33000 null ", "COL1(datatype : DECIMAL, precision : 15, scale : 5) null 3.30000 3.33000 null ", "COL1(datatype : DECIMAL, precision : 24, scale : 5) null 3.30000 3.33000 3333.00000 ", "COL1(datatype : DECIMAL, precision : 24, scale : 5) null 3.30000 3.33000 3333.00000 ", "COL1(datatype : DECIMAL, precision : 10, scale : 5) null 3.30000 3.33000 null ", "COL1(datatype : DECIMAL, precision : 10, scale : 5) null 3.30000 3.33000 null ", "COL1(datatype : DOUBLE, precision : 15, scale : 0) null 3.3 3.33 4.443999767303467 ", "COL1(datatype : DOUBLE, precision : 15, scale : 0) null 3.3 3.33 4.443999767303467 ", "COL1(datatype : DOUBLE, precision : 15, scale : 0) null 3.3 3.33 null ", "COL1(datatype : DOUBLE, precision : 15, scale : 0) null 3.3 3.33 null ", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "COL1(datatype : DOUBLE, precision : 15, scale : 0) null 4.400000095367432 4.440000057220459 4.443999767303467 ", "COL1(datatype : DOUBLE, precision : 15, scale : 0) null 4.400000095367432 4.440000057220459 4.443999767303467 ", "COL1(datatype : DOUBLE, precision : 15, scale : 0) null 4.400000095367432 4.440000057220459 4.443999767303467 ", "COL1(datatype : DOUBLE, precision : 15, scale : 0) null 4.400000095367432 4.440000057220459 4.443999767303467 ", "COL1(datatype : DOUBLE, precision : 15, scale : 0) null 4.400000095367432 4.440000057220459 4.443999767303467 ", "COL1(datatype : DOUBLE, precision : 15, scale : 0) null 4.400000095367432 4.440000057220459 4.443999767303467 ", "COL1(datatype : DOUBLE, precision : 15, scale : 0) null 4.400000095367432 4.440000057220459 4.443999767303467 ", "COL1(datatype : DOUBLE, precision : 15, scale : 0) null 4.400000095367432 4.440000057220459 4.443999767303467 ", "COL1(datatype : REAL, precision : 7, scale : 0) null 4.4 4.44 4.444 ", "COL1(datatype : REAL, precision : 7, scale : 0) null 4.4 4.44 4.444 ", "COL1(datatype : DOUBLE, precision : 15, scale : 0) null 4.400000095367432 4.440000057220459 4.443999767303467 ", "COL1(datatype : DOUBLE, precision : 15, scale : 0) null 4.400000095367432 4.440000057220459 4.443999767303467 ", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "COL1(datatype : DOUBLE, precision : 15, scale : 0) null 5.5 5.55 2.0 ", "COL1(datatype : DOUBLE, precision : 15, scale : 0) null 5.5 5.55 2.0 ", "COL1(datatype : DOUBLE, precision : 15, scale : 0) null 5.5 5.55 null ", "COL1(datatype : DOUBLE, precision : 15, scale : 0) null 5.5 5.55 null ", "COL1(datatype : DOUBLE, precision : 15, scale : 0) null 5.5 5.55 3333.0 ", "COL1(datatype : DOUBLE, precision : 15, scale : 0) null 5.5 5.55 3333.0 ", "COL1(datatype : DOUBLE, precision : 15, scale : 0) null 5.5 5.55 null ", "COL1(datatype : DOUBLE, precision : 15, scale : 0) null 5.5 5.55 null ", "COL1(datatype : DOUBLE, precision : 15, scale : 0) null 5.5 5.55 4.443999767303467 ", "COL1(datatype : DOUBLE, precision : 15, scale : 0) null 5.5 5.55 4.443999767303467 ", "COL1(datatype : DOUBLE, precision : 15, scale : 0) null 5.5 5.55 null ", "COL1(datatype : DOUBLE, precision : 15, scale : 0) null 5.5 5.55 null ", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "COL1(datatype : CHAR, precision : 60, scale : 0) null 1992-01-06                                                   1992-01-16                                                   null ", "COL1(datatype : CHAR, precision : 60, scale : 0) null 1992-01-06                                                   1992-01-16                                                   null ", "COL1(datatype : VARCHAR, precision : 60, scale : 0) null 1992-01-06                                                   1992-01-16                                                   15:30:20 ", "COL1(datatype : VARCHAR, precision : 60, scale : 0) null 1992-01-06                                                   1992-01-16                                                   15:30:20 ", "COL1(datatype : LONG VARCHAR, precision : 32700, scale : 0) null 1992-01-06                                                   1992-01-16                                                   2000-01-01 15:30:20 ", "COL1(datatype : LONG VARCHAR, precision : 32700, scale : 0) null 1992-01-06                                                   1992-01-16                                                   2000-01-01 15:30:20 ", "", "", "", "", "", "", "COL1(datatype : CLOB, precision : 1024, scale : 0) null 1992-01-06                                                   1992-01-16                                                   null ", "COL1(datatype : CLOB, precision : 1024, scale : 0) null 1992-01-06                                                   1992-01-16                                                   null ", "COL1(datatype : DATE, precision : 10, scale : 0) null 1992-01-06 1992-01-16 null ", "COL1(datatype : DATE, precision : 10, scale : 0) null 1992-01-06 1992-01-16 null ", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "COL1(datatype : VARCHAR, precision : 60, scale : 0) null 1992-01-07 1992-01-17 15:30:20 ", "COL1(datatype : VARCHAR, precision : 60, scale : 0) null 1992-01-07 1992-01-17 15:30:20 ", "COL1(datatype : VARCHAR, precision : 60, scale : 0) null 1992-01-07 1992-01-17 15:30:20 ", "COL1(datatype : VARCHAR, precision : 60, scale : 0) null 1992-01-07 1992-01-17 15:30:20 ", "COL1(datatype : LONG VARCHAR, precision : 32700, scale : 0) null 1992-01-07 1992-01-17 15:30:20 ", "COL1(datatype : LONG VARCHAR, precision : 32700, scale : 0) null 1992-01-07 1992-01-17 15:30:20 ", "", "", "", "", "", "", "COL1(datatype : CLOB, precision : 1024, scale : 0) null 1992-01-07 1992-01-17 15:30:20 ", "COL1(datatype : CLOB, precision : 1024, scale : 0) null 1992-01-07 1992-01-17 15:30:20 ", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "COL1(datatype : LONG VARCHAR, precision : 32700, scale : 0) null 1992-01-08 1992-01-18 2000-01-01 15:30:20 ", "COL1(datatype : LONG VARCHAR, precision : 32700, scale : 0) null 1992-01-08 1992-01-18 2000-01-01 15:30:20 ", "COL1(datatype : LONG VARCHAR, precision : 32700, scale : 0) null 1992-01-08 1992-01-18 2000-01-01 15:30:20 ", "COL1(datatype : LONG VARCHAR, precision : 32700, scale : 0) null 1992-01-08 1992-01-18 2000-01-01 15:30:20 ", "COL1(datatype : LONG VARCHAR, precision : 32700, scale : 0) null 1992-01-08 1992-01-18 2000-01-01 15:30:20 ", "COL1(datatype : LONG VARCHAR, precision : 32700, scale : 0) null 1992-01-08 1992-01-18 2000-01-01 15:30:20 ", "", "", "", "", "", "", "COL1(datatype : CLOB, precision : 32700, scale : 0) null 1992-01-08 1992-01-18 2000-01-01 15:30:20 ", "COL1(datatype : CLOB, precision : 32700, scale : 0) null 1992-01-08 1992-01-18 2000-01-01 15:30:20 ", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "COL1(datatype : CHAR () FOR BIT DATA, precision : 60, scale : 0) null 10aa20202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020 null 10aaaa202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020 ", "COL1(datatype : CHAR () FOR BIT DATA, precision : 60, scale : 0) null 10aa20202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020 null 10aaaa202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020 ", "COL1(datatype : VARCHAR () FOR BIT DATA, precision : 60, scale : 0) null 10aa20202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020 null 10aaaa202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020 ", "COL1(datatype : VARCHAR () FOR BIT DATA, precision : 60, scale : 0) null 10aa20202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020 null 10aaaa202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020 ", "COL1(datatype : LONG VARCHAR FOR BIT DATA, precision : 32700, scale : 0) null 10aa20202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020 null 10aaaa202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020 ", "COL1(datatype : LONG VARCHAR FOR BIT DATA, precision : 32700, scale : 0) null 10aa20202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020 null 10aaaa202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020 ", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "COL1(datatype : VARCHAR () FOR BIT DATA, precision : 60, scale : 0) null 10bb null 10bbbb ", "COL1(datatype : VARCHAR () FOR BIT DATA, precision : 60, scale : 0) null 10bb null 10bbbb ", "COL1(datatype : VARCHAR () FOR BIT DATA, precision : 60, scale : 0) null 10bb null 10bbbb ", "COL1(datatype : VARCHAR () FOR BIT DATA, precision : 60, scale : 0) null 10bb null 10bbbb ", "COL1(datatype : LONG VARCHAR FOR BIT DATA, precision : 32700, scale : 0) null 10bb null 10bbbb ", "COL1(datatype : LONG VARCHAR FOR BIT DATA, precision : 32700, scale : 0) null 10bb null 10bbbb ", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "COL1(datatype : LONG VARCHAR FOR BIT DATA, precision : 32700, scale : 0) null 10cc null 10cccc ", "COL1(datatype : LONG VARCHAR FOR BIT DATA, precision : 32700, scale : 0) null 10cc null 10cccc ", "COL1(datatype : LONG VARCHAR FOR BIT DATA, precision : 32700, scale : 0) null 10cc null 10cccc ", "COL1(datatype : LONG VARCHAR FOR BIT DATA, precision : 32700, scale : 0) null 10cc null 10cccc ", "COL1(datatype : LONG VARCHAR FOR BIT DATA, precision : 32700, scale : 0) null 10cc null 10cccc ", "COL1(datatype : LONG VARCHAR FOR BIT DATA, precision : 32700, scale : 0) null 10cc null 10cccc ", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "COL1(datatype : CLOB, precision : 1024, scale : 0) null 13 14 null ", "COL1(datatype : CLOB, precision : 1024, scale : 0) null 13 14 null ", "COL1(datatype : CLOB, precision : 1024, scale : 0) null 13 14 15:30:20 ", "COL1(datatype : CLOB, precision : 1024, scale : 0) null 13 14 15:30:20 ", "COL1(datatype : CLOB, precision : 32700, scale : 0) null 13 14 2000-01-01 15:30:20 ", "COL1(datatype : CLOB, precision : 32700, scale : 0) null 13 14 2000-01-01 15:30:20 ", "", "", "", "", "", "", "COL1(datatype : CLOB, precision : 1024, scale : 0) null 13 14 null ", "COL1(datatype : CLOB, precision : 1024, scale : 0) null 13 14 null ", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "COL1(datatype : DATE, precision : 10, scale : 0) null 2000-01-01 2000-01-01 null ", "COL1(datatype : DATE, precision : 10, scale : 0) null 2000-01-01 2000-01-01 null ", "", "", "", "", "", "", "", "", "", "", "", "", "COL1(datatype : DATE, precision : 10, scale : 0) null 2000-01-01 2000-01-01 null ", "COL1(datatype : DATE, precision : 10, scale : 0) null 2000-01-01 2000-01-01 null ", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "COL1(datatype : TIME, precision : 8, scale : 0) null 15:30:20 15:30:20 null ", "COL1(datatype : TIME, precision : 8, scale : 0) null 15:30:20 15:30:20 null ", "COL1(datatype : TIME, precision : 8, scale : 0) null 15:30:20 15:30:20 15:30:20 ", "COL1(datatype : TIME, precision : 8, scale : 0) null 15:30:20 15:30:20 15:30:20 ", "", "", "", "", "", "", "", "", "", "", "", "", "COL1(datatype : TIME, precision : 8, scale : 0) null 15:30:20 15:30:20 null ", "COL1(datatype : TIME, precision : 8, scale : 0) null 15:30:20 15:30:20 null ", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "COL1(datatype : TIMESTAMP, precision : 29, scale : 9) null 2000-01-01 15:30:20.0 2000-01-01 15:30:20.0 null ", "COL1(datatype : TIMESTAMP, precision : 29, scale : 9) null 2000-01-01 15:30:20.0 2000-01-01 15:30:20.0 null ", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "COL1(datatype : TIMESTAMP, precision : 29, scale : 9) null 2000-01-01 15:30:20.0 2000-01-01 15:30:20.0 null ", "COL1(datatype : TIMESTAMP, precision : 29, scale : 9) null 2000-01-01 15:30:20.0 2000-01-01 15:30:20.0 null ", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "COL1(datatype : BLOB, precision : 1024, scale : 0) null null null null ", "COL1(datatype : BLOB, precision : 1024, scale : 0) null null null null "};
        Statement statement = this.createStatement();
        int n = 0;
        for (int i = 0; i < SQLTypes.length; ++i) {
            for (int j = 0; j < SQLTypes.length; ++j) {
                String string;
                boolean bl = stringArray[n].equals("");
                try {
                    string = "SELECT COALESCE(" + ColumnNames[i] + "," + ColumnNames[j] + ") from AllDataTypesTable";
                    this.dumpRS(statement.executeQuery(string), stringArray[n]);
                    CoalesceTest.assertFalse((String)"Statement should have failed", (boolean)bl);
                }
                catch (SQLException sQLException) {
                    if (!bl) {
                        CoalesceTest.fail("Expected to succeed", sQLException);
                    }
                    if (!CoalesceTest.isSupportedCoalesce(i, j) && sQLException.getSQLState().equals("42815")) {
                        CoalesceTest.assertSQLState("42815", sQLException);
                    }
                    CoalesceTest.assertSQLState("22007", sQLException);
                }
                ++n;
                try {
                    string = "SELECT VALUE(" + ColumnNames[i] + "," + ColumnNames[j] + ") from AllDataTypesTable";
                    this.dumpRS(statement.executeQuery(string), stringArray[n]);
                    CoalesceTest.assertFalse((String)"Statement should have failed", (boolean)bl);
                }
                catch (SQLException sQLException) {
                    if (!bl) {
                        CoalesceTest.fail("Expected to succeed", sQLException);
                    }
                    if (!CoalesceTest.isSupportedCoalesce(i, j) && sQLException.getSQLState().equals("42815")) {
                        CoalesceTest.assertSQLState("42815", sQLException);
                    }
                    CoalesceTest.assertSQLState("22007", sQLException);
                }
                ++n;
            }
        }
    }

    public void testDateCoalesce() throws Throwable {
        Statement statement = this.createStatement();
        statement.executeUpdate("insert into tF values(null, null, null)");
        statement.executeUpdate("insert into tF values(date('1992-01-02'), '1992-01-03', '1992-01-04')");
        String string = "COL1(datatype : DATE, precision : 10, scale : 0) null 1992-01-02 ";
        String string2 = "COL1(datatype : DATE, precision : 10, scale : 0) null 1992-01-03 ";
        String string3 = "COL1(datatype : DATE, precision : 10, scale : 0) null 1992-01-04 ";
        this.dumpRS(statement.executeQuery("select coalesce(dateCol,dateCol) from tF"), string);
        this.dumpRS(statement.executeQuery("select value(dateCol,dateCol) from tF"), string);
        this.dumpRS(statement.executeQuery("select coalesce(dateCol,charCol) from tF"), string);
        this.dumpRS(statement.executeQuery("select value(dateCol,charCol) from tF"), string);
        this.dumpRS(statement.executeQuery("select coalesce(charCol,dateCol) from tF"), string2);
        this.dumpRS(statement.executeQuery("select value(charCol,dateCol) from tF"), string2);
        this.dumpRS(statement.executeQuery("select coalesce(dateCol,varcharCol) from tF"), string);
        this.dumpRS(statement.executeQuery("select value(dateCol,varcharCol) from tF"), string);
        this.dumpRS(statement.executeQuery("select coalesce(varcharCol,dateCol) from tF"), string3);
        this.dumpRS(statement.executeQuery("select value(varcharCol,dateCol) from tF"), string3);
        statement.executeUpdate("insert into tF values(date('1992-01-01'), 'I am char', 'I am varchar')");
        CoalesceTest.assertStatementError("22007", statement, "select coalesce(charCol,dateCol) from tF");
        CoalesceTest.assertStatementError("22007", statement, "select value(charCol,dateCol) from tF");
        CoalesceTest.assertStatementError("22007", statement, "select coalesce(varcharCol,dateCol) from tF");
        CoalesceTest.assertStatementError("22007", statement, "select value(varcharCol,dateCol) from tF");
    }

    public void testTimeCoalesce() throws Throwable {
        Statement statement = this.createStatement();
        statement.executeUpdate("insert into tG values(null, null, null)");
        statement.executeUpdate("insert into tG values(time('12:30:30'), '12:30:31', '12:30:32')");
        String string = "COL1(datatype : TIME, precision : 8, scale : 0) null 12:30:30 ";
        String string2 = "COL1(datatype : TIME, precision : 8, scale : 0) null 12:30:31 ";
        String string3 = "COL1(datatype : TIME, precision : 8, scale : 0) null 12:30:32 ";
        this.dumpRS(statement.executeQuery("select coalesce(timeCol,timeCol) from tG"), string);
        this.dumpRS(statement.executeQuery("select value(timeCol,timeCol) from tG"), string);
        this.dumpRS(statement.executeQuery("select coalesce(timeCol,charCol) from tG"), string);
        this.dumpRS(statement.executeQuery("select value(timeCol,charCol) from tG"), string);
        this.dumpRS(statement.executeQuery("select coalesce(charCol,timeCol) from tG"), string2);
        this.dumpRS(statement.executeQuery("select value(charCol,timeCol) from tG"), string2);
        this.dumpRS(statement.executeQuery("select coalesce(timeCol,varcharCol) from tG"), string);
        this.dumpRS(statement.executeQuery("select value(timeCol,varcharCol) from tG"), string);
        this.dumpRS(statement.executeQuery("select coalesce(varcharCol,timeCol) from tG"), string3);
        this.dumpRS(statement.executeQuery("select value(varcharCol,timeCol) from tG"), string3);
        statement.executeUpdate("insert into tG values(time('12:30:33'), 'I am char', 'I am varchar')");
        CoalesceTest.assertStatementError("22007", statement, "select coalesce(charCol,timeCol) from tG");
        CoalesceTest.assertStatementError("22007", statement, "select value(charCol,timeCol) from tG");
        CoalesceTest.assertStatementError("22007", statement, "select coalesce(charCol,timeCol) from tG");
        CoalesceTest.assertStatementError("22007", statement, "select value(charCol,timeCol) from tG");
        string = "COL1(datatype : TIME, precision : 8, scale : 0) null 12:30:30 12:30:33 ";
        this.dumpRS(statement.executeQuery("select coalesce(timeCol,charCol) from tG"), string);
        this.dumpRS(statement.executeQuery("select value(timeCol,charCol) from tG"), string);
        this.dumpRS(statement.executeQuery("select coalesce(timeCol,varcharCol) from tG"), string);
        this.dumpRS(statement.executeQuery("select value(timeCol,varcharCol) from tG"), string);
    }

    public void testTimeStampCoalesce() throws Throwable {
        Statement statement = this.createStatement();
        statement.executeUpdate("insert into tH values(null, null, null)");
        statement.executeUpdate("insert into tH values(timestamp('1992-01-01 12:30:30'), '1992-01-01 12:30:31', '1992-01-01 12:30:32')");
        String string = "COL1(datatype : TIMESTAMP, precision : 29, scale : 9) null 1992-01-01 12:30:30.0 ";
        String string2 = "COL1(datatype : TIMESTAMP, precision : 29, scale : 9) null 1992-01-01 12:30:31.0 ";
        String string3 = "COL1(datatype : TIMESTAMP, precision : 29, scale : 9) null 1992-01-01 12:30:32.0 ";
        this.dumpRS(statement.executeQuery("select coalesce(timestampCol,timestampCol) from tH"), string);
        this.dumpRS(statement.executeQuery("select value(timestampCol,timestampCol) from tH"), string);
        this.dumpRS(statement.executeQuery("select coalesce(timestampCol,charCol) from tH"), string);
        this.dumpRS(statement.executeQuery("select value(timestampCol,charCol) from tH"), string);
        this.dumpRS(statement.executeQuery("select coalesce(charCol,timestampCol) from tH"), string2);
        this.dumpRS(statement.executeQuery("select value(charCol,timestampCol) from tH"), string2);
        this.dumpRS(statement.executeQuery("select coalesce(timestampCol,varcharCol) from tH"), string);
        this.dumpRS(statement.executeQuery("select value(timestampCol,varcharCol) from tH"), string);
        this.dumpRS(statement.executeQuery("select coalesce(varcharCol,timestampCol) from tH"), string3);
        this.dumpRS(statement.executeQuery("select value(varcharCol,timestampCol) from tH"), string3);
        statement.executeUpdate("insert into tH values(timestamp('1992-01-01 12:30:33'), 'I am char', 'I am varchar')");
        CoalesceTest.assertStatementError("22007", statement, "select coalesce(charCol,timestampCol) from tH");
        CoalesceTest.assertStatementError("22007", statement, "select value(charCol,timestampCol) from tH");
        CoalesceTest.assertStatementError("22007", statement, "select coalesce(charCol,timestampCol) from tH");
        CoalesceTest.assertStatementError("22007", statement, "select value(charCol,timestampCol) from tH");
    }

    public void testNumericCoalesce() throws Throwable {
        Statement statement = this.createStatement();
        statement.executeUpdate("insert into tE values(1, 2, 3, 4, 5.5, 6.6, 7.7, 3.4028235E38)");
        statement.executeUpdate("insert into tE values(null,null,null,null,null,null,null,null)");
        String[] stringArray = new String[]{"COL1(datatype : SMALLINT, precision : 5, scale : 0) 1 null ", "COL1(datatype : INTEGER, precision : 10, scale : 0) 1 null ", "COL1(datatype : BIGINT, precision : 19, scale : 0) 1 null ", "COL1(datatype : DECIMAL, precision : 22, scale : 2) 1.00 null ", "COL1(datatype : DECIMAL, precision : 11, scale : 6) 1.000000 null ", "COL1(datatype : DECIMAL, precision : 31, scale : 28) 1.0000000000000000000000000000 null ", "COL1(datatype : DOUBLE, precision : 15, scale : 0) 1.0 null ", "COL1(datatype : INTEGER, precision : 10, scale : 0) 2 null ", "COL1(datatype : BIGINT, precision : 19, scale : 0) 2 null ", "COL1(datatype : DECIMAL, precision : 22, scale : 2) 2.00 null ", "COL1(datatype : DECIMAL, precision : 16, scale : 6) 2.000000 null ", "COL1(datatype : DECIMAL, precision : 31, scale : 28) 2.0000000000000000000000000000 null ", "COL1(datatype : DOUBLE, precision : 15, scale : 0) 2.0 null ", "COL1(datatype : BIGINT, precision : 19, scale : 0) 3 null ", "COL1(datatype : DECIMAL, precision : 22, scale : 2) 3.00 null ", "COL1(datatype : DECIMAL, precision : 25, scale : 6) 3.000000 null ", "COL1(datatype : DECIMAL, precision : 31, scale : 28) 3.0000000000000000000000000000 null ", "COL1(datatype : DOUBLE, precision : 15, scale : 0) 3.0 null ", "COL1(datatype : DECIMAL, precision : 22, scale : 2) 4.00 null ", "COL1(datatype : DECIMAL, precision : 26, scale : 6) 4.000000 null ", "COL1(datatype : DECIMAL, precision : 31, scale : 28) 4.0000000000000000000000000000 null ", "COL1(datatype : DECIMAL, precision : 22, scale : 2) 4.00 null ", "COL1(datatype : DOUBLE, precision : 15, scale : 0) 4.0 null ", "COL1(datatype : REAL, precision : 7, scale : 0) 7.7 null ", "COL1(datatype : DOUBLE, precision : 15, scale : 0) 7.699999809265137 null ", "COL1(datatype : DOUBLE, precision : 15, scale : 0) 3.4028235E38 null "};
        this.dumpRS(statement.executeQuery("select coalesce(smallintCol,smallintCol) from tE"), stringArray[0]);
        this.dumpRS(statement.executeQuery("select coalesce(smallintCol,intCol) from tE"), stringArray[1]);
        this.dumpRS(statement.executeQuery("select coalesce(smallintCol,bigintCol) from tE"), stringArray[2]);
        this.dumpRS(statement.executeQuery("select coalesce(smallintCol,decimalCol1) from tE"), stringArray[3]);
        this.dumpRS(statement.executeQuery("select coalesce(smallintCol,decimalCol2) from tE"), stringArray[4]);
        this.dumpRS(statement.executeQuery("select coalesce(smallintCol,decimalCol3) from tE"), stringArray[5]);
        this.dumpRS(statement.executeQuery("select coalesce(smallintCol,realCol) from tE"), stringArray[6]);
        this.dumpRS(statement.executeQuery("select coalesce(smallintCol,doubleCol) from tE"), stringArray[6]);
        this.dumpRS(statement.executeQuery("select coalesce(intCol,intCol) from tE"), stringArray[7]);
        this.dumpRS(statement.executeQuery("select coalesce(intCol,smallintCol) from tE"), stringArray[7]);
        this.dumpRS(statement.executeQuery("select coalesce(intCol,bigintCol) from tE"), stringArray[8]);
        this.dumpRS(statement.executeQuery("select coalesce(intCol,decimalCol1) from tE"), stringArray[9]);
        this.dumpRS(statement.executeQuery("select coalesce(intCol,decimalCol2) from tE"), stringArray[10]);
        this.dumpRS(statement.executeQuery("select coalesce(intCol,decimalCol3) from tE"), stringArray[11]);
        this.dumpRS(statement.executeQuery("select coalesce(intCol,realCol) from tE"), stringArray[12]);
        this.dumpRS(statement.executeQuery("select coalesce(intCol,doubleCol) from tE"), stringArray[12]);
        this.dumpRS(statement.executeQuery("select coalesce(bigintCol,bigintCol) from tE"), stringArray[13]);
        this.dumpRS(statement.executeQuery("select coalesce(bigintCol,smallintCol) from tE"), stringArray[13]);
        this.dumpRS(statement.executeQuery("select coalesce(bigintCol,intCol) from tE"), stringArray[13]);
        this.dumpRS(statement.executeQuery("select coalesce(bigintCol,decimalCol1) from tE"), stringArray[14]);
        this.dumpRS(statement.executeQuery("select coalesce(bigintCol,decimalCol2) from tE"), stringArray[15]);
        this.dumpRS(statement.executeQuery("select coalesce(bigintCol,decimalCol3) from tE"), stringArray[16]);
        this.dumpRS(statement.executeQuery("select coalesce(bigintCol,realCol) from tE"), stringArray[17]);
        this.dumpRS(statement.executeQuery("select coalesce(bigintCol,doubleCol) from tE"), stringArray[17]);
        this.dumpRS(statement.executeQuery("select coalesce(decimalCol1,decimalCol1) from tE"), stringArray[18]);
        this.dumpRS(statement.executeQuery("select coalesce(decimalCol1,decimalCol2) from tE"), stringArray[19]);
        this.dumpRS(statement.executeQuery("select coalesce(decimalCol1,decimalCol3) from tE"), stringArray[20]);
        this.dumpRS(statement.executeQuery("select coalesce(decimalCol1,smallintCol) from tE"), stringArray[21]);
        this.dumpRS(statement.executeQuery("select coalesce(decimalCol1,intCol) from tE"), stringArray[21]);
        this.dumpRS(statement.executeQuery("select coalesce(decimalCol1,bigintCol) from tE"), stringArray[21]);
        this.dumpRS(statement.executeQuery("select coalesce(decimalCol1,realCol) from tE"), stringArray[22]);
        this.dumpRS(statement.executeQuery("select coalesce(decimalCol1,doubleCol) from tE"), stringArray[22]);
        this.dumpRS(statement.executeQuery("select coalesce(realCol,realCol) from tE"), stringArray[23]);
        this.dumpRS(statement.executeQuery("select coalesce(realCol,smallintCol) from tE"), stringArray[24]);
        this.dumpRS(statement.executeQuery("select coalesce(realCol,intCol) from tE"), stringArray[24]);
        this.dumpRS(statement.executeQuery("select coalesce(realCol,bigintCol) from tE"), stringArray[24]);
        this.dumpRS(statement.executeQuery("select coalesce(realCol,decimalCol1) from tE"), stringArray[24]);
        this.dumpRS(statement.executeQuery("select coalesce(realCol,doubleCol) from tE"), stringArray[24]);
        this.dumpRS(statement.executeQuery("select coalesce(doubleCol,doubleCol) from tE"), stringArray[25]);
        this.dumpRS(statement.executeQuery("select coalesce(doubleCol,smallintCol) from tE"), stringArray[25]);
        this.dumpRS(statement.executeQuery("select coalesce(doubleCol,intCol) from tE"), stringArray[25]);
        this.dumpRS(statement.executeQuery("select coalesce(doubleCol,bigintCol) from tE"), stringArray[25]);
        this.dumpRS(statement.executeQuery("select coalesce(doubleCol,decimalCol1) from tE"), stringArray[25]);
        this.dumpRS(statement.executeQuery("select coalesce(doubleCol,realCol) from tE"), stringArray[25]);
    }

    public void testMiscellaneousCoalesce() throws SQLException {
        String[] stringArray = new String[]{"COL1(datatype : CHAR, precision : 50, scale : 0) asdfghj                                            ", "COL1(datatype : CHAR, precision : 50, scale : 0) asdfghj                                            ", "COL1(datatype : CHAR, precision : 254, scale : 0) first argument to coalesce                                                                                                                                                                                                                                     first argument to coalesce                                                                                                                                                                                                                                     ", "COL1(datatype : CHAR, precision : 254, scale : 0) first argument to value                                                                                                                                                                                                                                        first argument to value                                                                                                                                                                                                                                        ", "COL1(datatype : CHAR, precision : 254, scale : 0) abcdefgh                                                                                                                                                                                                                                                       null ", "COL1(datatype : CHAR, precision : 254, scale : 0) abcdefgh                                                                                                                                                                                                                                                       null "};
        Statement statement = this.createStatement();
        statement.executeUpdate("insert into tD (c1,c2) values(1,'abcdefgh')");
        statement.executeUpdate("insert into tD (c1) values(2)");
        int n = 0;
        this.dumpRS(statement.executeQuery("values coalesce(cast('asdfghj' as char(30)),cast('asdf' as char(50)))"), stringArray[n++]);
        this.dumpRS(statement.executeQuery("values value(cast('asdfghj' as char(30)),cast('asdf' as char(50)))"), stringArray[n++]);
        PreparedStatement preparedStatement = this.prepareStatement("select coalesce(?,c2) from tD");
        preparedStatement.setString(1, "first argument to coalesce");
        this.dumpRS(preparedStatement.executeQuery(), stringArray[n++]);
        preparedStatement = this.prepareStatement("select value(?,c2) from tD");
        preparedStatement.setString(1, "first argument to value");
        this.dumpRS(preparedStatement.executeQuery(), stringArray[n++]);
        preparedStatement = this.prepareStatement("select coalesce(?,c2) from tD");
        preparedStatement.setNull(1, 1);
        this.dumpRS(preparedStatement.executeQuery(), stringArray[n++]);
        preparedStatement = this.prepareStatement("select value(?,c2) from tD");
        preparedStatement.setNull(1, -5);
        this.dumpRS(preparedStatement.executeQuery(), stringArray[n++]);
        preparedStatement = this.prepareStatement("select coalesce(c1,?) from tD");
        try {
            preparedStatement.setString(1, "abc");
            this.dumpRS(preparedStatement.executeQuery(), "");
            CoalesceTest.fail((String)"Expected statement to fail");
        }
        catch (SQLException sQLException) {
            CoalesceTest.assertSQLState("22018", sQLException);
        }
    }

    public void testCharCoalesce() throws Throwable {
        String[] stringArray = new String[]{"COL1(datatype : CHAR, precision : 254, scale : 0) c1 not null                                                                                                                                                                                                                                                    c1 not null but c2 is                                                                                                                                                                                                                                          c2 not null but c1 is                                                                                                                                                                                                                                          null ", "COL1(datatype : CHAR, precision : 254, scale : 0) c1 not null                                                                                                                                                                                                                                                    c1 not null but c2 is                                                                                                                                                                                                                                          c2 not null but c1 is                                                                                                                                                                                                                                          null ", "COL1(datatype : CHAR, precision : 254, scale : 0) c2 not null                                                                                                                                                                                                                                                    c1 not null but c2 is                                                                                                                                                                                                                                          c2 not null but c1 is                                                                                                                                                                                                                                          null ", "COL1(datatype : CHAR, precision : 254, scale : 0) c2 not null                                                                                                                                                                                                                                                    c1 not null but c2 is                                                                                                                                                                                                                                          c2 not null but c1 is                                                                                                                                                                                                                                          null ", "COL1(datatype : VARCHAR, precision : 254, scale : 0) c1 not null                                                                                                                                                                                                                                                    c1 not null but c2 is                                                                                                                                                                                                                                          null null ", "COL1(datatype : VARCHAR, precision : 254, scale : 0) c1 not null                                                                                                                                                                                                                                                    c1 not null but c2 is                                                                                                                                                                                                                                          null null ", "COL1(datatype : VARCHAR, precision : 254, scale : 0) vc1 not null vc1 is not null but vc2 is null null ", "COL1(datatype : VARCHAR, precision : 254, scale : 0) vc1 not null vc1 is not null but vc2 is null null ", "COL1(datatype : VARCHAR, precision : 2000, scale : 0) vc1 not null vc1 is not null but vc2 is vc2 is not null but vc1 is null ", "COL1(datatype : VARCHAR, precision : 2000, scale : 0) vc1 not null vc1 is not null but vc2 is vc2 is not null but vc1 is null ", "COL1(datatype : VARCHAR, precision : 2000, scale : 0) vc2 not null vc1 is not null but vc2 is vc2 is not null but vc1 is null ", "COL1(datatype : VARCHAR, precision : 2000, scale : 0) vc2 not null vc1 is not null but vc2 is vc2 is not null but vc1 is null ", "COL1(datatype : LONG VARCHAR, precision : 32700, scale : 0) c1 not null                                                                                                                                                                                                                                                    c1 not null but c2 is                                                                                                                                                                                                                                          lvc1 not null again null ", "COL1(datatype : LONG VARCHAR, precision : 32700, scale : 0) c1 not null                                                                                                                                                                                                                                                    c1 not null but c2 is                                                                                                                                                                                                                                          lvc1 not null again null ", "COL1(datatype : LONG VARCHAR, precision : 32700, scale : 0) lvc1 not null c1 not null but c2 is                                                                                                                                                                                                                                          lvc1 not null again null ", "COL1(datatype : LONG VARCHAR, precision : 32700, scale : 0) lvc1 not null c1 not null but c2 is                                                                                                                                                                                                                                          lvc1 not null again null ", "COL1(datatype : LONG VARCHAR, precision : 32700, scale : 0) vc1 not null vc1 is not null but vc2 is lvc1 not null again null ", "COL1(datatype : LONG VARCHAR, precision : 32700, scale : 0) vc1 not null vc1 is not null but vc2 is lvc1 not null again null ", "COL1(datatype : LONG VARCHAR, precision : 32700, scale : 0) lvc1 not null vc1 is not null but vc2 is lvc1 not null again null ", "COL1(datatype : LONG VARCHAR, precision : 32700, scale : 0) lvc1 not null vc1 is not null but vc2 is lvc1 not null again null ", "COL1(datatype : LONG VARCHAR, precision : 32700, scale : 0) lvc1 not null null lvc1 not null again null ", "COL1(datatype : LONG VARCHAR, precision : 32700, scale : 0) lvc1 not null null lvc1 not null again null ", "COL1(datatype : CLOB, precision : 254, scale : 0) clob1 not null c1 not null but c2 is                                                                                                                                                                                                                                          clob1 not null again null ", "COL1(datatype : CLOB, precision : 254, scale : 0) clob1 not null c1 not null but c2 is                                                                                                                                                                                                                                          clob1 not null again null ", "COL1(datatype : CLOB, precision : 33792, scale : 0) c1 not null                                                                                                                                                                                                                                                    c1 not null but c2 is                                                                                                                                                                                                                                          clob2 not null again null ", "COL1(datatype : CLOB, precision : 33792, scale : 0) c1 not null                                                                                                                                                                                                                                                    c1 not null but c2 is                                                                                                                                                                                                                                          clob2 not null again null ", "COL1(datatype : CLOB, precision : 253, scale : 0) clob1 not null vc1 is not null but vc2 is clob1 not null again null ", "COL1(datatype : CLOB, precision : 253, scale : 0) clob1 not null vc1 is not null but vc2 is clob1 not null again null ", "COL1(datatype : CLOB, precision : 33792, scale : 0) vc2 not null null vc2 is not null but vc1 is null ", "COL1(datatype : CLOB, precision : 33792, scale : 0) vc2 not null null vc2 is not null but vc1 is null ", "COL1(datatype : CLOB, precision : 32700, scale : 0) clob1 not null null clob1 not null again null ", "COL1(datatype : CLOB, precision : 32700, scale : 0) clob1 not null null clob1 not null again null ", "COL1(datatype : CLOB, precision : 33792, scale : 0) lvc2 not null null lvc2 not null again null ", "COL1(datatype : CLOB, precision : 33792, scale : 0) lvc2 not null null lvc2 not null again null ", "COL1(datatype : CLOB, precision : 33792, scale : 0) clob1 not null null clob1 not null again null ", "COL1(datatype : CLOB, precision : 33792, scale : 0) clob1 not null null clob1 not null again null "};
        Statement statement = this.createStatement();
        statement.executeUpdate("insert into tB values('c1 not null', 'c2 not null', 'vc1 not null', 'vc2 not null', 'lvc1 not null', 'lvc2 not null', 'clob1 not null', 'clob2 not null')");
        statement.executeUpdate("insert into tB values('c1 not null but c2 is', null, 'vc1 is not null but vc2 is', null, null, null,null,null)");
        statement.executeUpdate("insert into tB values(null,'c2 not null but c1 is', null, 'vc2 is not null but vc1 is', 'lvc1 not null again', 'lvc2 not null again', 'clob1 not null again', 'clob2 not null again')");
        statement.executeUpdate("insert into tB values(null,null, null, null, null, null, null, null)");
        int n = 0;
        this.dumpRS(statement.executeQuery("select coalesce(c1,c2) from tB"), stringArray[n++]);
        this.dumpRS(statement.executeQuery("select value(c1,c2) from tB"), stringArray[n++]);
        this.dumpRS(statement.executeQuery("select coalesce(c2,c1) from tB"), stringArray[n++]);
        this.dumpRS(statement.executeQuery("select value(c2,c1) from tB"), stringArray[n++]);
        this.dumpRS(statement.executeQuery("select coalesce(c1,vc1) from tB"), stringArray[n++]);
        this.dumpRS(statement.executeQuery("select value(c1,vc1) from tB"), stringArray[n++]);
        this.dumpRS(statement.executeQuery("select coalesce(vc1,c1) from tB"), stringArray[n++]);
        this.dumpRS(statement.executeQuery("select value(vc1,c1) from tB"), stringArray[n++]);
        this.dumpRS(statement.executeQuery("select coalesce(vc1,vc2) from tB"), stringArray[n++]);
        this.dumpRS(statement.executeQuery("select value(vc1,vc2) from tB"), stringArray[n++]);
        this.dumpRS(statement.executeQuery("select coalesce(vc2,vc1) from tB"), stringArray[n++]);
        this.dumpRS(statement.executeQuery("select value(vc2,vc1) from tB"), stringArray[n++]);
        this.dumpRS(statement.executeQuery("select coalesce(c1,lvc1) from tB"), stringArray[n++]);
        this.dumpRS(statement.executeQuery("select value(c1,lvc1) from tB"), stringArray[n++]);
        this.dumpRS(statement.executeQuery("select coalesce(lvc1,c1) from tB"), stringArray[n++]);
        this.dumpRS(statement.executeQuery("select value(lvc1,c1) from tB"), stringArray[n++]);
        this.dumpRS(statement.executeQuery("select coalesce(vc1,lvc1) from tB"), stringArray[n++]);
        this.dumpRS(statement.executeQuery("select value(vc1,lvc1) from tB"), stringArray[n++]);
        this.dumpRS(statement.executeQuery("select coalesce(lvc1,vc1) from tB"), stringArray[n++]);
        this.dumpRS(statement.executeQuery("select value(lvc1,vc1) from tB"), stringArray[n++]);
        this.dumpRS(statement.executeQuery("select coalesce(lvc1,lvc2) from tB"), stringArray[n++]);
        this.dumpRS(statement.executeQuery("select value(lvc1,lvc2) from tB"), stringArray[n++]);
        this.dumpRS(statement.executeQuery("select coalesce(clob1,c1) from tB"), stringArray[n++]);
        this.dumpRS(statement.executeQuery("select value(clob1,c1) from tB"), stringArray[n++]);
        this.dumpRS(statement.executeQuery("select coalesce(c1,clob2) from tB"), stringArray[n++]);
        this.dumpRS(statement.executeQuery("select value(c1,clob2) from tB"), stringArray[n++]);
        this.dumpRS(statement.executeQuery("select coalesce(clob1,vc1) from tB"), stringArray[n++]);
        this.dumpRS(statement.executeQuery("select value(clob1,vc1) from tB"), stringArray[n++]);
        this.dumpRS(statement.executeQuery("select coalesce(vc2,clob2) from tB"), stringArray[n++]);
        this.dumpRS(statement.executeQuery("select value(vc2,clob2) from tB"), stringArray[n++]);
        this.dumpRS(statement.executeQuery("select coalesce(clob1,lvc1) from tB"), stringArray[n++]);
        this.dumpRS(statement.executeQuery("select value(clob1,lvc1) from tB"), stringArray[n++]);
        this.dumpRS(statement.executeQuery("select coalesce(lvc2,clob2) from tB"), stringArray[n++]);
        this.dumpRS(statement.executeQuery("select value(lvc2,clob2) from tB"), stringArray[n++]);
        this.dumpRS(statement.executeQuery("select coalesce(clob1,clob2) from tB"), stringArray[n++]);
        this.dumpRS(statement.executeQuery("select value(clob1,clob2) from tB"), stringArray[n++]);
    }

    public void testCharForBitDataCoalesce() throws SQLException, UnsupportedEncodingException {
        String[] stringArray = new String[]{"COL1(datatype : CHAR () FOR BIT DATA, precision : 254, scale : 0) 63626431206e6f74206e756c6c20202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020 63626431206e6f74206e756c6c20627574206362643220697320202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020 63626432206e6f74206e756c6c20627574206362643120697320202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020 null ", "COL1(datatype : CHAR () FOR BIT DATA, precision : 254, scale : 0) 63626431206e6f74206e756c6c20202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020 63626431206e6f74206e756c6c20627574206362643220697320202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020 63626432206e6f74206e756c6c20627574206362643120697320202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020 null ", "COL1(datatype : CHAR () FOR BIT DATA, precision : 254, scale : 0) 63626432206e6f74206e756c6c20202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020 63626431206e6f74206e756c6c20627574206362643220697320202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020 63626432206e6f74206e756c6c20627574206362643120697320202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020 null ", "COL1(datatype : CHAR () FOR BIT DATA, precision : 254, scale : 0) 63626432206e6f74206e756c6c20202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020 63626431206e6f74206e756c6c20627574206362643220697320202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020 63626432206e6f74206e756c6c20627574206362643120697320202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020 null ", "COL1(datatype : VARCHAR () FOR BIT DATA, precision : 254, scale : 0) 63626431206e6f74206e756c6c20202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020 63626431206e6f74206e756c6c20627574206362643220697320202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020 null null ", "COL1(datatype : VARCHAR () FOR BIT DATA, precision : 254, scale : 0) 63626431206e6f74206e756c6c20202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020 63626431206e6f74206e756c6c20627574206362643220697320202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020 null null ", "COL1(datatype : VARCHAR () FOR BIT DATA, precision : 254, scale : 0) 7663626431206e6f74206e756c6c 7663626431206e6f74206e756c6c20627574207663626432206973 null null ", "COL1(datatype : VARCHAR () FOR BIT DATA, precision : 254, scale : 0) 7663626431206e6f74206e756c6c 7663626431206e6f74206e756c6c20627574207663626432206973 null null ", "COL1(datatype : VARCHAR () FOR BIT DATA, precision : 2000, scale : 0) 7663626431206e6f74206e756c6c 7663626431206e6f74206e756c6c20627574207663626432206973 7663626432206e6f74206e756c6c20627574207663626431206973 null ", "COL1(datatype : VARCHAR () FOR BIT DATA, precision : 2000, scale : 0) 7663626431206e6f74206e756c6c 7663626431206e6f74206e756c6c20627574207663626432206973 7663626432206e6f74206e756c6c20627574207663626431206973 null ", "COL1(datatype : VARCHAR () FOR BIT DATA, precision : 2000, scale : 0) 7663626432206e6f74206e756c6c 7663626431206e6f74206e756c6c20627574207663626432206973 7663626432206e6f74206e756c6c20627574207663626431206973 null ", "COL1(datatype : VARCHAR () FOR BIT DATA, precision : 2000, scale : 0) 7663626432206e6f74206e756c6c 7663626431206e6f74206e756c6c20627574207663626432206973 7663626432206e6f74206e756c6c20627574207663626431206973 null ", "COL1(datatype : LONG VARCHAR FOR BIT DATA, precision : 32700, scale : 0) 63626431206e6f74206e756c6c20202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020 63626431206e6f74206e756c6c20627574206362643220697320202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020 6c7663626431206e6f74206e756c6c20616761696e null ", "COL1(datatype : LONG VARCHAR FOR BIT DATA, precision : 32700, scale : 0) 63626431206e6f74206e756c6c20202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020 63626431206e6f74206e756c6c20627574206362643220697320202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020 6c7663626431206e6f74206e756c6c20616761696e null ", "COL1(datatype : LONG VARCHAR FOR BIT DATA, precision : 32700, scale : 0) 6c7663626431206e6f74206e756c6c 63626431206e6f74206e756c6c20627574206362643220697320202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020 6c7663626431206e6f74206e756c6c20616761696e null ", "COL1(datatype : LONG VARCHAR FOR BIT DATA, precision : 32700, scale : 0) 6c7663626431206e6f74206e756c6c 63626431206e6f74206e756c6c20627574206362643220697320202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020 6c7663626431206e6f74206e756c6c20616761696e null ", "COL1(datatype : LONG VARCHAR FOR BIT DATA, precision : 32700, scale : 0) 7663626431206e6f74206e756c6c 7663626431206e6f74206e756c6c20627574207663626432206973 6c7663626431206e6f74206e756c6c20616761696e null ", "COL1(datatype : LONG VARCHAR FOR BIT DATA, precision : 32700, scale : 0) 7663626431206e6f74206e756c6c 7663626431206e6f74206e756c6c20627574207663626432206973 6c7663626431206e6f74206e756c6c20616761696e null ", "COL1(datatype : LONG VARCHAR FOR BIT DATA, precision : 32700, scale : 0) 6c7663626431206e6f74206e756c6c 7663626431206e6f74206e756c6c20627574207663626432206973 6c7663626431206e6f74206e756c6c20616761696e null ", "COL1(datatype : LONG VARCHAR FOR BIT DATA, precision : 32700, scale : 0) 6c7663626431206e6f74206e756c6c 7663626431206e6f74206e756c6c20627574207663626432206973 6c7663626431206e6f74206e756c6c20616761696e null ", "COL1(datatype : LONG VARCHAR FOR BIT DATA, precision : 32700, scale : 0) 6c7663626431206e6f74206e756c6c null 6c7663626431206e6f74206e756c6c20616761696e null ", "COL1(datatype : LONG VARCHAR FOR BIT DATA, precision : 32700, scale : 0) 6c7663626431206e6f74206e756c6c null 6c7663626431206e6f74206e756c6c20616761696e null ", "COL1(datatype : BLOB, precision : 33792, scale : 0) 626c6f6231206e6f74206e756c6c null 626c6f6231206e6f74206e756c6c20616761696e null ", "COL1(datatype : BLOB, precision : 33792, scale : 0) 626c6f6231206e6f74206e756c6c null 626c6f6231206e6f74206e756c6c20616761696e null "};
        PreparedStatement preparedStatement = this.prepareStatement("insert into tC values (?,?,?,?,?,?,?,?)");
        preparedStatement.setBytes(1, "cbd1 not null".getBytes("US-ASCII"));
        preparedStatement.setBytes(2, "cbd2 not null".getBytes("US-ASCII"));
        preparedStatement.setBytes(3, "vcbd1 not null".getBytes("US-ASCII"));
        preparedStatement.setBytes(4, "vcbd2 not null".getBytes("US-ASCII"));
        preparedStatement.setBytes(5, "lvcbd1 not null".getBytes("US-ASCII"));
        preparedStatement.setBytes(6, "lvcbd2 not null".getBytes("US-ASCII"));
        preparedStatement.setBytes(7, "blob1 not null".getBytes("US-ASCII"));
        preparedStatement.setBytes(8, "blob2 not null".getBytes("US-ASCII"));
        preparedStatement.executeUpdate();
        preparedStatement.setBytes(1, "cbd1 not null but cbd2 is".getBytes("US-ASCII"));
        preparedStatement.setBytes(2, null);
        preparedStatement.setBytes(3, "vcbd1 not null but vcbd2 is".getBytes("US-ASCII"));
        preparedStatement.setBytes(4, null);
        preparedStatement.setBytes(5, null);
        preparedStatement.setBytes(6, null);
        preparedStatement.setBytes(7, null);
        preparedStatement.setBytes(8, null);
        preparedStatement.executeUpdate();
        preparedStatement.setBytes(1, null);
        preparedStatement.setBytes(2, "cbd2 not null but cbd1 is".getBytes("US-ASCII"));
        preparedStatement.setBytes(3, null);
        preparedStatement.setBytes(4, "vcbd2 not null but vcbd1 is".getBytes("US-ASCII"));
        preparedStatement.setBytes(5, "lvcbd1 not null again".getBytes("US-ASCII"));
        preparedStatement.setBytes(6, "lvcbd2 not null again".getBytes("US-ASCII"));
        preparedStatement.setBytes(7, "blob1 not null again".getBytes("US-ASCII"));
        preparedStatement.setBytes(8, "blob2 not null again".getBytes("US-ASCII"));
        preparedStatement.executeUpdate();
        preparedStatement.setBytes(1, null);
        preparedStatement.setBytes(2, null);
        preparedStatement.setBytes(3, null);
        preparedStatement.setBytes(4, null);
        preparedStatement.setBytes(5, null);
        preparedStatement.setBytes(6, null);
        preparedStatement.setBytes(7, null);
        preparedStatement.setBytes(8, null);
        preparedStatement.executeUpdate();
        int n = 0;
        Statement statement = this.createStatement();
        this.dumpRS(statement.executeQuery("select coalesce(cbd1,cbd2) from tC"), stringArray[n++]);
        this.dumpRS(statement.executeQuery("select value(cbd1,cbd2) from tC"), stringArray[n++]);
        this.dumpRS(statement.executeQuery("select coalesce(cbd2,cbd1) from tC"), stringArray[n++]);
        this.dumpRS(statement.executeQuery("select value(cbd2,cbd1) from tC"), stringArray[n++]);
        this.dumpRS(statement.executeQuery("select coalesce(cbd1,vcbd1) from tC"), stringArray[n++]);
        this.dumpRS(statement.executeQuery("select value(cbd1,vcbd1) from tC"), stringArray[n++]);
        this.dumpRS(statement.executeQuery("select coalesce(vcbd1,cbd1) from tC"), stringArray[n++]);
        this.dumpRS(statement.executeQuery("select value(vcbd1,cbd1) from tC"), stringArray[n++]);
        this.dumpRS(statement.executeQuery("select coalesce(vcbd1,vcbd2) from tC"), stringArray[n++]);
        this.dumpRS(statement.executeQuery("select value(vcbd1,vcbd2) from tC"), stringArray[n++]);
        this.dumpRS(statement.executeQuery("select coalesce(vcbd2,vcbd1) from tC"), stringArray[n++]);
        this.dumpRS(statement.executeQuery("select value(vcbd2,vcbd1) from tC"), stringArray[n++]);
        this.dumpRS(statement.executeQuery("select coalesce(cbd1,lvcbd1) from tC"), stringArray[n++]);
        this.dumpRS(statement.executeQuery("select value(cbd1,lvcbd1) from tC"), stringArray[n++]);
        this.dumpRS(statement.executeQuery("select coalesce(lvcbd1,cbd1) from tC"), stringArray[n++]);
        this.dumpRS(statement.executeQuery("select value(lvcbd1,cbd1) from tC"), stringArray[n++]);
        this.dumpRS(statement.executeQuery("select coalesce(vcbd1,lvcbd1) from tC"), stringArray[n++]);
        this.dumpRS(statement.executeQuery("select value(vcbd1,lvcbd1) from tC"), stringArray[n++]);
        this.dumpRS(statement.executeQuery("select coalesce(lvcbd1,vcbd1) from tC"), stringArray[n++]);
        this.dumpRS(statement.executeQuery("select value(lvcbd1,vcbd1) from tC"), stringArray[n++]);
        this.dumpRS(statement.executeQuery("select coalesce(lvcbd1,lvcbd2) from tC"), stringArray[n++]);
        this.dumpRS(statement.executeQuery("select value(lvcbd1,lvcbd2) from tC"), stringArray[n++]);
        CoalesceTest.assertStatementError("42815", statement, "select coalesce(blob1,cbd1) from tC");
        CoalesceTest.assertStatementError("42815", statement, "select value(blob1,cbd1) from tC");
        CoalesceTest.assertStatementError("42815", statement, "select coalesce(cbd1,blob2) from tC");
        CoalesceTest.assertStatementError("42815", statement, "select value(cbd1,blob2) from tC");
        CoalesceTest.assertStatementError("42815", statement, "select coalesce(blob1,vcbd1) from tC");
        CoalesceTest.assertStatementError("42815", statement, "select value(blob1,vcbd1) from tC");
        CoalesceTest.assertStatementError("42815", statement, "select coalesce(vcbd2,blob2) from tC");
        CoalesceTest.assertStatementError("42815", statement, "select value(vcbd2,blob2) from tC");
        CoalesceTest.assertStatementError("42815", statement, "select coalesce(blob1,lvcbd1) from tC");
        CoalesceTest.assertStatementError("42815", statement, "select value(blob1,lvcbd1) from tC");
        CoalesceTest.assertStatementError("42815", statement, "select coalesce(lvcbd2,blob2) from tC");
        CoalesceTest.assertStatementError("42815", statement, "select value(lvcbd2,blob2) from tC");
        this.dumpRS(statement.executeQuery("select coalesce(blob1,blob2) from tC"), stringArray[n++]);
        this.dumpRS(statement.executeQuery("select value(blob1,blob2) from tC"), stringArray[n++]);
    }

    public void testAggregateDerby2016() throws SQLException {
        String[] stringArray = new String[]{"COL1(datatype : INTEGER, precision : 10, scale : 0) 2 ", "COL1(datatype : INTEGER, precision : 10, scale : 0) 55 ", "COL1(datatype : INTEGER, precision : 10, scale : 0) 1 "};
        Statement statement = this.createStatement();
        int n = 0;
        PreparedStatement preparedStatement = this.prepareStatement("insert into tAggr values ?");
        for (int i = 0; i < 3; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.executeUpdate();
        }
        this.dumpRS(statement.executeQuery("select coalesce(max(i), 55) from tAggr"), stringArray[n++]);
        statement.executeUpdate("delete from tAggr");
        preparedStatement.setNull(1, 4);
        preparedStatement.executeUpdate();
        this.dumpRS(statement.executeQuery("select coalesce(max(i), 55) from tAggr"), stringArray[n++]);
        this.dumpRS(statement.executeQuery("select coalesce(max(i), count(*), 55) from tAggr"), stringArray[n++]);
    }

    public void testColumnRemappingDerby4342() throws SQLException {
        JDBC.assertSingleValueResultSet(this.createStatement().executeQuery("select t1.smallintcol from AllDataTypesTable t1 join AllDataTypesTable t2 on t1.smallintcol=t2.smallintcol where coalesce(t1.smallintcol, t1.integercol) = 1"), "1");
    }

    public void testPredicateCategorizationDerby4594() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("create table d4594_t1 (a1 int)");
        statement.execute("create table d4594_t2 (a2 int)");
        statement.execute("insert into d4594_t1 values 1");
        JDBC.assertEmpty(statement.executeQuery("select 1 from d4594_t1 join d4594_t2 on 1=1 where coalesce(a2, 0) <> 1"));
        JDBC.assertEmpty(statement.executeQuery("select 1 from d4594_t1 left join d4594_t2 on 1=1 where coalesce(a2, 0) <> 1"));
    }

    public void testMultipleUntypedParameters() throws SQLException {
        this.assertCompileError("42610", "values coalesce(?,?,?)");
        this.vetThreeArgCoalesce("values coalesce(cast(? as char(1)), ?, ?)");
        this.vetThreeArgCoalesce("values coalesce(?, cast(? as char(1)), ?)");
        this.vetThreeArgCoalesce("values coalesce(?, ?, cast(? as char(1)))");
    }

    public void testQuantifiedComparison() throws SQLException {
        JDBC.assertUnorderedResultSet(this.createStatement().executeQuery("select c, coalesce((c = all (values 'Y')), false) from (values 'Y', 'N') v(c)"), new String[][]{{"N", "false"}, {"Y", "true"}});
    }

    private void vetThreeArgCoalesce(String string) throws SQLException {
        String[][] stringArrayArray = new String[][]{{"a", "b", "c", "a"}, {null, "b", "c", "b"}, {"a", null, "c", "a"}, {"a", "b", null, "a"}, {null, null, "c", "c"}, {"a", null, null, "a"}, {null, "b", null, "b"}, {null, null, null, null}};
        PreparedStatement preparedStatement = this.prepareStatement(string);
        for (int i = 0; i < stringArrayArray.length; ++i) {
            preparedStatement.setString(1, stringArrayArray[i][0]);
            preparedStatement.setString(2, stringArrayArray[i][1]);
            preparedStatement.setString(3, stringArrayArray[i][2]);
            JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), stringArrayArray[i][3]);
        }
    }

    private void dumpRS(ResultSet resultSet, String string) throws SQLException {
        if (resultSet == null) {
            return;
        }
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        if (n <= 0) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 1; i <= n; ++i) {
            if (i > 1) {
                stringBuffer.append(",");
            }
            stringBuffer.append("COL" + i);
            stringBuffer.append("(datatype : " + resultSetMetaData.getColumnTypeName(i));
            stringBuffer.append(", precision : " + resultSetMetaData.getPrecision(i));
            stringBuffer.append(", scale : " + resultSetMetaData.getScale(i) + ")");
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        while (resultSet.next()) {
            for (int i = 1; i <= n; ++i) {
                if (i > 1) {
                    stringBuffer2.append(",");
                }
                stringBuffer2.append(resultSet.getString(i));
                stringBuffer2.append(" ");
            }
        }
        Object object = stringBuffer.toString() + " " + stringBuffer2.toString();
        if (CoalesceTest.usingDerbyNetClient() && string.indexOf("()") != -1) {
            String string2 = ((String)object).replaceAll("CHAR", "CHAR ()");
            object = string2;
        }
        CoalesceTest.assertEquals((String)string, (String)object);
        resultSet.close();
    }

    public static boolean isClobWithCharAndDateTypeArguments(String string) throws Throwable {
        return string.indexOf("CLOB") != -1 && string.indexOf("CHAR") != -1 && (string.indexOf("DATE") != -1 || string.indexOf("TIME") != -1);
    }

    private static boolean isSupportedCoalesce(int n, int n2) {
        return !resultDataTypeRulesTable[n][n2].equals("ERROR");
    }
}

