/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.perf.clients;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import org.apache.derbyTesting.perf.clients.DBFiller;
import org.apache.derbyTesting.perf.clients.WisconsinFiller;

public class BankAccountFiller
implements DBFiller {
    static final String ACCOUNT_TABLE = "ACCOUNTS";
    static final String BRANCH_TABLE = "BRANCHES";
    static final String TELLER_TABLE = "TELLERS";
    static final String HISTORY_TABLE = "HISTORY";
    static final int DEFAULT_TELLERS_PER_BRANCH = 10;
    static final int DEFAULT_ACCOUNTS_PER_BRANCH = 100000;
    private static final int ACCOUNT_EXTRA = 84;
    private static final int BRANCH_EXTRA = 88;
    private static final int TELLER_EXTRA = 84;
    static final int HISTORY_EXTRA = 18;
    private final int branches;
    private final int tellersPerBranch;
    private final int accountsPerBranch;

    public BankAccountFiller(int n, int n2, int n3) {
        if (n <= 0 || n2 <= 0 || n3 <= 0) {
            throw new IllegalArgumentException("all arguments must be greater than 0");
        }
        this.branches = n;
        this.tellersPerBranch = n2;
        this.accountsPerBranch = n3;
    }

    public BankAccountFiller(int n) {
        this(n, 10, 100000);
    }

    @Override
    public void fill(Connection connection) throws SQLException {
        connection.setAutoCommit(false);
        BankAccountFiller.dropTables(connection);
        BankAccountFiller.createTables(connection);
        this.fillTables(connection);
    }

    private static void dropTables(Connection connection) throws SQLException {
        WisconsinFiller.dropTable(connection, ACCOUNT_TABLE);
        WisconsinFiller.dropTable(connection, BRANCH_TABLE);
        WisconsinFiller.dropTable(connection, TELLER_TABLE);
        WisconsinFiller.dropTable(connection, HISTORY_TABLE);
        connection.commit();
    }

    private static void createTables(Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        statement.executeUpdate("CREATE TABLE ACCOUNTS(ACCOUNT_ID INT NOT NULL, BRANCH_ID INT NOT NULL, ACCOUNT_BALANCE BIGINT NOT NULL, EXTRA_DATA CHAR(84) NOT NULL)");
        statement.executeUpdate("CREATE TABLE BRANCHES(BRANCH_ID INT NOT NULL, BRANCH_BALANCE BIGINT NOT NULL, EXTRA_DATA CHAR(88) NOT NULL)");
        statement.executeUpdate("CREATE TABLE TELLERS(TELLER_ID INT NOT NULL, BRANCH_ID INT NOT NULL, TELLER_BALANCE INT NOT NULL, EXTRA_DATA CHAR(84) NOT NULL)");
        statement.executeUpdate("CREATE TABLE HISTORY(ACCOUNT_ID INT NOT NULL, TELLER_ID INT NOT NULL, BRANCH_ID INT NOT NULL, AMOUNT BIGINT NOT NULL, TIME_STAMP TIMESTAMP NOT NULL, EXTRA_DATA CHAR(18) NOT NULL)");
        statement.close();
        connection.commit();
    }

    private void fillTables(Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO ACCOUNTS(ACCOUNT_ID, BRANCH_ID, ACCOUNT_BALANCE, EXTRA_DATA) VALUES (?, ?, 0, ?)");
        preparedStatement.setString(3, BankAccountFiller.createJunk(84));
        for (int i = 0; i < this.accountsPerBranch * this.branches; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.setInt(2, i / this.accountsPerBranch);
            preparedStatement.executeUpdate();
        }
        preparedStatement.close();
        statement.executeUpdate("ALTER TABLE ACCOUNTS ADD CONSTRAINT ACCOUNTS_PK PRIMARY KEY (ACCOUNT_ID)");
        connection.commit();
        PreparedStatement preparedStatement2 = connection.prepareStatement("INSERT INTO BRANCHES(BRANCH_ID, BRANCH_BALANCE, EXTRA_DATA) VALUES (?, 0, ?)");
        preparedStatement2.setString(2, BankAccountFiller.createJunk(88));
        for (int i = 0; i < this.branches; ++i) {
            preparedStatement2.setInt(1, i);
            preparedStatement2.executeUpdate();
        }
        preparedStatement2.close();
        statement.executeUpdate("ALTER TABLE BRANCHES ADD CONSTRAINT BRANCHES_PK PRIMARY KEY (BRANCH_ID)");
        connection.commit();
        PreparedStatement preparedStatement3 = connection.prepareStatement("INSERT INTO TELLERS(TELLER_ID, BRANCH_ID, TELLER_BALANCE, EXTRA_DATA) VALUES (?, ?, 0, ?)");
        preparedStatement3.setString(3, BankAccountFiller.createJunk(84));
        for (int i = 0; i < this.tellersPerBranch * this.branches; ++i) {
            preparedStatement3.setInt(1, i);
            preparedStatement3.setInt(2, i / this.tellersPerBranch);
            preparedStatement3.executeUpdate();
        }
        preparedStatement3.close();
        statement.executeUpdate("ALTER TABLE TELLERS ADD CONSTRAINT TELLERS_PK PRIMARY KEY (TELLER_ID)");
        connection.commit();
        statement.close();
    }

    static String createJunk(int n) {
        char[] cArray = new char[n];
        Arrays.fill(cArray, 'x');
        return new String(cArray);
    }
}

