/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.tools;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ImportExportProcedureTest
extends BaseJDBCTestCase {
    private static final String INVALID_DELIMITER = "XIE0J";

    public ImportExportProcedureTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("ImportExportProcedureTest");
        baseTestSuite.addTest(TestConfiguration.defaultSuite(ImportExportProcedureTest.class));
        return new SupportFilesSetup((Test)baseTestSuite, new String[]{"functionTests/testData/ImportExport/db2ttypes.del", "functionTests/testData/ImportExport/mixednl.del", "functionTests/testData/ImportExport/position_info.del"});
    }

    public void testImportExportProcedures() throws Exception {
        ResultSet resultSet = null;
        Statement statement = this.createStatement();
        Connection connection = this.getConnection();
        statement.executeUpdate("create table ex_emp(id int , name char(7) , skills varchar(200), salary decimal(10,2)) ");
        statement.executeUpdate("create table imp_emp(id int , name char(7), skills varchar(200), salary decimal(10,2)) ");
        statement.executeUpdate("insert into ex_emp values(99, 'smith' , 'tennis\"p,l,ayer\"', 190.55) ");
        SupportFilesSetup.deleteFile("extinout/emp.dat");
        CallableStatement callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_EXPORT_TABLE (null, 'EX_EMP' , 'extinout/emp.dat' , null, null, null) ");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_IMPORT_TABLE (null, 'IMP_EMP' , 'extinout/emp.dat' , null, null, null, 0) ");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        statement.executeUpdate(" insert into ex_emp values(100, 'smith' , 'tennis\"player\"', 190.55) ");
        statement.executeUpdate(" insert into ex_emp values(101, 'smith' , 'tennis\"player', 190.55) ");
        statement.executeUpdate(" insert into ex_emp values(102, 'smith' , '\"tennis\"player', 190.55) ");
        statement.executeUpdate(" insert into ex_emp values(103, 'smith' , '\"tennis\"player\"', 190.55) ");
        statement.executeUpdate(" insert into ex_emp values(104, 'smith' , '\"tennis\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"player\"', null) ");
        statement.executeUpdate("insert into ex_emp values(105, 'smith' , '\"\"', 190.55) ");
        statement.executeUpdate("insert into ex_emp values(106, 'smith' , '\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"', 190.55)");
        statement.executeUpdate("insert into ex_emp values(107, 'smith\"' , null, 190.55) ");
        statement.executeUpdate("insert into ex_emp values(108, null , null, null) ");
        SupportFilesSetup.deleteFile("extinout/emp.dat");
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_EXPORT_TABLE (null, 'EX_EMP' , 'extinout/emp.dat' , null, null, null) ");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_IMPORT_TABLE (null, 'IMP_EMP' , 'extinout/emp.dat' , null, null, null, 0) ");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        resultSet = statement.executeQuery(" select * from ex_emp");
        String[] stringArray = new String[]{"ID", "NAME", "SKILLS", "SALARY"};
        JDBC.assertColumnNames(resultSet, stringArray);
        Object[][] objectArray = new String[][]{{"99", "smith", "tennis\"p,l,ayer\"", "190.55"}, {"100", "smith", "tennis\"player\"", "190.55"}, {"101", "smith", "tennis\"player", "190.55"}, {"102", "smith", "\"tennis\"player", "190.55"}, {"103", "smith", "\"tennis\"player\"", "190.55"}, {"104", "smith", "\"tennis\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"player\"", null}, {"105", "smith", "\"\"", "190.55"}, {"106", "smith", "\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"", "190.55"}, {"107", "smith\"", null, "190.55"}, {"108", null, null, null}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" select * from imp_emp");
        stringArray = new String[]{"ID", "NAME", "SKILLS", "SALARY"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"99", "smith", "tennis\"p,l,ayer\"", "190.55"}, {"99", "smith", "tennis\"p,l,ayer\"", "190.55"}, {"100", "smith", "tennis\"player\"", "190.55"}, {"101", "smith", "tennis\"player", "190.55"}, {"102", "smith", "\"tennis\"player", "190.55"}, {"103", "smith", "\"tennis\"player\"", "190.55"}, {"104", "smith", "\"tennis\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"player\"", null}, {"105", "smith", "\"\"", "190.55"}, {"106", "smith", "\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"", "190.55"}, {"107", "smith\"", null, "190.55"}, {"108", null, null, null}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery("select count(*) from imp_emp, ex_emp where ex_emp.id = imp_emp.id and (ex_emp.skills=imp_emp.skills or (ex_emp.skills is NULL and imp_emp.skills is NULL))");
        stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"11"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        ImportExportProcedureTest.assertUpdateCount(statement, 7, " delete from imp_emp where id < 105");
        SupportFilesSetup.deleteFile("extinout/emp.dat");
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_EXPORT_QUERY('select * from ex_emp where id < 105', 'extinout/emp.dat' , null, null, null) ");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_IMPORT_TABLE (null, 'IMP_EMP' , 'extinout/emp.dat' , null, null, null, 0) ");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        resultSet = statement.executeQuery("select count(*) from imp_emp, ex_emp where ex_emp.id = imp_emp.id and (ex_emp.skills=imp_emp.skills or (ex_emp.skills is NULL and imp_emp.skills is NULL))");
        stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"10"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        SupportFilesSetup.deleteFile("extinout/emp.dat");
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_EXPORT_QUERY('select name , salary , skills, id from ex_emp where id < 105', 'extinout/emp.dat' , null, null, null) ");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_IMPORT_DATA(null, 'IMP_EMP' ,'NAME, SALARY, SKILLS, ID', null, 'extinout/emp.dat', null, null, null, 1) ");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        resultSet = statement.executeQuery("select count(*) from imp_emp, ex_emp where ex_emp.id = imp_emp.id and (ex_emp.skills=imp_emp.skills or (ex_emp.skills is NULL and imp_emp.skills is NULL))");
        stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"6"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_IMPORT_DATA(null, 'IMP_EMP' ,null, '4, 1, 3, 2', 'extinout/emp.dat', null, null, null, 1) ");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        resultSet = statement.executeQuery("select count(*) from imp_emp, ex_emp where ex_emp.id = imp_emp.id and (ex_emp.skills=imp_emp.skills or (ex_emp.skills is NULL and imp_emp.skills is NULL))");
        stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"6"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_IMPORT_DATA(null, 'IMP_EMP' ,'SALARY, ID, SKILLS, NAME', '2, 4, 3, 1', 'extinout/emp.dat', null, null, null, 1) ");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        resultSet = statement.executeQuery("select count(*) from imp_emp, ex_emp where ex_emp.id = imp_emp.id and (ex_emp.skills=imp_emp.skills or (ex_emp.skills is NULL and imp_emp.skills is NULL))");
        stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"6"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        SupportFilesSetup.deleteFile("extinout/emp.dat");
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_EXPORT_TABLE (null, 'EX_EMP' , 'extinout/emp.dat' , null, '''', null) ");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_IMPORT_TABLE (null, 'IMP_EMP' , 'extinout/emp.dat' , null, '''', null, 1) ");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        resultSet = statement.executeQuery(" select * from imp_emp ");
        stringArray = new String[]{"ID", "NAME", "SKILLS", "SALARY"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"99", "smith", "tennis\"p,l,ayer\"", "190.55"}, {"100", "smith", "tennis\"player\"", "190.55"}, {"101", "smith", "tennis\"player", "190.55"}, {"102", "smith", "\"tennis\"player", "190.55"}, {"103", "smith", "\"tennis\"player\"", "190.55"}, {"104", "smith", "\"tennis\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"player\"", null}, {"105", "smith", "\"\"", "190.55"}, {"106", "smith", "\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"", "190.55"}, {"107", "smith\"", null, "190.55"}, {"108", null, null, null}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        SupportFilesSetup.deleteFile("extinout/emp.dat");
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_EXPORT_TABLE (null, 'EX_EMP' , 'extinout/emp.dat' , '''',null, null) ");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        ImportExportProcedureTest.assertUpdateCount(statement, 10, " delete from imp_emp ");
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_IMPORT_TABLE (null, 'IMP_EMP' , 'extinout/emp.dat' , '''', null, null, 0) ");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        resultSet = statement.executeQuery(" select * from imp_emp");
        stringArray = new String[]{"ID", "NAME", "SKILLS", "SALARY"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"99", "smith", "tennis\"p,l,ayer\"", "190.55"}, {"100", "smith", "tennis\"player\"", "190.55"}, {"101", "smith", "tennis\"player", "190.55"}, {"102", "smith", "\"tennis\"player", "190.55"}, {"103", "smith", "\"tennis\"player\"", "190.55"}, {"104", "smith", "\"tennis\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"player\"", null}, {"105", "smith", "\"\"", "190.55"}, {"106", "smith", "\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"", "190.55"}, {"107", "smith\"", null, "190.55"}, {"108", null, null, null}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        SupportFilesSetup.deleteFile("extinout/emp.dat");
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_EXPORT_TABLE (null, 'EX_EMP' , 'extinout/emp.dat' , '*', '%', null) ");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_IMPORT_TABLE (null, 'EX_EMP' , 'extinout/emp.dat' , '*', '%', null, 1) ");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        resultSet = statement.executeQuery(" select * from imp_emp ");
        stringArray = new String[]{"ID", "NAME", "SKILLS", "SALARY"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"99", "smith", "tennis\"p,l,ayer\"", "190.55"}, {"100", "smith", "tennis\"player\"", "190.55"}, {"101", "smith", "tennis\"player", "190.55"}, {"102", "smith", "\"tennis\"player", "190.55"}, {"103", "smith", "\"tennis\"player\"", "190.55"}, {"104", "smith", "\"tennis\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"player\"", null}, {"105", "smith", "\"\"", "190.55"}, {"106", "smith", "\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"", "190.55"}, {"107", "smith\"", null, "190.55"}, {"108", null, null, null}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate("create table noncast(c1 double , c2 real ) ");
        statement.executeUpdate(" insert into noncast values(1.5 , 6.7 ) ");
        statement.executeUpdate(" insert into noncast values(2.5 , 8.999) ");
        SupportFilesSetup.deleteFile("extinout/noncast.dat");
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_EXPORT_TABLE ('APP' , 'NONCAST' , 'extinout/noncast.dat'  , null , null , null) ");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_IMPORT_TABLE (null, 'NONCAST' , 'extinout/noncast.dat'  , null , null , null , 0) ");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_IMPORT_DATA(null, 'NONCAST', 'C2 , C1' , '2, 1' , 'extinout/noncast.dat'  , null , null , null , 0) ");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        resultSet = statement.executeQuery(" select * from noncast ");
        stringArray = new String[]{"C1", "C2"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1.5", "6.7"}, {"2.5", "8.999"}, {"1.5", "6.7"}, {"2.5", "8.999"}, {"1.5", "6.7"}, {"2.5", "8.999"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate("CREATE TABLE   TTYPES(DATETYPE DATE, TIMETYPE TIME, TSTAMPTYPE TIMESTAMP )");
        statement.executeUpdate(" insert into ttypes values('1999-09-09' , '12:15:19' , '1999-09-09 11:11:11')");
        statement.executeUpdate(" insert into ttypes values('2999-12-01' , '13:16:10' , '2999-09-09 11:12:11')");
        statement.executeUpdate(" insert into ttypes values('3000-11-02' , '14:17:21' , '4999-09-09 11:13:11')");
        statement.executeUpdate(" insert into ttypes values('2004-04-03' , '15:18:31' , '2004-09-09 11:14:11')");
        statement.executeUpdate(" insert into ttypes values(null , null , null)");
        SupportFilesSetup.deleteFile("extinout/ttypes.del");
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_EXPORT_TABLE (null, 'TTYPES' , 'extinout/ttypes.del' , null, null, null) ");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_IMPORT_TABLE (null, 'TTYPES' , 'extinout/ttypes.del' , null, null, null, 0) ");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        resultSet = statement.executeQuery(" select * from ttypes");
        stringArray = new String[]{"DATETYPE", "TIMETYPE", "TSTAMPTYPE"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1999-09-09", "12:15:19", "1999-09-09 11:11:11.0"}, {"2999-12-01", "13:16:10", "2999-09-09 11:12:11.0"}, {"3000-11-02", "14:17:21", "4999-09-09 11:13:11.0"}, {"2004-04-03", "15:18:31", "2004-09-09 11:14:11.0"}, {null, null, null}, {"1999-09-09", "12:15:19", "1999-09-09 11:11:11.0"}, {"2999-12-01", "13:16:10", "2999-09-09 11:12:11.0"}, {"3000-11-02", "14:17:21", "4999-09-09 11:13:11.0"}, {"2004-04-03", "15:18:31", "2004-09-09 11:14:11.0"}, {null, null, null}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        connection.setAutoCommit(false);
        statement.executeUpdate(" create table t1(a int ) ");
        statement.executeUpdate(" insert into t1 values(1) ");
        statement.executeUpdate(" insert into t1 values(2) ");
        SupportFilesSetup.deleteFile("extinout/t1.del");
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_EXPORT_TABLE (null, 'T1' , 'extinout/t1.del' , null, null, null) ");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_IMPORT_TABLE (null, 'T1' , 'extinout/t1.del' , null, null, null, 0) ");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        connection.rollback();
        resultSet = statement.executeQuery(" select * from t1");
        stringArray = new String[]{"A"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1"}, {"2"}, {"1"}, {"2"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate(" insert into t1 values(3) ");
        statement.executeUpdate(" insert into t1 values(4) ");
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_IMPORT_TABLE (null, 'T1' , 'extinout/nofile.del' , null, null, null, 0) ");
        ImportExportProcedureTest.assertStatementError("38000", callableStatement);
        connection.commit();
        resultSet = statement.executeQuery(" select * from t1 ");
        stringArray = new String[]{"A"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1"}, {"2"}, {"1"}, {"2"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate(" insert into t1 values(3) ");
        statement.executeUpdate(" insert into t1 values(4) ");
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_IMPORT_TABLE (null, 'NOTABLE' , 'extinout/t1.del' , null, null, null, 0) ");
        ImportExportProcedureTest.assertStatementError("XIE0M", callableStatement);
        connection.commit();
        resultSet = statement.executeQuery(" select * from t1 ");
        stringArray = new String[]{"A"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1"}, {"2"}, {"1"}, {"2"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        ImportExportProcedureTest.assertUpdateCount(statement, 4, " delete from t1");
        statement.executeUpdate("insert into t1 values(1) ");
        statement.executeUpdate(" insert into t1 values(2) ");
        SupportFilesSetup.deleteFile("extinout/t1.del");
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_EXPORT_TABLE (null, 'T1' , 'extinout/t1.del' , null, null, null) ");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        connection.rollback();
        resultSet = statement.executeQuery(" select * from t1");
        stringArray = new String[]{"A"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1"}, {"2"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_IMPORT_TABLE (null, 'T1' , 'extinout/t1.del' , null, null, null, 1) ");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        connection.rollback();
        resultSet = statement.executeQuery(" select * from t1");
        stringArray = new String[]{"A"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1"}, {"2"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate(" insert into t1 values(3) ");
        statement.executeUpdate(" insert into t1 values(4) ");
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_IMPORT_TABLE (null, 'T1' , 'extinout/nofile.del' , null, null, null, 1) ");
        ImportExportProcedureTest.assertStatementError("38000", callableStatement);
        connection.commit();
        resultSet = statement.executeQuery(" select * from t1 ");
        stringArray = new String[]{"A"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1"}, {"2"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate(" insert into t1 values(3) ");
        statement.executeUpdate(" insert into t1 values(4) ");
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_IMPORT_TABLE (null, 'NOTABLE' , 'extinout/t1.del' , null, null, null, 1) ");
        ImportExportProcedureTest.assertStatementError("XIE0M", callableStatement);
        connection.commit();
        resultSet = statement.executeQuery("select * from t1 ");
        stringArray = new String[]{"A"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1"}, {"2"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        ImportExportProcedureTest.assertUpdateCount(statement, 2, " delete from t1");
        statement.executeUpdate("insert into t1 values(1) ");
        statement.executeUpdate(" insert into t1 values(2) ");
        SupportFilesSetup.deleteFile("extinout/t1.del");
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_EXPORT_TABLE (null, 'T1' , 'extinout/t1.del' , null, null, null) ");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_IMPORT_DATA(null, 'T1' , 'A' , '1' , 'extinout/t1.del' , null, null, null, 0) ");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        connection.rollback();
        resultSet = statement.executeQuery(" select * from t1");
        stringArray = new String[]{"A"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1"}, {"2"}, {"1"}, {"2"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate(" insert into t1 values(3) ");
        statement.executeUpdate(" insert into t1 values(4) ");
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_IMPORT_DATA(null, 'T1', 'A' , '1'  , 'extinout/nofile.del' , null, null, null, 0) ");
        ImportExportProcedureTest.assertStatementError("38000", callableStatement);
        connection.commit();
        resultSet = statement.executeQuery(" select * from t1 ");
        stringArray = new String[]{"A"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1"}, {"2"}, {"1"}, {"2"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate(" insert into t1 values(3) ");
        statement.executeUpdate(" insert into t1 values(4) ");
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_IMPORT_DATA(null, 'NOTABLE' , 'A' , '1', 'extinout/t1.del' , null, null, null, 1) ");
        ImportExportProcedureTest.assertStatementError("XIE0M", callableStatement);
        connection.commit();
        resultSet = statement.executeQuery(" select * from t1 ");
        stringArray = new String[]{"A"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1"}, {"2"}, {"1"}, {"2"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        connection.setAutoCommit(true);
        statement.executeUpdate("insert into t1 values(3) ");
        statement.executeUpdate(" insert into t1 values(4) ");
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_IMPORT_DATA(null, 'T1' , 'A' , '1' , 'extinout/t1.del' , null, null, null, 0) ");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        resultSet = statement.executeQuery(" select * from t1 ");
        stringArray = new String[]{"A"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1"}, {"2"}, {"1"}, {"2"}, {"3"}, {"4"}, {"1"}, {"2"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate(" insert into t1 values(5) ");
        statement.executeUpdate(" insert into t1 values(6) ");
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_IMPORT_DATA(null, 'T1', 'A' , '1'  , 'extinout/nofile.del' , null, null, null, 0) ");
        ImportExportProcedureTest.assertStatementError("38000", callableStatement);
        resultSet = statement.executeQuery(" select * from t1 ");
        stringArray = new String[]{"A"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1"}, {"2"}, {"1"}, {"2"}, {"3"}, {"4"}, {"1"}, {"2"}, {"5"}, {"6"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate("create table alltypes(chartype char(20) , biginttype bigint , datetype date , decimaltype decimal(10,5) , doubletype double , inttype integer , lvartype long varchar , realtype real , sminttype smallint , timetype time , tstamptype timestamp , vartype varchar(50))");
        statement.executeUpdate(" insert into  alltypes values('chartype string' , 9223372036854775807, '1993-10-29' , 12345.54321, 10E307, 2147483647, 'long varchar testing', 10E3, 32767, '09.39.43', '2004-09-09 11:14:11', 'varchar testing')");
        statement.executeUpdate(" insert into  alltypes values('chartype string' , -9223372036854775808, '1993-10-29' , 0.0, -10E307, -2147483647, 'long varchar testing', -10E3, 32767, '09.39.43', '2004-09-09 11:14:11', 'varchar testing')");
        statement.executeUpdate(" insert into  alltypes values('\"chartype\" string' , 9223372036854775807, '1993-10-29' , -12345.54321, 10E307, 2147483647, 'long \"varchar\" testing', 10E3, 32767, '09.39.43', '2004-09-09 11:14:11', '\"varchar\" testing')");
        SupportFilesSetup.deleteFile("extinout/alltypes.del");
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_EXPORT_TABLE (null, 'ALLTYPES' , 'extinout/alltypes.del' , null, null, null) ");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_IMPORT_TABLE (null, 'ALLTYPES' , 'extinout/alltypes.del' , null, null, null, 0) ");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        resultSet = statement.executeQuery(" select * from alltypes ");
        stringArray = new String[]{"CHARTYPE", "BIGINTTYPE", "DATETYPE", "DECIMALTYPE", "DOUBLETYPE", "INTTYPE", "LVARTYPE", "REALTYPE", "SMINTTYPE", "TIMETYPE", "TSTAMPTYPE", "VARTYPE"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"chartype string", "9223372036854775807", "1993-10-29", "12345.54321", "1.0E308", "2147483647", "long varchar testing", "10000.0", "32767", "09:39:43", "2004-09-09 11:14:11.0", "varchar testing"}, {"chartype string", "-9223372036854775808", "1993-10-29", "0.00000", "-1.0E308", "-2147483647", "long varchar testing", "-10000.0", "32767", "09:39:43", "2004-09-09 11:14:11.0", "varchar testing"}, {"\"chartype\" string", "9223372036854775807", "1993-10-29", "-12345.54321", "1.0E308", "2147483647", "long \"varchar\" testing", "10000.0", "32767", "09:39:43", "2004-09-09 11:14:11.0", "\"varchar\" testing"}, {"chartype string", "9223372036854775807", "1993-10-29", "12345.54321", "1.0E308", "2147483647", "long varchar testing", "10000.0", "32767", "09:39:43", "2004-09-09 11:14:11.0", "varchar testing"}, {"chartype string", "-9223372036854775808", "1993-10-29", "0.00000", "-1.0E308", "-2147483647", "long varchar testing", "-10000.0", "32767", "09:39:43", "2004-09-09 11:14:11.0", "varchar testing"}, {"\"chartype\" string", "9223372036854775807", "1993-10-29", "-12345.54321", "1.0E308", "2147483647", "long \"varchar\" testing", "10000.0", "32767", "09:39:43", "2004-09-09 11:14:11.0", "\"varchar\" testing"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        ImportExportProcedureTest.assertUpdateCount(statement, 6, " delete from alltypes");
        statement.executeUpdate("create table test1(a char(20)) ");
        statement.executeUpdate(" create trigger trig_import after INSERT on alltypes referencing new as newrow for each  row insert into test1 values(newrow.chartype)");
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_IMPORT_TABLE (null, 'ALLTYPES' , 'extinout/alltypes.del' , null, null, null, 0) ");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        resultSet = statement.executeQuery(" select count(*) from alltypes ");
        stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"3"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" select * from test1");
        stringArray = new String[]{"A"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"chartype string"}, {"chartype string"}, {"\"chartype\" string"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        ImportExportProcedureTest.assertUpdateCount(statement, 3, " delete from alltypes");
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_IMPORT_TABLE (null, 'ALLTYPES' , 'extinout/alltypes.del' , null, null, null, 1) ");
        ImportExportProcedureTest.assertStatementError("38000", callableStatement);
        resultSet = statement.executeQuery(" select count(*) from alltypes");
        stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"0"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate(" drop trigger trig_import");
        statement.executeUpdate(" drop table test1");
        statement.executeUpdate("create table table1(c1 char(30), c2 int generated always as identity, c3 real, c4 char(1))");
        statement.executeUpdate(" create table table2(c1 char(30), c2 int, c3 real, c4 char(1))");
        statement.executeUpdate(" insert into table2 values('Robert',100, 45.2, 'J')");
        statement.executeUpdate(" insert into table2 values('Mike',101, 76.9, 'K')");
        statement.executeUpdate(" insert into table2 values('Leo',102, 23.4, 'I')");
        SupportFilesSetup.deleteFile("extinout/import.del");
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_EXPORT_QUERY('select c1,c3,c4 from table2' , 'extinout/import.del' , null, null, null) ");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        callableStatement = this.prepareCall(" CALL SYSCS_UTIL.SYSCS_IMPORT_DATA(NULL,'TABLE1', 'C1,C3,C4' , null, 'extinout/import.del',null, null,null,0)");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        resultSet = statement.executeQuery(" select * from table1");
        stringArray = new String[]{"C1", "C2", "C3", "C4"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"Robert", "1", "45.2", "J"}, {"Mike", "2", "76.9", "K"}, {"Leo", "3", "23.4", "I"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        ImportExportProcedureTest.assertUpdateCount(statement, 3, " delete from table1");
        SupportFilesSetup.deleteFile("extinout/import.del");
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_EXPORT_TABLE(null , 'TABLE2' , 'extinout/import.del',  null, null, null) ");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        callableStatement = this.prepareCall("CALL SYSCS_UTIL.SYSCS_IMPORT_TABLE(NULL, 'TABLE1', 'extinout/import.del',null, null, null,1)");
        ImportExportProcedureTest.assertStatementError("38000", callableStatement);
        callableStatement = this.prepareCall("CALL SYSCS_UTIL.SYSCS_IMPORT_DATA(NULL, 'TABLE1', 'C1,C3,C4' , '1,3,4', 'extinout/import.del',null, null, null,1)");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        resultSet = statement.executeQuery(" select * from table1");
        stringArray = new String[]{"C1", "C2", "C3", "C4"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"Robert", "1", "45.2", "J"}, {"Mike", "2", "76.9", "K"}, {"Leo", "3", "23.4", "I"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        ImportExportProcedureTest.assertUpdateCount(statement, 3, " update table2 set c2=null");
        SupportFilesSetup.deleteFile("extinout/import.del");
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_EXPORT_TABLE(null , 'TABLE2' , 'extinout/import.del' , null, null, null) ");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        callableStatement = this.prepareCall(" CALL SYSCS_UTIL.SYSCS_IMPORT_TABLE(NULL, 'TABLE1', 'extinout/import.del',null, null, null,1)");
        ImportExportProcedureTest.assertStatementError("38000", callableStatement);
        resultSet = statement.executeQuery(" select * from table1");
        stringArray = new String[]{"C1", "C2", "C3", "C4"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"Robert", "1", "45.2", "J"}, {"Mike", "2", "76.9", "K"}, {"Leo", "3", "23.4", "I"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate("create table parent(a int not null primary key)");
        statement.executeUpdate(" insert into parent values (1) , (2) , (3) , (4) ");
        statement.executeUpdate(" create table child(b int references parent(a))");
        statement.executeUpdate(" insert into child values (1) , (2) , (3) , (4) ");
        SupportFilesSetup.deleteFile("extinout/parent.del");
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_EXPORT_QUERY('select * from parent where a < 3' , 'extinout/parent.del' , null, null, null) ");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        callableStatement = this.prepareCall("CALL SYSCS_UTIL.SYSCS_IMPORT_TABLE(NULL, 'PARENT', 'extinout/parent.del',null, null, null,1)");
        ImportExportProcedureTest.assertStatementError("XIE0R", callableStatement);
        resultSet = statement.executeQuery(" select * from parent");
        stringArray = new String[]{"A"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1"}, {"2"}, {"3"}, {"4"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate("create table nt1( a int , b char(30))");
        callableStatement = this.prepareCall(" CALL SYSCS_UTIL.SYSCS_IMPORT_TABLE(NULL, 'NT1', 'extin/mixednl.del',null, null, 'UTF-8',0)");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        resultSet = statement.executeQuery(" select * from nt1");
        stringArray = new String[]{"A", "B"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"0", "XXXXXX0"}, {"1", "XXXXXX1"}, {"2", "XXXXXX2"}, {"3", "XXXXXX3"}, {"4", "XXXXXX4"}, {"5", "YYYYY5"}, {"6", "YYYYY6"}, {"7", "YYYYY7"}, {"8", "YYYYY8"}, {"9", "YYYYY9"}, {"10", "ZZZZZZ10"}, {"11", "ZZZZZZ11"}, {"12", "ZZZZZZ12"}, {"13", "ZZZZZZ13"}, {"14", "ZZZZZZ14"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate(" drop table nt1 ");
        statement.executeUpdate("create table position_info ( position_code varchar(10) not null , literal_no int not null , job_category_code varchar(10), summary_description long varchar, detail_description long varchar, web_flag varchar(1) )");
        callableStatement = this.prepareCall(" CALL SYSCS_UTIL.SYSCS_IMPORT_TABLE ('APP', 'POSITION_INFO', 'extin/position_info.del', null, null, 'US-ASCII', 1)");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        resultSet = statement.executeQuery(" select count(*) from position_info ");
        stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"680"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" select detail_description from position_info where position_code='AG1000'");
        stringArray = new String[]{"DETAIL_DESCRIPTION"};
        JDBC.assertColumnNames(resultSet, stringArray);
        resultSet.next();
        String string = resultSet.getString(1);
        ImportExportProcedureTest.assertTrue((boolean)string.startsWith("Essential Duties and Responsibilities (include"));
        SupportFilesSetup.deleteFile("extinout/pinfo.del");
        callableStatement = this.prepareCall(" CALL SYSCS_UTIL.SYSCS_EXPORT_TABLE ('APP', 'POSITION_INFO', 'extinout/pinfo.del', null, null, null)");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        ImportExportProcedureTest.assertUpdateCount(statement, 680, " delete from position_info");
        callableStatement = this.prepareCall(" CALL SYSCS_UTIL.SYSCS_IMPORT_TABLE ('APP', 'POSITION_INFO', 'extinout/pinfo.del', null, null, null, 1)");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        resultSet = statement.executeQuery(" select count(*) from position_info ");
        stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"680"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" select detail_description from position_info where position_code='AG1000'");
        stringArray = new String[]{"DETAIL_DESCRIPTION"};
        JDBC.assertColumnNames(resultSet, stringArray);
        resultSet.next();
        string = resultSet.getString(1);
        ImportExportProcedureTest.assertTrue((boolean)string.startsWith("Essential Duties and Responsibilities (include"));
        SupportFilesSetup.deleteFile("extinout/autoinc.dat");
        callableStatement = this.prepareCall("CALL SYSCS_UTIL.SYSCS_EXPORT_QUERY('values(1),(2),(3)','extinout/autoinc.dat',null,null,null)");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        statement.executeUpdate(" create table dest_always(i int generated always as identity)");
        statement.executeUpdate(" create table dest_by_default(i int generated by default as identity)");
        callableStatement = this.prepareCall(" CALL SYSCS_UTIL.SYSCS_IMPORT_TABLE('APP','DEST_ALWAYS','extinout/autoinc.dat',null,null,null,0)");
        ImportExportProcedureTest.assertStatementError("38000", callableStatement);
        resultSet = statement.executeQuery(" select * from dest_always");
        stringArray = new String[]{"I"};
        JDBC.assertColumnNames(resultSet, stringArray);
        JDBC.assertDrainResults(resultSet, 0);
        callableStatement = this.prepareCall(" CALL SYSCS_UTIL.SYSCS_IMPORT_TABLE('APP','DEST_BY_DEFAULT','extinout/autoinc.dat',null,null,null,0)");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        resultSet = statement.executeQuery(" select * from dest_by_default");
        stringArray = new String[]{"I"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1"}, {"2"}, {"3"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate(" drop table dest_always");
        statement.executeUpdate(" drop table dest_by_default");
        statement.executeUpdate(" create table dest_always(i int generated always as identity)");
        statement.executeUpdate(" create table dest_by_default(i int generated by default as identity)");
        callableStatement = this.prepareCall(" CALL SYSCS_UTIL.SYSCS_IMPORT_TABLE('APP','DEST_ALWAYS','extinout/autoinc.dat',null,null,null,1)");
        ImportExportProcedureTest.assertStatementError("38000", callableStatement);
        resultSet = statement.executeQuery(" select * from dest_always");
        stringArray = new String[]{"I"};
        JDBC.assertColumnNames(resultSet, stringArray);
        JDBC.assertDrainResults(resultSet, 0);
        callableStatement = this.prepareCall(" CALL SYSCS_UTIL.SYSCS_IMPORT_TABLE('APP','DEST_BY_DEFAULT','extinout/autoinc.dat',null,null,null,1)");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        resultSet = statement.executeQuery(" select * from dest_by_default");
        stringArray = new String[]{"I"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1"}, {"2"}, {"3"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate(" drop table dest_always");
        statement.executeUpdate(" drop table dest_by_default");
        statement.executeUpdate("create schema \"Group\"");
        statement.executeUpdate(" create table \"Group\".\"Order\"(\"select\" int, \"delete\" int, itemName char(20)) ");
        statement.executeUpdate(" insert into \"Group\".\"Order\" values(1, 2, 'memory') ");
        statement.executeUpdate(" insert into \"Group\".\"Order\" values(3, 4, 'disk') ");
        statement.executeUpdate(" insert into \"Group\".\"Order\" values(5, 6, 'mouse') ");
        SupportFilesSetup.deleteFile("extinout/order.dat");
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_EXPORT_TABLE ('GROUP', 'Order' , 'extinout/order.dat', null, null, null) ");
        ImportExportProcedureTest.assertStatementError("38000", callableStatement);
        SupportFilesSetup.deleteFile("extinout/order.dat");
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_EXPORT_TABLE ('Group', 'ORDER' , 'extinout/order.dat', null, null, null) ");
        ImportExportProcedureTest.assertStatementError("38000", callableStatement);
        SupportFilesSetup.deleteFile("extinout/order.dat");
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_EXPORT_QUERY('select * from \"Group\".Order' , 'extinout/order.dat' ,    null , null , null ) ");
        ImportExportProcedureTest.assertStatementError("38000", callableStatement);
        SupportFilesSetup.deleteFile("extinout/order.dat");
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_EXPORT_TABLE ('Group', 'Order' , 'extinout/order.dat', null, null, null) ");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        SupportFilesSetup.deleteFile("extinout/order.dat");
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_EXPORT_QUERY('select * from \"Group\".\"Order\"' , 'extinout/order.dat' ,    null , null , null ) ");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        SupportFilesSetup.deleteFile("extinout/order.dat");
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_EXPORT_QUERY('select \"select\" , \"delete\" , itemName from \"Group\".\"Order\"' , 'extinout/order.dat' ,    null , null , null ) ");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_IMPORT_TABLE ('GROUP', 'Order' , 'extinout/order.dat', null, null, null, 0) ");
        ImportExportProcedureTest.assertStatementError("XIE0M", callableStatement);
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_IMPORT_TABLE ('Group', 'ORDER' , 'extinout/order.dat', null, null, null, 0) ");
        ImportExportProcedureTest.assertStatementError("XIE0M", callableStatement);
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_IMPORT_DATA('Group', 'ORDER' , null , null ,   'extinout/order.dat'   , null , null , null, 1) ");
        ImportExportProcedureTest.assertStatementError("XIE0M", callableStatement);
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_IMPORT_DATA('Group', 'Order' , 'DELETE, ITEMNAME' , '2, 3' ,   'extinout/order.dat'   , null , null , null, 1) ");
        ImportExportProcedureTest.assertStatementError("XIE08", callableStatement);
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_IMPORT_DATA('Group', 'Order' , 'delete, itemName' , '2, 3' ,   'extinout/order.dat'   , null , null , null, 1) ");
        ImportExportProcedureTest.assertStatementError("XIE08", callableStatement);
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_IMPORT_TABLE ('Group', 'Order' , 'extinout/order.dat', null, null, null, 0) ");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        resultSet = statement.executeQuery(" select * from \"Group\".\"Order\"");
        stringArray = new String[]{"select", "delete", "ITEMNAME"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "2", "memory"}, {"3", "4", "disk"}, {"5", "6", "mouse"}, {"1", "2", "memory"}, {"3", "4", "disk"}, {"5", "6", "mouse"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_IMPORT_DATA('Group', 'Order' , null , null ,   'extinout/order.dat'   , null , null , null, 1) ");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        resultSet = statement.executeQuery(" select * from \"Group\".\"Order\"");
        stringArray = new String[]{"select", "delete", "ITEMNAME"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "2", "memory"}, {"3", "4", "disk"}, {"5", "6", "mouse"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_IMPORT_DATA('Group', 'Order' , 'delete' , '2' ,   'extinout/order.dat'   , null , null , null, 1) ");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        resultSet = statement.executeQuery(" select * from \"Group\".\"Order\"");
        stringArray = new String[]{"select", "delete", "ITEMNAME"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{null, "2", null}, {null, "4", null}, {null, "6", null}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_IMPORT_DATA('Group', 'Order' , 'ITEMNAME, select, delete' , '3,2,1' ,   'extinout/order.dat'   , null , null , null, 1) ");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        resultSet = statement.executeQuery(" select * from \"Group\".\"Order\"");
        stringArray = new String[]{"select", "delete", "ITEMNAME"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"2", "1", "memory"}, {"4", "3", "disk"}, {"6", "5", "mouse"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate("create schema inventory");
        statement.executeUpdate(" create table inventory.orderTable(id int, amount int, itemName char(20)) ");
        statement.executeUpdate(" insert into inventory.orderTable values(101, 5, 'pizza') ");
        statement.executeUpdate(" insert into inventory.orderTable values(102, 6, 'coke') ");
        statement.executeUpdate(" insert into inventory.orderTable values(103, 7, 'break sticks') ");
        statement.executeUpdate(" insert into inventory.orderTable values(104, 8, 'buffolo wings') ");
        SupportFilesSetup.deleteFile("extinout/order.dat");
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_EXPORT_TABLE ('inventory', 'ORDERTABLE' , 'extinout/order.dat', null, null, null) ");
        ImportExportProcedureTest.assertStatementError("38000", callableStatement);
        SupportFilesSetup.deleteFile("extinout/order.dat");
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_EXPORT_TABLE ('INVENTORY', 'ordertable' , 'extinout/order.dat', null, null, null) ");
        ImportExportProcedureTest.assertStatementError("38000", callableStatement);
        SupportFilesSetup.deleteFile("extinout/order.dat");
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_EXPORT_TABLE ('INVENTORY', 'ORDERTABLE' , 'extinout/order.dat', null, null, null) ");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_IMPORT_TABLE ('inventory', 'ORDERTABLE' , 'extinout/order.dat', null, null, null, 0) ");
        ImportExportProcedureTest.assertStatementError("XIE0M", callableStatement);
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_IMPORT_TABLE ('INVENTORY', 'ordertable' , 'extinout/order.dat', null, null, null, 0) ");
        ImportExportProcedureTest.assertStatementError("XIE0M", callableStatement);
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_IMPORT_DATA('INVENTORY', 'ordertable' , null , null ,   'extinout/order.dat'   , null , null , null, 1) ");
        ImportExportProcedureTest.assertStatementError("XIE0M", callableStatement);
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_IMPORT_DATA('INVENTORY', 'ORDERTABLE' , 'amount, ITEMNAME' , '2, 3' ,   'extinout/order.dat'   , null , null , null, 1) ");
        ImportExportProcedureTest.assertStatementError("XIE08", callableStatement);
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_IMPORT_DATA('INVENTORY', 'ORDERTABLE' , null , null ,   'extinout/order.dat'   , null , null , null, 1) ");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        resultSet = statement.executeQuery(" select * from inventory.orderTable");
        stringArray = new String[]{"ID", "AMOUNT", "ITEMNAME"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"101", "5", "pizza"}, {"102", "6", "coke"}, {"103", "7", "break sticks"}, {"104", "8", "buffolo wings"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_IMPORT_DATA('INVENTORY', 'ORDERTABLE' , 'ITEMNAME, ID, AMOUNT' , '3,2,1' ,   'extinout/order.dat'   , null , null , null, 1) ");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        resultSet = statement.executeQuery(" select * from inventory.orderTable");
        stringArray = new String[]{"ID", "AMOUNT", "ITEMNAME"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"5", "101", "pizza"}, {"6", "102", "coke"}, {"7", "103", "break sticks"}, {"8", "104", "buffolo wings"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate(" drop table inventory.orderTable");
        this.getConnection().rollback();
        statement.close();
    }

    public void test4555ColumnIndexesParsing() throws Exception {
        Statement statement = this.createStatement();
        statement.executeUpdate(" create table pet(C1 varchar(50), C2 varchar(50) , C3 varchar(50))");
        statement.executeUpdate("insert into pet values('Pet', 'Kind' , 'Age')");
        statement.executeUpdate("insert into pet values('Name', 'of' , null)");
        statement.executeUpdate("insert into pet values(null, 'Animal' , null)");
        statement.executeUpdate("insert into pet values('Rover', 'Dog' , '4')");
        statement.executeUpdate("insert into pet values('Spot', 'Cat' , '2')");
        statement.executeUpdate("insert into pet values('Squawky','Parrot','37')");
        statement.executeUpdate(" create table pet1(C1 varchar(50), C2 varchar(50) , C3 int NOT NULL)");
        SupportFilesSetup.deleteFile("extinout/pet.dat");
        statement.executeUpdate("call SYSCS_UTIL.SYSCS_EXPORT_TABLE (null, 'PET' , 'extinout/pet.dat', null, null, null) ");
        statement.executeUpdate("delete from pet");
        CallableStatement callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_IMPORT_DATA_BULK(null, 'PET' , null , '1,2,\"Age\"' ,   'extinout/pet.dat'   , null , null , null, 0, 3) ");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        JDBC.assertFullResultSet(statement.executeQuery("select * from pet"), new String[][]{{"Rover", "Dog", "4"}, {"Spot", "Cat", "2"}, {"Squawky", "Parrot", "37"}});
        statement.executeUpdate("delete from pet");
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_IMPORT_DATA_BULK(null, 'PET' , null , '\"Pet Name\",\"Kind of Animal\",\"Age\"' ,   'extinout/pet.dat'   , null , null , null, 0, 3) ");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        JDBC.assertFullResultSet(statement.executeQuery("select * from pet"), new String[][]{{"Rover", "Dog", "4"}, {"Spot", "Cat", "2"}, {"Squawky", "Parrot", "37"}});
        statement.executeUpdate("delete from pet");
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_IMPORT_DATA_BULK(null, 'PET' , 'C3,C1,C2' , '\"Age\",1,2' ,   'extinout/pet.dat'   , null , null ,null , 0, 3) ");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        JDBC.assertFullResultSet(statement.executeQuery("select * from Pet"), new String[][]{{"Rover", "Dog", "4"}, {"Spot", "Cat", "2"}, {"Squawky", "Parrot", "37"}});
        statement.executeUpdate("delete from pet");
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_IMPORT_DATA_BULK(null, 'PET' , null , '\"Pet\",2,3' ,   'extinout/pet.dat'   , null , null , null, 0, 3) ");
        ImportExportProcedureTest.assertStatementError("42XAU", callableStatement);
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_IMPORT_DATA_BULK(null, 'PET' , null , '\"Pet Name\",2,3' ,   'extinout/petlist.dat'   , null , null , null, 0, 0) ");
        ImportExportProcedureTest.assertStatementError("42XAV", callableStatement);
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_IMPORT_DATA_BULK(null, 'PET' , null , '\"Pet Name\",2,3' ,   'extinout/petlist.dat'   , null , null , null, 0, 2) ");
        ImportExportProcedureTest.assertStatementError("XIE04", callableStatement);
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_IMPORT_DATA_BULK(null, 'PET' , null , '1,2,\"Age\"' ,   'extinout/pet.dat'   , null , null , null, 0, 0) ");
        ImportExportProcedureTest.assertStatementError("42XAV", callableStatement);
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_IMPORT_DATA_BULK(null, 'PET1' , null , '1,2,\"Age\"' ,   'extinout/pet.dat'   , null , null , null, 0, 1) ");
        ImportExportProcedureTest.assertStatementError("XIE0R", callableStatement);
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_IMPORT_DATA_BULK(null, 'PET1' , null , '\"Pet\"\"Kind\"\"Age\"' ,   'extinout/pet.dat'   , null , null , null, 0, 1) ");
        ImportExportProcedureTest.assertStatementError("42XAU", callableStatement);
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_IMPORT_DATA_BULK(null, 'PET' , null , '1,2,\"Age\"' ,   'extinout/pet.dat'   , null , null , null, 0, 7) ");
        ImportExportProcedureTest.assertStatementError("42XAU", callableStatement);
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_IMPORT_DATA_BULK(null, 'PET' , null , '1,2,\"AGE\"' ,   'extinout/pet.dat'   , null , null , null, 0, 3) ");
        ImportExportProcedureTest.assertStatementError("42XAU", callableStatement);
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_IMPORT_DATA_BULK(null, 'PET' , null , '1,\"Kind of Animal\",\"Age\"' ,   'extinout/pet.dat'   , null , null , null, 0, 3) ");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        JDBC.assertFullResultSet(statement.executeQuery("select * from pet"), new String[][]{{"Rover", "Dog", "4"}, {"Spot", "Cat", "2"}, {"Squawky", "Parrot", "37"}});
        statement.executeUpdate("delete from pet");
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_IMPORT_DATA_BULK(null, 'PET' , null , '\"Pet\"\"Name\",\"Kind\"\"of\"\"Animal\",\"Age\"' ,   'extinout/pet.dat'   , null , null , null, 0, 3) ");
        ImportExportProcedureTest.assertStatementError("42XAU", callableStatement);
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_IMPORT_DATA_BULK(null, 'PET1' , null , '\"Pet Name\",\"Kind of\",\"Age\"' ,   'extinout/pet.dat'   , null , null , null, 0, 2) ");
        try {
            callableStatement.execute();
        }
        catch (SQLException sQLException) {
            ImportExportProcedureTest.assertSQLState("XIE0R", sQLException);
            ImportExportProcedureTest.assertTrue((String)("not column C3:" + sQLException.getMessage()), (sQLException.getMessage().indexOf("C3") >= 0 ? 1 : 0) != 0);
        }
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_IMPORT_DATA_BULK(null, 'PET' , null , '\"Pet Name Rover\",2,3' ,   'extinout/pet.dat'   , null , null , null, 0, 4) ");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        JDBC.assertFullResultSet(statement.executeQuery("select * from pet"), new String[][]{{"Spot", "Cat", "2"}, {"Squawky", "Parrot", "37"}});
        statement.executeUpdate("delete from pet");
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_IMPORT_DATA_BULK(null, 'PET' , null , '1,2,\"Age 4\"' ,   'extinout/pet.dat'   , null , null , null, 0, 4) ");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        JDBC.assertFullResultSet(statement.executeQuery("select * from pet"), new String[][]{{"Spot", "Cat", "2"}, {"Squawky", "Parrot", "37"}});
        statement.executeUpdate("delete from pet");
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_IMPORT_DATA_BULK(null, 'PET' , null , '1,\"Kind of Animal Dog\",3' ,   'extinout/pet.dat'   , null , null , null, 0, 4) ");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        JDBC.assertFullResultSet(statement.executeQuery("select * from pet"), new String[][]{{"Spot", "Cat", "2"}, {"Squawky", "Parrot", "37"}});
        statement.executeUpdate("delete from pet");
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_IMPORT_DATA_BULK(null, 'PET' , null , '1,2' ,   'extinout/pet.dat'   , null , null , null, 0, 3) ");
        ImportExportProcedureTest.assertStatementError("42802", callableStatement);
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_IMPORT_DATA_BULK(null, 'PET' , null , '1,\"Kind of Animal\"' ,   'extinout/pet.dat'   , null , null , null, 0, 3) ");
        ImportExportProcedureTest.assertStatementError("42802", callableStatement);
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_IMPORT_DATA_BULK(null, 'PET' , null , '1,\"Age\"' ,   'extinout/pet.dat'   , null , null , null, 0, 3) ");
        ImportExportProcedureTest.assertStatementError("42802", callableStatement);
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_IMPORT_DATA_BULK(null, 'PET' , null , '1,2,3' ,   'extinout/pet.dat'   , null , null , null, 0, -2) ");
        ImportExportProcedureTest.assertStatementError("42XAV", callableStatement);
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_IMPORT_DATA_BULK(null, 'PET' , null , '1,2,3' ,   'extinout/pet.dat'   , null , null , null, 0, -1) ");
        ImportExportProcedureTest.assertStatementError("42XAV", callableStatement);
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_IMPORT_DATA_BULK(null, 'PET' , 'C1,C2' , '1,2' ,   'extinout/pet.dat'   , null , null , null, 0, 3) ");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        JDBC.assertFullResultSet(statement.executeQuery("select C1,C2 from pet"), new String[][]{{"Rover", "Dog"}, {"Spot", "Cat"}, {"Squawky", "Parrot"}});
        statement.executeUpdate("delete from pet");
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_IMPORT_DATA_BULK(null, 'PET1' , 'C1,C2' , '1,3' ,   'extinout/pet.dat'   , null , null , null, 0, 3) ");
        ImportExportProcedureTest.assertStatementError("XIE0R", callableStatement);
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_IMPORT_DATA_BULK(null, 'PET' , 'C1,C3' , '1,3' ,   'extinout/pet.dat'   , null , null , null, 0, 3) ");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        JDBC.assertFullResultSet(statement.executeQuery("select C1,C3 from pet"), new String[][]{{"Rover", "4"}, {"Spot", "2"}, {"Squawky", "37"}});
        statement.executeUpdate("delete from pet");
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_IMPORT_DATA_BULK(null, 'PET' , 'C1,C2' , '\"Pet Name\",\"Kind of Animal\"' ,   'extinout/pet.dat'   , null , null , null, 0, 3) ");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        JDBC.assertFullResultSet(statement.executeQuery("select C1,C2 from pet"), new String[][]{{"Rover", "Dog"}, {"Spot", "Cat"}, {"Squawky", "Parrot"}});
        statement.executeUpdate("delete from pet");
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_IMPORT_TABLE_BULK(null, 'PET', 'extinout/petlist.dat', null, null, null, 0, 0) ");
        ImportExportProcedureTest.assertStatementError("38000", callableStatement);
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_IMPORT_TABLE_BULK(null, 'PET', 'extinout/petlist.dat', null, null, null, 0, 2) ");
        ImportExportProcedureTest.assertStatementError("XJ001", callableStatement);
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_IMPORT_TABLE_BULK(null, 'PET', 'extinout/pet.dat', null, null, null, 0, -1) ");
        ImportExportProcedureTest.assertStatementError("42XAV", callableStatement);
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_IMPORT_TABLE_BULK(null, 'PET', 'extinout/pet.dat', null, null, null, 0, 7) ");
        try {
            callableStatement.execute();
        }
        catch (SQLException sQLException) {
            ImportExportProcedureTest.assertSQLState("XIE0E", sQLException);
            ImportExportProcedureTest.assertTrue((String)("not line 7:" + sQLException.getMessage()), (sQLException.getMessage().indexOf("7") >= 0 ? 1 : 0) != 0);
        }
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_IMPORT_DATA(null, 'PET1' , null , '1,2,\"AGE\"' ,   'extinout/pet.dat'   , null , null , null, 0) ");
        ImportExportProcedureTest.assertStatementError("42XAV", callableStatement);
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_IMPORT_DATA(null, 'PET1' , null , '1,2,AGE' ,   'extinout/pet.dat'   , null , null , null, 0) ");
        ImportExportProcedureTest.assertStatementError("38000", callableStatement);
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_IMPORT_DATA(null, 'PET1' , null , '1,2,4' ,   'extinout/pet.dat'   , null , null , null, 0) ");
        ImportExportProcedureTest.assertStatementError("38000", callableStatement);
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_IMPORT_DATA(null, 'PET' , null , '1,2,3' ,   'extinout/petlist.dat'   , null , null , null, 0) ");
        ImportExportProcedureTest.assertStatementError("38000", callableStatement);
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_IMPORT_DATA_LOBS_FROM_EXTFILE(null, 'PET1' , null , '1,2,\"AGE\"' ,   'extinout/pet.dat'   , null , null , null, 0) ");
        ImportExportProcedureTest.assertStatementError("42XAV", callableStatement);
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_IMPORT_DATA_LOBS_FROM_EXTFILE(null, 'PET1' , null , '1,2,AGE' ,   'extinout/pet.dat'   , null , null , null, 0) ");
        ImportExportProcedureTest.assertStatementError("38000", callableStatement);
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_IMPORT_DATA_LOBS_FROM_EXTFILE(null, 'PET1' , null , '1,2,4' ,   'extinout/pet.dat'   , null , null , null, 0) ");
        ImportExportProcedureTest.assertStatementError("38000", callableStatement);
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_IMPORT_DATA_LOBS_FROM_EXTFILE(null, 'PET' , null , '1,2,3' ,   'extinout/petlist.dat'   , null , null , null, 0) ");
        ImportExportProcedureTest.assertStatementError("38000", callableStatement);
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_IMPORT_TABLE(null, 'PET', 'extinout/petlist.dat', null, null, null, 0) ");
        ImportExportProcedureTest.assertStatementError("38000", callableStatement);
        statement.executeUpdate(" create table pet2(C1 varchar(50), C2 varchar(50))");
        statement.executeUpdate("insert into pet2 values('Rover', 'Dog')");
        statement.executeUpdate("insert into pet2 values('Spot', 'Cat')");
        statement.executeUpdate("insert into pet2 values('Squawky','Parrot')");
        SupportFilesSetup.deleteFile("extinout/pet2.dat");
        statement.executeUpdate("call SYSCS_UTIL.SYSCS_EXPORT_TABLE (null, 'PET2' , 'extinout/pet2.dat', null, null, null) ");
        statement.executeUpdate("delete from pet2");
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_IMPORT_TABLE(null, 'PET2', 'extinout/pet2.dat', null, null, null, 0) ");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        JDBC.assertFullResultSet(statement.executeQuery("select * from pet2"), new String[][]{{"Rover", "Dog"}, {"Spot", "Cat"}, {"Squawky", "Parrot"}});
        statement.executeUpdate("delete from pet2");
        statement.executeUpdate(" create table pet3(C1 varchar(50),C2 int, C3 varchar(50))");
        statement.executeUpdate("insert into pet3 values('Rover', 4, 'Dog')");
        statement.executeUpdate("insert into pet3 values('Spot', 2,'Cat')");
        statement.executeUpdate("insert into pet3 values('Squawky',37,'Parrot')");
        SupportFilesSetup.deleteFile("extinout/pet3.dat");
        statement.executeUpdate("call SYSCS_UTIL.SYSCS_EXPORT_TABLE (null, 'PET3' , 'extinout/pet3.dat', null, null, null) ");
        statement.executeUpdate("delete from pet3");
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_IMPORT_TABLE(null, 'PET3', 'extinout/pet3.dat', null, null, null, 0) ");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        JDBC.assertFullResultSet(statement.executeQuery("select * from pet3"), new String[][]{{"Rover", "4", "Dog"}, {"Spot", "2", "Cat"}, {"Squawky", "37", "Parrot"}});
        statement.executeUpdate("delete from pet3");
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_IMPORT_TABLE_LOBS_FROM_EXTFILE(null, 'PET', 'extinout/petlist.dat', null, null, null, 0) ");
        ImportExportProcedureTest.assertStatementError("38000", callableStatement);
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_IMPORT_TABLE_LOBS_FROM_EXTFILE(null, 'PET2', 'extinout/pet2.dat', null, null, null, 0) ");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        JDBC.assertFullResultSet(statement.executeQuery("select * from pet2"), new String[][]{{"Rover", "Dog"}, {"Spot", "Cat"}, {"Squawky", "Parrot"}});
        statement.executeUpdate("delete from pet2");
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_IMPORT_TABLE_LOBS_FROM_EXTFILE(null, 'PET3', 'extinout/pet3.dat', null, null, null, 0) ");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        JDBC.assertFullResultSet(statement.executeQuery("select * from pet3"), new String[][]{{"Rover", "4", "Dog"}, {"Spot", "2", "Cat"}, {"Squawky", "37", "Parrot"}});
        statement.executeUpdate("delete from pet3");
    }

    public void testImportExportProcedureNegative() throws Exception {
        ResultSet resultSet = null;
        Statement statement = this.createStatement();
        statement.executeUpdate("create schema iep");
        statement.executeUpdate(" create table iep.t1(a int)");
        statement.executeUpdate(" insert into iep.t1 values(100) , (101) , (102) , (103) , (104) , (105) , (106)");
        SupportFilesSetup.deleteFile("extout/nodir/t1.dat");
        CallableStatement callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_EXPORT_TABLE ('IEP', 'T1' , 'extout/nodir/t1.dat' , null, null, null) ");
        ImportExportProcedureTest.assertStatementError("XIE0I", callableStatement);
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_EXPORT_TABLE ('IEP', 'NOTABLE' , 'extinout/t1.dat' , null, null, null) ");
        ImportExportProcedureTest.assertStatementError("38000", callableStatement);
        SupportFilesSetup.deleteFile("extinout/t1.dat");
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_EXPORT_TABLE ('XXXX', 'T1' , 'extinout/t1.dat' , null, null, null) ");
        ImportExportProcedureTest.assertStatementError("38000", callableStatement);
        SupportFilesSetup.deleteFile("extinout/t1.dat");
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_EXPORT_QUERY('select from t1', 'extinout/t1.dat' , null, null, null) ");
        ImportExportProcedureTest.assertStatementError("38000", callableStatement);
        SupportFilesSetup.deleteFile("extinout/t1.dat");
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_EXPORT_QUERY('select * from iep.t1', 'extinout/t1.dat' , null, null, 'NOSUCHCODESET') ");
        ImportExportProcedureTest.assertStatementError("XIE0I", callableStatement);
        SupportFilesSetup.deleteFile("extinout/t1.dat");
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_EXPORT_TABLE ('XXXX', 'T1' , 'extinout/t1.dat' , null, null, null) ");
        ImportExportProcedureTest.assertStatementError("38000", callableStatement);
        SupportFilesSetup.deleteFile("extinout/t1.dat");
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_EXPORT_TABLE ('IEP', 'T1' , 'extinout/t1.dat' , null, '.', null) ");
        ImportExportProcedureTest.assertStatementError("XIE0K", callableStatement);
        SupportFilesSetup.deleteFile("extinout/t1.dat");
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_EXPORT_TABLE ('IEP', 'T1' , 'extinout/t1.dat' , '.', null, null) ");
        ImportExportProcedureTest.assertStatementError(INVALID_DELIMITER, callableStatement);
        SupportFilesSetup.deleteFile("extinout/t1.dat");
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_EXPORT_TABLE ('IEP', 'T1' , 'extinout/t1.dat' , ';', ';', null) ");
        ImportExportProcedureTest.assertStatementError(INVALID_DELIMITER, callableStatement);
        SupportFilesSetup.deleteFile("extinout/t1.dat");
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_EXPORT_TABLE ('IEP', 'T1' , 'extinout/t1.dat' , ' ', ';', null) ");
        ImportExportProcedureTest.assertStatementError(INVALID_DELIMITER, callableStatement);
        SupportFilesSetup.deleteFile("extinout/t1.dat");
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_EXPORT_TABLE ('IEP', 'T1' , 'extinout/t1.dat' , null, ' ', null) ");
        ImportExportProcedureTest.assertStatementError(INVALID_DELIMITER, callableStatement);
        SupportFilesSetup.deleteFile("extinout/t1.dat");
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_EXPORT_TABLE ('IEP', 'T1' , 'extinout/t1.dat' , '', ';', null) ");
        ImportExportProcedureTest.assertStatementError(INVALID_DELIMITER, callableStatement);
        SupportFilesSetup.deleteFile("extinout/t1.dat");
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_EXPORT_TABLE ('IEP', 'T1' , 'extinout/t1.dat' , null, '', null) ");
        ImportExportProcedureTest.assertStatementError(INVALID_DELIMITER, callableStatement);
        SupportFilesSetup.deleteFile("extinout/t1.dat");
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_EXPORT_TABLE ('IEP', 'T1' , 'extinout/t1.dat' , '\\', '\\', null) ");
        ImportExportProcedureTest.assertStatementError(INVALID_DELIMITER, callableStatement);
        statement.executeUpdate("set schema iep");
        SupportFilesSetup.deleteFile("extinout/t1.dat");
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_EXPORT_TABLE ('IEP', 'T1' , 'extinout/t1.dat' , null, null, 'utf-8') ");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        ImportExportProcedureTest.assertUpdateCount(statement, 7, " delete from t1 ");
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_IMPORT_TABLE('IEP', 'T1' , 'extinout/t1.dat' , null, null, 'utf-8', 0) ");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        SupportFilesSetup.deleteFile("extinout/t1.dat");
        resultSet = statement.executeQuery(" select * from t1");
        String[] stringArray = new String[]{"A"};
        JDBC.assertColumnNames(resultSet, stringArray);
        Object[][] objectArray = new String[][]{{"100"}, {"101"}, {"102"}, {"103"}, {"104"}, {"105"}, {"106"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        SupportFilesSetup.deleteFile("extin/nodir/t1.dat");
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_IMPORT_TABLE('IEP', 'T1' , 'extin/nodir/t1.dat' , null, null, null, 0) ");
        ImportExportProcedureTest.assertStatementError("38000", callableStatement);
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_IMPORT_TABLE ('IEP', 'NOTABLE' , 'extinout/t1.dat' , null, null, null, 0) ");
        ImportExportProcedureTest.assertStatementError("XIE0M", callableStatement);
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_IMPORT_TABLE ('XXXX', 'T1' , 'extinout/t1.dat' , null, null, null, 0) ");
        ImportExportProcedureTest.assertStatementError("XIE0M", callableStatement);
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_IMPORT_TABLE ('IEP', 'T1' , 'extinout/t1.dat' , null, null, 'INCORRECTCODESET', 0) ");
        ImportExportProcedureTest.assertStatementError("38000", callableStatement);
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_IMPORT_TABLE ('IEP', 'T1' , 'extinout/t1.dat' , '', ';', null, 0) ");
        ImportExportProcedureTest.assertStatementError(INVALID_DELIMITER, callableStatement);
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_IMPORT_TABLE ('IEP', 'T1' , 'extinout/t1.dat' , null, '', null, 0) ");
        ImportExportProcedureTest.assertStatementError(INVALID_DELIMITER, callableStatement);
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_IMPORT_TABLE ('IEP', 'T1' , 'extinout/t1.dat' , ';', ';', null, 1) ");
        ImportExportProcedureTest.assertStatementError(INVALID_DELIMITER, callableStatement);
        Connection connection = this.getConnection();
        connection.setAutoCommit(false);
        statement.executeUpdate(" create table v1(a int) ");
        ImportExportProcedureTest.assertUpdateCount(statement, 0, " declare global temporary table session.temp1(c1 int) on commit preserve rows not logged");
        statement.executeUpdate(" insert into session.temp1 values(1) , (2) , (3) , (4) , (5) , (6)");
        resultSet = statement.executeQuery(" select * from session.temp1");
        stringArray = new String[]{"C1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1"}, {"2"}, {"3"}, {"4"}, {"5"}, {"6"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        SupportFilesSetup.deleteFile("extinout/temp1.dat");
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_EXPORT_TABLE ('SESSION', 'TEMP1' , 'extinout/temp1.dat' , null, null, null) ");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        resultSet = statement.executeQuery("select * from session.temp1");
        stringArray = new String[]{"C1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1"}, {"2"}, {"3"}, {"4"}, {"5"}, {"6"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_IMPORT_TABLE ('IEP', 'V1' , 'extinout/temp1.dat' , null, null, null, 0) ");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        resultSet = statement.executeQuery(" select * from v1");
        stringArray = new String[]{"A"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1"}, {"2"}, {"3"}, {"4"}, {"5"}, {"6"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        connection.commit();
        ImportExportProcedureTest.assertUpdateCount(statement, 0, "declare global temporary table session.temp2(c1 int) not logged");
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_IMPORT_TABLE ('SESSION', 'TEMP2' , 'extinout/temp1.dat' , null, null, null, 0) ");
        ImportExportProcedureTest.assertStatementError("XIE0M", callableStatement);
        ImportExportProcedureTest.assertStatementError("42X05", statement, " select * from session.temp2 ");
        connection.commit();
        statement.executeUpdate(" drop table v1");
        connection.setAutoCommit(true);
        statement.executeUpdate(" create table t3(c1 int , c2 double , c3 decimal , c4 varchar(20) )");
        statement.executeUpdate(" insert into t3 values(1 , 3.5 , 8.6 , 'test strings')");
        statement.executeUpdate(" insert into t3 values(2 , 3.5 , 8.6 , 'test strings')");
        statement.executeUpdate(" insert into t3 values(3 , 3.5 , 8.6 , 'test strings')");
        statement.executeUpdate(" insert into t3 values(4 , 3.5 , 8.6 , 'test strings')");
        SupportFilesSetup.deleteFile("extinout/t3.dat");
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_EXPORT_TABLE ('IEP', 'T3' , 'extinout/t3.dat' , null, null, null) ");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_IMPORT_TABLE ('IEP', 'T3' , 'extinout/t3.dat' , null, null, null, 0) ");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        resultSet = statement.executeQuery(" select * from t3");
        stringArray = new String[]{"C1", "C2", "C3", "C4"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "3.5", "8", "test strings"}, {"2", "3.5", "8", "test strings"}, {"3", "3.5", "8", "test strings"}, {"4", "3.5", "8", "test strings"}, {"1", "3.5", "8", "test strings"}, {"2", "3.5", "8", "test strings"}, {"3", "3.5", "8", "test strings"}, {"4", "3.5", "8", "test strings"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_IMPORT_DATA('IEP', 'T3' , 'X1, X2, X3, X4', null, 'extinout/t3.dat' , null, null, null, 0) ");
        ImportExportProcedureTest.assertStatementError("XIE08", callableStatement);
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_IMPORT_DATA('IEP', 'T3' , 'X1, X2, X3', '1,2,3,4', 'extinout/t3.dat' , null, null, null, 0) ");
        ImportExportProcedureTest.assertStatementError("XIE08", callableStatement);
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_IMPORT_DATA('IEP', 'T3' , 'C1, C2, C3', '1,2,3,4', 'extinout/t3.dat' , null, null, null, 0) ");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_IMPORT_DATA('IEP', 'T3' , 'C1, C2, C3,C4', '1,2', 'extinout/t3.dat' , null, null, null, 0) ");
        ImportExportProcedureTest.assertStatementError("38000", callableStatement);
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_IMPORT_DATA('IEP', 'T3' , null, '11,22,12,24', 'extinout/t3.dat' , null, null, null, 0) ");
        ImportExportProcedureTest.assertStatementError("38000", callableStatement);
        ImportExportProcedureTest.assertUpdateCount(statement, 12, "delete from t3 ");
        SupportFilesSetup.deleteFile("extinout/t3.dat");
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_EXPORT_TABLE ('IEP', 'T3' , 'extinout/t3.dat' , ';', '^', 'utf-16') ");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_IMPORT_DATA('IEP', 'T3' , 'X1, X2, X3, X4', null, 'extinout/t3.dat' , ';', '^', 'utf-16', 1) ");
        ImportExportProcedureTest.assertStatementError("XIE08", callableStatement);
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_IMPORT_DATA('IEP', 'T3' , 'X1, X2, X3', '1,2,3,4', 'extinout/t3.dat' , ';', '^', 'utf-16', 1) ");
        ImportExportProcedureTest.assertStatementError("XIE08", callableStatement);
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_IMPORT_DATA('IEP', 'T3' , 'C1, C2, C3', null, 'extinout/t3.dat' , ';', '^', 'utf-16', 1) ");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_IMPORT_DATA('IEP', 'T3' , null, '1,2', 'extinout/t3.dat' , ';', '^', 'utf-16', 1) ");
        ImportExportProcedureTest.assertStatementError("38000", callableStatement);
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_IMPORT_DATA('IEP', 'T3' , null, '11,22,12,24', 'extinout/t3.dat' , ';', '^', 'utf-16', 1) ");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_IMPORT_TABLE ('SYS', 'SYSTABLES' , 'extinout/t3.dat' , ';', '^', 'utf-16', 1) ");
        ImportExportProcedureTest.assertStatementError("38000", callableStatement);
        statement.executeUpdate("create table parent(a int not null primary key)");
        statement.executeUpdate(" insert into parent values (1) , (2) , (3) , (4) ");
        SupportFilesSetup.deleteFile("extinout/parent.del");
        callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_EXPORT_QUERY('select * from parent where a < 3' , 'extinout/parent.del' , null, null, null) ");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        Connection connection2 = this.openDefaultConnection();
        Statement statement2 = connection2.createStatement();
        connection2.setAutoCommit(false);
        statement2.executeUpdate("lock table iep.parent in share mode");
        connection.setAutoCommit(false);
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.locks.waitTimeout', '5')");
        ImportExportProcedureTest.assertUpdateCount(callableStatement, 0);
        ImportExportProcedureTest.assertStatementError("38000", statement, "CALL SYSCS_UTIL.SYSCS_IMPORT_TABLE('IEP', 'PARENT', 'extinout/parent.del',null, null, null,1)");
        connection2.rollback();
        connection2.close();
        connection.setAutoCommit(true);
        this.getConnection().rollback();
        statement.close();
    }
}

