/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;

public class CurrentOfTest
extends BaseJDBCTestCase {
    public CurrentOfTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("CurrentOfTest");
        baseTestSuite.addTestSuite(CurrentOfTest.class);
        return baseTestSuite;
    }

    protected void setUp() throws SQLException {
        this.getConnection().setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.executeUpdate("create table t (i int, c char(50))");
        statement.executeUpdate("create table s (i int, c char(50))");
        statement.executeUpdate("insert into t values (1956, 'hello world')");
        statement.executeUpdate("insert into t values (456, 'hi yourself')");
        statement.executeUpdate("insert into t values (180, 'rubber ducky')");
        statement.executeUpdate("insert into t values (3, 'you are the one')");
        statement.close();
        this.commit();
    }

    @Override
    protected void tearDown() throws Exception {
        JDBC.dropSchema(this.getConnection().getMetaData(), this.getTestConfiguration().getUserName());
        super.tearDown();
    }

    public void testReadOnlyCursors() throws SQLException {
        String[] stringArray = new String[]{"select I, C from t for read only", "select I, C from t for fetch only", "select I, C FROM T ORDER BY 1", "values (1, 2, 3)", "select I, C from t union all select I, C from t", "select t1.I, t1.C from t t1, t t2 where t1.I = t2.I", "select I, C from (select * from t) t1", "select I, C from t where I in (select I from t)"};
        for (int i = 0; i < stringArray.length; ++i) {
            PreparedStatement preparedStatement = this.prepareStatement(stringArray[i]);
            ResultSet resultSet = preparedStatement.executeQuery();
            CurrentOfTest.assertNull((String)stringArray[i], (Object)resultSet.getCursorName());
            resultSet.close();
            preparedStatement.setCursorName("PLEASE_UPDATE");
            resultSet = preparedStatement.executeQuery();
            CurrentOfTest.assertEquals((String)stringArray[i], (String)"PLEASE_UPDATE", (String)resultSet.getCursorName());
            this.assertCompileError("42X23", "DELETE FROM T WHERE CURRENT OF PLEASE_UPDATE");
            this.assertCompileError("42X23", "UPDATE T SET I = 3 WHERE CURRENT OF PLEASE_UPDATE");
            resultSet.close();
            preparedStatement.close();
        }
    }

    public void testDelete() throws SQLException {
        String string = "select i, c from t for read only";
        Statement statement = this.createStatement();
        Object[][] objectArray = new Object[][]{{new String("1956"), new String("hello world")}, {new String("456"), new String("hi yourself")}, {new String("180"), new String("rubber ducky")}, {new String("3"), new String("you are the one")}};
        JDBC.assertFullResultSet(statement.executeQuery(string), objectArray, true);
        PreparedStatement preparedStatement = this.prepareStatement("select i, c from t for update");
        ResultSet resultSet = preparedStatement.executeQuery();
        this.assertCompileError("42X28", "delete from s where current of " + resultSet.getCursorName());
        PreparedStatement preparedStatement2 = this.prepareStatement("delete from t where current of " + resultSet.getCursorName());
        CurrentOfTest.assertStatementError("24000", preparedStatement2);
        resultSet.next();
        CurrentOfTest.assertEquals((int)1956, (int)resultSet.getInt(1));
        CurrentOfTest.assertUpdateCount(preparedStatement2, 1);
        resultSet.next();
        CurrentOfTest.assertEquals((int)456, (int)resultSet.getInt(1));
        resultSet.next();
        CurrentOfTest.assertEquals((int)180, (int)resultSet.getInt(1));
        CurrentOfTest.assertUpdateCount(preparedStatement2, 1);
        resultSet.next();
        CurrentOfTest.assertEquals((int)3, (int)resultSet.getInt(1));
        CurrentOfTest.assertFalse((boolean)resultSet.next());
        if (CurrentOfTest.usingEmbedded()) {
            CurrentOfTest.assertStatementError("24000", preparedStatement2);
        } else {
            CurrentOfTest.assertStatementError("42X30", preparedStatement2);
        }
        resultSet.close();
        if (CurrentOfTest.usingEmbedded()) {
            CurrentOfTest.assertStatementError("42X30", preparedStatement2);
        } else {
            CurrentOfTest.assertStatementError("XCL16", preparedStatement2);
        }
        Statement statement2 = this.createStatement();
        CurrentOfTest.assertStatementError("42X30", statement2, "delete from t where current of myCursor");
        objectArray = new Object[][]{{new String("456"), new String("hi yourself")}, {new String("3"), new String("you are the one")}};
        JDBC.assertFullResultSet(statement.executeQuery(string), objectArray, true);
        preparedStatement2.close();
        statement2.close();
        preparedStatement.close();
        preparedStatement = this.prepareStatement("SELECT I, C FROM T FOR UPDATE OF I");
        resultSet = preparedStatement.executeQuery();
        preparedStatement2 = this.prepareStatement("delete from t where current of " + resultSet.getCursorName());
        CurrentOfTest.assertTrue((boolean)resultSet.next());
        CurrentOfTest.assertUpdateCount(preparedStatement2, 1);
        preparedStatement2.close();
        statement.close();
        resultSet.close();
        preparedStatement.close();
    }

    public void testUpdate() throws SQLException {
        String string = "select i, c from t for read only";
        PreparedStatement preparedStatement = this.prepareStatement("select I, C from t for update of I");
        ResultSet resultSet = preparedStatement.executeQuery();
        this.assertCompileError("42X31", "update t set C = 'abcde' where current of " + resultSet.getCursorName());
        resultSet.close();
        preparedStatement.close();
        Statement statement = this.createStatement();
        Object[][] objectArray = new Object[][]{{new String("1956"), new String("hello world")}, {new String("456"), new String("hi yourself")}, {new String("180"), new String("rubber ducky")}, {new String("3"), new String("you are the one")}};
        JDBC.assertFullResultSet(statement.executeQuery(string), objectArray, true);
        preparedStatement = this.prepareStatement("select I, C from t for update");
        resultSet = preparedStatement.executeQuery();
        this.assertCompileError("42X29", "update s set i=1 where current of " + resultSet.getCursorName());
        PreparedStatement preparedStatement2 = this.prepareStatement("update t set i=i+10, c='Gumby was here' where current of " + resultSet.getCursorName());
        CurrentOfTest.assertStatementError("24000", preparedStatement2);
        resultSet.next();
        CurrentOfTest.assertEquals((int)1956, (int)resultSet.getInt(1));
        CurrentOfTest.assertUpdateCount(preparedStatement2, 1);
        CurrentOfTest.assertUpdateCount(preparedStatement2, 1);
        resultSet.next();
        CurrentOfTest.assertEquals((int)456, (int)resultSet.getInt(1));
        resultSet.next();
        CurrentOfTest.assertEquals((int)180, (int)resultSet.getInt(1));
        CurrentOfTest.assertUpdateCount(preparedStatement2, 1);
        resultSet.next();
        CurrentOfTest.assertEquals((int)3, (int)resultSet.getInt(1));
        CurrentOfTest.assertFalse((boolean)resultSet.next());
        CurrentOfTest.assertStatementError("24000", preparedStatement2);
        resultSet.close();
        preparedStatement.close();
        CurrentOfTest.assertStatementError("42X30", preparedStatement2);
        preparedStatement2.close();
        Statement statement2 = this.createStatement();
        CurrentOfTest.assertStatementError("42X30", statement2, "update t set i=1 where current of nosuchcursor");
        statement2.close();
        objectArray = new Object[][]{{new String("1976"), new String("Gumby was here")}, {new String("456"), new String("hi yourself")}, {new String("190"), new String("Gumby was here")}, {new String("3"), new String("you are the one")}};
        JDBC.assertFullResultSet(statement.executeQuery(string), objectArray, true);
        resultSet.close();
    }

    public void testUpdateRecompileCreateIndex() throws Exception {
        this.recompile("UPDATE T SET I = I + 1 WHERE CURRENT OF ", "CREATE INDEX IT ON T(I)", null);
    }

    public void testUpdateRecompileChangeFunction() throws Exception {
        Statement statement = this.createStatement();
        statement.execute("CREATE FUNCTION F(V INTEGER) RETURNS INTEGER NO SQL LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + ((Object)((Object)this)).getClass().getName() + ".doubleValue'");
        this.commit();
        String string = "CREATE FUNCTION F(V INTEGER) RETURNS INTEGER NO SQL LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + ((Object)((Object)this)).getClass().getName() + ".tripleValue'";
        int n = this.recompile("UPDATE T SET I = F(I) WHERE CURRENT OF ", "DROP FUNCTION F", string);
        String[][] stringArray = new String[][]{{"3"}, {"180"}, {"456"}, {"1956"}};
        if (n == 180) {
            stringArray[1] = new String[]{"360"};
            stringArray[2] = new String[]{"1368"};
        } else {
            stringArray[1] = new String[]{"540"};
            stringArray[2] = new String[]{"912"};
        }
        JDBC.assertFullResultSet(statement.executeQuery("SELECT I FROM T ORDER BY I"), stringArray);
        statement.close();
    }

    public void testDeleteRecompileCreateIndex() throws Exception {
        this.recompile("DELETE FROM T WHERE CURRENT OF ", "CREATE INDEX IT ON T(I)", null);
    }

    private int recompile(String string, String string2, String string3) throws SQLException {
        int n;
        Statement statement = this.createStatement();
        PreparedStatement preparedStatement = this.prepareStatement("select I, C from t for update");
        ResultSet resultSet = preparedStatement.executeQuery();
        PreparedStatement preparedStatement2 = this.prepareStatement(string + resultSet.getCursorName());
        int n2 = -1;
        while (resultSet.next()) {
            n = resultSet.getInt(1);
            if (n != 180 && n != 456) continue;
            preparedStatement2.execute();
            n2 = n;
            break;
        }
        CurrentOfTest.assertTrue((n2 == 180 || n2 == 456 ? 1 : 0) != 0);
        statement.execute(string2);
        if (string3 != null) {
            statement.execute(string3);
        }
        n = -1;
        while (resultSet.next()) {
            int n3 = resultSet.getInt(1);
            if (n3 != 180 && n3 != 456) continue;
            preparedStatement2.execute();
            n = n3;
            break;
        }
        CurrentOfTest.assertTrue((n2 != n ? 1 : 0) != 0);
        CurrentOfTest.assertTrue((n == 180 || n == 456 ? 1 : 0) != 0);
        preparedStatement2.close();
        resultSet.close();
        preparedStatement.close();
        this.commit();
        statement.close();
        this.assertCheckTable("T");
        return n2;
    }

    public void testCursorChangeUpdateList() throws SQLException {
        this.cursorChange("42X31", "select I, C from t for update", "update t set i=i+19, c='OLD' || cast(i as CHAR(20)) where current of ", "select I, C from t for update of I");
        this.cursorChange(null, "select I, C from t for update", "DELETE FROM t WHERE CURRENT OF ", "select I, C from t for update of I");
    }

    public void testCursorChangeToReadOnly() throws SQLException {
        this.cursorChange("42X23", "select I, C from t for update", "update t set i=i+23 where current of ", "select I, C from t for fetch only");
        this.cursorChange("42X23", "select I, C from t for update", "DELETE FROM t WHERE CURRENT OF ", "select I, C from t for fetch only");
    }

    public void testCursorChangeToDifferentTable() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("INSERT INTO S(I,C) SELECT I,C FROM T");
        statement.close();
        this.commit();
        this.cursorChange("42X29", "select I, C from t for update", "update t set i=i+23 where current of ", "SELECT I, C FROM S FOR UPDATE");
        this.cursorChange("42X28", "select I, C from t for update", "DELETE FROM t WHERE CURRENT OF ", "SELECT I, C FROM S FOR UPDATE");
    }

    private void cursorChange(String string, String string2, String string3, String string4) throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("insert into t values (425, 'apache db derby')");
        statement.executeUpdate("insert into t values (280, 'derby-user users')");
        statement.close();
        this.commit();
        this.cursorChange(string, "CHANGE_ME", string2, string3, string4);
        this.cursorChange(string, null, string2, string3, string4);
    }

    private void cursorChange(String string, String string2, String string3, String string4, String string5) throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement(string3);
        if (string2 != null) {
            preparedStatement.setCursorName(string2);
        }
        ResultSet resultSet = preparedStatement.executeQuery();
        string2 = resultSet.getCursorName();
        PreparedStatement preparedStatement2 = this.prepareStatement(string4 + string2);
        CurrentOfTest.assertTrue((boolean)resultSet.next());
        CurrentOfTest.assertUpdateCount(preparedStatement2, 1);
        resultSet.close();
        PreparedStatement preparedStatement3 = this.prepareStatement(string5);
        preparedStatement3.setCursorName(string2);
        resultSet = preparedStatement3.executeQuery();
        CurrentOfTest.assertTrue((boolean)resultSet.next());
        if (string != null) {
            CurrentOfTest.assertStatementError(string, preparedStatement2);
        } else {
            CurrentOfTest.assertUpdateCount(preparedStatement2, 1);
        }
        resultSet.close();
        resultSet = preparedStatement.executeQuery();
        resultSet.next();
        CurrentOfTest.assertUpdateCount(preparedStatement2, 1);
        resultSet.close();
        preparedStatement2.close();
        preparedStatement3.close();
        preparedStatement.close();
    }

    public static int doubleValue(int n) {
        return n * 2;
    }

    public static int tripleValue(int n) {
        return n * 3;
    }
}

