/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.perf.basic.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;

public class BaseLoad100TestSetup
extends CleanDatabaseTestSetup {
    protected int rowsToLoad = 10000;
    protected String tableName = "BASELOAD100";
    private boolean binaryData;

    public BaseLoad100TestSetup(Test test) {
        super(test);
    }

    public BaseLoad100TestSetup(Test test, int n) {
        super(test);
        this.rowsToLoad = n;
    }

    public BaseLoad100TestSetup(Test test, String string) {
        super(test);
        this.tableName = string;
    }

    public BaseLoad100TestSetup(Test test, int n, String string) {
        this(test, n, string, false);
    }

    public BaseLoad100TestSetup(Test test, int n, String string, boolean bl) {
        super(test);
        this.tableName = string;
        this.rowsToLoad = n;
        this.binaryData = bl;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Connection connection = this.getConnection();
        connection.setAutoCommit(false);
        PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO " + this.tableName + " VALUES ( ?,?,?,?,?,?,?,?,? )");
        this.loadData(preparedStatement);
        preparedStatement.close();
        connection.close();
    }

    @Override
    protected void decorateSQL(Statement statement) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CREATE TABLE ").append(this.tableName);
        stringBuffer.append("(i1 INT, i2 INT, i3 INT, i4 INT, i5 INT");
        for (int i = 6; i <= 9; ++i) {
            stringBuffer.append(", c").append(i).append(" CHAR(20)");
            if (!this.binaryData) continue;
            stringBuffer.append(" FOR BIT DATA");
        }
        stringBuffer.append(')');
        statement.execute(stringBuffer.toString());
    }

    private void loadData(PreparedStatement preparedStatement) throws Exception {
        for (int i = 0; i < this.rowsToLoad; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.setInt(2, 2);
            if (i % 100 == 57) {
                preparedStatement.setInt(3, 436);
            } else {
                preparedStatement.setInt(3, 2);
            }
            preparedStatement.setInt(4, 2);
            preparedStatement.setInt(5, i);
            preparedStatement.setObject(6, this.convertData("01234567890123456789"));
            if (i % 100 == 34) {
                preparedStatement.setObject(7, this.convertData("012345javaone6789"));
            } else {
                preparedStatement.setObject(7, this.convertData("01234567890123456789"));
            }
            preparedStatement.setObject(8, this.convertData("01234567890123456789"));
            preparedStatement.setObject(9, this.convertData(i + 1000 + "0123456789012"));
            preparedStatement.executeUpdate();
        }
        preparedStatement.getConnection().commit();
    }

    private Object convertData(String string) throws IOException {
        if (this.binaryData) {
            return string.getBytes("US-ASCII");
        }
        return string;
    }
}

