/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.optional.dump;

import java.io.File;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.iapi.sql.dictionary.OptionalTool;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.optional.dump.DataFileVTI;
import org.apache.derby.tools.dblook;

public class RawDBReader
implements OptionalTool {
    public void loadTool(String ... configurationParameters) throws SQLException {
        if (configurationParameters == null || configurationParameters.length < 7) {
            throw this.badArgs("Wrong number of arguments.");
        }
        int idx = 0;
        String recoveryScript = configurationParameters[idx++];
        String controlSchema = configurationParameters[idx++];
        String schemaPrefix = configurationParameters[idx++];
        String corruptDBLocation = configurationParameters[idx++];
        String encryptionAttributes = configurationParameters[idx++];
        String dbo = configurationParameters[idx++];
        String dboPassword = configurationParameters[idx++];
        if (this.nullOrEmpty(recoveryScript)) {
            throw this.badArgs("Null or empty recovery script argument.");
        }
        if (this.nullOrEmpty(controlSchema)) {
            throw this.badArgs("Null or empty control schema argument.");
        }
        if (this.nullOrEmpty(schemaPrefix)) {
            throw this.badArgs("Null or empty schema prefix argument.");
        }
        if (this.nullOrEmpty(corruptDBLocation)) {
            throw this.badArgs("Null or empty database location argument.");
        }
        if (this.nullOrEmpty(dbo)) {
            throw this.badArgs("Null or empty database owner argument.");
        }
        Connection conn = this.getDerbyConnection();
        this.createControlSchema(conn, controlSchema, corruptDBLocation, encryptionAttributes, dbo, dboPassword);
        this.createUserSchemas(conn, controlSchema, schemaPrefix, corruptDBLocation, encryptionAttributes, dbo, dboPassword);
        this.createViews(conn, recoveryScript, controlSchema, schemaPrefix, corruptDBLocation, encryptionAttributes, dbo, dboPassword);
    }

    private boolean nullOrEmpty(String text) {
        return text == null || text.length() == 0;
    }

    public void unloadTool(String ... configurationParameters) throws SQLException {
        if (configurationParameters == null || configurationParameters.length < 2) {
            throw this.badArgs("Wrong number of arguments.");
        }
        int idx = 0;
        String controlSchema = configurationParameters[idx++];
        String schemaPrefix = configurationParameters[idx++];
        if (this.nullOrEmpty(controlSchema)) {
            throw this.badArgs("Null or empty control schema argument.");
        }
        if (this.nullOrEmpty(schemaPrefix)) {
            throw this.badArgs("Null or empty schema prefix argument.");
        }
        Connection conn = this.getDerbyConnection();
        this.dropViews(conn, schemaPrefix);
        this.dropUserSchemas(conn, schemaPrefix);
        this.dropControlSchema(conn, controlSchema);
    }

    private SQLException badArgs(String message) {
        return new SQLException(message);
    }

    private void createControlSchema(Connection conn, String controlSchema, String corruptDBLocation, String encryptionAttributes, String dbo, String dboPassword) throws SQLException {
        this.executeDDL(conn, "create schema " + controlSchema);
        this.executeDDL(conn, "set schema " + controlSchema);
        this.executeDDL(conn, "create type serializable external name 'java.io.Serializable' language java");
        this.createTable(conn, controlSchema, "SYSCONGLOMERATES", "( schemaid char(36), tableid char(36), conglomeratenumber bigint, conglomeratename varchar( 128), isindex boolean, descriptor serializable, isconstant boolean, conglomerateid char( 36 ) )", "c20.dat", corruptDBLocation, encryptionAttributes, dbo, dboPassword);
        this.createTable(conn, controlSchema, "SYSCOLUMNS", "( referenceid char(36), columnname varchar(128), columnnumber int, columndatatype serializable, columndefault serializable, columndefaultid char(36), autoincrementvalue bigint, autoincrementstart bigint, autoincrementinc bigint, autoincrementcycle boolean )", "c90.dat", corruptDBLocation, encryptionAttributes, dbo, dboPassword);
        this.createTable(conn, controlSchema, "SYSSCHEMAS", "( schemaID char(36), schemaname varchar(128), authorizationid varchar(128) )", "cc0.dat", corruptDBLocation, encryptionAttributes, dbo, dboPassword);
        this.createTable(conn, controlSchema, "SYSTABLES", "( tableid char(36), tablename varchar(128), tabletype char(1), schemaid char(36), lockgranularity char(1) )", "c60.dat", corruptDBLocation, encryptionAttributes, dbo, dboPassword);
    }

    private void createTable(Connection conn, String schema, String tableName, String tableSignature, String heapFileName, String corruptDBLocation, String encryptionAttributes, String dbo, String dboPassword) throws SQLException {
        String qualifiedName = schema + "." + tableName;
        String dataFileVTIClassName = DataFileVTI.class.getName();
        this.executeDDL(conn, "create function " + qualifiedName + "\n(\n    databaseDirectoryName varchar( 32672 ),\n    dataFileName varchar( 32672 ),\n    tableSignature varchar( 32672 ),\n    encryptionAttributes varchar( 32672 ),\n    userName varchar( 32672 ),\n    password varchar( 32672 )\n)\nreturns table\n" + tableSignature + "language java\nparameter style derby_jdbc_result_set\nno sql\nexternal name '" + dataFileVTIClassName + ".dataFileVTI'\n");
        this.executeDDL(conn, "create view " + qualifiedName + "\nas select * from table\n(\n    " + qualifiedName + "\n    (\n        '" + corruptDBLocation + "',\n        '" + heapFileName + "',\n        '" + tableSignature + "',\n        " + this.singleQuote(encryptionAttributes) + ",\n        " + this.singleQuote(dbo) + ",\n        " + this.singleQuote(dboPassword) + "\n    )\n) t\n");
    }

    private void createUserSchemas(Connection conn, String controlSchema, String schemaPrefix, String corruptDBLocation, String encryptionAttributes, String dbo, String dboPassword) throws SQLException {
        PreparedStatement ps = this.prepareStatement(conn, "select schemaName\nfrom " + controlSchema + ".sysschemas\nwhere schemaName not like 'SYS%' and schemaName != 'NULLID' and schemaName != 'SQLJ'\n");
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            String schemaName = this.makeSchemaName(schemaPrefix, rs.getString(1));
            this.executeDDL(conn, "create schema " + schemaName);
        }
        rs.close();
        ps.close();
    }

    private String makeSchemaName(String schemaPrefix, String corruptName) {
        return IdUtil.normalToDelimited((String)(schemaPrefix + corruptName));
    }

    private void createViews(Connection conn, String recoveryScriptName, String controlSchema, String schemaPrefix, String corruptDBLocation, String encryptionAttributes, String dbo, String dboPassword) throws SQLException {
        File recoveryScript = new File(recoveryScriptName);
        PrintWriter scriptWriter = null;
        try {
            scriptWriter = new PrintWriter(recoveryScript);
        }
        catch (Exception e) {
            throw this.wrap(e);
        }
        String localDBName = ((EmbedConnection)conn).getDBName();
        scriptWriter.println("connect 'jdbc:derby:" + localDBName + "';\n");
        PreparedStatement ps = this.prepareStatement(conn, "select s.schemaName, t.tableName, g.conglomerateNumber, c.columnName, c.columnNumber, c.columnDatatype\nfrom " + controlSchema + ".sysschemas s,\n" + controlSchema + ".systables t,\n" + controlSchema + ".sysconglomerates g,\n" + controlSchema + ".syscolumns c\nwhere s.schemaName not like 'SYS%' and schemaName != 'NULLID' and schemaName != 'SQLJ'\nand s.schemaID = t.schemaID\nand t.tableID = g.tableID and not g.isindex\nand t.tableID = c.referenceID\norder by s.schemaName, t.tableName, c.columnNumber");
        ResultSet rs = ps.executeQuery();
        ArrayList<String> columnNames = new ArrayList<String>();
        ArrayList<TypeDescriptor> columnTypes = new ArrayList<TypeDescriptor>();
        String corruptSchemaName = null;
        String corruptTableName = null;
        String schemaName = null;
        String tableName = null;
        long conglomerateNumber = -1L;
        while (rs.next()) {
            int col = 1;
            String currentCorruptSchemaName = rs.getString(col++);
            String currentCorruptTableName = rs.getString(col++);
            if (!currentCorruptSchemaName.equals(corruptSchemaName)) {
                scriptWriter.println("create schema " + IdUtil.normalToDelimited((String)currentCorruptSchemaName) + ";\n");
            }
            String newSchemaName = this.makeSchemaName(schemaPrefix, currentCorruptSchemaName);
            String newTableName = IdUtil.normalToDelimited((String)currentCorruptTableName);
            if (!(schemaName == null || schemaName.equals(newSchemaName) && tableName.equals(newTableName))) {
                this.createView(conn, scriptWriter, controlSchema, corruptSchemaName, corruptTableName, schemaName, tableName, conglomerateNumber, columnNames, columnTypes, corruptDBLocation, encryptionAttributes, dbo, dboPassword);
                columnNames.clear();
                columnTypes.clear();
            }
            corruptSchemaName = currentCorruptSchemaName;
            corruptTableName = currentCorruptTableName;
            schemaName = newSchemaName;
            tableName = newTableName;
            conglomerateNumber = rs.getLong(col++);
            columnNames.add(this.normalizeColumnName(rs.getString(col++)));
            int n = ++col;
            ++col;
            columnTypes.add((TypeDescriptor)rs.getObject(n));
        }
        if (schemaName != null) {
            this.createView(conn, scriptWriter, controlSchema, corruptSchemaName, corruptTableName, schemaName, tableName, conglomerateNumber, columnNames, columnTypes, corruptDBLocation, encryptionAttributes, dbo, dboPassword);
        }
        rs.close();
        ps.close();
        scriptWriter.flush();
        scriptWriter.close();
    }

    private String normalizeColumnName(String unnormalizedName) {
        return dblook.addQuotes((String)dblook.expandDoubleQuotes((String)dblook.stripQuotes((String)dblook.addQuotes((String)unnormalizedName))));
    }

    private void createView(Connection conn, PrintWriter scriptWriter, String controlSchema, String corruptSchemaName, String corruptTableName, String schemaName, String tableName, long conglomerateNumber, ArrayList<String> columnNames, ArrayList<TypeDescriptor> columnTypes, String corruptDBLocation, String encryptionAttributes, String dbo, String dboPassword) throws SQLException {
        String conglomerateName = "c" + Long.toHexString(conglomerateNumber) + ".dat";
        String tableSignature = this.makeTableSignature(controlSchema, columnNames, columnTypes);
        String localTableName = IdUtil.normalToDelimited((String)corruptSchemaName) + "." + IdUtil.normalToDelimited((String)corruptTableName);
        String viewName = schemaName + "." + tableName;
        scriptWriter.println("-- siphon data out of " + conglomerateName);
        scriptWriter.println("create table " + localTableName + " as select * from " + viewName + " with no data;");
        scriptWriter.println("insert into " + localTableName + " select * from " + viewName + ";\n");
        this.createTable(conn, schemaName, tableName, tableSignature, conglomerateName, corruptDBLocation, encryptionAttributes, dbo, dboPassword);
    }

    private String makeTableSignature(String controlSchema, ArrayList<String> columnNames, ArrayList<TypeDescriptor> columnTypes) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("( ");
        for (int i = 0; i < columnNames.size(); ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(columnNames.get(i) + " ");
            TypeDescriptor type = columnTypes.get(i);
            if (type.isUserDefinedType()) {
                buffer.append(controlSchema + ".serializable");
                continue;
            }
            buffer.append(type.getSQLstring());
        }
        buffer.append(" )");
        return buffer.toString();
    }

    private String singleQuote(String text) {
        return text == null ? "null" : "'" + text + "'";
    }

    private void dropViews(Connection conn, String schemaPrefix) throws SQLException {
        PreparedStatement ps = this.prepareStatement(conn, "select s.schemaName, t.tableName\nfrom sys.sysschemas s, sys.systables t\nwhere s.schemaName like '" + schemaPrefix + "%'\nand s.schemaID = t.schemaID");
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            int col = 1;
            this.dropTable(conn, IdUtil.normalToDelimited((String)rs.getString(col++)), IdUtil.normalToDelimited((String)rs.getString(col++)));
        }
        rs.close();
        ps.close();
    }

    private void dropTable(Connection conn, String schema, String tableName) throws SQLException {
        String qualifiedName = schema + "." + tableName;
        this.executeDDL(conn, "drop view " + qualifiedName);
        this.executeDDL(conn, "drop function " + qualifiedName);
    }

    private void dropUserSchemas(Connection conn, String schemaPrefix) throws SQLException {
        PreparedStatement ps = this.prepareStatement(conn, "select s.schemaName\nfrom sys.sysschemas s\nwhere s.schemaName like '" + schemaPrefix + "%'\n");
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            String schemaName = IdUtil.normalToDelimited((String)rs.getString(1));
            this.executeDDL(conn, "drop schema " + schemaName + " restrict");
        }
        rs.close();
        ps.close();
    }

    private void dropControlSchema(Connection conn, String controlSchema) throws SQLException {
        this.executeDDL(conn, "set schema sys");
        this.dropTable(conn, controlSchema, "SYSTABLES");
        this.dropTable(conn, controlSchema, "SYSSCHEMAS");
        this.dropTable(conn, controlSchema, "SYSCOLUMNS");
        this.dropTable(conn, controlSchema, "SYSCONGLOMERATES");
        this.executeDDL(conn, "drop type " + controlSchema + ".serializable restrict");
        this.executeDDL(conn, "drop schema " + controlSchema + " restrict");
    }

    private Connection getDerbyConnection() throws SQLException {
        return DriverManager.getConnection("jdbc:default:connection");
    }

    private String delimitedID(String text) {
        return IdUtil.normalToDelimited((String)text);
    }

    private String stringLiteral(String text) {
        return StringUtil.quoteStringLiteral((String)text);
    }

    private void executeDDL(Connection conn, String text) throws SQLException {
        PreparedStatement ddl = this.prepareStatement(conn, text);
        ddl.execute();
        ddl.close();
    }

    private PreparedStatement prepareStatement(Connection conn, String text) throws SQLException {
        return conn.prepareStatement(text);
    }

    private SQLException wrap(Throwable t) {
        String errorMessage = t.getMessage();
        String sqlState = "XJ001.U".substring(0, 5);
        return new SQLException(errorMessage, sqlState, t);
    }
}

