/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Assert;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.store.StoreBaseTest;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;

public class Derby3625Test
extends StoreBaseTest {
    public Derby3625Test(String name) {
        super(name);
    }

    public void testTwoToOneByteCase() throws SQLException {
        int i;
        PreparedStatement insert_stmt = this.prepareStatement("INSERT INTO testCompress VALUES(?, ?, ?)");
        byte[] pad_blob = new byte[32630];
        insert_stmt.setInt(1, 1);
        insert_stmt.setBytes(2, pad_blob);
        insert_stmt.setString(3, "page 1");
        insert_stmt.executeUpdate();
        pad_blob = new byte[302];
        insert_stmt.setInt(1, 2);
        insert_stmt.setBytes(2, pad_blob);
        insert_stmt.setString(3, "page 2");
        for (i = 0; i < 98; ++i) {
            insert_stmt.executeUpdate();
        }
        insert_stmt.setInt(1, 3);
        insert_stmt.setBytes(2, pad_blob);
        insert_stmt.setString(3, "page 3");
        for (i = 0; i < 98; ++i) {
            insert_stmt.executeUpdate();
        }
        pad_blob = new byte[100];
        insert_stmt.setInt(1, 4);
        insert_stmt.setBytes(2, pad_blob);
        insert_stmt.setString(3, "page 4");
        insert_stmt.executeUpdate();
        pad_blob = new byte[32534];
        insert_stmt.setInt(1, 4);
        insert_stmt.setBytes(2, pad_blob);
        insert_stmt.setString(3, "page 4");
        insert_stmt.executeUpdate();
        this.commit();
        int[] space_info = this.getSpaceInfo("APP", "TESTCOMPRESS", true);
        Assert.assertEquals((String)"wrong allocated page count in test setup", (int)4, (int)space_info[1]);
        Statement stmt = this.createStatement();
        stmt.executeUpdate("DELETE FROM testCompress where id = 2 or id = 3");
        this.commit();
        CallableStatement call_compress = this.prepareCall("CALL SYSCS_UTIL.SYSCS_INPLACE_COMPRESS_TABLE(?, ?, 1, 1, 1)");
        call_compress.setString(1, "APP");
        call_compress.setString(2, "TESTCOMPRESS");
        call_compress.executeUpdate();
        this.commit();
        space_info = this.getSpaceInfo("APP", "TESTCOMPRESS", true);
        Assert.assertEquals((String)"wrong allocated page count", (int)3, (int)space_info[1]);
        insert_stmt.close();
    }

    protected static Test baseSuite(String name) {
        BaseTestSuite suite = new BaseTestSuite(name);
        suite.addTestSuite(Derby3625Test.class);
        return new CleanDatabaseTestSetup(DatabasePropertyTestSetup.setLockTimeouts((Test)suite, 2, 4)){

            @Override
            protected void decorateSQL(Statement stmt) throws SQLException {
                Connection conn = stmt.getConnection();
                CallableStatement set_dbprop = conn.prepareCall("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY(?, ?)");
                set_dbprop.setString(1, "derby.storage.pageReservedSpace");
                set_dbprop.setString(2, "0");
                set_dbprop.executeUpdate();
                stmt.executeUpdate("CREATE TABLE testCompress (id int, padcol blob(1M), c varchar(200))");
                set_dbprop.setString(2, null);
                set_dbprop.executeUpdate();
                set_dbprop.close();
                conn.setAutoCommit(false);
            }
        };
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite("Derby3625Test");
        suite.addTest(Derby3625Test.baseSuite("Derby36625Test:embedded"));
        return suite;
    }
}

