/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.tuple;

import java.io.IOException;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.tuple.Sketch;
import org.apache.datasketches.tuple.SketchIterator;
import org.apache.datasketches.tuple.Sketches;
import org.apache.datasketches.tuple.SummaryDeserializer;
import org.apache.datasketches.tuple.adouble.DoubleSummary;
import org.apache.datasketches.tuple.adouble.DoubleSummaryDeserializer;
import org.apache.pig.EvalFunc;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;

public class DoubleSummarySketchToEstimates
extends EvalFunc<Tuple> {
    private static final SummaryDeserializer<DoubleSummary> SUMMARY_DESERIALIZER = new DoubleSummaryDeserializer();

    public Tuple exec(Tuple input) throws IOException {
        if (input == null || input.size() == 0) {
            return null;
        }
        DataByteArray dba = (DataByteArray)input.get(0);
        Sketch sketch = Sketches.heapifySketch((Memory)Memory.wrap((byte[])dba.get()), SUMMARY_DESERIALIZER);
        Tuple output = TupleFactory.getInstance().newTuple(2);
        output.set(0, (Object)sketch.getEstimate());
        double sum = 0.0;
        SketchIterator it = sketch.iterator();
        while (it.next()) {
            sum += ((DoubleSummary)it.getSummary()).getValue();
        }
        output.set(1, (Object)(sum / sketch.getTheta()));
        return output;
    }
}

