/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.quantiles;

import java.io.IOException;
import java.util.Comparator;
import org.apache.datasketches.ArrayOfItemsSerDe;
import org.apache.datasketches.ArrayOfStringsSerDe;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.pig.quantiles.Util;
import org.apache.datasketches.quantiles.ItemsSketch;
import org.apache.pig.EvalFunc;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;

public class GetPmfFromStringsSketch
extends EvalFunc<Tuple> {
    public Tuple exec(Tuple input) throws IOException {
        if (input.size() < 2) {
            throw new IllegalArgumentException("expected two or more inputs: sketch and list of split points");
        }
        if (!(input.get(0) instanceof DataByteArray)) {
            throw new IllegalArgumentException("expected a DataByteArray as a sketch, got " + input.get(0).getClass().getSimpleName());
        }
        DataByteArray dba = (DataByteArray)input.get(0);
        ItemsSketch sketch = ItemsSketch.getInstance((Memory)Memory.wrap((byte[])dba.get()), Comparator.naturalOrder(), (ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
        Object[] splitPoints = new String[input.size() - 1];
        for (int i = 1; i < input.size(); ++i) {
            if (!(input.get(i) instanceof String)) {
                throw new IllegalArgumentException("expected a string value as a split point, got " + input.get(i).getClass().getSimpleName());
            }
            splitPoints[i - 1] = (String)input.get(i);
        }
        double[] pmf = sketch.getPMF(splitPoints);
        if (pmf == null) {
            return null;
        }
        return Util.doubleArrayToTuple(pmf);
    }
}

