/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.cpc;

import java.io.IOException;
import org.apache.datasketches.cpc.CpcSketch;
import org.apache.pig.EvalFunc;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;

public class SketchToString
extends EvalFunc<String> {
    private final boolean isDetailed_;
    private final long seed_;

    public SketchToString() {
        this(false, 9001L);
    }

    public SketchToString(String isDetailed) {
        this(Boolean.parseBoolean(isDetailed), 9001L);
    }

    public SketchToString(String isDetailed, String seed) {
        this(Boolean.parseBoolean(isDetailed), Long.parseLong(seed));
    }

    private SketchToString(boolean isDetailed, long seed) {
        this.isDetailed_ = isDetailed;
        this.seed_ = seed;
    }

    public String exec(Tuple sketchTuple) throws IOException {
        if (sketchTuple == null || sketchTuple.size() == 0) {
            return null;
        }
        DataByteArray dba = (DataByteArray)sketchTuple.get(0);
        CpcSketch sketch = CpcSketch.heapify((byte[])dba.get(), (long)this.seed_);
        return sketch.toString(this.isDetailed_);
    }
}

