/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.tuple;

import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.pig.tuple.DataToArrayOfDoublesSketch;
import org.apache.datasketches.pig.tuple.PigUtil;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesSketches;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesUpdatableSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesUpdatableSketchBuilder;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DataToArrayOfDoublesSketchTest {
    @Test
    public void execNullInputTuple() throws Exception {
        DataToArrayOfDoublesSketch func = new DataToArrayOfDoublesSketch();
        Tuple resultTuple = (Tuple)func.exec(null);
        Assert.assertNull((Object)resultTuple);
    }

    @Test
    public void execEmptyInputTuple() throws Exception {
        DataToArrayOfDoublesSketch func = new DataToArrayOfDoublesSketch();
        Tuple resultTuple = (Tuple)func.exec(TupleFactory.getInstance().newTuple());
        Assert.assertNull((Object)resultTuple);
    }

    @Test
    public void execEmptyBag() throws Exception {
        DataToArrayOfDoublesSketch func = new DataToArrayOfDoublesSketch("1");
        Tuple inputTuple = PigUtil.objectsToTuple(BagFactory.getInstance().newDefaultBag());
        Tuple resultTuple = (Tuple)func.exec(inputTuple);
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        DataByteArray bytes = (DataByteArray)resultTuple.get(0);
        Assert.assertTrue((bytes.size() > 0 ? 1 : 0) != 0);
        ArrayOfDoublesSketch sketch = ArrayOfDoublesSketches.heapifySketch((Memory)Memory.wrap((byte[])bytes.get()));
        Assert.assertEquals((double)sketch.getEstimate(), (double)0.0);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void execWrongSizeOfInnerTuple() throws Exception {
        DataToArrayOfDoublesSketch func = new DataToArrayOfDoublesSketch("32", "1");
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        bag.add(PigUtil.objectsToTuple(1));
        Tuple inputTuple = PigUtil.objectsToTuple(bag);
        func.exec(inputTuple);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void execWrongKeyType() throws Exception {
        DataToArrayOfDoublesSketch func = new DataToArrayOfDoublesSketch("32", "1");
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        bag.add(PigUtil.objectsToTuple(new Object(), 1.0));
        Tuple inputTuple = PigUtil.objectsToTuple(bag);
        func.exec(inputTuple);
    }

    @Test
    public void execAllInputTypes() throws Exception {
        DataToArrayOfDoublesSketch func = new DataToArrayOfDoublesSketch("32", "1");
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        bag.add(PigUtil.objectsToTuple("a", 1.0));
        bag.add(PigUtil.objectsToTuple("b", 1.0));
        bag.add(PigUtil.objectsToTuple("a", 2.0));
        bag.add(PigUtil.objectsToTuple("b", 2.0));
        bag.add(PigUtil.objectsToTuple(1, 3.0));
        bag.add(PigUtil.objectsToTuple(2L, 3.0));
        bag.add(PigUtil.objectsToTuple(Float.valueOf(1.0f), 3.0));
        bag.add(PigUtil.objectsToTuple(2.0, 3.0));
        bag.add(PigUtil.objectsToTuple((byte)3, 3.0));
        bag.add(PigUtil.objectsToTuple(new DataByteArray("c".getBytes()), 3.0));
        Tuple inputTuple = PigUtil.objectsToTuple(bag);
        Tuple resultTuple = (Tuple)func.exec(inputTuple);
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        DataByteArray bytes = (DataByteArray)resultTuple.get(0);
        Assert.assertTrue((bytes.size() > 0 ? 1 : 0) != 0);
        ArrayOfDoublesSketch sketch = ArrayOfDoublesSketches.heapifySketch((Memory)Memory.wrap((byte[])bytes.get()));
        Assert.assertEquals((double)sketch.getEstimate(), (double)8.0, (double)0.0);
        for (double[] values : sketch.getValues()) {
            Assert.assertEquals((double)values[0], (double)3.0);
        }
    }

    @Test
    public void execWithSampling() throws Exception {
        DataToArrayOfDoublesSketch func = new DataToArrayOfDoublesSketch("1024", "0.5", "1");
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        int uniques = 10000;
        for (int i = 0; i < uniques; ++i) {
            bag.add(PigUtil.objectsToTuple(i, 1.0));
        }
        Tuple resultTuple = (Tuple)func.exec(PigUtil.objectsToTuple(bag));
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        DataByteArray bytes = (DataByteArray)resultTuple.get(0);
        Assert.assertTrue((bytes.size() > 0 ? 1 : 0) != 0);
        ArrayOfDoublesSketch sketch = ArrayOfDoublesSketches.heapifySketch((Memory)Memory.wrap((byte[])bytes.get()));
        Assert.assertEquals((double)sketch.getEstimate(), (double)uniques, (double)((double)uniques * 0.01));
    }

    @Test
    public void accumulator() throws Exception {
        DataToArrayOfDoublesSketch func = new DataToArrayOfDoublesSketch("32", "1");
        Tuple inputTuple = TupleFactory.getInstance().newTuple(1);
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        bag.add(PigUtil.objectsToTuple("a", 1.0));
        inputTuple.set(0, (Object)bag);
        func.accumulate(inputTuple);
        inputTuple = TupleFactory.getInstance().newTuple(1);
        bag = BagFactory.getInstance().newDefaultBag();
        bag.add(PigUtil.objectsToTuple("b", 1.0));
        bag.add(PigUtil.objectsToTuple("a", 2.0));
        bag.add(PigUtil.objectsToTuple("b", 2.0));
        inputTuple.set(0, (Object)bag);
        func.accumulate(inputTuple);
        Tuple resultTuple = (Tuple)func.getValue();
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        DataByteArray bytes = (DataByteArray)resultTuple.get(0);
        Assert.assertTrue((bytes.size() > 0 ? 1 : 0) != 0);
        ArrayOfDoublesSketch sketch = ArrayOfDoublesSketches.heapifySketch((Memory)Memory.wrap((byte[])bytes.get()));
        Assert.assertEquals((double)sketch.getEstimate(), (double)2.0, (double)0.0);
        for (double[] values : sketch.getValues()) {
            Assert.assertEquals((double)values[0], (double)3.0);
        }
        func.cleanup();
        resultTuple = (Tuple)func.getValue();
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        bytes = (DataByteArray)resultTuple.get(0);
        Assert.assertTrue((bytes.size() > 0 ? 1 : 0) != 0);
        ArrayOfDoublesSketch sketch2 = ArrayOfDoublesSketches.heapifySketch((Memory)Memory.wrap((byte[])bytes.get()));
        Assert.assertEquals((double)sketch2.getEstimate(), (double)0.0, (double)0.0);
    }

    @Test
    public void algebraicInitial() throws Exception {
        DataToArrayOfDoublesSketch.Initial func = new DataToArrayOfDoublesSketch.Initial(null);
        Tuple inputTuple = TupleFactory.getInstance().newTuple(1);
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        bag.add(PigUtil.objectsToTuple(null, null));
        bag.add(PigUtil.objectsToTuple(null, null));
        bag.add(PigUtil.objectsToTuple(null, null));
        inputTuple.set(0, (Object)bag);
        Tuple resultTuple = (Tuple)func.exec(inputTuple);
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        DataBag resultBag = (DataBag)resultTuple.get(0);
        Assert.assertEquals((long)resultBag.size(), (long)3L);
    }

    @Test
    public void algebraicIntermediateFinal() throws Exception {
        DataToArrayOfDoublesSketch.IntermediateFinal func = new DataToArrayOfDoublesSketch.IntermediateFinal("1");
        Tuple inputTuple = TupleFactory.getInstance().newTuple(1);
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        inputTuple.set(0, (Object)bag);
        bag.add(PigUtil.objectsToTuple(PigUtil.tuplesToBag(PigUtil.objectsToTuple("a", 1.0))));
        ArrayOfDoublesUpdatableSketch sketch = new ArrayOfDoublesUpdatableSketchBuilder().build();
        sketch.update("b", new double[]{1.0});
        sketch.update("a", new double[]{2.0});
        sketch.update("b", new double[]{2.0});
        bag.add(PigUtil.objectsToTuple(new DataByteArray(sketch.compact().toByteArray())));
        Tuple resultTuple = (Tuple)func.exec(inputTuple);
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        DataByteArray bytes = (DataByteArray)resultTuple.get(0);
        Assert.assertTrue((bytes.size() > 0 ? 1 : 0) != 0);
        ArrayOfDoublesSketch sketch2 = ArrayOfDoublesSketches.heapifySketch((Memory)Memory.wrap((byte[])bytes.get()));
        Assert.assertEquals((double)sketch2.getEstimate(), (double)2.0, (double)0.0);
        for (double[] values : sketch2.getValues()) {
            Assert.assertEquals((double)values[0], (double)3.0);
        }
    }

    @Test
    public void algebraicIntermediateFinalWithSampling() throws Exception {
        DataToArrayOfDoublesSketch.IntermediateFinal func = new DataToArrayOfDoublesSketch.IntermediateFinal("1024", "0.5", "1");
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        int uniques = 10000;
        for (int i = 0; i < uniques; ++i) {
            bag.add(PigUtil.objectsToTuple(i, 1.0));
        }
        Tuple resultTuple = (Tuple)func.exec(PigUtil.objectsToTuple(PigUtil.tuplesToBag(PigUtil.objectsToTuple(bag))));
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        DataByteArray bytes = (DataByteArray)resultTuple.get(0);
        Assert.assertTrue((bytes.size() > 0 ? 1 : 0) != 0);
        ArrayOfDoublesSketch sketch = ArrayOfDoublesSketches.heapifySketch((Memory)Memory.wrap((byte[])bytes.get()));
        Assert.assertEquals((double)sketch.getEstimate(), (double)uniques, (double)((double)uniques * 0.01));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void algebraicIntermediateFinalNullBag() throws Exception {
        DataToArrayOfDoublesSketch.IntermediateFinal func = new DataToArrayOfDoublesSketch.IntermediateFinal("32", "1");
        func.exec(TupleFactory.getInstance().newTuple(1));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void algebraicIntermediateFinalWrongType() throws Exception {
        DataToArrayOfDoublesSketch.IntermediateFinal func = new DataToArrayOfDoublesSketch.IntermediateFinal("32", "1");
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        bag.add(TupleFactory.getInstance().newTuple((Object)1.0));
        func.exec(TupleFactory.getInstance().newTuple((Object)bag));
    }
}

