/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.theta;

import java.io.IOException;
import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.pig.PigTestingUtil;
import org.apache.datasketches.pig.theta.Estimate;
import org.apache.datasketches.pig.theta.Union;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.testng.Assert;
import org.testng.annotations.Test;

public class UnionTest {
    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkConstructorExceptions1() {
        Union test = new Union("1023");
        Assert.assertNotNull((Object)test);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void checkConstructorExceptions3() {
        Union test = new Union("8");
        Assert.assertNotNull((Object)test);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void testConstructorExceptions4() {
        Union test = new Union("1024", "2.0");
        Assert.assertNotNull((Object)test);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void checkNotDBAExcep() throws IOException {
        Union inter = new Union();
        Tuple inputTuple = TupleFactory.getInstance().newTuple(1);
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        inputTuple.set(0, (Object)bag);
        Tuple innerTuple = TupleFactory.getInstance().newTuple(1);
        bag.add(innerTuple);
        inter.accumulate(inputTuple);
        innerTuple.set(0, (Object)new Double(1.0));
        inter = new Union();
        inter.accumulate(inputTuple);
    }

    @Test
    public void checkConstructors() {
        Union inter = new Union();
        inter = new Union("1024");
        inter = new Union("1024", "1.0");
        inter = new Union("1024", "1.0", "9001");
        inter = new Union(1024, 1.0f, 9001L);
        Union.Initial initial = new Union.Initial();
        initial = new Union.Initial("1024");
        initial = new Union.Initial("1024", "1.0");
        initial = new Union.Initial("1024", "1.0", "9001");
        Union.IntermediateFinal interFin = new Union.IntermediateFinal();
        interFin = new Union.IntermediateFinal("1024");
        interFin = new Union.IntermediateFinal("1024", "1.0");
        interFin = new Union.IntermediateFinal("1024", "1.0", "9001");
        interFin = new Union.IntermediateFinal(1024, 1.0f, 9001L);
    }

    @Test
    public void checkNullInput() throws IOException {
        Union unionFunc = new Union();
        Estimate estFunc = new Estimate();
        Tuple inputTuple = TupleFactory.getInstance().newTuple(1);
        Tuple resultTuple = (Tuple)unionFunc.exec(inputTuple);
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        Double est = (Double)estFunc.exec(resultTuple);
        Assert.assertEquals((double)est, (double)0.0, (double)0.0);
    }

    @Test
    public void checkExactTopExec() throws IOException {
        Union unionFunc = new Union();
        Estimate estFunc = new Estimate();
        Tuple inputTuple = TupleFactory.getInstance().newTuple(1);
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        inputTuple.set(0, (Object)bag);
        for (int i = 0; i < 4; ++i) {
            Tuple dataTuple = TupleFactory.getInstance().newTuple(1);
            dataTuple.set(0, (Object)PigTestingUtil.createDbaFromQssRange(64, i * 64, 64));
            bag.add(dataTuple);
        }
        Tuple resultTuple = (Tuple)unionFunc.exec(inputTuple);
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        Double est = (Double)estFunc.exec(resultTuple);
        Assert.assertEquals((double)est, (double)256.0, (double)0.0);
    }

    @Test(expectedExceptions={ClassCastException.class})
    public void checkBadClassCast() throws IOException {
        Union unionFunc = new Union("256");
        Tuple inputTuple = TupleFactory.getInstance().newTuple(1);
        inputTuple.set(0, (Object)new Double(1.0));
        unionFunc.accumulate(inputTuple);
    }

    @Test
    public void checkNullEmptyAccumulator() throws IOException {
        Union unionFunc = new Union("256");
        Estimate estFunc = new Estimate();
        Tuple inputTuple = null;
        unionFunc.accumulate(inputTuple);
        inputTuple = TupleFactory.getInstance().newTuple(0);
        unionFunc.accumulate(inputTuple);
        inputTuple = TupleFactory.getInstance().newTuple(1);
        unionFunc.accumulate(inputTuple);
        inputTuple = TupleFactory.getInstance().newTuple(1);
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        inputTuple.set(0, (Object)bag);
        unionFunc.accumulate(inputTuple);
        Tuple innerTuple = TupleFactory.getInstance().newTuple(0);
        bag.add(innerTuple);
        unionFunc.accumulate(inputTuple);
        inputTuple = TupleFactory.getInstance().newTuple(1);
        bag = BagFactory.getInstance().newDefaultBag();
        inputTuple.set(0, (Object)bag);
        innerTuple = TupleFactory.getInstance().newTuple(1);
        bag.add(innerTuple);
        unionFunc.accumulate(inputTuple);
        Tuple resultTuple = (Tuple)unionFunc.getValue();
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        Double est = (Double)estFunc.exec(resultTuple);
        Assert.assertEquals((double)est, (double)0.0, (double)0.0);
    }

    @Test
    public void checkEmptyGetValue() throws IOException {
        Union unionFunc = new Union("256");
        Estimate estFunc = new Estimate();
        Tuple resultTuple = (Tuple)unionFunc.getValue();
        DataByteArray dba = (DataByteArray)resultTuple.get(0);
        Assert.assertEquals((int)dba.size(), (int)8);
        Double est = (Double)estFunc.exec(resultTuple);
        Assert.assertEquals((double)est, (double)0.0, (double)0.0);
    }

    @Test
    public void checkExactAccumulator() throws IOException {
        Union unionFunc = new Union("256");
        Estimate estFunc = new Estimate();
        Tuple inputTuple = TupleFactory.getInstance().newTuple(1);
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        inputTuple.set(0, (Object)bag);
        for (int i = 0; i < 4; ++i) {
            Tuple dataTuple = TupleFactory.getInstance().newTuple(1);
            dataTuple.set(0, (Object)PigTestingUtil.createDbaFromQssRange(256, i * 64, 64));
            bag.add(dataTuple);
        }
        unionFunc.accumulate(inputTuple);
        Tuple resultTuple = (Tuple)unionFunc.getValue();
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        DataByteArray dba = (DataByteArray)resultTuple.get(0);
        Assert.assertTrue((dba.size() > 0 ? 1 : 0) != 0);
        Double est = (Double)estFunc.exec(resultTuple);
        Assert.assertEquals((double)est, (double)256.0, (double)0.0);
        unionFunc.cleanup();
        resultTuple = (Tuple)unionFunc.getValue();
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        dba = (DataByteArray)resultTuple.get(0);
        Assert.assertTrue((dba.size() > 0 ? 1 : 0) != 0);
        est = (Double)estFunc.exec(resultTuple);
        Assert.assertEquals((double)est, (double)0.0, (double)0.0);
    }

    @Test
    public void checkExactAlgebraicInitial() throws IOException {
        Union.Initial unionFuncInit = new Union.Initial("256");
        Tuple inputTuple = TupleFactory.getInstance().newTuple(1);
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        inputTuple.set(0, (Object)bag);
        for (int i = 0; i < 4; ++i) {
            Tuple dataTuple = TupleFactory.getInstance().newTuple(1);
            dataTuple.set(0, (Object)PigTestingUtil.createDbaFromQssRange(16, i, 1));
            bag.add(dataTuple);
        }
        Tuple resultTuple = (Tuple)unionFuncInit.exec(inputTuple);
        Assert.assertTrue((resultTuple == inputTuple ? 1 : 0) != 0);
    }

    @Test
    public void checkAlgFinalFromPriorIntermed() throws IOException {
        Union.IntermediateFinal unionFuncIFinal = new Union.IntermediateFinal("256");
        Estimate estFunc = new Estimate();
        Tuple inputTuple = TupleFactory.getInstance().newTuple(1);
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        inputTuple.set(0, (Object)bag);
        for (int i = 0; i < 4; ++i) {
            Tuple sketchTuple = TupleFactory.getInstance().newTuple(1);
            sketchTuple.set(0, (Object)PigTestingUtil.createDbaFromQssRange(64, i * 64, 64));
            bag.add(sketchTuple);
        }
        Tuple resultTuple = (Tuple)unionFuncIFinal.exec(inputTuple);
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        DataByteArray bytes = (DataByteArray)resultTuple.get(0);
        Assert.assertTrue((bytes.size() > 0 ? 1 : 0) != 0);
        Double est = (Double)estFunc.exec(resultTuple);
        Assert.assertEquals((double)est, (double)256.0, (double)0.0);
    }

    @Test
    public void checkAlgFinalFromPriorInitial() throws IOException {
        Union.IntermediateFinal unionFuncFinal = new Union.IntermediateFinal("256");
        Estimate estFunc = new Estimate();
        Tuple inputTuple = TupleFactory.getInstance().newTuple(1);
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        inputTuple.set(0, (Object)bag);
        Tuple innerTuple = TupleFactory.getInstance().newTuple(1);
        DataBag innerBag = BagFactory.getInstance().newDefaultBag();
        innerTuple.set(0, (Object)innerBag);
        bag.add(innerTuple);
        for (int i = 0; i < 4; ++i) {
            Tuple sketchTuple = TupleFactory.getInstance().newTuple(1);
            sketchTuple.set(0, (Object)PigTestingUtil.createDbaFromQssRange(64, i * 64, 64));
            innerBag.add(sketchTuple);
        }
        Tuple resultTuple = (Tuple)unionFuncFinal.exec(inputTuple);
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        DataByteArray bytes = (DataByteArray)resultTuple.get(0);
        Assert.assertTrue((bytes.size() > 0 ? 1 : 0) != 0);
        Double est = (Double)estFunc.exec(resultTuple);
        Assert.assertEquals((double)est, (double)256.0, (double)0.0);
    }

    @Test
    public void checkAlgFinalOuterBagEmptyTuples() throws IOException {
        Union.IntermediateFinal interFuncFinal = new Union.IntermediateFinal("256");
        Estimate estFunc = new Estimate();
        Tuple inputTuple = TupleFactory.getInstance().newTuple(1);
        Tuple resultTuple = (Tuple)interFuncFinal.exec(inputTuple);
        Assert.assertEquals((double)((Double)estFunc.exec(resultTuple)), (double)0.0, (double)0.0);
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        inputTuple.set(0, (Object)bag);
        resultTuple = (Tuple)interFuncFinal.exec(inputTuple);
        Assert.assertEquals((double)((Double)estFunc.exec(resultTuple)), (double)0.0, (double)0.0);
        Tuple innerTuple = TupleFactory.getInstance().newTuple(1);
        bag.add(innerTuple);
        resultTuple = (Tuple)interFuncFinal.exec(inputTuple);
        Assert.assertEquals((double)((Double)estFunc.exec(resultTuple)), (double)0.0, (double)0.0);
    }

    @Test
    public void checkAlgFinalInnerBagEmpty() throws IOException {
        Union.IntermediateFinal interFuncFinal = new Union.IntermediateFinal("256");
        Estimate estFunc = new Estimate();
        Tuple inputTuple = TupleFactory.getInstance().newTuple(1);
        Tuple resultTuple = (Tuple)interFuncFinal.exec(inputTuple);
        Assert.assertEquals((double)((Double)estFunc.exec(resultTuple)), (double)0.0, (double)0.0);
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        inputTuple.set(0, (Object)bag);
        resultTuple = (Tuple)interFuncFinal.exec(inputTuple);
        Assert.assertEquals((double)((Double)estFunc.exec(resultTuple)), (double)0.0, (double)0.0);
        Tuple innerTuple = TupleFactory.getInstance().newTuple(1);
        bag.add(innerTuple);
        DataBag bag2 = BagFactory.getInstance().newDefaultBag();
        innerTuple.set(0, (Object)bag2);
        resultTuple = (Tuple)interFuncFinal.exec(inputTuple);
        Assert.assertEquals((double)((Double)estFunc.exec(resultTuple)), (double)0.0, (double)0.0);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void checkAlgFinalInnerNotDBA() throws IOException {
        Union.IntermediateFinal interFuncFinal = new Union.IntermediateFinal("256");
        Estimate estFunc = new Estimate();
        Tuple inputTuple = TupleFactory.getInstance().newTuple(1);
        Tuple resultTuple = (Tuple)interFuncFinal.exec(inputTuple);
        Assert.assertEquals((double)((Double)estFunc.exec(resultTuple)), (double)0.0, (double)0.0);
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        inputTuple.set(0, (Object)bag);
        resultTuple = (Tuple)interFuncFinal.exec(inputTuple);
        Assert.assertEquals((double)((Double)estFunc.exec(resultTuple)), (double)0.0, (double)0.0);
        Tuple innerTuple = TupleFactory.getInstance().newTuple(1);
        bag.add(innerTuple);
        innerTuple.set(0, (Object)new Double(1.0));
        resultTuple = (Tuple)interFuncFinal.exec(inputTuple);
        Assert.assertEquals((double)((Double)estFunc.exec(resultTuple)), (double)0.0, (double)0.0);
    }

    @Test
    public void outputSchemaTest() throws IOException {
        Union udf = new Union("512");
        Schema inputSchema = null;
        Schema nullOutputSchema = null;
        Schema outputSchema = null;
        Schema.FieldSchema outputOuterFs0 = null;
        Schema outputInnerSchema = null;
        Schema.FieldSchema outputInnerFs0 = null;
        inputSchema = Schema.generateNestedSchema((byte)120, (byte[])new byte[]{50});
        nullOutputSchema = udf.outputSchema(null);
        outputSchema = udf.outputSchema(inputSchema);
        outputOuterFs0 = outputSchema.getField(0);
        outputInnerSchema = outputOuterFs0.schema;
        outputInnerFs0 = outputInnerSchema.getField(0);
        Assert.assertNull((Object)nullOutputSchema, (String)"Should be null");
        Assert.assertNotNull((Object)outputOuterFs0, (String)"outputSchema.getField(0) schema may not be null");
        String expected = "tuple";
        String result = DataType.findTypeName((byte)outputOuterFs0.type);
        Assert.assertEquals((String)result, (String)expected);
        expected = "bytearray";
        Assert.assertNotNull((Object)outputInnerFs0, (String)"innerSchema.getField(0) schema may not be null");
        result = DataType.findTypeName((byte)outputInnerFs0.type);
        Assert.assertEquals((String)result, (String)expected);
        StringBuilder sb = new StringBuilder();
        sb.append("input schema: ").append(inputSchema).append(PigTestingUtil.LS).append("output schema: ").append(outputSchema).append(PigTestingUtil.LS).append("outputOuterFs: ").append(outputOuterFs0).append(", type: ").append(DataType.findTypeName((byte)outputOuterFs0.type)).append(PigTestingUtil.LS).append("outputInnerSchema: ").append(outputInnerSchema).append(PigTestingUtil.LS).append("outputInnerFs0: ").append(outputInnerFs0).append(", type: ").append(DataType.findTypeName((byte)outputInnerFs0.type)).append(PigTestingUtil.LS);
        UnionTest.println(sb.toString());
    }

    @Test
    public void printlnTest() {
        UnionTest.println(this.getClass().getSimpleName());
    }

    static void println(String s) {
    }
}

