/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.frequencies;

import org.apache.datasketches.ArrayOfItemsSerDe;
import org.apache.datasketches.ArrayOfStringsSerDe;
import org.apache.datasketches.frequencies.ErrorType;
import org.apache.datasketches.frequencies.ItemsSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.pig.frequencies.UnionFrequentStringsSketch;
import org.apache.datasketches.pig.tuple.PigUtil;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class UnionFrequentStringsSketchTest {
    @Test
    public void execNullInput() throws Exception {
        UnionFrequentStringsSketch func = new UnionFrequentStringsSketch("8");
        Tuple resultTuple = (Tuple)func.exec(null);
        Assert.assertNull((Object)resultTuple);
    }

    @Test
    public void execEmptyInputTuple() throws Exception {
        UnionFrequentStringsSketch func = new UnionFrequentStringsSketch("8");
        Tuple resultTuple = (Tuple)func.exec(TupleFactory.getInstance().newTuple());
        Assert.assertNull((Object)resultTuple);
    }

    @Test
    public void exec() throws Exception {
        UnionFrequentStringsSketch func = new UnionFrequentStringsSketch("8");
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        ItemsSketch sketch = new ItemsSketch(8);
        sketch.update((Object)"a");
        sketch.update((Object)"b");
        bag.add(PigUtil.objectsToTuple(new DataByteArray(sketch.toByteArray((ArrayOfItemsSerDe)new ArrayOfStringsSerDe()))));
        sketch = new ItemsSketch(8);
        sketch.update((Object)"a");
        sketch.update((Object)"b");
        bag.add(PigUtil.objectsToTuple(new DataByteArray(sketch.toByteArray((ArrayOfItemsSerDe)new ArrayOfStringsSerDe()))));
        Tuple resultTuple = (Tuple)func.exec(PigUtil.objectsToTuple(bag));
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        DataByteArray bytes = (DataByteArray)resultTuple.get(0);
        Assert.assertTrue((bytes.size() > 0 ? 1 : 0) != 0);
        ItemsSketch sketch2 = ItemsSketch.getInstance((Memory)Memory.wrap((byte[])bytes.get()), (ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
        Assert.assertEquals((int)sketch2.getNumActiveItems(), (int)2);
        Assert.assertEquals((long)sketch2.getEstimate((Object)"a"), (long)2L);
        Assert.assertEquals((long)sketch2.getEstimate((Object)"b"), (long)2L);
    }

    @Test
    public void accumulatorNullInput() throws Exception {
        UnionFrequentStringsSketch func = new UnionFrequentStringsSketch("8");
        func.accumulate(null);
        Tuple resultTuple = (Tuple)func.getValue();
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        DataByteArray bytes = (DataByteArray)resultTuple.get(0);
        Assert.assertTrue((bytes.size() > 0 ? 1 : 0) != 0);
        ItemsSketch sketch = ItemsSketch.getInstance((Memory)Memory.wrap((byte[])bytes.get()), (ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
        Assert.assertTrue((boolean)sketch.isEmpty());
        Assert.assertEquals((int)sketch.getNumActiveItems(), (int)0);
    }

    @Test
    public void accumulatorEmptyInputTuple() throws Exception {
        UnionFrequentStringsSketch func = new UnionFrequentStringsSketch("8");
        func.accumulate(TupleFactory.getInstance().newTuple());
        Tuple resultTuple = (Tuple)func.getValue();
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        DataByteArray bytes = (DataByteArray)resultTuple.get(0);
        Assert.assertTrue((bytes.size() > 0 ? 1 : 0) != 0);
        ItemsSketch sketch = ItemsSketch.getInstance((Memory)Memory.wrap((byte[])bytes.get()), (ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
        Assert.assertTrue((boolean)sketch.isEmpty());
        Assert.assertEquals((int)sketch.getNumActiveItems(), (int)0);
    }

    @Test
    public void accumulatorNotABag() throws Exception {
        UnionFrequentStringsSketch func = new UnionFrequentStringsSketch("8");
        func.accumulate(PigUtil.objectsToTuple(new Object[]{null}));
        Tuple resultTuple = (Tuple)func.getValue();
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        DataByteArray bytes = (DataByteArray)resultTuple.get(0);
        Assert.assertTrue((bytes.size() > 0 ? 1 : 0) != 0);
        ItemsSketch sketch = ItemsSketch.getInstance((Memory)Memory.wrap((byte[])bytes.get()), (ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
        Assert.assertTrue((boolean)sketch.isEmpty());
        Assert.assertEquals((int)sketch.getNumActiveItems(), (int)0);
    }

    @Test
    public void accumulatorEmptyBag() throws Exception {
        UnionFrequentStringsSketch func = new UnionFrequentStringsSketch("8");
        func.accumulate(PigUtil.objectsToTuple(BagFactory.getInstance().newDefaultBag()));
        Tuple resultTuple = (Tuple)func.getValue();
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        DataByteArray bytes = (DataByteArray)resultTuple.get(0);
        Assert.assertTrue((bytes.size() > 0 ? 1 : 0) != 0);
        ItemsSketch sketch = ItemsSketch.getInstance((Memory)Memory.wrap((byte[])bytes.get()), (ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
        Assert.assertTrue((boolean)sketch.isEmpty());
        Assert.assertEquals((int)sketch.getNumActiveItems(), (int)0);
    }

    @Test
    public void accumulatorEmptyInnerTuple() throws Exception {
        UnionFrequentStringsSketch func = new UnionFrequentStringsSketch("8");
        func.accumulate(PigUtil.objectsToTuple(PigUtil.tuplesToBag(TupleFactory.getInstance().newTuple())));
        Tuple resultTuple = (Tuple)func.getValue();
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        DataByteArray bytes = (DataByteArray)resultTuple.get(0);
        Assert.assertTrue((bytes.size() > 0 ? 1 : 0) != 0);
        ItemsSketch sketch = ItemsSketch.getInstance((Memory)Memory.wrap((byte[])bytes.get()), (ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
        Assert.assertTrue((boolean)sketch.isEmpty());
        Assert.assertEquals((int)sketch.getNumActiveItems(), (int)0);
    }

    @Test
    public void accumulatorNullSketch() throws Exception {
        UnionFrequentStringsSketch func = new UnionFrequentStringsSketch("8");
        func.accumulate(PigUtil.objectsToTuple(PigUtil.tuplesToBag(PigUtil.objectsToTuple(new Object[]{null}))));
        Tuple resultTuple = (Tuple)func.getValue();
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        DataByteArray bytes = (DataByteArray)resultTuple.get(0);
        Assert.assertTrue((bytes.size() > 0 ? 1 : 0) != 0);
        ItemsSketch sketch = ItemsSketch.getInstance((Memory)Memory.wrap((byte[])bytes.get()), (ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
        Assert.assertTrue((boolean)sketch.isEmpty());
        Assert.assertEquals((int)sketch.getNumActiveItems(), (int)0);
    }

    @Test
    public void accumulatorEmptySketch() throws Exception {
        UnionFrequentStringsSketch func = new UnionFrequentStringsSketch("8");
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        ItemsSketch sketch = new ItemsSketch(8);
        bag.add(PigUtil.objectsToTuple(new DataByteArray(sketch.toByteArray((ArrayOfItemsSerDe)new ArrayOfStringsSerDe()))));
        func.accumulate(PigUtil.objectsToTuple(bag));
        Tuple resultTuple = (Tuple)func.getValue();
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        DataByteArray bytes = (DataByteArray)resultTuple.get(0);
        Assert.assertTrue((bytes.size() > 0 ? 1 : 0) != 0);
        ItemsSketch sketch2 = ItemsSketch.getInstance((Memory)Memory.wrap((byte[])bytes.get()), (ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
        Assert.assertTrue((boolean)sketch2.isEmpty());
        Assert.assertEquals((int)sketch2.getNumActiveItems(), (int)0);
    }

    @Test
    public void accumulator() throws Exception {
        UnionFrequentStringsSketch func = new UnionFrequentStringsSketch("8");
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        ItemsSketch sketch = new ItemsSketch(8);
        sketch.update((Object)"a");
        sketch.update((Object)"b");
        bag.add(PigUtil.objectsToTuple(new DataByteArray(sketch.toByteArray((ArrayOfItemsSerDe)new ArrayOfStringsSerDe()))));
        func.accumulate(PigUtil.objectsToTuple(bag));
        bag = BagFactory.getInstance().newDefaultBag();
        sketch = new ItemsSketch(8);
        sketch.update((Object)"a");
        sketch.update((Object)"b");
        bag.add(PigUtil.objectsToTuple(new DataByteArray(sketch.toByteArray((ArrayOfItemsSerDe)new ArrayOfStringsSerDe()))));
        func.accumulate(PigUtil.objectsToTuple(bag));
        Tuple resultTuple = (Tuple)func.getValue();
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        DataByteArray bytes = (DataByteArray)resultTuple.get(0);
        Assert.assertTrue((bytes.size() > 0 ? 1 : 0) != 0);
        ItemsSketch sketch2 = ItemsSketch.getInstance((Memory)Memory.wrap((byte[])bytes.get()), (ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
        Assert.assertFalse((boolean)sketch2.isEmpty());
        Assert.assertEquals((int)sketch2.getNumActiveItems(), (int)2);
        Assert.assertEquals((long)sketch2.getEstimate((Object)"a"), (long)2L);
        Assert.assertEquals((long)sketch2.getEstimate((Object)"b"), (long)2L);
    }

    @Test
    public void algebraicInitial() throws Exception {
        UnionFrequentStringsSketch.Initial func = new UnionFrequentStringsSketch.Initial(null);
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        bag.add(null);
        bag.add(null);
        bag.add(null);
        Tuple resultTuple = (Tuple)func.exec(PigUtil.objectsToTuple(bag));
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        DataBag resultBag = (DataBag)resultTuple.get(0);
        Assert.assertEquals((long)resultBag.size(), (long)3L);
    }

    @Test
    public void algebraicIntemediateFinalExact() throws Exception {
        UnionFrequentStringsSketch.IntermediateFinal func = new UnionFrequentStringsSketch.IntermediateFinal("8");
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        ItemsSketch sketch = new ItemsSketch(8);
        sketch.update((Object)"a");
        sketch.update((Object)"b");
        DataBag innerBag = PigUtil.tuplesToBag(PigUtil.objectsToTuple(new DataByteArray(sketch.toByteArray((ArrayOfItemsSerDe)new ArrayOfStringsSerDe()))));
        bag.add(PigUtil.objectsToTuple(innerBag));
        sketch = new ItemsSketch(8);
        sketch.update((Object)"a", 2L);
        sketch.update((Object)"b", 3L);
        bag.add(PigUtil.objectsToTuple(new DataByteArray(sketch.toByteArray((ArrayOfItemsSerDe)new ArrayOfStringsSerDe()))));
        Tuple resultTuple = (Tuple)func.exec(PigUtil.objectsToTuple(bag));
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        DataByteArray bytes = (DataByteArray)resultTuple.get(0);
        Assert.assertTrue((bytes.size() > 0 ? 1 : 0) != 0);
        ItemsSketch sketch2 = ItemsSketch.getInstance((Memory)Memory.wrap((byte[])bytes.get()), (ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
        Assert.assertFalse((boolean)sketch2.isEmpty());
        Assert.assertEquals((int)sketch2.getNumActiveItems(), (int)2);
        Assert.assertEquals((long)sketch2.getEstimate((Object)"a"), (long)3L);
        Assert.assertEquals((long)sketch2.getEstimate((Object)"b"), (long)4L);
    }

    @Test
    public void algebraicIntemediateFinalEstimation() throws Exception {
        UnionFrequentStringsSketch.IntermediateFinal func = new UnionFrequentStringsSketch.IntermediateFinal("8");
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        ItemsSketch sketch = new ItemsSketch(8);
        sketch.update((Object)"a", 10L);
        sketch.update((Object)"b");
        sketch.update((Object)"c");
        sketch.update((Object)"d");
        sketch.update((Object)"e");
        sketch.update((Object)"f");
        sketch.update((Object)"g");
        sketch.update((Object)"g");
        DataBag innerBag = PigUtil.tuplesToBag(PigUtil.objectsToTuple(new DataByteArray(sketch.toByteArray((ArrayOfItemsSerDe)new ArrayOfStringsSerDe()))));
        bag.add(PigUtil.objectsToTuple(innerBag));
        sketch = new ItemsSketch(8);
        sketch.update((Object)"a");
        sketch.update((Object)"a");
        sketch.update((Object)"g", 5L);
        sketch.update((Object)"h");
        sketch.update((Object)"i");
        sketch.update((Object)"j");
        sketch.update((Object)"k");
        sketch.update((Object)"l");
        bag.add(PigUtil.objectsToTuple(new DataByteArray(sketch.toByteArray((ArrayOfItemsSerDe)new ArrayOfStringsSerDe()))));
        Tuple resultTuple = (Tuple)func.exec(PigUtil.objectsToTuple(bag));
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        DataByteArray bytes = (DataByteArray)resultTuple.get(0);
        Assert.assertTrue((bytes.size() > 0 ? 1 : 0) != 0);
        ItemsSketch sketch2 = ItemsSketch.getInstance((Memory)Memory.wrap((byte[])bytes.get()), (ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
        Assert.assertFalse((boolean)sketch2.isEmpty());
        Assert.assertEquals((long)sketch2.getStreamLength(), (long)29L);
        ItemsSketch.Row[] items = sketch2.getFrequentItems(ErrorType.NO_FALSE_POSITIVES);
        Assert.assertEquals((int)items.length, (int)2);
        int count = 0;
        for (ItemsSketch.Row item : items) {
            if (item.getLowerBound() <= 1L) continue;
            ++count;
        }
        Assert.assertEquals((int)count, (int)2);
    }
}

