/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.hll;

import org.apache.datasketches.hive.common.BytesWritableHelper;
import org.apache.datasketches.hive.hll.UnionSketchUDF;
import org.apache.datasketches.hll.HllSketch;
import org.apache.datasketches.hll.TgtHllType;
import org.apache.datasketches.memory.Memory;
import org.apache.hadoop.io.BytesWritable;
import org.testng.Assert;
import org.testng.annotations.Test;

public class UnionSketchUDFTest {
    @Test
    public void nullInputs() {
        UnionSketchUDF udf = new UnionSketchUDF();
        BytesWritable result = udf.evaluate(null, null);
        HllSketch resultSketch = HllSketch.heapify((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)result));
        Assert.assertTrue((boolean)resultSketch.isEmpty());
        Assert.assertEquals((double)resultSketch.getEstimate(), (double)0.0);
    }

    @Test
    public void validSketches() {
        UnionSketchUDF udf = new UnionSketchUDF();
        HllSketch sketch1 = new HllSketch(12);
        for (int i = 0; i < 128; ++i) {
            sketch1.update((long)i);
        }
        HllSketch sketch2 = new HllSketch(12);
        for (int i = 100; i < 256; ++i) {
            sketch2.update((long)i);
        }
        BytesWritable input1 = new BytesWritable(sketch1.toCompactByteArray());
        BytesWritable input2 = new BytesWritable(sketch2.toCompactByteArray());
        BytesWritable result = udf.evaluate(input1, input2);
        HllSketch resultSketch = HllSketch.heapify((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)result));
        Assert.assertEquals((double)resultSketch.getEstimate(), (double)256.0, (double)2.56);
    }

    @Test
    public void validSketchesExplicitParams() {
        UnionSketchUDF udf = new UnionSketchUDF();
        int lgK = 10;
        TgtHllType type = TgtHllType.HLL_6;
        HllSketch sketch1 = new HllSketch(10);
        for (int i = 0; i < 128; ++i) {
            sketch1.update((long)i);
        }
        HllSketch sketch2 = new HllSketch(10);
        for (int i = 100; i < 256; ++i) {
            sketch2.update((long)i);
        }
        BytesWritable input1 = new BytesWritable(sketch1.toCompactByteArray());
        BytesWritable input2 = new BytesWritable(sketch2.toCompactByteArray());
        BytesWritable result = udf.evaluate(input1, input2, 10, type.toString());
        HllSketch resultSketch = HllSketch.heapify((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)result));
        Assert.assertEquals((int)resultSketch.getLgConfigK(), (int)10);
        Assert.assertEquals((Object)resultSketch.getTgtHllType(), (Object)type);
        Assert.assertEquals((double)resultSketch.getEstimate(), (double)256.0, (double)5.12);
    }
}

