/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.hll;

import java.util.List;
import org.apache.datasketches.hive.hll.SketchToEstimateAndErrorBoundsUDF;
import org.apache.datasketches.hll.HllSketch;
import org.apache.hadoop.io.BytesWritable;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SketchToEstimateAndErrorBoundsUDFTest {
    @Test
    public void nullSketch() {
        List result = new SketchToEstimateAndErrorBoundsUDF().evaluate(null);
        Assert.assertNull((Object)result);
    }

    @Test
    public void emptySketch() {
        HllSketch sketch = new HllSketch(12);
        List result = new SketchToEstimateAndErrorBoundsUDF().evaluate(new BytesWritable(sketch.toCompactByteArray()));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((int)result.size(), (int)3);
        Assert.assertEquals((double)((Double)result.get(0)), (double)0.0);
        Assert.assertEquals((double)((Double)result.get(1)), (double)0.0);
        Assert.assertEquals((double)((Double)result.get(2)), (double)0.0);
    }

    @Test
    public void normalCase() {
        HllSketch sketch = new HllSketch(12);
        sketch.update(1L);
        sketch.update(2L);
        List result = new SketchToEstimateAndErrorBoundsUDF().evaluate(new BytesWritable(sketch.toCompactByteArray()));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((int)result.size(), (int)3);
        Assert.assertEquals((double)((Double)result.get(0)), (double)2.0, (double)0.01);
        Assert.assertTrue(((Double)result.get(1) <= 2.0 ? 1 : 0) != 0);
        Assert.assertTrue(((Double)result.get(2) >= 2.0 ? 1 : 0) != 0);
    }

    @Test
    public void normalCaseWithKappa() {
        HllSketch sketch = new HllSketch(12);
        sketch.update(1L);
        sketch.update(2L);
        List result = new SketchToEstimateAndErrorBoundsUDF().evaluate(new BytesWritable(sketch.toCompactByteArray()), 3);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((int)result.size(), (int)3);
        Assert.assertEquals((double)((Double)result.get(0)), (double)2.0, (double)0.01);
        Assert.assertTrue(((Double)result.get(1) <= 2.0 ? 1 : 0) != 0);
        Assert.assertTrue(((Double)result.get(2) >= 2.0 ? 1 : 0) != 0);
    }
}

