/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.unparsers.runtime1;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.daffodil.io.DataOutputStream;
import org.apache.daffodil.io.FormatInfo;
import org.apache.daffodil.runtime1.processors.ElementRuntimeData;
import org.apache.daffodil.runtime1.processors.unparsers.UState;
import org.apache.daffodil.unparsers.runtime1.PackedBinaryBaseUnparser;
import scala.Int$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public abstract class PackedBinaryDecimalBaseUnparser
extends PackedBinaryBaseUnparser {
    private final ElementRuntimeData e;
    private final int binaryDecimalVirtualPoint;

    public PackedBinaryDecimalBaseUnparser(ElementRuntimeData e, int binaryDecimalVirtualPoint) {
        this.e = e;
        this.binaryDecimalVirtualPoint = binaryDecimalVirtualPoint;
        super(e);
    }

    @Override
    public Number getNumberToPut(UState ustate) {
        Number number = super.getNumberToPut(ustate);
        BigDecimal bigDec = (BigDecimal)number;
        if (bigDec.movePointRight(this.binaryDecimalVirtualPoint).scale() != 0) {
            throw this.e.schemaDefinitionError("Decimal point of number '%s' does not match the binaryVirtualDecmialPoint: %d", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{bigDec, BoxesRunTime.boxToInteger((int)this.binaryDecimalVirtualPoint)}));
        }
        return bigDec.unscaledValue();
    }

    @Override
    public boolean putNumber(DataOutputStream dos, Number number, int nBits, FormatInfo finfo) {
        byte[] packedNum = this.fromBigInteger((BigInteger)number, nBits);
        return dos.putByteArray(packedNum, Int$.MODULE$.int2long(packedNum.length * 8), finfo, dos.putByteArray$default$4());
    }
}

