/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import java.util.Objects;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;

public class SessionConsumerCloseMessage
extends PacketImpl {
    private long consumerID;

    public SessionConsumerCloseMessage(long objectID) {
        super((byte)74);
        this.consumerID = objectID;
    }

    public SessionConsumerCloseMessage() {
        super((byte)74);
    }

    public long getConsumerID() {
        return this.consumerID;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeLong(this.consumerID);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        this.consumerID = buffer.readLong();
    }

    @Override
    protected String getPacketString() {
        return super.getPacketString() + ", consumerID=" + this.consumerID;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Objects.hashCode(this.consumerID);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SessionConsumerCloseMessage)) {
            return false;
        }
        SessionConsumerCloseMessage other = (SessionConsumerCloseMessage)obj;
        return this.consumerID == other.consumerID;
    }
}

