/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.config.amqpBrokerConnectivity;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBridgeAddressPolicyElement;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBridgeQueuePolicyElement;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectionAddressType;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectionElement;

public class AMQPBridgeBrokerConnectionElement
extends AMQPBrokerConnectionElement {
    private static final long serialVersionUID = 2519807622833191168L;
    private Set<AMQPBridgeAddressPolicyElement> bridgeFromAddressPolicies = new HashSet<AMQPBridgeAddressPolicyElement>();
    private Set<AMQPBridgeQueuePolicyElement> bridgeFromQueuePolicies = new HashSet<AMQPBridgeQueuePolicyElement>();
    private Set<AMQPBridgeAddressPolicyElement> bridgeToAddressPolicies = new HashSet<AMQPBridgeAddressPolicyElement>();
    private Set<AMQPBridgeQueuePolicyElement> bridgeToQueuePolicies = new HashSet<AMQPBridgeQueuePolicyElement>();
    private Map<String, Object> properties = new HashMap<String, Object>();

    public AMQPBridgeBrokerConnectionElement() {
        this.setType(AMQPBrokerConnectionAddressType.BRIDGE);
    }

    public AMQPBridgeBrokerConnectionElement(String name) {
        this.setType(AMQPBrokerConnectionAddressType.BRIDGE);
        this.setName(name);
    }

    @Override
    public AMQPBridgeBrokerConnectionElement setType(AMQPBrokerConnectionAddressType type) {
        if (AMQPBrokerConnectionAddressType.BRIDGE.equals((Object)type)) {
            return (AMQPBridgeBrokerConnectionElement)super.setType(type);
        }
        throw new IllegalArgumentException("Cannot change a BRIDGE connection element to type: " + String.valueOf((Object)type));
    }

    public Set<AMQPBridgeAddressPolicyElement> getBridgeFromAddressPolicies() {
        return this.bridgeFromAddressPolicies;
    }

    public AMQPBridgeBrokerConnectionElement addBridgeFromAddressPolicy(AMQPBridgeAddressPolicyElement fromAddressPolicy) {
        this.bridgeFromAddressPolicies.add(fromAddressPolicy);
        return this;
    }

    public Set<AMQPBridgeAddressPolicyElement> getBridgeToAddressPolicies() {
        return this.bridgeToAddressPolicies;
    }

    public AMQPBridgeBrokerConnectionElement addBridgeToAddressPolicy(AMQPBridgeAddressPolicyElement toAddressPolicy) {
        this.bridgeToAddressPolicies.add(toAddressPolicy);
        return this;
    }

    public Set<AMQPBridgeQueuePolicyElement> getBridgeFromQueuePolicies() {
        return this.bridgeFromQueuePolicies;
    }

    public AMQPBridgeBrokerConnectionElement addBridgeFromQueuePolicy(AMQPBridgeQueuePolicyElement fromQueuePolicy) {
        this.bridgeFromQueuePolicies.add(fromQueuePolicy);
        return this;
    }

    public Set<AMQPBridgeQueuePolicyElement> getBridgeToQueuePolicies() {
        return this.bridgeToQueuePolicies;
    }

    public AMQPBridgeBrokerConnectionElement addBridgeToQueuePolicy(AMQPBridgeQueuePolicyElement toQueuePolicy) {
        this.bridgeToQueuePolicies.add(toQueuePolicy);
        return this;
    }

    public AMQPBridgeBrokerConnectionElement addProperty(String key, String value) {
        this.properties.put(key, value);
        return this;
    }

    public AMQPBridgeBrokerConnectionElement addProperty(String key, Number value) {
        this.properties.put(key, value);
        return this;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.bridgeFromAddressPolicies, this.bridgeFromQueuePolicies, this.properties, this.bridgeToAddressPolicies, this.bridgeToQueuePolicies);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AMQPBridgeBrokerConnectionElement other = (AMQPBridgeBrokerConnectionElement)obj;
        return Objects.equals(this.bridgeFromAddressPolicies, other.bridgeFromAddressPolicies) && Objects.equals(this.bridgeFromQueuePolicies, other.bridgeFromQueuePolicies) && Objects.equals(this.properties, other.properties) && Objects.equals(this.bridgeToAddressPolicies, other.bridgeToAddressPolicies) && Objects.equals(this.bridgeToQueuePolicies, other.bridgeToQueuePolicies);
    }
}

