/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import java.lang.invoke.MethodHandles;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.ActiveMQQueueExistsException;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.utils.CompositeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoCreateUtil {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void autoCreateQueue(ClientSession session, SimpleString destAddress, SimpleString selectorString) throws ActiveMQException {
        ClientSession.AddressQuery response = session.addressQuery(destAddress);
        SimpleString queueName = AutoCreateUtil.getCoreQueueName(session, destAddress);
        if (!response.isExists() || !response.getQueueNames().contains(queueName)) {
            if (!response.isAutoCreateQueues()) throw new ActiveMQException("Destination " + String.valueOf(destAddress) + " does not exist", ActiveMQExceptionType.QUEUE_DOES_NOT_EXIST);
            try {
                QueueConfiguration queueConfiguration = QueueConfiguration.of((SimpleString)queueName).setAutoCreated(Boolean.valueOf(true)).setAddress(destAddress);
                AutoCreateUtil.setRequiredQueueConfigurationIfNotSet(queueConfiguration, response, RoutingType.ANYCAST, selectorString, true);
                session.createQueue(queueConfiguration);
                logger.debug("The queue {} was created automatically", (Object)destAddress);
                return;
            }
            catch (ActiveMQQueueExistsException queueConfiguration) {}
            return;
        } else {
            ClientSession.QueueQuery queueQueryResult = session.queueQuery(queueName);
            RoutingType routingType = queueQueryResult.getRoutingType();
            if (routingType == null || routingType == RoutingType.ANYCAST || CompositeAddress.isFullyQualified((SimpleString)destAddress)) return;
            throw new ActiveMQException("Destination " + String.valueOf(destAddress) + " does not support JMS queue semantics", ActiveMQExceptionType.QUEUE_DOES_NOT_EXIST);
        }
    }

    public static void setRequiredQueueConfigurationIfNotSet(QueueConfiguration queueConfiguration, ClientSession.AddressQuery addressQuery, RoutingType routingType, SimpleString filter, boolean durable) {
        if (queueConfiguration.getRoutingType() == null) {
            queueConfiguration.setRoutingType(routingType);
        }
        if (queueConfiguration.getFilterString() == null) {
            queueConfiguration.setFilterString(filter);
        }
        if (queueConfiguration.getMaxConsumers() == null) {
            queueConfiguration.setMaxConsumers(Integer.valueOf(addressQuery.getDefaultMaxConsumers()));
        }
        if (queueConfiguration.isPurgeOnNoConsumers() == null) {
            queueConfiguration.setPurgeOnNoConsumers(Boolean.valueOf(addressQuery.isDefaultPurgeOnNoConsumers()));
        }
        queueConfiguration.setDurable(Boolean.valueOf(durable));
    }

    public static SimpleString getCoreQueueName(ClientSession session, SimpleString destAddress) {
        if (session.getVersion() < 130) {
            return destAddress;
        }
        return CompositeAddress.extractQueueName((SimpleString)destAddress);
    }
}

