/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.credential.impl;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.ResolverException;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.impl.AbstractCredentialResolver;

public class StaticCredentialResolver
extends AbstractCredentialResolver {
    @Nonnull
    private final List<Credential> creds;

    public StaticCredentialResolver(@Nonnull @ParameterName(name="credentials") List<Credential> credentials) {
        Constraint.isNotNull(credentials, (String)"Input credentials list cannot be null");
        this.creds = CollectionSupport.copyToList(credentials);
    }

    public StaticCredentialResolver(@Nonnull @ParameterName(name="credential") Credential credential) {
        Constraint.isNotNull((Object)credential, (String)"Input credential cannot be null");
        this.creds = CollectionSupport.singletonList((Object)credential);
    }

    @Override
    @Nonnull
    public Iterable<Credential> resolve(@Nullable CriteriaSet criteria) throws ResolverException {
        return this.creds;
    }
}

