/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.cluster.ha;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.core.io.IOCriticalErrorListener;
import org.apache.activemq.artemis.core.server.cluster.ha.BackupPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.HAPolicy;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.core.server.impl.ColocatedActivation;
import org.apache.activemq.artemis.core.server.impl.PrimaryActivation;

public class ColocatedPolicy
implements HAPolicy<PrimaryActivation> {
    private boolean requestBackup = ActiveMQDefaultConfiguration.isDefaultHapolicyRequestBackup();
    private int backupRequestRetries = ActiveMQDefaultConfiguration.getDefaultHapolicyBackupRequestRetries();
    private long backupRequestRetryInterval = ActiveMQDefaultConfiguration.getDefaultHapolicyBackupRequestRetryInterval();
    private int maxBackups = ActiveMQDefaultConfiguration.getDefaultHapolicyMaxBackups();
    private int backupPortOffset = ActiveMQDefaultConfiguration.getDefaultHapolicyBackupPortOffset();
    private List<String> excludedConnectors = new ArrayList<String>();
    private BackupPolicy backupPolicy;
    private HAPolicy<PrimaryActivation> primaryPolicy;

    public ColocatedPolicy(boolean requestBackup, int backupRequestRetries, long backupRequestRetryInterval, int maxBackups, int backupPortOffset, List<String> excludedConnectors, HAPolicy primaryPolicy, BackupPolicy backupPolicy) {
        this.requestBackup = requestBackup;
        this.backupRequestRetries = backupRequestRetries;
        this.backupRequestRetryInterval = backupRequestRetryInterval;
        this.maxBackups = maxBackups;
        this.backupPortOffset = backupPortOffset;
        this.excludedConnectors = excludedConnectors;
        this.primaryPolicy = primaryPolicy;
        this.backupPolicy = backupPolicy;
    }

    @Override
    public String getBackupGroupName() {
        HAPolicy<PrimaryActivation> primaryPolicy = this.primaryPolicy;
        if (primaryPolicy == null) {
            return null;
        }
        return primaryPolicy.getBackupGroupName();
    }

    @Override
    public String getScaleDownGroupName() {
        return null;
    }

    @Override
    public boolean isSharedStore() {
        return this.backupPolicy.isSharedStore();
    }

    @Override
    public boolean isBackup() {
        return false;
    }

    @Override
    public PrimaryActivation createActivation(ActiveMQServerImpl server, boolean wasPrimary, Map<String, Object> activationParams, IOCriticalErrorListener ioCriticalErrorListener) throws Exception {
        return new ColocatedActivation(server, this, this.primaryPolicy.createActivation(server, wasPrimary, activationParams, ioCriticalErrorListener));
    }

    @Override
    public boolean canScaleDown() {
        return false;
    }

    @Override
    public String getScaleDownClustername() {
        return null;
    }

    public boolean isRequestBackup() {
        return this.requestBackup;
    }

    public void setRequestBackup(boolean requestBackup) {
        this.requestBackup = requestBackup;
    }

    public int getBackupRequestRetries() {
        return this.backupRequestRetries;
    }

    public void setBackupRequestRetries(int backupRequestRetries) {
        this.backupRequestRetries = backupRequestRetries;
    }

    public long getBackupRequestRetryInterval() {
        return this.backupRequestRetryInterval;
    }

    public void setBackupRequestRetryInterval(long backupRequestRetryInterval) {
        this.backupRequestRetryInterval = backupRequestRetryInterval;
    }

    public int getMaxBackups() {
        return this.maxBackups;
    }

    public void setMaxBackups(int maxBackups) {
        this.maxBackups = maxBackups;
    }

    public int getBackupPortOffset() {
        return this.backupPortOffset;
    }

    public void setBackupPortOffset(int backupPortOffset) {
        this.backupPortOffset = backupPortOffset;
    }

    public List<String> getExcludedConnectors() {
        return this.excludedConnectors;
    }

    public void setExcludedConnectors(List<String> excludedConnectors) {
        this.excludedConnectors = excludedConnectors;
    }

    public HAPolicy<PrimaryActivation> getPrimaryPolicy() {
        return this.primaryPolicy;
    }

    public void setPrimaryPolicy(HAPolicy<PrimaryActivation> primaryPolicy) {
        this.primaryPolicy = primaryPolicy;
    }

    public BackupPolicy getBackupPolicy() {
        return this.backupPolicy;
    }

    public void setBackupPolicy(BackupPolicy backupPolicy) {
        this.backupPolicy = backupPolicy;
    }
}

