/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import java.util.Objects;
import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;
import org.apache.activemq.artemis.utils.XidCodecSupport;

public class SessionXAEndMessage
extends PacketImpl {
    private Xid xid;
    private boolean failed;

    public SessionXAEndMessage(Xid xid, boolean failed) {
        super((byte)52);
        this.xid = xid;
        this.failed = failed;
    }

    public SessionXAEndMessage() {
        super((byte)52);
    }

    public boolean isFailed() {
        return this.failed;
    }

    public Xid getXid() {
        return this.xid;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        XidCodecSupport.encodeXid(this.xid, buffer);
        buffer.writeBoolean(this.failed);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        this.xid = XidCodecSupport.decodeXid(buffer);
        this.failed = buffer.readBoolean();
    }

    @Override
    public String getPacketString() {
        return super.getPacketString() + ", xid=" + String.valueOf(this.xid) + ", failed=" + this.failed + "]";
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.failed, this.xid);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SessionXAEndMessage)) {
            return false;
        }
        SessionXAEndMessage other = (SessionXAEndMessage)obj;
        return this.failed == other.failed && Objects.equals(this.xid, other.xid);
    }
}

